/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.peer.MenuBarPeer;
import java.util.Enumeration;
import java.util.Vector;

public class MenuBar
extends MenuComponent
implements MenuContainer {
    Vector menus = new Vector();
    Menu help_menu;

    public synchronized Menu add(Menu menu) {
        if (menu.parent != null) {
            menu.parent.remove(menu);
        }
        menu.parent = this;
        this.menus.add(menu);
        if (this.peer != null) {
            MenuBarPeer mp = (MenuBarPeer)this.peer;
            mp.add(menu);
        }
        return menu;
    }

    public void addNotify() {
        if (this.peer != null) {
            this.peer = Toolkit.getDefaultToolkit().createMenuBar(this);
        }
    }

    public int countMenus() {
        return this.getMenuCount();
    }

    public void deleteShortcut(MenuShortcut shortcut) {
        MenuItem it;
        while ((it = this.getShortcutMenuItem(shortcut)) != null) {
            it.deleteShortcut();
        }
    }

    public Menu getHelpMenu() {
        return this.help_menu;
    }

    public Menu getMenu(int index) {
        return (Menu)this.menus.get(index);
    }

    public int getMenuCount() {
        return this.menus.size();
    }

    public MenuItem getShortcutMenuItem(MenuShortcut shortcut) {
        MenuEnumeration m = new MenuEnumeration(this);
        while (m.hasMoreElements()) {
            MenuItem item = (MenuItem)m.nextElement();
            if (item.getShortcut() != shortcut) continue;
            return item;
        }
        return null;
    }

    public synchronized void remove(MenuComponent menu) {
        int s = this.menus.size();
        for (int i = 0; i < s; ++i) {
            if (this.menus.get(i) != menu) continue;
            this.remove(i);
            break;
        }
    }

    public synchronized void remove(int index) {
        Menu m = (Menu)this.menus.get(index);
        this.menus.remove(index);
        m.removeNotify();
        m.parent = null;
        if (this.peer != null) {
            MenuBarPeer mp = (MenuBarPeer)this.peer;
            mp.remove(index);
        }
    }

    public synchronized void setHelpMenu(Menu menu) {
        if (this.help_menu != null) {
            this.help_menu.removeNotify();
            this.help_menu.parent = null;
        }
        if (menu.parent != null) {
            menu.parent.remove(menu);
        }
        if (menu.parent != null) {
            menu.parent.remove(menu);
        }
        menu.parent = this;
        if (this.peer != null) {
            MenuBarPeer mp = (MenuBarPeer)this.peer;
            mp.addHelpMenu(menu);
        }
    }

    public synchronized Enumeration shortcuts() {
        return new ShortcutEnumeration(new MenuEnumeration(this));
    }

    static class ShortcutEnumeration
    implements Enumeration {
        Enumeration back;

        ShortcutEnumeration(Enumeration back) {
            this.back = back;
        }

        public boolean hasMoreElements() {
            return this.back.hasMoreElements();
        }

        public Object nextElement() {
            MenuItem item;
            while ((item = (MenuItem)this.back.nextElement()).getShortcut() == null) {
            }
            return item.getShortcut();
        }
    }

    static class MenuEnumeration
    implements Enumeration {
        Enumeration main;
        Enumeration sub = null;
        MenuBar menubar;

        MenuEnumeration(Menu m) {
            this.menubar = null;
            this.main = m.items.elements();
        }

        MenuEnumeration(MenuBar mb) {
            this.menubar = mb;
            this.main = mb.menus.elements();
        }

        public boolean hasMoreElements() {
            boolean r = false;
            if (this.sub != null) {
                r = this.sub.hasMoreElements();
            }
            if (!r) {
                r = this.main.hasMoreElements();
            }
            if (!r && this.menubar != null) {
                if (this.menubar.help_menu != null) {
                    this.main = new MenuEnumeration(this.menubar.help_menu);
                    r = this.main.hasMoreElements();
                }
                this.menubar = null;
            }
            return r;
        }

        public Object nextElement() {
            Object r;
            while (true) {
                if (this.sub.hasMoreElements()) {
                    return this.sub.nextElement();
                }
                this.sub = null;
                if (!this.main.hasMoreElements() && this.menubar != null && this.menubar.help_menu != null) {
                    this.main = new MenuEnumeration(this.menubar.help_menu);
                    this.menubar = null;
                }
                if (!((r = this.main.nextElement()) instanceof Menu)) break;
                this.sub = new MenuEnumeration((Menu)r);
            }
            return r;
        }
    }
}

