/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.EventDispatchThread;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.EmptyStackException;

public class EventQueue {
    private static final int INITIAL_QUEUE_DEPTH = 8;
    private AWTEvent[] queue;
    private int next_in;
    private int next_out;
    private EventQueue next;
    private EventQueue prev;
    private EventDispatchThread dispatchThread;

    private /* synthetic */ void finit$() {
        this.queue = new AWTEvent[8];
        this.next_in = 0;
        this.next_out = 0;
        this.dispatchThread = new EventDispatchThread(this);
    }

    public EventQueue() {
        this.finit$();
    }

    public synchronized AWTEvent getNextEvent() throws InterruptedException {
        if (this.next != null) {
            return this.next.getNextEvent();
        }
        while (this.next_in == this.next_out) {
            this.wait();
        }
        AWTEvent res = this.queue[this.next_out];
        if (++this.next_out == this.queue.length) {
            this.next_out = 0;
        }
        return res;
    }

    public synchronized AWTEvent peekEvent() {
        if (this.next != null) {
            return this.next.peekEvent();
        }
        if (this.next_in != this.next_out) {
            return this.queue[this.next_out];
        }
        return null;
    }

    public synchronized AWTEvent peekEvent(int id) {
        if (this.next != null) {
            return this.next.peekEvent(id);
        }
        int i = this.next_out;
        while (i != this.next_in) {
            AWTEvent qevt = this.queue[i];
            if (qevt.id != id) continue;
            return qevt;
        }
        return null;
    }

    public synchronized void postEvent(AWTEvent evt) {
        if (this.next != null) {
            this.next.postEvent(evt);
            return;
        }
        int i = this.next_out;
        while (i != this.next_in) {
            Object src;
            AWTEvent qevt = this.queue[i];
            if (qevt.id == evt.id && (src = qevt.getSource()) == evt.getSource() && src instanceof Component) {
                Component srccmp = (Component)src;
                AWTEvent coalesced_evt = srccmp.coalesceEvents(qevt, evt);
                if (coalesced_evt == null) break;
                this.queue[i] = coalesced_evt;
                return;
            }
            if (++i != this.queue.length) continue;
            i = 0;
        }
        this.queue[this.next_in] = evt;
        if (++this.next_in == this.queue.length) {
            this.next_in = 0;
        }
        if (this.next_in == this.next_out) {
            AWTEvent[] oldQueue = this.queue;
            this.queue = new AWTEvent[this.queue.length * 2];
            int len = oldQueue.length - this.next_out;
            System.arraycopy(oldQueue, this.next_out, this.queue, 0, len);
            if (this.next_out != 0) {
                System.arraycopy(oldQueue, 0, this.queue, len, this.next_out);
            }
            this.next_out = 0;
            this.next_in = oldQueue.length;
        }
        this.notify();
    }

    public static void invokeAndWait(Runnable runnable) throws InvocationTargetException, InterruptedException {
        EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
        Thread current = Thread.currentThread();
        if (current == eq.dispatchThread) {
            throw new Error("Can't call invokeAndWait from event dispatch thread");
        }
        InvocationEvent ie = new InvocationEvent(eq, runnable, current, true);
        Thread thread = current;
        synchronized (thread) {
            try {
                eq.postEvent(ie);
                current.wait();
            }
            finally {
                Object var6_5 = null;
            }
            Exception exception = ie.getException();
            if (exception != null) {
                throw new InvocationTargetException(exception);
            }
            return;
        }
    }

    static void invokeLater(Runnable runnable) {
        EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
        InvocationEvent ie = new InvocationEvent(eq, runnable, null, false);
        eq.postEvent(ie);
    }

    static boolean isDispatchThread() {
        EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
        return Thread.currentThread() == eq.dispatchThread;
    }

    public synchronized void push(EventQueue newEventQueue) {
        int i = this.next_out;
        while (i != this.next_in) {
            newEventQueue.postEvent(this.queue[i]);
            this.next_out = i++;
            if (i != this.queue.length) continue;
            i = 0;
        }
        this.next = newEventQueue;
        newEventQueue.prev = this;
    }

    protected void pop() {
        if (this.prev == null) {
            throw new EmptyStackException();
        }
        EventQueue eventQueue = this.prev;
        synchronized (eventQueue) {
            Object var3_2;
            try {
                this.prev.next = null;
            }
            finally {
                var3_2 = null;
            }
            EventQueue eventQueue2 = this;
            synchronized (eventQueue2) {
                try {
                    int i = this.next_out;
                    while (i != this.next_in) {
                        this.prev.postEvent(this.queue[i]);
                        this.next_out = i++;
                        if (i != this.queue.length) continue;
                        i = 0;
                    }
                    var3_2 = null;
                }
                catch (Throwable throwable) {
                    var3_2 = null;
                    throw throwable;
                }
            }
            return;
        }
    }

    protected void dispatchEvent(AWTEvent evt) {
        if (evt instanceof ActiveEvent) {
            ActiveEvent active_evt = (ActiveEvent)((Object)evt);
            active_evt.dispatch();
        } else {
            Object source = evt.getSource();
            if (source instanceof Component) {
                Component srccmp = (Component)source;
                srccmp.dispatchEvent(evt);
            } else if (source instanceof MenuComponent) {
                MenuComponent srccmp = (MenuComponent)source;
                srccmp.dispatchEvent(evt);
            }
        }
    }
}

