/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.PaintEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.EventListener;
import java.util.Locale;
import java.util.Vector;

public abstract class Component
implements ImageObserver,
MenuContainer,
Serializable {
    public static final float BOTTOM_ALIGNMENT = 1.0f;
    public static final float CENTER_ALIGNMENT = 0.5f;
    public static final float LEFT_ALIGNMENT = 0.0f;
    public static final float RIGHT_ALIGNMENT = 1.0f;
    public static final float TOP_ALIGNMENT = 0.0f;
    static Object treeLock = new String("AWT_TREE_LOCK");
    int x;
    int y;
    int width;
    int height;
    Color foreground;
    Color background;
    Font font;
    Font peerFont;
    Cursor cursor;
    Locale locale;
    boolean visible;
    boolean enabled;
    boolean valid;
    boolean hasFocus;
    Vector popups;
    String name;
    boolean nameExplicitlySet;
    Dimension minSize;
    Dimension prefSize;
    boolean newEventsOnly;
    long eventMask;
    PropertyChangeSupport changeSupport;
    boolean isPacked;
    int componentSerializedDataVersion;
    transient Container parent;
    transient ComponentPeer peer;
    transient ComponentListener componentListener;
    transient FocusListener focusListener;
    transient KeyListener keyListener;
    transient MouseListener mouseListener;
    transient MouseMotionListener mouseMotionListener;
    transient InputMethodListener inputMethodListener;
    transient HierarchyListener hierarchyListener;
    transient HierarchyBoundsListener hierarchyBoundsListener;
    transient ComponentOrientation orientation;

    static /* synthetic */ Class class$(String type$) {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    private /* synthetic */ void finit$() {
        this.visible = true;
        this.enabled = true;
        this.eventMask = 8192;
        this.orientation = ComponentOrientation.UNKNOWN;
    }

    protected Component() {
        this.finit$();
    }

    public String getName() {
        if (this.name == null && !this.nameExplicitlySet) {
            this.name = this.generateName();
        }
        return this.name;
    }

    public void setName(String name) {
        this.nameExplicitlySet = true;
        this.name = name;
    }

    String generateName() {
        return null;
    }

    public Container getParent() {
        return this.parent;
    }

    public ComponentPeer getPeer() {
        return this.peer;
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        return this.getGraphicsConfigurationImpl();
    }

    GraphicsConfiguration getGraphicsConfigurationImpl() {
        GraphicsConfiguration config;
        if (this.peer != null && (config = this.peer.getGraphicsConfiguration()) != null) {
            return config;
        }
        if (this.parent != null) {
            return this.parent.getGraphicsConfiguration();
        }
        return null;
    }

    public final Object getTreeLock() {
        return treeLock;
    }

    public Toolkit getToolkit() {
        Toolkit tk;
        if (this.peer != null && (tk = this.peer.getToolkit()) != null) {
            return tk;
        }
        if (this.parent != null) {
            return this.parent.getToolkit();
        }
        return Toolkit.getDefaultToolkit();
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isDisplayable() {
        if (this.parent != null) {
            return this.parent.isDisplayable();
        }
        return false;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isShowing() {
        if (!this.visible || this.peer == null) {
            return false;
        }
        return this.parent == null ? true : this.parent.isShowing();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
        if (this.peer != null) {
            this.peer.setEnabled(b);
        }
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void enable(boolean b) {
        this.setEnabled(b);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public boolean isDoubleBuffered() {
        return false;
    }

    public void enableInputMethods(boolean enable) {
    }

    public void setVisible(boolean b) {
        this.show(b);
    }

    public void show() {
        if (this.peer != null) {
            this.peer.setVisible(true);
        }
        this.visible = true;
    }

    public void show(boolean b) {
        if (b) {
            this.show();
        } else {
            this.hide();
        }
    }

    public void hide() {
        if (this.peer != null) {
            this.peer.setVisible(false);
        }
        this.visible = false;
    }

    public Color getForeground() {
        if (this.foreground != null) {
            return this.foreground;
        }
        if (this.parent != null) {
            return this.parent.getForeground();
        }
        return null;
    }

    public void setForeground(Color c) {
        if (this.peer != null) {
            this.peer.setForeground(c);
        }
        this.foreground = c;
    }

    public Color getBackground() {
        if (this.background != null) {
            return this.background;
        }
        if (this.parent != null) {
            return this.parent.getBackground();
        }
        return null;
    }

    public void setBackground(Color c) {
        if (this.peer != null) {
            this.peer.setBackground(c);
        }
        this.background = c;
    }

    public Font getFont() {
        if (this.font != null) {
            return this.font;
        }
        if (this.parent != null) {
            return this.parent.getFont();
        }
        return null;
    }

    public void setFont(Font f) {
        if (this.peer != null) {
            this.peer.setFont(f);
        }
        this.font = f;
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        if (this.parent == null) {
            throw new IllegalComponentStateException("Component has no parent: Can not determine Locale");
        }
        return this.parent.getLocale();
    }

    public void setLocale(Locale l) {
        this.locale = l;
        this.invalidate();
    }

    public ColorModel getColorModel() {
        GraphicsConfiguration config = this.getGraphicsConfiguration();
        if (config != null) {
            return config.getColorModel();
        }
        return this.getToolkit().getColorModel();
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public Point getLocationOnScreen() {
        if (!this.isShowing()) {
            throw new IllegalComponentStateException("component not showing");
        }
        return this.peer.getLocationOnScreen();
    }

    public Point location() {
        return this.getLocation();
    }

    public void setLocation(int x, int y) {
        if (this.x == x && this.y == y) {
            return;
        }
        this.invalidate();
        this.x = x;
        this.y = y;
        if (this.peer != null) {
            this.peer.setBounds(x, y, this.width, this.height);
        }
    }

    public void move(int x, int y) {
        this.setLocation(x, y);
    }

    public void setLocation(Point p) {
        this.setLocation(p.x, p.y);
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension size() {
        return this.getSize();
    }

    public void setSize(int width, int height) {
        if (this.width == width && this.height == height) {
            return;
        }
        this.invalidate();
        this.width = width;
        this.height = height;
        if (this.peer != null) {
            this.peer.setBounds(this.x, this.y, width, height);
        }
    }

    public void resize(int width, int height) {
        this.setSize(width, height);
    }

    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public void resize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Rectangle bounds() {
        return this.getBounds();
    }

    public void setBounds(int x, int y, int w, int h) {
        if (this.x == x && this.y == y && this.width == w && this.height == h) {
            return;
        }
        this.invalidate();
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        if (this.peer != null) {
            this.peer.setBounds(x, y, w, h);
        }
    }

    public void reshape(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height);
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Rectangle getBounds(Rectangle r) {
        r.x = this.x;
        r.y = this.y;
        r.width = this.width;
        r.height = this.height;
        return r;
    }

    public Dimension getSize(Dimension d) {
        d.width = this.width;
        d.height = this.height;
        return d;
    }

    public Point getLocation(Point p) {
        p.x = this.x;
        p.y = this.y;
        return p;
    }

    public boolean isOpaque() {
        return this.isLightweight() ^ true;
    }

    public boolean isLightweight() {
        return this.peer != null && this.peer instanceof LightweightPeer;
    }

    public Dimension getPreferredSize() {
        if (this.peer == null) {
            return new Dimension(this.width, this.height);
        }
        return this.peer.getPreferredSize();
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        if (this.peer == null) {
            return new Dimension(this.width, this.height);
        }
        return this.peer.getMinimumSize();
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getAlignmentX() {
        return 0.5f;
    }

    public float getAlignmentY() {
        return 0.5f;
    }

    public void doLayout() {
    }

    public void layout() {
        this.doLayout();
    }

    public void validate() {
    }

    public void invalidate() {
        this.valid = false;
        if (this.parent != null && this.parent.valid) {
            this.parent.invalidate();
        }
    }

    public Graphics getGraphics() {
        if (this.peer != null) {
            Graphics gfx = this.peer.getGraphics();
            if (gfx != null) {
                return gfx;
            }
            Container parent = this.getParent();
            if (parent != null) {
                gfx = parent.getGraphics();
                Rectangle bounds = this.getBounds();
                gfx.setClip(bounds);
                gfx.translate(bounds.x, bounds.y);
                return gfx;
            }
        }
        return null;
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.getToolkit().getFontMetrics(font);
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void paint(Graphics g) {
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paintAll(Graphics g) {
        if (!this.visible) {
            return;
        }
        if (this.peer != null) {
            this.peer.paint(g);
        }
        this.paint(g);
    }

    public void repaint() {
        this.repaint(0L, 0, 0, this.getWidth(), this.getHeight());
    }

    public void repaint(long tm) {
        this.repaint(tm, 0, 0, this.getWidth(), this.getHeight());
    }

    public void repaint(int x, int y, int width, int height) {
        this.repaint(0L, x, y, width, height);
    }

    public void repaint(long tm, int x, int y, int width, int height) {
        if (this.isLightweight() && this.parent != null) {
            if (this.parent != null) {
                this.parent.repaint(tm, x + this.getX(), y + this.getY(), width, height);
            }
            return;
        }
        if (this.peer != null) {
            this.peer.repaint(tm, x, y, width, height);
        }
    }

    public void print(Graphics g) {
        this.paint(g);
    }

    public void printAll(Graphics g) {
        this.paintAll(g);
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        return false;
    }

    public Image createImage(ImageProducer producer) {
        return null;
    }

    public Image createImage(int width, int height) {
        return this.getGraphicsConfiguration().createCompatibleImage(width, height);
    }

    public boolean prepareImage(Image image, ImageObserver observer) {
        return false;
    }

    public boolean prepareImage(Image image, int width, int height, ImageObserver observer) {
        return false;
    }

    public int checkImage(Image image, ImageObserver observer) {
        return 0;
    }

    public int checkImage(Image image, int width, int height, ImageObserver observer) {
        if (this.peer != null) {
            return this.peer.checkImage(image, width, height, observer);
        }
        return this.getToolkit().checkImage(image, width, height, observer);
    }

    public boolean contains(int x, int y) {
        return x >= 0 && y >= 0 && x < this.width && y < this.height;
    }

    public boolean inside(int x, int y) {
        return this.contains(x, y);
    }

    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public Component getComponentAt(int x, int y) {
        if (this.contains(x, y)) {
            return this;
        }
        return null;
    }

    public Component locate(int x, int y) {
        return this.getComponentAt(x, y);
    }

    public Component getComponentAt(Point p) {
        return this.getComponentAt(p.x, p.y);
    }

    public void deliverEvent(Event e) {
    }

    public final void dispatchEvent(AWTEvent e) {
        this.dispatchEventImpl(e);
        if (this.peer != null) {
            this.peer.handleEvent(e);
        }
    }

    void dispatchEventImpl(AWTEvent e) {
        if (e.id <= 103 && e.id >= 100 && (this.componentListener != null || (this.eventMask & 1L) != 0L)) {
            this.processEvent(e);
        } else if (e.id <= 402 && e.id >= 400 && (this.keyListener != null || (this.eventMask & (long)8) != 0L)) {
            this.processEvent(e);
        } else if (e.id <= 506 && e.id >= 500 && (this.mouseListener != null || this.mouseMotionListener != null || (this.eventMask & (long)16) != 0L)) {
            this.processEvent(e);
        } else if (e.id <= 1005 && e.id >= 1004 && (this.focusListener != null || (this.eventMask & (long)4) != 0L)) {
            this.processEvent(e);
        } else if (e.id <= 1101 && e.id >= 1100 && (this.inputMethodListener != null || (this.eventMask & (long)2048) != 0L)) {
            this.processEvent(e);
        } else if (e.id <= 1402 && e.id >= 1400 && (this.hierarchyListener != null || this.hierarchyBoundsListener != null || (this.eventMask & 0x8000L) != 0L)) {
            this.processEvent(e);
        } else if (e.id <= 801 && e.id >= 800 && (this.eventMask & (long)8192) != 0L) {
            this.processEvent(e);
        }
    }

    public boolean postEvent(Event e) {
        return false;
    }

    public synchronized void addComponentListener(ComponentListener l) {
        this.componentListener = AWTEventMulticaster.add(this.componentListener, l);
        if (this.componentListener != null) {
            this.enableEvents(1L);
        }
    }

    public synchronized void removeComponentListener(ComponentListener l) {
        this.componentListener = AWTEventMulticaster.remove(this.componentListener, l);
    }

    public synchronized void addFocusListener(FocusListener l) {
        this.focusListener = AWTEventMulticaster.add(this.focusListener, l);
        if (this.focusListener != null) {
            this.enableEvents(4);
        }
    }

    public synchronized void removeFocusListener(FocusListener l) {
        this.focusListener = AWTEventMulticaster.remove(this.focusListener, l);
    }

    public synchronized void addHierarchyListener(HierarchyListener l) {
        this.hierarchyListener = AWTEventMulticaster.add(this.hierarchyListener, l);
        if (this.hierarchyListener != null) {
            this.enableEvents(32768L);
        }
    }

    public synchronized void removeHierarchyListener(HierarchyListener l) {
        this.hierarchyListener = AWTEventMulticaster.remove(this.hierarchyListener, l);
    }

    public synchronized void addHierarchyBoundsListener(HierarchyBoundsListener l) {
        this.hierarchyBoundsListener = AWTEventMulticaster.add(this.hierarchyBoundsListener, l);
        if (this.hierarchyBoundsListener != null) {
            this.enableEvents(32768L);
        }
    }

    public synchronized void removeHierarchyBoundsListener(HierarchyBoundsListener l) {
        this.hierarchyBoundsListener = AWTEventMulticaster.remove(this.hierarchyBoundsListener, l);
    }

    public synchronized void addKeyListener(KeyListener l) {
        this.keyListener = AWTEventMulticaster.add(this.keyListener, l);
        if (this.keyListener != null) {
            this.enableEvents(8);
        }
    }

    public synchronized void removeKeyListener(KeyListener l) {
        this.keyListener = AWTEventMulticaster.remove(this.keyListener, l);
    }

    public synchronized void addMouseListener(MouseListener l) {
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, l);
        if (this.mouseListener != null) {
            this.enableEvents(16);
        }
    }

    public synchronized void removeMouseListener(MouseListener l) {
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, l);
    }

    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        this.mouseMotionListener = AWTEventMulticaster.add(this.mouseMotionListener, l);
        if (this.mouseMotionListener != null) {
            this.enableEvents(16);
        }
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener l) {
        this.mouseMotionListener = AWTEventMulticaster.remove(this.mouseMotionListener, l);
    }

    public synchronized void addInputMethodListener(InputMethodListener l) {
        this.inputMethodListener = AWTEventMulticaster.add(this.inputMethodListener, l);
        if (this.inputMethodListener != null) {
            this.enableEvents(2048);
        }
    }

    public synchronized void removeInputMethodListener(InputMethodListener l) {
        this.inputMethodListener = AWTEventMulticaster.remove(this.inputMethodListener, l);
    }

    public EventListener[] getListeners(Class listenerType) {
        if (listenerType == Component.class$("java.awt.event.ComponentListener")) {
            return Component.getListenersImpl(listenerType, this.componentListener);
        }
        if (listenerType == Component.class$("java.awt.event.FocusListener")) {
            return Component.getListenersImpl(listenerType, this.focusListener);
        }
        if (listenerType == Component.class$("java.awt.event.KeyListener")) {
            return Component.getListenersImpl(listenerType, this.keyListener);
        }
        if (listenerType == Component.class$("java.awt.event.MouseListener")) {
            return Component.getListenersImpl(listenerType, this.mouseListener);
        }
        if (listenerType == Component.class$("java.awt.event.MouseMotionListener")) {
            return Component.getListenersImpl(listenerType, this.mouseMotionListener);
        }
        if (listenerType == Component.class$("java.awt.event.InputMethodListener")) {
            return Component.getListenersImpl(listenerType, this.inputMethodListener);
        }
        if (listenerType == Component.class$("java.awt.event.HierarchyListener")) {
            return Component.getListenersImpl(listenerType, this.hierarchyListener);
        }
        if (listenerType == Component.class$("java.awt.event.HierarchyBoundsListener")) {
            return Component.getListenersImpl(listenerType, this.hierarchyBoundsListener);
        }
        return Component.getListenersImpl(listenerType, null);
    }

    static EventListener[] getListenersImpl(Class listenerType, EventListener el) {
        if (!Component.class$("java.util.EventListener").isAssignableFrom(listenerType)) {
            throw new ClassCastException();
        }
        Vector v = new Vector();
        if (el != null) {
            Component.getListenerList(el, v);
        }
        Object[] el_a = (EventListener[])Array.newInstance(listenerType, v.size());
        v.copyInto(el_a);
        return el_a;
    }

    static void getListenerList(EventListener el, Vector v) {
        if (el instanceof AWTEventMulticaster) {
            AWTEventMulticaster mc = (AWTEventMulticaster)el;
            Component.getListenerList(mc.a, v);
            Component.getListenerList(mc.b, v);
        } else {
            v.addElement(el);
        }
    }

    protected final void enableEvents(long eventsToEnable) {
        this.eventMask |= eventsToEnable;
        if (this.isLightweight() && this.parent != null) {
            this.parent.enableEvents(eventsToEnable);
        } else if (this.peer != null) {
            this.peer.setEventMask(this.eventMask);
        }
    }

    protected final void disableEvents(long eventsToDisable) {
        this.eventMask &= eventsToDisable ^ (long)-1;
    }

    protected AWTEvent coalesceEvents(AWTEvent existingEvent, AWTEvent newEvent) {
        switch (existingEvent.id) {
            case 503: 
            case 506: {
                return newEvent;
            }
            case 800: 
            case 801: {
                return this.coalescePaintEvents((PaintEvent)existingEvent, (PaintEvent)newEvent);
            }
        }
        return null;
    }

    private PaintEvent coalescePaintEvents(PaintEvent queuedEvent, PaintEvent newEvent) {
        Rectangle r1 = queuedEvent.getUpdateRect();
        Rectangle r2 = newEvent.getUpdateRect();
        Rectangle union = r1.union(r2);
        int ua = union.width * union.height;
        int r1a = r1.width * r1.height;
        int r2a = r2.width * r2.height;
        if (ua > (r1a + r2a) * 2) {
            return null;
        }
        newEvent.setUpdateRect(union);
        return newEvent;
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof FocusEvent) {
            this.processFocusEvent((FocusEvent)e);
        } else if (e instanceof PaintEvent) {
            this.processPaintEvent((PaintEvent)e);
        } else if (e instanceof MouseEvent) {
            if (e.id == 503 || e.id == 506) {
                this.processMouseMotionEvent((MouseEvent)e);
            } else {
                this.processMouseEvent((MouseEvent)e);
            }
        } else if (e instanceof ComponentEvent) {
            this.processComponentEvent((ComponentEvent)e);
        } else if (e instanceof KeyEvent) {
            this.processKeyEvent((KeyEvent)e);
        } else if (e instanceof InputMethodEvent) {
            this.processInputMethodEvent((InputMethodEvent)e);
        } else if (e instanceof HierarchyEvent) {
            if (e.id == 1400) {
                this.processHierarchyEvent((HierarchyEvent)e);
            } else {
                this.processHierarchyBoundsEvent((HierarchyEvent)e);
            }
        }
    }

    protected void processComponentEvent(ComponentEvent e) {
        if (this.componentListener == null) {
            return;
        }
        switch (e.id) {
            case 103: {
                this.componentListener.componentHidden(e);
                break;
            }
            case 100: {
                this.componentListener.componentMoved(e);
                break;
            }
            case 101: {
                this.componentListener.componentResized(e);
                break;
            }
            case 102: {
                this.componentListener.componentShown(e);
            }
        }
    }

    protected void processFocusEvent(FocusEvent e) {
        if (this.focusListener == null) {
            return;
        }
        switch (e.id) {
            case 1004: {
                this.focusListener.focusGained(e);
                break;
            }
            case 1005: {
                this.focusListener.focusLost(e);
            }
        }
    }

    protected void processKeyEvent(KeyEvent e) {
        if (this.keyListener == null) {
            return;
        }
        switch (e.id) {
            case 401: {
                this.keyListener.keyPressed(e);
                break;
            }
            case 402: {
                this.keyListener.keyReleased(e);
                break;
            }
            case 400: {
                this.keyListener.keyTyped(e);
            }
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        if (this.mouseListener == null) {
            return;
        }
        switch (e.id) {
            case 500: {
                this.mouseListener.mouseClicked(e);
                break;
            }
            case 504: {
                this.mouseListener.mouseEntered(e);
                break;
            }
            case 505: {
                this.mouseListener.mouseExited(e);
                break;
            }
            case 501: {
                this.mouseListener.mousePressed(e);
                break;
            }
            case 502: {
                this.mouseListener.mouseReleased(e);
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        if (this.mouseMotionListener == null) {
            return;
        }
        switch (e.id) {
            case 506: {
                this.mouseMotionListener.mouseDragged(e);
                break;
            }
            case 503: {
                this.mouseMotionListener.mouseMoved(e);
            }
        }
    }

    protected void processInputMethodEvent(InputMethodEvent e) {
        if (this.inputMethodListener == null) {
            return;
        }
        switch (e.id) {
            case 1101: {
                this.inputMethodListener.caretPositionChanged(e);
                break;
            }
            case 1100: {
                this.inputMethodListener.inputMethodTextChanged(e);
            }
        }
    }

    protected void processHierarchyEvent(HierarchyEvent e) {
        if (this.hierarchyListener == null) {
            return;
        }
        if (e.id == 1400) {
            this.hierarchyListener.hierarchyChanged(e);
        }
    }

    protected void processHierarchyBoundsEvent(HierarchyEvent e) {
        if (this.hierarchyBoundsListener == null) {
            return;
        }
        switch (e.id) {
            case 1401: {
                this.hierarchyBoundsListener.ancestorMoved(e);
                break;
            }
            case 1402: {
                this.hierarchyBoundsListener.ancestorResized(e);
            }
        }
    }

    private void processPaintEvent(PaintEvent event) {
        if (this.peer == null) {
            return;
        }
        Graphics gfx = this.getGraphics();
        Rectangle clip = event.getUpdateRect();
        gfx.setClip(clip);
        switch (event.id) {
            case 800: {
                this.paint(gfx);
                break;
            }
            case 801: {
                this.update(gfx);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown paint event");
            }
        }
    }

    public boolean handleEvent(Event evt) {
        return false;
    }

    public boolean mouseDown(Event evt, int x, int y) {
        return false;
    }

    public boolean mouseDrag(Event evt, int x, int y) {
        return false;
    }

    public boolean mouseUp(Event evt, int x, int y) {
        return false;
    }

    public boolean mouseMove(Event evt, int x, int y) {
        return false;
    }

    public boolean mouseEnter(Event evt, int x, int y) {
        return false;
    }

    public boolean mouseExit(Event evt, int x, int y) {
        return false;
    }

    public boolean keyDown(Event evt, int key) {
        return false;
    }

    public boolean keyUp(Event evt, int key) {
        return false;
    }

    public boolean action(Event evt, Object what) {
        return false;
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createComponent(this);
        }
        this.addNotifyContainerChildren();
        this.peer.setEventMask(this.eventMask);
    }

    void addNotifyContainerChildren() {
    }

    public void removeNotify() {
        if (this.peer != null) {
            this.peer.dispose();
        }
        this.peer = null;
    }

    public boolean gotFocus(Event evt, Object what) {
        return false;
    }

    public boolean lostFocus(Event evt, Object what) {
        return false;
    }

    public boolean isFocusTraversable() {
        return this.enabled && this.visible && (this.peer == null || this.peer.isFocusTraversable());
    }

    public void requestFocus() {
        if (this.peer != null) {
            this.peer.requestFocus();
        }
    }

    Component findNextFocusComponent(Component child) {
        return null;
    }

    public void transferFocus() {
        Component next = this.parent == null ? this.findNextFocusComponent(null) : this.parent.findNextFocusComponent(this);
        if (next != null && next != this) {
            next.requestFocus();
        }
    }

    public void nextFocus() {
        this.transferFocus();
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }

    public synchronized void add(PopupMenu popup) {
        if (this.popups == null) {
            this.popups = new Vector();
        }
        this.popups.addElement(popup);
    }

    public synchronized void remove(MenuComponent popup) {
        this.popups.removeElement(popup);
    }

    protected String paramString() {
        StringBuffer param = new StringBuffer();
        String name = this.getName();
        if (name != null) {
            param.append(name);
            param.append(",");
        }
        param.append(this.width);
        param.append("x");
        param.append(this.height);
        param.append("+");
        param.append(this.x);
        param.append("+");
        param.append(this.y);
        if (!this.isValid()) {
            param.append(",invalid");
        }
        if (!this.isVisible()) {
            param.append(",invisible");
        }
        if (!this.isEnabled()) {
            param.append(",disabled");
        }
        if (!this.isOpaque()) {
            param.append(",translucent");
        }
        if (this.isDoubleBuffered()) {
            param.append(",doublebuffered");
        }
        return param.toString();
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "]";
    }

    public void list() {
        this.list(System.out, 0);
    }

    public void list(PrintStream out) {
        this.list(out, 0);
    }

    public void list(PrintStream out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.print(' ');
        }
        out.println(this.toString());
    }

    public void list(PrintWriter out) {
        this.list(out, 0);
    }

    public void list(PrintWriter out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.print(' ');
        }
        out.println(this.toString());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyName, listener);
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void setComponentOrientation(ComponentOrientation o) {
        this.orientation = o;
    }

    public ComponentOrientation getComponentOrientation() {
        return this.orientation;
    }
}

