/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "mpeg3protos.h"
#include <stdlib.h>

mpeg3_vtrack_t* mpeg3_new_vtrack(mpeg3_t *file, int stream_id, mpeg3_demuxer_t *demuxer)
{
  mpeg3_vtrack_t *new_vtrack;
  
  new_vtrack = calloc(1, sizeof(mpeg3_vtrack_t));
  new_vtrack->demuxer = mpeg3_new_demuxer(file, 0, 1, 0, stream_id);
  
  if(demuxer) {
    mpeg3demux_copy_titles(new_vtrack->demuxer, demuxer);
  }

  new_vtrack->current_position = 0;

  return new_vtrack;
}

int mpeg3_delete_vtrack(mpeg3_t *file, mpeg3_vtrack_t *vtrack)
{
  if(vtrack->demuxer) {
    mpeg3_delete_demuxer(vtrack->demuxer);
  }
  
  free(vtrack);

  return 0;
}
