/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * avi_read.h : avi reading base functions.
 *
 */

#ifndef AVI_READ_H
#define AVI_READ_H

/*********************************************************************
 *                             INCLUDES                              *
 *********************************************************************/

#include "libxmps/libxmps.h"

/*
 * includes : local
 *
 */

#include "avifmt.h"

/*********************************************************************
 *                              TYPES                                *
 *********************************************************************/

typedef struct
{
  long pos;
  long len;
  long flags;

} video_index_entry;

typedef struct
{
   long pos;
   long len;
   long tot;

} audio_index_entry;

typedef struct
{
   BITMAPINFOHEADER   bitmapinfoheader;
   long               width;             
   long               height;            
   double             fps;               
   char               compressor[8];     
   long               video_strn;        
   long               video_frames;      
   char               video_tag[4];      
   long               video_pos;         
   long               a_fmt;             
   long               a_chans;           
   long               a_rate;            
   long               a_bits;            
   long               audio_strn;        
   long               audio_bytes;       
   long               audio_chunks;      
   char               audio_tag[4];      
   long               audio_posc;        
   long               audio_posb;        
   long               pos;               
   long               n_idx;             
   long               max_idx;           
   unsigned char    (*idx)[16]; 
   video_index_entry *video_index;
   audio_index_entry *audio_index;
   long               last_pos;          
   long               last_len;          
   int                must_use_index;    
   long               movi_start;
} avi_t;

#define AVI_MODE_WRITE  0
#define AVI_MODE_READ   1

/* The error codes delivered by avi_open_input_file */

#define AVI_ERR_SIZELIM      1
#define AVI_ERR_OPEN         2
#define AVI_ERR_READ         3
#define AVI_ERR_WRITE        4
#define AVI_ERR_WRITE_INDEX  5
#define AVI_ERR_CLOSE        6
#define AVI_ERR_NOT_PERM     7
#define AVI_ERR_NO_MEM       8
#define AVI_ERR_NO_AVI       9
#define AVI_ERR_NO_HDRL     10
#define AVI_ERR_NO_MOVI     11
#define AVI_ERR_NO_VIDS     12
#define AVI_ERR_NO_IDX      13

/*
 * possible audio formats
 *
 */

#define WAVE_FORMAT_UNKNOWN             (0x0000)
#define WAVE_FORMAT_PCM                 (0x0001)
#define WAVE_FORMAT_ADPCM               (0x0002)
#define WAVE_FORMAT_IBM_CVSD            (0x0005)
#define WAVE_FORMAT_ALAW                (0x0006)
#define WAVE_FORMAT_MULAW               (0x0007)
#define WAVE_FORMAT_OKI_ADPCM           (0x0010)
#define WAVE_FORMAT_DVI_ADPCM           (0x0011)
#define WAVE_FORMAT_DIGISTD             (0x0015)
#define WAVE_FORMAT_DIGIFIX             (0x0016)
#define WAVE_FORMAT_YAMAHA_ADPCM        (0x0020)
#define WAVE_FORMAT_DSP_TRUESPEECH      (0x0022)
#define WAVE_FORMAT_GSM610              (0x0031)
#define WAVE_FORMAT_MPEGLAYER12         (0x0050)
#define WAVE_FORMAT_MPEGLAYER3          (0x0055)
#define WAVE_FORMAT_DIVX                (0x0160)
#define WAVE_FORMAT_DIVX_WMA            (0x0161)


unsigned int AVI_is_avi(xmps_media_plugin_t *media);

avi_t       *AVI_open_input(xmps_media_plugin_t *media, 
			    int getIndex);

unsigned int AVI_has_audio(avi_t *AVI);
unsigned int AVI_has_video(avi_t *AVI);

long         AVI_video_frames(avi_t *AVI);
int          AVI_video_width(avi_t *AVI);
int          AVI_video_height(avi_t *AVI);
double       AVI_frame_rate(avi_t *AVI);
char*        AVI_video_compressor(avi_t *AVI);

int          AVI_audio_channels(avi_t *AVI);
int          AVI_audio_bits(avi_t *AVI);
int          AVI_audio_format(avi_t *AVI);
long         AVI_audio_rate(avi_t *AVI);
long         AVI_audio_bytes(avi_t *AVI);
int          AVI_sampsize(avi_t *AVI);

long         AVI_video_time(avi_t *AVI);
long         AVI_audio_time(avi_t *AVI);

long         AVI_frame_size(avi_t *AVI, 
			    long frame);

int          AVI_seek_start(avi_t *AVI);

int          AVI_set_video_position(avi_t *AVI, 
				    long frame);

unsigned int AVI_is_keyframe(avi_t *AVI, 
			     long frame);

long         AVI_read_frame(avi_t *AVI, 
			    char *vidbuf);

int          AVI_set_audio_position(avi_t *AVI, 
				    long byte);

long         AVI_read_audio(avi_t *AVI, 
			    char *audbuf, 
			    long bytes);

int          AVI_read_data(avi_t *AVI, 
			   char *vidbuf, 
			   long max_vidbuf,
			   char *audbuf, 
			   long max_audbuf,
			   long *len);

void         AVI_print_error(char *str);
char        *AVI_strerror();
char        *AVI_syserror();
int          AVI_close(avi_t *AVI);

#endif
