/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * libxmpsutils.h : 
 *
 */

#ifndef _LIBXMPSUTILS_H
#define _LIBXMPSUTILS_H

#include "libxmps/libxmps.h"
#include <gtk/gtk.h>
#include <glib.h>

typedef enum {

  XMPS_MEDIA_FILE,
  XMPS_MEDIA_VCD,
  XMPS_MEDIA_HTTP

} xmps_media_types_t;

typedef struct {

  char              *full_path;
  char              *display_name;
  unsigned int       selected;
  xmps_media_types_t type;

} xmps_item_t;

typedef struct {

  unsigned int nbr_items;
  unsigned int current_pos;
  GList       *list;

} xmps_playlist_t; 

/*
 * menu types 
 *
 * - these are used to build 
 *   shared abstract menus for GUIs
 */

typedef enum {

  XMPS_MENU_ITEM_TYPE_ITEM,
  XMPS_MENU_ITEM_TYPE_RADIO,
  XMPS_MENU_ITEM_TYPE_CHECK

} xmps_menu_item_type_t;

typedef void (*xmps_menu_callback_t)(unsigned int id, 
				     unsigned int on);

typedef struct {

  unsigned int            id;
  char                   *label;
  xmps_menu_item_type_t   type;
  unsigned int            group;
  unsigned int            active;

} xmps_menu_item_t;

typedef struct {

  unsigned int         nbr_items;
  unsigned int         position;
  xmps_menu_callback_t callback;
  GList               *children;

} xmps_menu_t;


typedef struct _xmps_gui_data_t {

  int    argc;
  char **argv;

  xmps_menu_t     *shared_menu;
  xmps_session_t  *session;
  xmps_playlist_t *playlist;

  xmps_config_file_t *cfgfile;

} xmps_gui_data_t;


xmps_item_t *xmps_item_new(xmps_media_types_t type, char *full_path);
/*
 * creates a new item and computes the display name.
 */

void push_xmps_event(gint event);
/*
 * adds an event to the queue.
 *
 */

gint pop_xmps_event(void);
/*
 * removes and returns oldest event.
 *
 */

/* prototypes */

xmps_menu_item_t *xmps_menu_item_new(unsigned int id, 
				     char *label, 
				     xmps_menu_item_type_t   type,
				     unsigned int            group,
				     unsigned int            active);
/* 
 * create a new menu item and fill it 
 */

xmps_menu_t *xmps_menu_new(xmps_menu_callback_t callback);
/*
 * create a new xmps_menu (empty)
 */

void xmps_menu_add(xmps_menu_t *menu, xmps_menu_item_t *item);
/*
 * append the item to the menu;
 */

void xmps_menu_reset(xmps_menu_t *menu);
/*
 * reset the internal pointer of the menu;
 */

xmps_menu_item_t *xmps_menu_get_item(xmps_menu_t *menu);
/*
 * get the current menu item.
 */

int xmps_menu_next(xmps_menu_t *menu);
/*
 * increments the internal pointer.
 */

/* prototypes */

xmps_playlist_t* xmps_playlist_new();
/*
 * creates a new playlist, and proceed initilisaiton.
 */

unsigned int xmps_playlist_get_nbr_items(xmps_playlist_t *playlist);
/*
 * returns the number of items in the playlist.
 */

unsigned int xmps_playlist_get_current_pos(xmps_playlist_t *playlist);
/*
 * returns the internal playlist position.
 */

int xmps_playlist_add(xmps_playlist_t *playlist, xmps_item_t *item);
/*
 * append an entry to the playlist.
 */

xmps_item_t *xmps_playlist_get_item(xmps_playlist_t *playlist);
/*
 * return current item in playlist;
 */

xmps_item_t *xmps_playlist_get_item_at(xmps_playlist_t *playlist, unsigned int i);
/*
 * returns item at position i
 */

int xmps_playlist_remove_item_at(xmps_playlist_t *playlist, unsigned int i);
/*
 * removes item i in playlist
 */

int xmps_playlist_toggle_selection_at(xmps_playlist_t *playlist, unsigned int i);
/*
 * select/unselect item at i
 */

int xmps_playlist_select_at(xmps_playlist_t *playlist, unsigned int i);
/*
 * select/unselect item at i
 */

int xmps_playlist_unselect_at(xmps_playlist_t *playlist, unsigned int i);
/*
 * select/unselect item at i
 */

int xmps_playlist_next(xmps_playlist_t *playlist);
/*
 * increments internal pointer of the playlist, return TRUE if succsesfull, FALSE if at the end.
 */

int xmps_playlist_prev(xmps_playlist_t *playlist);
/*
 * decrements internal pointer of the playlist, return TRUE if succsesfull, FALSE if at the begining.
 */

void xmps_playlist_reset(xmps_playlist_t *playlist);
/*
 * reset internal pointer.
 */

int xmps_playlist_set_pos(xmps_playlist_t *playlist, unsigned int pos);
/*
 * set internal pointer.
 */

void xmps_playlist_destroy(xmps_playlist_t *playlist);
/*
 * will free memory, and set the pointer to NULL;
 */

void xmps_playlist_clear(xmps_playlist_t *playlist);
/*
 * removes all items.
 */

/* Use this function to set the directory containing installed pixmaps. */
void        add_pixmap_directory       (const gchar     *directory);

/* Used to translate text in menus. Should be given as argument to
 * gtk_item_factory_set_translate_func(). */
gchar*      menu_translate             (const gchar *path, gpointer data);

/*
 * Private Functions.
 */

/* This is used to create the pixmaps in the interface. */
GtkWidget*  create_pixmap              (GtkWidget       *widget,
                                        const gchar     *filename);


void xmps_make_config_dir(void);
/*
 * make .xmps dir and 
 * .xmps/Skins dir.
 *
 */

void xmps_file_info_create(xmps_session_t *xmps_session);
void xmps_file_info_show();

/* functions */

void xmps_gtk_config_create(xmps_session_t *xmps_session);
void xmps_gtk_config_show();
void xmps_gtk_config_hide();

GtkWidget *xmps_gtk_get_menu(xmps_session_t *xmps_session);

/*
 * About window
 */

void xmps_about_create (void);
void xmps_about_show (void);

#endif
