/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *  xmps_graphics.h
 *
 *  Header file for the graphics functions.
 *  @Author : Damien Chavarria (1999)
 *
 */

#ifndef _XMPS_GRAPHICS_H
#define _XMPS_GRAPHICS_H

#include "libxmps/libxmps.h"
#include "libxmpsutils/libxmpsutils.h"
#include <gtk/gtk.h>

/******************************************************************
 *								  *
 * <----------------------------------------------------------->  *								  
 * <------------------ SKIN SPECIFICATION --------------------->  *
 * <----------------------------------------------------------->  *
 * <--                                                       -->  *
 * <-- This header gives all the information for building    -->  *
 * <-- skins for xmps, it defines also all the types,        -->  *
 * <-- constants and functions for handling skins.           -->  *
 * <--                                                       -->  *
 * <----------------------------------------------------------->  *
 * <----------------------------------------------------------->  *
 *								  *
 ******************** ZONES SPECIFICATION *************************
 *								  *
 *  0 -> ABOUT_MENU          : start  = (5, 5)			  *
 *		               size   = (18, 18)    		  *
 *								  *
 *  1 -> TITLE               : start  = (23, 5)			  *
 *		               size   = (229, 18)    		  *
 *								  *
 *  2 -> CLOSE	             : start  = (252, 5)		  *
 *		               size   = (18, 18)    		  *
 *								  *
 *  3 -> INVERT_TIME         : start  = (129, 32)		  *
 *		               size   = (10, 7)    		  *
 *								  *
 *  4 -> LOOP                : start  = (129, 41)		  *
 *		               size   = (10, 9)    		  *
 *								  *
 *  5 -> DIGITS              : start  = (144, 31)		  *
 *		               size   = (75, 31)    		  *
 *								  *
 *  6 -> SMALL_DIGITS        : start  = (223, 42)		  *
 *		               size   = (37, 11)    		  *
 *								  *
 *  7 -> FULL_SCREEN_BUTTON  : start  = (124, 75) 		  *
 *		               size   = (22, 16)                  *
 *								  *
 *  8 -> LOOP_BUTTON         : start  = (124, 94)		  *
 *		               size   = (22, 16)    		  *
 *								  *
 *  9 -> BALANCE_BAR         : start  = (155, 82)		  *
 *		               size   = (81, 11)    		  *
 *								  *
 * 10 -> VOLUME_BAR          : start  = (155, 100)		  *
 *		               size   = (111, 11)    		  *
 *								  *
 * 11 -> PLAYLIST_BUTTON     : start  = (243, 81)		  *
 *		               size   = (22, 15)    		  *
 *							 	  *
 * 12 -> REWIND_BUTTON       : start  = (12, 125)		  *
 *		               size   = (25, 17)    		  *
 *								  *
 * 13 -> STOP_BUTTON         : start  = (47, 125)		  *
 *		               size   = (25, 17)    		  *
 *								  *
 * 14 -> PLAY_BUTTON         : start  = (82, 125)		  *
 *		               size   = (25, 17)    		  *
 *								  *
 * 15 -> PAUSE_BUTTON        : start  = (117, 125)		  *
 *		               size   = (25, 17)    		  *
 *								  *
 * 16 -> FAST_FORWARD_BUTTON : start  = (152, 125)		  *
 *		               size   = (25, 17)    		  *
 *								  *
 * 17 -> LOAD_BUTTON :         start  = (189, 125)		  *
 *		               size   = (51, 17)    		  *
 *								  *
 * 18 -> RESIZE              : start  = (253, 126)		  *
 *		               size   = (17, 19)    		  *
 *								  *
 * 19 -> PROGRESS_BAR        : start  = (5, 111)		  *
 *		               size   = (265, 10)    		  *
 *								  *
 * 20 -> PROGRESS_BAR_CURSOR : size   = (25, 8)    		  *
 *								  *
 * 21 -> VOLUME_BAR_CURSOR   : size   = (18, 7)    		  *
 *								  *
 * 22 -> BALANCE_BAR_CURSOR  : size   = (18, 7)    		  *
 *								  *
 ******************** FILES SPECIFICATION *************************
 *								  *
 * All files must be in xpm format. each element is always 	  *
 * separated from the others and from the edge of the pixmap      *
 * by a white, 2-pixels-width row or collumn (except for main)    *
 *								  *
 * main.xpm :							  *
 * ----------							  *
 *	It contains the background.				  *
 *	Dimension : 275x150 pixels				  *
 *								  *
 * buttons.xpm :						  *
 * -------------						  *
 *	First line  : rewind, stop, play, pause, fast forward     *
 *		      and load buttons, normal state		  *
 *	Second line : rewind, stop, play, pause, fast forward     *
 *		      and load buttons, pushed state		  *
 *								  *
 * digits.xpm :							  *
 * ------------							  *
 *	First line  : none, 0 to 9 big digits.			  *
 *	Second line : none, 0 to 9 small digits.		  *
 *	Third line  : minus signs, loop signs.			  *
 *								  *
 *	The big digits are (12x23) pixels and there are 5 of them *
 *	The positions are : (144, 30), (162, 30), (175, 30),	  *
 *			    (194, 30), (207, 30)  		  *
 *								  *
 *	The small ones are (6x11) pixels and there are 5 of them  *
 *	The positions are : (223, 42), (232, 42), (238, 42),	  *
 *			    (247, 42), (253, 42)  		  *
 *								  *
 * letters.xpm :						  *
 * -------------						  *
 *	First line  : A to Z, etc....				  *
 *		      for the file title zone.			  *
 *								  *
 * controls.xpm :						  *
 * --------------						  *
 *	First line  : playlist button, untoggled, toggled         *
 *		      untoggled pushed, toggled pushed.           *
 *	Second line : full screen button normal and pushed	  *
 *	              loop button normal and pushed.		  *
 *	Third line  : Balance bar and cursor.			  *
 *	Fourth line : Volume bar and cursor.			  *
 *	Fifth line  : Progression bar and cursor.		  *
 *	Sixth line  : Resize.					  *
 *								  *
 * titlebar.xpm :						  *
 * --------------						  *
 *	First line  : About, title and close zones activated.	  *
 *	Second line : About, title and close zones unactivated.	  *
 *								  *
 *************************** RESIZING *****************************
 *								  *
 *  The skins need to be resizable.				  *
 *  So there are parts of the pixmaps that are used in for loops  *
 *  to fill the remainig space we resizing the application	  *
 *								  *
 *  These zones, generally 1-pixel width or heigh are specified   *
 *  in the file resize.jpg in the doc directory.		  *
 *								  *
 **************************** NOTES *******************************
 *								  *
 * [Pending] : make an html file... clearer :)			  *
 *								  *
 ******************************************************************/

/* TYPES */

typedef enum {
  NONE,
  ABOUT_MENU_CLICKED,
  INVERT_TIME_DIGIT_CLICKED,
  LOOP_DIGIT_CLICKED,
  FULL_SCREEN_BUTTON_CLICKED,
  LOOP_BUTTON_CLICKED,
  PLAYLIST_BUTTON_CLICKED,
  REWIND_BUTTON_CLICKED,
  STOP_BUTTON_CLICKED,
  PLAY_BUTTON_CLICKED,
  PAUSE_BUTTON_CLICKED,
  FAST_FORWARD_BUTTON_CLICKED,
  LOAD_BUTTON_CLICKED,
  PROGRESS_BAR_MOVING,
  VOLUME_BAR_MOVING,
  BALANCE_BAR_MOVING,
  WINDOW_MOVING,
  WINDOW_CLOSING,
  WINDOW_RESIZING,
  PLAYLIST_MENU_CLICKED,
  PLAYLIST_TITLE_CLICKED,
  PLAYLIST_CLOSE_CLICKED,
  PLAYLIST_ITEMS_CLICKED,
  PLAYLIST_ADD_BUTTON_CLICKED,
  PLAYLIST_REMOVE_BUTTON_CLICKED,
  PLAYLIST_SORT_BUTTON_CLICKED,
  PLAYLIST_RAND_BUTTON_CLICKED,
  PLAYLIST_RESIZE_CLICKED,
  PLAYLIST_CURSOR_CLICKED,
} xmps_action;

/* rectangle type */

typedef struct {
  gint start_x;
  gint start_y;
  gint size_x;
  gint size_y;
} xmps_rect;

/* progress bars */

typedef struct {
  xmps_rect     bar_rect;
  xmps_rect     cursor_rect;
  gint          pos_x;
  gint          pos_y;
  gint          cursor_pos_x;
  gint          cursor_pos_y;
  gint          value; /* 0 to 100 */
} xmps_progress_bar;

/* skin type */

typedef struct {
  gchar       *directory;
  gchar       *name;
  GdkColor    playlist_bgcolor;
  GdkColor    filename_bgcolor;
  GdkColor    filename_font_color;
  GdkColor    playlist_font_color;
  GdkColor    playlist_selected;
} xmps_skin;

typedef struct {

  /* playlist */

  gint   playlist_pos_x;
  gint   playlist_pos_y;
  gint   playlist_size_x;
  gint   playlist_nbr_lines;
  gint   playlist_current_display_position;

  /* main window */

  GtkWidget  *skinned_window;
  GtkWidget  *playlist_window;
  
  gint        idle;

  gint        move_x;
  gint        move_y;
  gint        resize_x;
  gint        resize_y;

  gint        window_pos_x;
  gint        window_pos_y;
  gint        window_size_x;
  gint        window_size_y;

  gint        has_focus;
  gint        playlist_has_focus;

  gint       save_window_pos;
  gint       save_skin;

  gint       is_playlist_toggled;
  gint       is_playlist_glued;
  gint       allways_glued;
  gint       allow_multiples_instances;
  gint       reverse_file_order;
  gint       scroll_title;
  gint       confirm_fullscreen;
  gint       save_on_exit;

  gint       save_playlist_content;
  gint       save_playlist_pos;
  gint       save_playlist_size;

  gint       playlist_multiple_selection;

  int        is_invert_time;
  int        is_loop;

  gint       fullscreen;
  char *     filesel_dir;
  
  int        has_to_play;
  int        showing_prop;

  guint32     current_time;
  guint32     total_time;

  xmps_action current_action;

  xmps_skin *current_skin;

  xmps_progress_bar balance_bar;
  xmps_progress_bar volume_bar;
  xmps_progress_bar progress_bar;

  xmps_playlist_t *playlist;
  xmps_session_t  *session;

  xmps_config_file_t *cfgfile;

  xmps_menu_callback_t menu_callback;

  GtkWidget      *file_selection;
  GtkAccelGroup  *global_accel;

} xmps_info;

/* CONSTANTS */

#define NORMAL 0
#define PUSHED 1

/* for toggled buttons */

#define NORMAL_TOGGLED 2
#define PUSHED_TOGGLED 3

/*for zones in general */

#define INACTIVE 0
#define ACTIVE   1

/* for the image size */

#define IMAGE_DEFAULT_SIZE_X 103
#define IMAGE_DEFAULT_SIZE_Y 77

/* for the digits */

#define NO_TIME -4271

/* for the actions */

#define ABOUT_MENU 	 	  0
#define TITLE 	   		  1
#define CLOSE	   		  2
#define INVERT_TIME		  3
#define LOOP	 		  4
#define DIGITS			  5
#define SMALL_DIGITS	 	  6
#define FULL_SCREEN_BUTTON 	  7
#define LOOP_BUTTON		  8
#define BALANCE_BAR		  9
#define VOLUME_BAR		 10
#define PLAYLIST_BUTTON		 11
#define REWIND_BUTTON		 12
#define STOP_BUTTON		 13
#define PLAY_BUTTON		 14
#define PAUSE_BUTTON		 15
#define FAST_FORWARD_BUTTON 	 16
#define LOAD_BUTTON		 17
#define RESIZE			 18
#define PROGRESS_BAR		 19
#define PROGRESS_BAR_CURSOR	 20
#define VOLUME_BAR_CURSOR	 21
#define BALANCE_BAR_CURSOR	 22
#define OTHER 			100 


/* for the playlist */

#define PLAYLIST_MENU		 0
#define PLAYLIST_TITLE		 1
#define PLAYLIST_CLOSE		 2
#define PLAYLIST_ITEMS		 3
#define PLAYLIST_CURSOR          4
#define PLAYLIST_ADD_BUTTON	 5
#define PLAYLIST_REMOVE_BUTTON	 6
#define PLAYLIST_SORT_BUTTON	 7
#define PLAYLIST_RAND_BUTTON	 8
#define PLAYLIST_RESIZE	         9
#define PLAYLIST_PROGRESS_BAR   10

/* global variables */

/* zones */

xmps_rect ABOUT_MENU_RECT;
xmps_rect TITLE_RECT;
xmps_rect CLOSE_RECT;
xmps_rect INVERT_TIME_RECT;
xmps_rect LOOP_RECT;
xmps_rect DIGITS_RECT;
xmps_rect SMALL_DIGITS_RECT;
xmps_rect FULL_SCREEN_BUTTON_RECT;
xmps_rect LOOP_BUTTON_RECT;
xmps_rect BALANCE_BAR_RECT;
xmps_rect VOLUME_BAR_RECT;
xmps_rect PLAYLIST_BUTTON_RECT;
xmps_rect REWIND_BUTTON_RECT;
xmps_rect STOP_BUTTON_RECT;
xmps_rect PLAY_BUTTON_RECT;
xmps_rect PAUSE_BUTTON_RECT;
xmps_rect FAST_FORWARD_BUTTON_RECT;
xmps_rect LOAD_BUTTON_RECT;
xmps_rect RESIZE_RECT;
xmps_rect PROGRESS_BAR_RECT;

xmps_rect PLAYLIST_MENU_RECT;
xmps_rect PLAYLIST_CLOSE_RECT;
xmps_rect PLAYLIST_TITLE_RECT;
xmps_rect PLAYLIST_ITEMS_RECT;
xmps_rect PLAYLIST_PROGRESS_BAR_RECT;
xmps_rect PLAYLIST_CURSOR_RECT;
xmps_rect PLAYLIST_ADD_BUTTON_RECT;
xmps_rect PLAYLIST_REMOVE_BUTTON_RECT;
xmps_rect PLAYLIST_SORT_BUTTON_RECT;
xmps_rect PLAYLIST_RAND_BUTTON_RECT;
xmps_rect PLAYLIST_RESIZE_RECT;

/* globals */

xmps_info xmps_config;

/* FUNCTIONS */

gint is_inside_rect(gint x, gint y, xmps_rect rect);
/* Inside rect test */

gint get_selected_zone(gint x, gint y);
/* Return the zone corresponding to a mouse clic */

gint playlist_get_selected_zone(gdouble x, gdouble y);
/* Return the zone corresponding to a mouse clic on the playlist*/

gint get_playlist_item_selected(gdouble y);
/* Return the index of the item conresponding to a click - returns -1 if no one is concerned */

void refresh_zone_rects();
/* called when resizing in order to adapt the rects to the new size */

#endif

