/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *  skins_draw_controls.c
 *
 *  Functions for handling the controls.xpm
 *  @Author : Damien Chavarria (1999)
 *
 */

/* INCLUDES */

#include "skins_draw_controls.h"

/* FUNCTIONS */

/************* draw_full_screen_button ****************
 * 						      *
 ******************************************************/

void draw_full_screen_button(gint state, GtkWidget *widget)
{
  gint dx;
  dx = xmps_config.window_size_x - 275;
  switch (state)
  {
  case NORMAL :  
#ifdef HAVE_GDKPIXBUF
    gdk_pixbuf_render_to_drawable (controls_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   2, 19,
				   124+dx, 75,
				   22, 16,GDK_RGB_DITHER_NONE, 0, 0);
#else
    gdk_draw_pixmap(widget->window,
		    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		    controls_pixmap,
		    2, 19,
		    124+dx, 75,
		    22, 16);
#endif    		  
    break;

  case PUSHED :  
#ifdef HAVE_GDKPIXBUF
    gdk_pixbuf_render_to_drawable (controls_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   26, 19,
				   124+dx, 75,
				   22, 16,GDK_RGB_DITHER_NONE, 0, 0);
#else
    gdk_draw_pixmap(widget->window,
		    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		    controls_pixmap,
		    26, 19,
		    124+dx, 75,
		    22, 16);
#endif    		 
    break;
  }
}

/***************** draw_loop_button *******************
 * 						      *
 ******************************************************/

void draw_loop_button(gint state, GtkWidget *widget)
{
  gint dx;
  dx = xmps_config.window_size_x - 275;
  switch (state)
  {
  case NORMAL :  
#ifdef HAVE_GDKPIXBUF
    gdk_pixbuf_render_to_drawable (controls_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   50, 19,
				   124+dx, 94,
				   22, 16,GDK_RGB_DITHER_NONE, 0, 0);
#else
    gdk_draw_pixmap(widget->window,
		    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		    controls_pixmap,
		    50, 19,
		    124+dx, 94,
		    22, 16);
#endif    		  
    break;
    
  case PUSHED :  
#ifdef HAVE_GDKPIXBUF
    gdk_pixbuf_render_to_drawable (controls_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   74, 19,
				   124+dx, 94,
				   22, 16,GDK_RGB_DITHER_NONE, 0, 0);
#else
    gdk_draw_pixmap(widget->window,
		    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		    controls_pixmap,
		    74, 19,
		    124+dx, 94,
		    22, 16);
#endif
    break;
  }
}

/*************** draw_playlist_button *****************
 * 						      *
 ******************************************************/

void draw_playlist_button(gint state, GtkWidget *widget)
{
  gint dx;
  dx = xmps_config.window_size_x - 275;
  switch (state)
  {
  case NORMAL :  
#ifdef HAVE_GDKPIXBUF
    gdk_pixbuf_render_to_drawable (controls_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   2, 2,
				   243+dx, 81,
				   22, 15,GDK_RGB_DITHER_NONE, 0, 0);
#else    		  
    gdk_draw_pixmap(widget->window,
		    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		    controls_pixmap,
		    2, 2,
		    243+dx, 81,
		    22, 15);
#endif
    break;

  case PUSHED :  
#ifdef HAVE_GDKPIXBUF
    gdk_pixbuf_render_to_drawable (controls_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   50, 2,
				   243+dx, 81,
				   22, 15,GDK_RGB_DITHER_NONE, 0, 0);
#else
    gdk_draw_pixmap(widget->window,
		    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		    controls_pixmap,
		    50, 2,
		    243+dx, 81,
		    22, 15);
#endif
    break;
    
  case NORMAL_TOGGLED : 
#ifdef HAVE_GDKPIXBUF
    gdk_pixbuf_render_to_drawable (controls_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   26, 2,
				   243+dx, 81,
				   22, 15,GDK_RGB_DITHER_NONE, 0, 0);
#else
    gdk_draw_pixmap(widget->window,
		    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		    controls_pixmap,
		    26, 2,
		    243+dx, 81,
		    22, 15);
#endif
    break;

  case PUSHED_TOGGLED :  
#ifdef HAVE_GDKPIXBUF
    gdk_pixbuf_render_to_drawable (controls_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   74, 2,
				   243+dx, 81,
				   22, 15,GDK_RGB_DITHER_NONE, 0, 0);
#else
    gdk_draw_pixmap(widget->window,
		    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		    controls_pixmap,
		    74, 2,
		    243+dx, 81,
		    22, 15);
#endif
    break;
  }
}

/******************** draw_resize *********************
 * 						      *
 ******************************************************/

void draw_resize(GtkWidget *widget)
{
  gint dx, dy;
  dx = xmps_config.window_size_x - 275;
  dy = xmps_config.window_size_y - 150;

#ifdef HAVE_GDKPIXBUF
  gdk_pixbuf_render_to_drawable (controls_pixbuf,widget->window,
				 widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				 2, 75,
				 253+dx, 126+dy,
				 17, 19,GDK_RGB_DITHER_NONE, 0, 0);
#else
  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  controls_pixmap,
                  2, 75,
                  253+dx, 126+dy,
                  17, 19);
#endif
}

/***************** draw_progress_bar ******************
 * 						      *
 ******************************************************/

void draw_progression_bar(GtkWidget *widget)
{
  int i, dx;
  dx = xmps_config.window_size_x - 275;

#ifdef HAVE_GDKPIXBUF

  gdk_pixbuf_render_to_drawable (controls_pixbuf,widget->window,
				 widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				 xmps_config.progress_bar.pos_x, xmps_config.progress_bar.pos_y,
				 xmps_config.progress_bar.bar_rect.start_x, xmps_config.progress_bar.bar_rect.start_y,
				 60, xmps_config.progress_bar.bar_rect.size_y,GDK_RGB_DITHER_NONE, 0, 0);
  for (i=0; i<dx; i++) 
    gdk_pixbuf_render_to_drawable (controls_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   xmps_config.progress_bar.pos_x+60, xmps_config.progress_bar.pos_y,
				   xmps_config.progress_bar.bar_rect.start_x+60+i, xmps_config.progress_bar.bar_rect.start_y,
				   1, xmps_config.progress_bar.bar_rect.size_y,GDK_RGB_DITHER_NONE, 0, 0);
  
  gdk_pixbuf_render_to_drawable (controls_pixbuf,widget->window,
				 widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				 xmps_config.progress_bar.pos_x+60, xmps_config.progress_bar.pos_y,
				 xmps_config.progress_bar.bar_rect.start_x+60+dx, xmps_config.progress_bar.bar_rect.start_y,
				 205, xmps_config.progress_bar.bar_rect.size_y,GDK_RGB_DITHER_NONE, 0, 0);
  
  
  gdk_pixbuf_render_to_drawable (controls_pixbuf,widget->window,
				 widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				 xmps_config.progress_bar.cursor_pos_x, xmps_config.progress_bar.cursor_pos_y,
				 xmps_config.progress_bar.bar_rect.start_x + 4 + xmps_config.progress_bar.value*(xmps_config.progress_bar.bar_rect.size_x 
                                 - xmps_config.progress_bar.cursor_rect.size_x 
				 - 4)/100, xmps_config.progress_bar.bar_rect.start_y + 
                                 (xmps_config.progress_bar.bar_rect.size_y - xmps_config.progress_bar.cursor_rect.size_y)/2,
				 xmps_config.progress_bar.cursor_rect.size_x, xmps_config.progress_bar.cursor_rect.size_y,GDK_RGB_DITHER_NONE, 0, 0);
#else

  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  controls_pixmap,
                  xmps_config.progress_bar.pos_x, xmps_config.progress_bar.pos_y,
                  xmps_config.progress_bar.bar_rect.start_x, xmps_config.progress_bar.bar_rect.start_y,
                  60, xmps_config.progress_bar.bar_rect.size_y);
  for (i=0; i<dx; i++)
  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  controls_pixmap,
                  xmps_config.progress_bar.pos_x+60, xmps_config.progress_bar.pos_y,
                  xmps_config.progress_bar.bar_rect.start_x+60+i, xmps_config.progress_bar.bar_rect.start_y,
                  1, xmps_config.progress_bar.bar_rect.size_y);

  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  controls_pixmap,
                  xmps_config.progress_bar.pos_x+60, xmps_config.progress_bar.pos_y,
                  xmps_config.progress_bar.bar_rect.start_x+60+dx, xmps_config.progress_bar.bar_rect.start_y,
                  205, xmps_config.progress_bar.bar_rect.size_y);


  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  controls_pixmap,
                  xmps_config.progress_bar.cursor_pos_x, xmps_config.progress_bar.cursor_pos_y,
                  xmps_config.progress_bar.bar_rect.start_x + 4 + xmps_config.progress_bar.value*(xmps_config.progress_bar.bar_rect.size_x 
                  - xmps_config.progress_bar.cursor_rect.size_x - 4)/100, xmps_config.progress_bar.bar_rect.start_y + 
                  (xmps_config.progress_bar.bar_rect.size_y - xmps_config.progress_bar.cursor_rect.size_y)/2,
                  xmps_config.progress_bar.cursor_rect.size_x, xmps_config.progress_bar.cursor_rect.size_y);



#endif
}



void draw_progress_bar(xmps_progress_bar p_bar, GtkWidget *widget)
{
#ifdef HAVE_GDKPIXBUF
   gdk_pixbuf_render_to_drawable (controls_pixbuf,widget->window,
				  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				  p_bar.pos_x, p_bar.pos_y,
				  p_bar.bar_rect.start_x, p_bar.bar_rect.start_y,
				  p_bar.bar_rect.size_x, p_bar.bar_rect.size_y,GDK_RGB_DITHER_NONE, 0, 0);

  
   gdk_pixbuf_render_to_drawable (controls_pixbuf,widget->window,
				  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				  p_bar.cursor_pos_x, p_bar.cursor_pos_y,
				  p_bar.bar_rect.start_x + 4 + p_bar.value*(p_bar.bar_rect.size_x - p_bar.cursor_rect.size_x - 4)/100, 
				  p_bar.bar_rect.start_y + (p_bar.bar_rect.size_y - p_bar.cursor_rect.size_y)/2,
				  p_bar.cursor_rect.size_x, p_bar.cursor_rect.size_y,GDK_RGB_DITHER_NONE, 0, 0);
#else

  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  controls_pixmap,
                  p_bar.pos_x, p_bar.pos_y,
                  p_bar.bar_rect.start_x, p_bar.bar_rect.start_y,
                  p_bar.bar_rect.size_x, p_bar.bar_rect.size_y);


  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  controls_pixmap,
                  p_bar.cursor_pos_x, p_bar.cursor_pos_y,
                  p_bar.bar_rect.start_x + 4 + p_bar.value*(p_bar.bar_rect.size_x - p_bar.cursor_rect.size_x - 4)/100, p_bar.bar_rect.start_y + (p_bar.bar_rect.size_y - p_bar.cursor_rect.size_y)/2,
                  p_bar.cursor_rect.size_x, p_bar.cursor_rect.size_y);


#endif
}


