/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * main : skinned window main file.
 
 */

/* includes */

#include "gnome_window.h"

GtkAdjustment *seek    = NULL;
GtkAdjustment *volume  = NULL;
GtkWidget     *filename_label;
GtkWidget     *time_label;
unsigned int   gnome_trackbar_dragging = 0;
int old_time;
int no_resize;

GnomeUIInfo file1_menu_uiinfo[] =
{
  GNOMEUIINFO_MENU_OPEN_ITEM (on_open1_activate, NULL),
  {
    GNOME_APP_UI_ITEM, N_("Open URL..."),
    NULL,
    on_open_url1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BOOK_GREEN,
    GDK_A, GDK_CONTROL_MASK, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("File Infos"),
    NULL,
    on_file_infos1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PREF,
    GDK_I, GDK_CONTROL_MASK, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_EXIT_ITEM (on_quit1_activate, NULL),
  GNOMEUIINFO_END
};

GnomeUIInfo edit1_menu_uiinfo[] =
{
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_TOGGLEITEM, N_("Loop"),
    NULL,
    on_loop1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    GDK_A, GDK_CONTROL_MASK, NULL
  },
  {
    GNOME_APP_UI_TOGGLEITEM, N_("Keep aspect ratio"),
    NULL,
    on_ratio1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    GDK_R, GDK_CONTROL_MASK, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Active Plugins"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    GDK_O, GDK_CONTROL_MASK, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("Go to fullscreen"),
    NULL,
    on_fullscreen1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    GDK_A, GDK_CONTROL_MASK, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("Global Preferences"),
    NULL,
    on_global_preferences1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PREF,
    GDK_G, GDK_CONTROL_MASK, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Save options now"),
    NULL,
    on_save_options_now1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    GDK_S, GDK_CONTROL_MASK, NULL
  },
  GNOMEUIINFO_END
};

GnomeUIInfo help1_menu_uiinfo[] =
{
  GNOMEUIINFO_MENU_ABOUT_ITEM (on_about1_activate, NULL),
  GNOMEUIINFO_END
};

GnomeUIInfo menubar1_uiinfo[] =
{
  {
    GNOME_APP_UI_SUBTREE, N_("File"),
    NULL,
    file1_menu_uiinfo, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_SUBTREE, N_("Preferences"),
    NULL,
    edit1_menu_uiinfo, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_SUBTREE, N_("Help"),
    NULL,
    help1_menu_uiinfo, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_END
};

/* functions */

void gnome_save_options()
{
  char *filename;

  filename = g_strconcat(g_get_home_dir(), "/.xmps/config", NULL);

  if (!config.cfgfile)
    config.cfgfile = xmps_config_file_new();

  xmps_config_write_int(config.cfgfile, "gnome_gui", "window_pos_x", config.window_pos_x);
  xmps_config_write_int(config.cfgfile, "gnome_gui", "window_pos_y", config.window_pos_y);
  xmps_config_write_boolean(config.cfgfile, "gnome_gui", "loop", config.is_loop);
  xmps_config_write_boolean(config.cfgfile, "gnome_gui", "keep_aspect_ratio", config.keep_aspect);
  xmps_config_write_boolean(config.cfgfile, "gnome_gui", "fullscreen", config.fullscreen);
  xmps_config_write_string(config.cfgfile, "gnome_gui", "filesel_dir", config.filesel_dir);

}

void gnome_load_options()
{
   config.window_pos_x   = 250;
   config.window_pos_y   = 100;
   config.is_loop        = FALSE;
   config.keep_aspect    = FALSE;
   config.fullscreen     = FALSE;
   config.filesel_dir    = g_strconcat(g_get_home_dir(), "/", NULL);
   config.file_selection = NULL;

   if(config.cfgfile)
     {
       xmps_config_read_int(config.cfgfile, "gnome_gui", "window_pos_x", &config.window_pos_x);
       xmps_config_read_int(config.cfgfile, "gnome_gui", "window_pos_y", &config.window_pos_y);
       xmps_config_read_boolean(config.cfgfile, "gnome_gui", "loop", &config.is_loop);
       xmps_config_read_boolean(config.cfgfile, "gnome_gui", "keep_aspect_ratio", &config.keep_aspect);
       xmps_config_read_boolean(config.cfgfile, "gnome_gui", "fullscreen", &config.fullscreen);
       xmps_config_read_string(config.cfgfile, "gnome_gui", "filesel_dir", &config.filesel_dir);
     }
}

void gnome_window_quit()
{
  XMPS_DEBUG("quiting...");

  gnome_save_options();

  xmps_playback_close(config.session);

  gtk_main_quit();
}

char *format_time_text(unsigned long time)
{
  char *result;
  int hours, minutes, seconds;

  result = (char*) malloc(9);

  hours   = time/3600;
  minutes = (time - hours*3600)/60;
  seconds = (time - hours*3600 - minutes*60);  

  sprintf(result, "%.2d:%.2d:%.2d", hours, minutes, seconds);

  return result;
}

void gtk_draw_logo(GtkWidget *widget)
{
  GdkGC *gc;
  gint  x,y;
  
  x = config.window_size_x;
  y = config.window_size_y - 110;
  
  gc = gdk_gc_new(widget->window);   
  gdk_rgb_gc_set_foreground(gc, 8*65536 + 21*256 + 56);
  gdk_draw_rectangle(widget->window, gc, TRUE, 0, 0, x, y);
  
  if(config.window_size_y >= 335) {
    
    gdk_draw_pixmap(widget->window,
		    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		    logo_pixmap,
		    0, 0,
		    (x-261)/2, ((y-25)-199)/2+25,
		    261, 199);
  }
  
  gdk_flush();
}

void gnome_start_playing()
{
  if(xmps_playlist_get_nbr_items(config.playlist) > 0)
    {
      xmps_video_info_t *video_info;

      xmps_playback_setup_video(config.session, 1, 0, 26, ((GdkWindowPrivate *)(config.window->window))->xwindow, "SDL");

      xmps_playback_open(config.session,
			 ((xmps_item_t *) xmps_playlist_get_item(config.playlist))->full_path);
      
      video_info =  xmps_playback_get_video_info(config.session);
      
      if(video_info != NULL && xmps_playback_has_video(config.session)) {

	/*
	 * preset size to avoid gtk callback
	 * from resize (no manual)
	 *
	 */
	
	config.window_size_x = video_info->width;
	config.window_size_y = video_info->height + 135;

	XMPS_DEBUG("resizing to info : %dx%d", video_info->width, video_info->height + 135);
	  
	gdk_window_resize(config.window->window, 
			  video_info->width, 
			  video_info->height + 135);
	gdk_flush();
      }
      
      if(xmps_playback_has_audio(config.session) && !xmps_playback_has_video(config.session))
	{
	  XMPS_DEBUG("stream is only audio");

	  gdk_window_resize(config.window->window, 275, 135);
	  gtk_draw_logo(config.window);
	  gdk_flush();
	}

      xmps_playback_set_loop(config.session, config.is_loop);
      
      /* 
       * let's rock, well sort of..
       *
       */
      
      config.has_to_play = 0;
      
      gdk_window_clear_area (filename_label->window,
			     filename_label->allocation.x, 
			     filename_label->allocation.y,
			     filename_label->allocation.width,
			     filename_label->allocation.height);

      gtk_label_set_text(GTK_LABEL(filename_label), xmps_playlist_get_item(config.playlist)->display_name);
      
      xmps_playback_play(config.session);
    }
}

gint gnome_gui_idle(gpointer data)
{
      gint event;


  if(config.has_to_play)
    {
      if(config.start_time == 0)
	config.start_time = gdk_time_get();

      if(gdk_time_get() - config.start_time > 500) {
	
	xmps_playlist_reset(config.playlist);
	config.has_to_play = 0;
	gnome_start_playing();
      }
    }

      do
	{
	  event = pop_xmps_event();

	  switch(event)
	    {
	    case XMPS_EVENT_BACK_FROM_FULLSCREEN:

	      XMPS_DEBUG("back from fullscreen");

	      config.fullscreen = 0; 
	      xmps_playback_video_fullscreen(config.session, 0);
	      break;

	    case XMPS_EVENT_EXIT:

	      gnome_window_quit();
	      break;

	    default:
	      break;
	    }
	}
      while(event != XMPS_EVENT_NO_EVENT);

  if(xmps_playback_is_playing(config.session))
    {
      char *current, *total;
      xmps_time_t *t_info = NULL;
      
      /* get current playback time */

      t_info = xmps_playback_get_time_info(config.session);


      if(t_info != NULL)
	{
	  if(! gnome_trackbar_dragging ) {
	    if(t_info->total_time != 0) {
	      
	      if(t_info->current_time*100/t_info->total_time != (int) seek->value) {
		
		gtk_adjustment_set_value(seek, t_info->current_time*100/t_info->total_time);
	      }
	    }
	  }

	  /*
	   * setup the time label
	   * 
	   */
	  
	  current = format_time_text(t_info->current_time);
	  total   = format_time_text(t_info->total_time);

	  if(t_info->current_time != old_time) {
	    gdk_window_clear_area (time_label->window,
				   time_label->allocation.x, 
				   time_label->allocation.y,
				   time_label->allocation.width,
				   time_label->allocation.height);
	    
	    old_time = t_info->current_time;

	    gtk_label_set_text(GTK_LABEL(time_label), g_strconcat(current, " / ", total, NULL));
	  
	  }

	    
	  free(current);
	  free(total);
	  
	}

      /* check for events */
      
    }

  return TRUE;
}


void gnome_file_ok (GtkWidget *w, GtkFileSelection *fs)
{
  GList *file_node;
  char  *filename;
  gint   index;
  gchar *dir = NULL;
  struct stat buf;
  xmps_item_t *item;

  gtk_widget_hide(config.file_selection);
  
  filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(config.file_selection));

  /* remove the blanks */
  g_strstrip(filename);

  /* remember the directory into config */

  /* check if it's a directory or a file */
  if (stat(filename, &buf) == 0)
    {
      if (S_ISDIR(buf.st_mode))
	{
	  g_free(config.filesel_dir);
	  config.filesel_dir = (char*) malloc(strlen(filename)+1);
	  strcpy(config.filesel_dir, filename);
	  
	  /* set the dir for next time */
	  gtk_file_selection_set_filename(GTK_FILE_SELECTION(config.file_selection),  g_strdup_printf("%s/", filename));
	  return;
	}
      else
	/* remember the dir in case of multiple sel */
	{
	  index = strlen(filename);
	  while (filename[index - 1] != '/')
	    {
	      filename[index - 1] = '\0';
	      index = strlen(filename);
	    }
	  
	  dir = filename;
	  
	  config.filesel_dir = (char*) malloc(strlen(dir)+1);
	  strcpy(config.filesel_dir, dir);
	}
    }

  /* process the selected files */

  xmps_playback_stop(config.session);
  xmps_playback_close(config.session);
  xmps_playlist_clear(config.playlist);
  
  for(file_node = GTK_CLIST(GTK_FILE_SELECTION(config.file_selection)->file_list)->selection; file_node != NULL; file_node = g_list_next(file_node))
    {
      gtk_clist_get_text(GTK_CLIST(GTK_FILE_SELECTION(config.file_selection)->file_list), (gint) file_node->data, 0, &filename);
      XMPS_DEBUG("trying to open %s", filename);

      item = (xmps_item_t *) xmps_item_new(XMPS_MEDIA_FILE, (char *) g_strconcat(dir, filename, NULL));

      xmps_playlist_add(config.playlist, item);
    }

  xmps_playlist_reset(config.playlist);
  gnome_start_playing();
}

void gnome_file_cancel (GtkWidget *widget, gpointer data)
{
  gtk_widget_hide(config.file_selection);
}

void gnome_file_destroy (GtkWidget *widget, gpointer data)
{
  config.file_selection = NULL;
}

void gnome_create_file_selection()
{
  if(config.file_selection == NULL)
    {
      config.file_selection = gtk_file_selection_new(_("Open Video files..."));
      gtk_clist_set_selection_mode(GTK_CLIST(GTK_FILE_SELECTION(config.file_selection)->file_list), GTK_SELECTION_EXTENDED);
      
      gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (config.file_selection)->ok_button),
			  "clicked", (GtkSignalFunc) gnome_file_ok, config.file_selection );
      gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (config.file_selection)->cancel_button),
				 "clicked", (GtkSignalFunc) gnome_file_cancel, GTK_OBJECT (config.file_selection));
      gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (config.file_selection)->cancel_button),
				 "destroy", (GtkSignalFunc) gnome_file_destroy, GTK_OBJECT (config.file_selection));
      
      gtk_file_selection_set_filename (GTK_FILE_SELECTION(config.file_selection), config.filesel_dir);
    }
}

void
on_file1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_open1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if(config.file_selection == NULL)
    {
      gnome_create_file_selection();

    }
  gtk_widget_show(config.file_selection);
}

void
on_add_to_playlist1_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}

void
on_url_ok_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget   *item;
  xmps_item_t *xmps_item;

  item =  (GtkWidget*) gtk_object_get_data (GTK_OBJECT (user_data), "entry1");
  gtk_widget_hide((GtkWidget *) user_data);

  if(item != NULL) {
    
    char *url;

    url = gtk_entry_get_text(GTK_ENTRY(item));

    if(url != NULL && strlen(url) > 6) {

      XMPS_DEBUG("got URL : %s", url);
      
      xmps_item = (xmps_item_t *) xmps_item_new(XMPS_MEDIA_HTTP, url);
      
      xmps_playlist_add(config.playlist, xmps_item);    
      xmps_playlist_reset(config.playlist);
      gnome_start_playing();
    }
  }
  
}


void
on_url_cancel_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_hide((GtkWidget *) user_data);
}


void
on_open_url1_activate           (GtkMenuItem     *menuitem,
				 gpointer         user_data)
{

  /*
   * open URL window
   */

  GtkWidget *open_url;
  GtkWidget *frame1;
  GtkWidget *vbox1;
  GtkWidget *label2;
  GtkWidget *entry1;
  GtkWidget *hbox1;
  GtkWidget *label1;
  GtkWidget *url_ok;
  GtkWidget *url_cancel;
  
  open_url = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_object_set_data (GTK_OBJECT (open_url), "open_url", open_url);
  gtk_container_set_border_width (GTK_CONTAINER (open_url), 1);
  gtk_window_set_title (GTK_WINDOW (open_url), _("Open URL"));
  gtk_window_set_position (GTK_WINDOW (open_url), GTK_WIN_POS_CENTER);
  gtk_window_set_modal (GTK_WINDOW (open_url), TRUE);
  gtk_window_set_policy (GTK_WINDOW (open_url), FALSE, FALSE, FALSE);

  frame1 = gtk_frame_new (_(" Open URL... "));
  gtk_widget_ref (frame1);
  gtk_object_set_data_full (GTK_OBJECT (open_url), "frame1", frame1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame1);
  gtk_container_add (GTK_CONTAINER (open_url), frame1);
  gtk_container_set_border_width (GTK_CONTAINER (frame1), 4);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (open_url), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (frame1), vbox1);
  gtk_container_set_border_width (GTK_CONTAINER (vbox1), 4);

  label2 = gtk_label_new (_("Enter url to open:"));
  gtk_widget_ref (label2);
  gtk_object_set_data_full (GTK_OBJECT (open_url), "label2", label2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (vbox1), label2, FALSE, FALSE, 0);
  gtk_misc_set_alignment (GTK_MISC (label2), 0.02, 0.5);

  entry1 = gtk_entry_new ();
  gtk_widget_ref (entry1);
  gtk_object_set_data_full (GTK_OBJECT (open_url), "entry1", entry1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry1);
  gtk_box_pack_start (GTK_BOX (vbox1), entry1, FALSE, FALSE, 0);
  gtk_widget_set_usize (entry1, 292, -2);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox1);
  gtk_object_set_data_full (GTK_OBJECT (open_url), "hbox1", hbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox1), 4);

  label1 = gtk_label_new ("");
  gtk_widget_ref (label1);
  gtk_object_set_data_full (GTK_OBJECT (open_url), "label1", label1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (hbox1), label1, TRUE, TRUE, 0);

  url_ok = gtk_button_new_with_label (_("OK"));
  gtk_widget_ref (url_ok);
  gtk_object_set_data_full (GTK_OBJECT (open_url), "url_ok", url_ok,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (url_ok);
  gtk_box_pack_start (GTK_BOX (hbox1), url_ok, FALSE, FALSE, 0);
  gtk_widget_set_usize (url_ok, 55, 30);
  gtk_container_set_border_width (GTK_CONTAINER (url_ok), 2);

  url_cancel = gtk_button_new_with_label (_("Cancel"));
  gtk_widget_ref (url_cancel);
  gtk_object_set_data_full (GTK_OBJECT (open_url), "url_cancel", url_cancel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (url_cancel);
  gtk_box_pack_start (GTK_BOX (hbox1), url_cancel, FALSE, FALSE, 0);
  gtk_widget_set_usize (url_cancel, 55, 24);
  gtk_container_set_border_width (GTK_CONTAINER (url_cancel), 2);
  
  gtk_signal_connect (GTK_OBJECT (url_ok), "clicked",
                      GTK_SIGNAL_FUNC (on_url_ok_clicked),
                      open_url);
  gtk_signal_connect (GTK_OBJECT (url_cancel), "clicked",
                      GTK_SIGNAL_FUNC (on_url_cancel_clicked),
                      open_url);
  
  gtk_widget_show(open_url);
}

void
on_quit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gnome_window_quit();
}


void
on_edit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_global_preferences1_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  xmps_gtk_config_create(config.session);
  xmps_gtk_config_show();
}

void
on_help1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  xmps_about_create();
  xmps_about_show();
}


void
on_file_infos1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  xmps_file_info_create(config.session);
  xmps_file_info_show();
}


void
on_show_playlist1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
}


void
on_skin_browser1_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  
}

void
on_save_options_now1_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_rewind_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  xmps_playback_close(config.session);
  xmps_playlist_prev(config.playlist);
  gnome_start_playing();
}

void
on_stop_clicked                        (GtkButton       *button,
                                        gpointer         user_data)
{
  xmps_playback_stop(config.session);
}

void
on_play_clicked                        (GtkButton       *button,
                                        gpointer         user_data)
{
  xmps_playback_play(config.session);
}

void
on_pause_clicked                       (GtkButton       *button,
                                        gpointer         user_data)
{
  xmps_playback_pause(config.session);
}

void
on_fast_forward_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  xmps_playback_close(config.session);
  xmps_playlist_next(config.playlist);
  gnome_start_playing();
}


void
on_load_clicked                        (GtkButton       *button,
                                        gpointer         user_data)
{
  if(config.file_selection == NULL)
    {
      gnome_create_file_selection();
    }
  gtk_widget_show(config.file_selection);
}

void
on_loop1_activate                      (GtkCheckMenuItem     *menuitem,
                                        gpointer         user_data)
{
  config.is_loop = GTK_CHECK_MENU_ITEM(menuitem)->active;
  /*
  if(config.is_loop)
    xmps_playback_set_flags(config.playback, XMPS_LOOP_SET, 1);
  */
}

void
on_ratio1_activate                      (GtkCheckMenuItem     *menuitem,
                                        gpointer         user_data)
{
  config.keep_aspect = GTK_CHECK_MENU_ITEM(menuitem)->active;
}

void
on_fullscreen1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  XMPS_DEBUG("switching to fullscreen ");
  
  config.fullscreen = 1; 
  xmps_playback_video_fullscreen(config.session, 1);
  
}

gboolean
on_gtk_window_configure_event          (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
  
  if( (event->width != config.window_size_x || event->height != config.window_size_y))
    {
      if(!((event->width % 4) == 0))
	{
	  XMPS_DEBUG("resizing to 4 alignment from %dx%d", event->width, event->height);

	  gdk_window_resize(config.window->window, event->width + (event->width % 4), event->height);
	  return FALSE;
	}
      else
	{
	  if(!config.keep_aspect) {

	    config.window_size_x = event->width;
	    config.window_size_y = event->height;
	    
	    XMPS_DEBUG("resizing window");
	    
	    if(config.session != NULL)
	      {
		xmps_video_info_t *info;
		
		info = (xmps_video_info_t *) xmps_playback_get_video_info(config.session);
		
		if(info == NULL)
		  return FALSE;
		
		if(event->width != info->width || event->height - 135 != info->height)
		  {
		    XMPS_DEBUG("resizing window surface");
		    
		    xmps_playback_video_resize(config.session, event->width, event->height - 135);
		    gdk_window_clear_area (config.window->window,
					   0, 
					   event->height  - 135,
					   event->width,
					   135);
		  }
	      }
	  }
	  else 
	    if(config.session != NULL && xmps_playback_is_playing(config.session)) {

	      int height;
	      xmps_video_info_t *info;
	      
	      info = (xmps_video_info_t *) xmps_playback_get_video_info(config.session);
	      
	      height = event->width*info->height/info->width + 135;
	      
	      config.window_size_x = event->width + (event->width % 4);
	      config.window_size_y = height;

	      XMPS_DEBUG("sizing to aspect ratio");

	      xmps_playback_video_resize(config.session, event->width, height - 135);
	      gdk_window_resize(config.window->window, event->width + (event->width % 4), height);

	      return FALSE;
	    }
	    else {

	      config.window_size_x = event->width;
	      config.window_size_y = event->height;
	    }
	}
      
      if(!xmps_playback_is_playing(config.session))
	{
	  gtk_draw_logo(widget);
	  gdk_flush();
	}
    }
    
    return FALSE;
}

gint on_key_press_event (GtkWidget * w, GdkEventKey * event, gpointer data)
{
  switch(event->keyval)
    {
    case GDK_f:
    case GDK_F:
      XMPS_DEBUG("switching to fullscreen ");
      
      config.fullscreen = 1;
      xmps_playback_video_fullscreen(config.session, 1);
      break;
    case GDK_Left:
      xmps_playback_close(config.session);
      xmps_playlist_prev(config.playlist);
      gnome_start_playing();
      break;
    case GDK_Right:
      xmps_playback_close(config.session);
      xmps_playlist_next(config.playlist);
      gnome_start_playing();
      break;
    case GDK_p:
    case GDK_P:
      XMPS_DEBUG("toggle_pause");
      xmps_playback_pause(config.session);
      break;
    default:
      break;      
    } 

  return FALSE;
}

void gnome_trackbar_drag_on(GtkWidget *widget, gpointer raw)
{
    gnome_trackbar_dragging = 1;
}

void gnome_trackbar_drag_off(GtkWidget *widget, gpointer raw)
{
  gnome_trackbar_dragging = 0;

  XMPS_DEBUG("seeking to %f", seek->value);
  
  xmps_playback_seek(config.session, (int) seek->value);
  
}

void gnome_seek( GtkAdjustment* adjust, gpointer raw )
{
 if(!gnome_trackbar_dragging) 
   return;

 XMPS_DEBUG("seek : value changed to %f", adjust->value);
}

void gnome_volume( GtkAdjustment* adjust, gpointer raw )
{
  XMPS_DEBUG("volume : value changed to %f", adjust->value);
  
  xmps_playback_set_volume(config.session, (int) adjust->value);
}

static gint gtk_expose_event (GtkWidget *widget, GdkEventExpose *event)
 {
   if(!xmps_playback_is_playing(config.session))
     {
       gtk_draw_logo(widget);
       gdk_flush();
     }
   
   if(xmps_playback_is_playing(config.session) && !xmps_playback_has_video(config.session))
     {
       gtk_draw_logo(widget);
       gdk_flush();
     }

   return FALSE;
 }

void
on_gtk_player1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
}


void
on_skinned_player1_activate            (GtkMenuItem     *menuitem,
                                      gpointer         user_data)
{
}

void gnome_shared_menu_callback(gpointer cb_data, guint action, GtkWidget * w)
{

  if( ((xmps_menu_item_t *)cb_data)->active == 0 )
    ((xmps_menu_item_t *)cb_data)->active = 1;
  else 
    ((xmps_menu_item_t *)cb_data)->active = 0;

  config.menu_callback(((xmps_menu_item_t *)cb_data)->id, ((xmps_menu_item_t *)cb_data)->active);
}

/* functions */

void gnome_create_shared_menu(xmps_menu_t *menu)
{
  GtkWidget *shared_menu, *gtk_item;
  xmps_menu_item_t *menu_item;
  GSList *items_group = NULL;
  int group = 0;
  int first;

  first = 1;
  config.menu_callback = menu->callback;

  shared_menu = gtk_menu_new ();
  xmps_menu_reset(menu);

  do
    {
      menu_item = (xmps_menu_item_t *) xmps_menu_get_item(menu);
      if(menu_item != NULL)
	{
	  if( strstr(menu_item->label, "-") )
	    {
	      gtk_item = gtk_menu_item_new();
	      gtk_menu_append (GTK_MENU (shared_menu), gtk_item);
	      gtk_widget_show (gtk_item);
	    }
	  else
	    {
	      if(menu_item->type == XMPS_MENU_ITEM_TYPE_RADIO)
		{
		  if(first)
		    {
		      // temp
		      menu_item->active = 1;

		      gtk_item = gtk_radio_menu_item_new_with_label(items_group, menu_item->label);
		      items_group = gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM (gtk_item));
		      first = 0;
		      group = menu_item->group; 
		    }
		  else
		    if(menu_item->group == group)
		      {
			gtk_item = gtk_radio_menu_item_new_with_label(items_group, menu_item->label);
			items_group = gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM (gtk_item));
		      }
		    else
		      {
			gtk_item = gtk_radio_menu_item_new_with_label(NULL, menu_item->label);
			items_group = gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM (gtk_item));
			group = menu_item->group; 
		      }
		}
	      else
		gtk_item = gtk_menu_item_new_with_label( menu_item->label );
	      
	      gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(gtk_item), menu_item->active);
	      gtk_menu_append (GTK_MENU (shared_menu), gtk_item);
	      
	      gtk_signal_connect_object (GTK_OBJECT (gtk_item), "activate",
					 GTK_SIGNAL_FUNC (gnome_shared_menu_callback),
					 (gpointer) menu_item );
	      gtk_widget_show (gtk_item);
	    }
	}
    }
  while(xmps_menu_next(menu));

  gtk_menu_item_set_submenu(GTK_MENU_ITEM(edit1_menu_uiinfo[3].widget), shared_menu);

  // the loop

  gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(edit1_menu_uiinfo[1].widget), config.is_loop);
  gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(edit1_menu_uiinfo[2].widget), config.keep_aspect);
}

gint gtk_button_press_event (GtkWidget *widget, GdkEventButton *event)
{
  XMPS_DEBUG("button press");
  
  if (event->button == 1) {
  

  }
  else {

   // gtk_menu_popup(GTK_MENU(config.popup_menu), NULL, NULL, 
   //		   NULL, NULL, event->button, event->time);
  }
  
  return 0;
}

/* main function */

GtkWidget *gnome_window_new(xmps_config_file_t *cfgfile, xmps_menu_t *menu)
{
  GtkWidget *g_window;
  GtkWidget *vbox1;
  GtkWidget *menubar1;
  GtkWidget *drawing_area;
  GtkWidget *frame1;
  GtkWidget *frame2;
  GtkWidget *vbox2;
  GtkWidget *frame21;
  GtkWidget *hbox31;
  GtkWidget *hbox4;
  GtkWidget *vbox3;
  GtkWidget *hbox2;
  GtkWidget *label2;
  GtkWidget *hbox3;
  GtkWidget *label4;
  GtkWidget *vbox4;
  GtkWidget *label5;
  GtkWidget *volume_scale;
  GtkWidget *progress_scale;
  GtkWidget *hbox1;
  GtkWidget *rewind;
  GtkWidget *stop;
  GtkWidget *play;
  GtkWidget *pause;
  GtkWidget *fast_forward;
  GtkWidget *load;
  GtkAccelGroup *accel_group;
  GtkWidget *play_pixmap;
  GtkWidget *stop_pixmap;
  GtkWidget *pause_pixmap;
  GtkWidget *rewind_pixmap;
  GtkWidget *fast_forward_pixmap;
  GtkWidget *load_pixmap;
  GtkWidget *dummy;
  
  accel_group = gtk_accel_group_new ();

  g_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (g_window, "g_window");
  gtk_object_set_data (GTK_OBJECT (g_window), "g_window", g_window);
  gtk_window_set_title (GTK_WINDOW (g_window), _("X Movie Player System"));
  gtk_window_set_default_size (GTK_WINDOW (g_window), 275, 135);
  gtk_widget_set_usize (g_window, 275, 335);

  config.window_size_x = 275;
  config.window_size_y = 335;

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox1, "vbox1");
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (g_window), vbox1);

  menubar1 = gtk_menu_bar_new ();
  gtk_widget_set_name (menubar1, "menubar1");
  gtk_widget_ref (menubar1);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "menubar1", menubar1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (menubar1);
  gtk_box_pack_start (GTK_BOX (vbox1), menubar1, FALSE, FALSE, 0);
  gnome_app_fill_menu (GTK_MENU_SHELL (menubar1), menubar1_uiinfo,
                       NULL, FALSE, 0);

  gtk_widget_set_name (menubar1_uiinfo[0].widget, "file1");
  gtk_widget_ref (menubar1_uiinfo[0].widget);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "file1",
                            menubar1_uiinfo[0].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_set_name (file1_menu_uiinfo[0].widget, "open1");
  gtk_widget_ref (file1_menu_uiinfo[0].widget);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "open1",
                            file1_menu_uiinfo[0].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_set_name (file1_menu_uiinfo[1].widget, "add_to_playlist1");
  gtk_widget_ref (file1_menu_uiinfo[1].widget);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "add_to_playlist1",
                            file1_menu_uiinfo[1].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_set_name (file1_menu_uiinfo[2].widget, "separator1");
  gtk_widget_ref (file1_menu_uiinfo[2].widget);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "separator1",
                            file1_menu_uiinfo[2].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_set_name (file1_menu_uiinfo[3].widget, "file_infos1");
  gtk_widget_ref (file1_menu_uiinfo[3].widget);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "file_infos1",
                            file1_menu_uiinfo[3].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_set_name (file1_menu_uiinfo[4].widget, "separator3");
  gtk_widget_ref (file1_menu_uiinfo[4].widget);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "separator3",
                            file1_menu_uiinfo[4].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_set_name (file1_menu_uiinfo[5].widget, "quit1");
  gtk_widget_ref (file1_menu_uiinfo[5].widget);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "quit1",
                            file1_menu_uiinfo[5].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_set_name (menubar1_uiinfo[1].widget, "edit1");
  gtk_widget_ref (menubar1_uiinfo[1].widget);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "edit1",
                            menubar1_uiinfo[1].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_set_name (edit1_menu_uiinfo[0].widget, "show_playlist1");
  gtk_widget_ref (edit1_menu_uiinfo[0].widget);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "show_playlist1",
                            edit1_menu_uiinfo[0].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_set_name (edit1_menu_uiinfo[1].widget, "separator2");
  gtk_widget_ref (edit1_menu_uiinfo[1].widget);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "separator2",
                            edit1_menu_uiinfo[1].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_set_name (edit1_menu_uiinfo[2].widget, "loop1");
  gtk_widget_ref (edit1_menu_uiinfo[2].widget);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "loop1",
                            edit1_menu_uiinfo[2].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_set_name (edit1_menu_uiinfo[3].widget, "fullscreen1");
  gtk_widget_ref (edit1_menu_uiinfo[3].widget);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "fullscreen1",
                            edit1_menu_uiinfo[3].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_set_name (edit1_menu_uiinfo[4].widget, "separator2");
  gtk_widget_ref (edit1_menu_uiinfo[4].widget);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "separator2",
                            edit1_menu_uiinfo[4].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_set_name (edit1_menu_uiinfo[5].widget, "options1");
  gtk_widget_ref (edit1_menu_uiinfo[5].widget);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "options1",
                            edit1_menu_uiinfo[5].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_set_name (edit1_menu_uiinfo[6].widget, "separator3");
  gtk_widget_ref (edit1_menu_uiinfo[6].widget);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "separator3",
                            edit1_menu_uiinfo[6].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_set_name (edit1_menu_uiinfo[7].widget, "save_options_now1");
  gtk_widget_ref (edit1_menu_uiinfo[7].widget);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "save_options_now1",
                            edit1_menu_uiinfo[7].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_set_name (edit1_menu_uiinfo[8].widget, "global_preferences1");
  gtk_widget_ref (edit1_menu_uiinfo[8].widget);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "global_preferences1",
                            edit1_menu_uiinfo[8].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_set_name (menubar1_uiinfo[2].widget, "help1");
  gtk_widget_ref (menubar1_uiinfo[2].widget);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "help1",
                            menubar1_uiinfo[2].widget,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_set_name (help1_menu_uiinfo[0].widget, "about1");
  gtk_widget_ref (help1_menu_uiinfo[0].widget);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "about1",
                            help1_menu_uiinfo[0].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  drawing_area = gtk_frame_new (NULL);
  gtk_widget_set_name (drawing_area, "frame");
  gtk_widget_ref (drawing_area);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "frame", drawing_area,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (drawing_area);
  gtk_box_pack_start (GTK_BOX (vbox1), drawing_area, TRUE, TRUE, 0);
  gtk_widget_set_usize (drawing_area, -2, 200);

  frame1 = gtk_frame_new (NULL);
  gtk_widget_set_name (frame1, "frame1");
  gtk_widget_ref (frame1);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "frame1", frame1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame1);
  gtk_box_pack_start (GTK_BOX (vbox1), frame1, FALSE, TRUE, 0);
  gtk_widget_set_usize (frame1, -2, 107);

  frame2 = gtk_frame_new (NULL);
  gtk_widget_set_name (frame2, "frame2");
  gtk_widget_ref (frame2);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "frame2", frame2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame2);
  gtk_container_add (GTK_CONTAINER (frame1), frame2);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox2, "vbox2");
  gtk_widget_ref (vbox2);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "vbox2", vbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox2);
  gtk_container_add (GTK_CONTAINER (frame2), vbox2);

  frame21 = gtk_frame_new (_(" File Info : "));
  gtk_widget_set_name (frame21, "frame21");
  gtk_widget_ref (frame21);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "frame21", frame21,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame21);
  gtk_box_pack_start (GTK_BOX (vbox2), frame21, TRUE, TRUE, 0);
  gtk_widget_set_usize (frame21, -2, 55);
  gtk_container_set_border_width (GTK_CONTAINER (frame21), 3);

  hbox31 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox31, "hbox31");
  gtk_widget_ref (hbox31);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "hbox31", hbox31,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox31);
  gtk_container_add (GTK_CONTAINER (frame21), hbox31);
  hbox4 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox4, "hbox4");
  gtk_widget_ref (hbox4);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "hbox4", hbox4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox4);
  gtk_box_pack_start (GTK_BOX (hbox31), hbox4, TRUE, TRUE, 0);

  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox3, "vbox3");
  gtk_widget_ref (vbox3);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "vbox3", vbox3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox3);
  gtk_box_pack_start (GTK_BOX (hbox4), vbox3, TRUE, TRUE, 0);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox2, "hbox2");
  gtk_widget_ref (hbox2);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "hbox2", hbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox2, FALSE, FALSE, 0);

  label2 = gtk_label_new (_(" Filename : "));
  gtk_widget_set_name (label2, "label2");
  gtk_widget_ref (label2);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "label2", label2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (hbox2), label2, FALSE, FALSE, 0);

  filename_label = gtk_label_new (_(""));
  gtk_widget_set_name (filename_label, "filename_label");
  gtk_widget_ref (filename_label);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "filename_label", filename_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (filename_label);
  gtk_box_pack_start (GTK_BOX (hbox2), filename_label, FALSE, FALSE, 0);

  hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox3, "hbox3");
  gtk_widget_ref (hbox3);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "hbox3", hbox3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox3, FALSE, FALSE, 0);

  label4 = gtk_label_new (_(" Time Info : "));
  gtk_widget_set_name (label4, "label4");
  gtk_widget_ref (label4);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "label4", label4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label4);
  gtk_box_pack_start (GTK_BOX (hbox3), label4, FALSE, FALSE, 0);

  time_label = gtk_label_new (_(""));
  gtk_widget_set_name (time_label, "time_label");
  gtk_widget_ref (time_label);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "time_label", time_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (time_label);
  gtk_box_pack_start (GTK_BOX (hbox3), time_label, FALSE, FALSE, 0);

  vbox4 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox4, "vbox4");
  gtk_widget_ref (vbox4);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "vbox4", vbox4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox4);
  gtk_box_pack_start (GTK_BOX (hbox4), vbox4, FALSE, TRUE, 0);
  gtk_widget_set_usize (vbox4, 70, -2);

  label5 = gtk_label_new (_("Volume"));
  gtk_widget_set_name (label5, "label5");
  gtk_widget_ref (label5);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "label5", label5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label5);
  gtk_box_pack_start (GTK_BOX (vbox4), label5, FALSE, FALSE, 0);

  volume = (GtkAdjustment *) gtk_adjustment_new (100.0, 0.0, 100.0, 1.0, 0.0, 0.0);
  gtk_signal_connect((GtkObject *) volume, "value_changed", gnome_volume, NULL);

  volume_scale = gtk_hscale_new ( volume );
  gtk_widget_set_name (volume_scale, "volume_scale");
  gtk_widget_ref (volume_scale);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "volume_scale", volume_scale,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (volume_scale);
  gtk_box_pack_start (GTK_BOX (vbox4), volume_scale, TRUE, TRUE, 0);
  gtk_scale_set_draw_value (GTK_SCALE (volume_scale), FALSE);
  gtk_scale_set_digits (GTK_SCALE (volume_scale), 0);

  gtk_scale_set_value_pos (GTK_SCALE(volume_scale), 100);

  seek = (GtkAdjustment *) gtk_adjustment_new (0.0, 0.0, 100.0, 1.0, 0.0, 0.0);
  gtk_signal_connect((GtkObject *) seek, "value_changed", gnome_seek, NULL);
  
  progress_scale = gtk_hscale_new(seek);
  gtk_widget_set_name (progress_scale, "progress_scale");
  gtk_widget_ref (progress_scale);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "progress_scale", progress_scale,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (progress_scale);
  
  gtk_signal_connect((GtkObject *) progress_scale, "button_press_event", gnome_trackbar_drag_on, NULL);
  gtk_signal_connect((GtkObject *) progress_scale, "button_release_event", gnome_trackbar_drag_off, NULL);

  gtk_box_pack_start (GTK_BOX (vbox2), progress_scale, FALSE, FALSE, 0);
  gtk_scale_set_draw_value (GTK_SCALE (progress_scale), FALSE);
  gtk_scale_set_value_pos (GTK_SCALE (progress_scale), GTK_POS_LEFT);
  gtk_scale_set_digits (GTK_SCALE (progress_scale), 0);
  gtk_range_set_update_policy (GTK_RANGE (progress_scale), GTK_UPDATE_DISCONTINUOUS);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox1, "hbox1");
  gtk_widget_ref (hbox1);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "hbox1", hbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox2), hbox1, TRUE, TRUE, 0);
  gtk_widget_set_usize (hbox1, -2, 32);
  gtk_container_set_border_width (GTK_CONTAINER (hbox1), 3);

  rewind = gtk_button_new();
  gtk_widget_set_name (rewind, "rewind");
  gtk_widget_ref (rewind);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "rewind", rewind,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (rewind);
  gtk_box_pack_start (GTK_BOX (hbox1), rewind, FALSE, FALSE, 0);
  gtk_widget_set_usize (rewind, 35, 20);
  gtk_container_set_border_width (GTK_CONTAINER (rewind), 3);

  rewind_pixmap = create_pixmap (g_window, "rewind.xpm");
  gtk_widget_show(rewind_pixmap);
  gtk_container_add(GTK_CONTAINER(rewind), rewind_pixmap);

  stop = gtk_button_new();
  gtk_widget_set_name (stop, "stop");
  gtk_widget_ref (stop);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "stop", stop,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (stop);
  gtk_box_pack_start (GTK_BOX (hbox1), stop, FALSE, FALSE, 0);
  gtk_widget_set_usize (stop, 35, 20);
  gtk_container_set_border_width (GTK_CONTAINER (stop), 3);

  stop_pixmap = create_pixmap (g_window, "stop.xpm");
  gtk_widget_show(stop_pixmap);
  gtk_container_add(GTK_CONTAINER(stop), stop_pixmap);

  play = gtk_button_new();
  gtk_widget_set_name (play, "play");
  gtk_widget_ref (play);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "play", play,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (play);
  gtk_box_pack_start (GTK_BOX (hbox1), play, FALSE, FALSE, 0);
  gtk_widget_set_usize (play, 35, 20);
  gtk_container_set_border_width (GTK_CONTAINER (play), 3);

  play_pixmap = create_pixmap (g_window, "play.xpm");
  gtk_widget_show(play_pixmap);
  gtk_container_add(GTK_CONTAINER(play), play_pixmap);

  pause = gtk_button_new();
  gtk_widget_set_name (pause, "pause");
  gtk_widget_ref (pause);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "pause", pause,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pause);
  gtk_box_pack_start (GTK_BOX (hbox1), pause, FALSE, FALSE, 0);
  gtk_widget_set_usize (pause, 35, 20);
  gtk_container_set_border_width (GTK_CONTAINER (pause), 3);

  pause_pixmap = create_pixmap (g_window, "pause.xpm");
  gtk_widget_show(pause_pixmap);
  gtk_container_add(GTK_CONTAINER(pause), pause_pixmap);

  fast_forward = gtk_button_new();
  gtk_widget_set_name (fast_forward, "fast_forward");
  gtk_widget_ref (fast_forward);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "fast_forward", fast_forward,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fast_forward);
  gtk_box_pack_start (GTK_BOX (hbox1), fast_forward, FALSE, FALSE, 0);
  gtk_widget_set_usize (fast_forward, 35, 20);
  gtk_container_set_border_width (GTK_CONTAINER (fast_forward), 3);

  fast_forward_pixmap = create_pixmap (g_window, "fast_forward.xpm");
  gtk_widget_show(fast_forward_pixmap);
  gtk_container_add(GTK_CONTAINER(fast_forward), fast_forward_pixmap);

  dummy = gtk_label_new("");
  gtk_widget_show(dummy);
   gtk_box_pack_start (GTK_BOX (hbox1), dummy, TRUE, TRUE, 2);

  load = gtk_button_new();
  gtk_widget_set_name (load, "load");
  gtk_widget_ref (load);
  gtk_object_set_data_full (GTK_OBJECT (g_window), "load", load,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (load);
  gtk_box_pack_start (GTK_BOX (hbox1), load, FALSE, FALSE, 0);
  gtk_widget_set_usize (load, 50, -2);
  gtk_container_set_border_width (GTK_CONTAINER (load), 3);

  load_pixmap = create_pixmap (g_window, "load.xpm");
  gtk_widget_show(load_pixmap);
  gtk_container_add(GTK_CONTAINER(load), load_pixmap);
  
  gtk_signal_connect (GTK_OBJECT (g_window), "destroy",
        	      GTK_SIGNAL_FUNC (gnome_window_quit), NULL);
  
  gtk_signal_connect (GTK_OBJECT (drawing_area), "expose_event",
		      (GtkSignalFunc) gtk_expose_event, NULL);

  gtk_signal_connect (GTK_OBJECT (g_window), "key-press-event",
		      (GtkSignalFunc) on_key_press_event, NULL);
  
  gtk_signal_connect (GTK_OBJECT (rewind), "clicked",
                      GTK_SIGNAL_FUNC (on_rewind_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (stop), "clicked",
                      GTK_SIGNAL_FUNC (on_stop_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (play), "clicked",
                      GTK_SIGNAL_FUNC (on_play_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (pause), "clicked",
                      GTK_SIGNAL_FUNC (on_pause_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (fast_forward), "clicked",
                      GTK_SIGNAL_FUNC (on_fast_forward_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (load), "clicked",
                      GTK_SIGNAL_FUNC (on_load_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (g_window), "configure_event",
                      GTK_SIGNAL_FUNC (on_gtk_window_configure_event),
                      NULL);

  gtk_signal_connect (GTK_OBJECT (g_window), "button_press_event",
		      (GtkSignalFunc) gtk_button_press_event, NULL);
  
   /* position loaded from options */

  gtk_widget_set_events (g_window, GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK);

  gtk_widget_set_uposition(GTK_WIDGET(g_window), config.window_pos_x, config.window_pos_y);

  gtk_widget_realize(g_window);
  gtk_widget_set_app_paintable(g_window, TRUE);

  style = gtk_widget_get_style( g_window );

  logo_pixmap = gdk_pixmap_create_from_xpm(g_window->window,  &mask,
                                           &style->bg[GTK_STATE_NORMAL],
                                           PIXMAPS_PATH "/xmps-logo.xpm");

  XMPS_DEBUG("gnome window created");

  gnome_create_shared_menu(menu);
    
  config.popup_menu = xmps_gtk_get_menu(config.session);
  
  config.start_time = 0;

  return g_window;
}
