/*
    llseek.c -- llseek stub
    Derived from work Copyright (C) 1994, 1995, 1996 Theodore Ts'o.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* This is a long, sad story about a function called lseek().  A long time ago,
 * (in a galaxy, far away), hard disks were small, and 32-bits was enough to
 * address any device.  Hence, lseek()'s offset parameter was 32-bit on Linux
 * x86.
 *     However, it became obvious that this wouldn't be enough, so the
 * llseek() syscall was added.  However, some of the standard C libraries
 * did not use this llseek() properly.  It is undocumented, as it is Linux
 * only.  So, we always must call the Linux syscall directly.
 *     When making one's own syscall, one uses the "_syscall5" macro
 * (where 5 is the number of paramters).  However, a syscall (i.e.
 * software interrupt 0x80) takes its parameters through registers.  In
 * particular, it uses ebx as the first parameter to the syscall function
 * (in llseek()'s case, the file descriptor).
 *     Unfortunately, ebx is also used to store the global offset table, which
 * is needed in shared libraries.  For some reason, gcc doesn't want to
 * push ebx before the interrupt, and pop it back again afterwards.  Anyway,
 * the result is, the global offset table feature must be disabled.  But this
 * feature is required for shared libraries, to make the code position
 * independent.  So the result is, this part of the code must be statically
 * linked to any binaries.
 */

static const char _llseek_c[] = "$Id: llseek.c,v 1.3 1999/10/02 20:56:47 aclausen Exp $";

#include "config.h"

#if SIZEOF_OFF_T < 8 && defined(linux)

#include <unistd.h>
#include <linux/unistd.h>
#include <syscall.h>
#include <errno.h>
#include <sys/types.h>

#ifndef __NR__llseek
#define __NR__llseek 140
#endif

static _syscall5(int,_llseek,
		 unsigned int, fd,
		 unsigned long, offset_high,
		 unsigned long, offset_low,
		 loff_t*, result,
		 unsigned int, origin)

loff_t
ped_llseek (unsigned int fd, loff_t offset, unsigned int whence)
{
	loff_t result;
	int retval;

	retval = _llseek(fd,
			 ((unsigned long long)offset) >> 32,
			 ((unsigned long long)offset) & 0xffffffff,
			 &result,
			 whence);
	return (retval==-1 ? (loff_t) retval : result);
}

#endif /* SIZEOF_OFF_T < 8 && defined(linux) */

