/*
 *   Copyright (C) 1999-2000 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <string.h>
#include <math.h>

#include <gtk/gtk.h>

#include "global.h"

static double RAD(double angle)
{
	return (angle / 180.0) * PI;
}

static double DEG(double angle)
{
	return (angle / PI) * 180.0;
}

int Convert_Locator(char *buffer, double *latitude, double *longitude)
{
	if (strlen(buffer) != 6 ||
	    buffer[0] < 'A' || buffer[0] > 'R' ||
	    buffer[1] < 'A' || buffer[1] > 'R' ||
	    buffer[2] < '0' || buffer[2] > '9' ||
	    buffer[3] < '0' || buffer[3] > '9' ||
	    buffer[4] < 'A' || buffer[4] > 'X' ||
	    buffer[5] < 'A' || buffer[5] > 'X')
		return FALSE;

	*longitude = -180.0 + FIELD_WIDTH   * (buffer[0] - 'A') +
			      SQUARE_WIDTH  * (buffer[2] - '0') +
			      SUB_WIDTH     * (buffer[4] - 'A') +
			      SUB_WIDTH / 2.0;

	*latitude  = -90.0  + FIELD_HEIGHT  * (buffer[1] - 'A') +
			      SQUARE_HEIGHT * (buffer[3] - '0') +
			      SUB_HEIGHT    * (buffer[5] - 'A') +
			      SUB_HEIGHT / 2.0;

	return TRUE;
}

int Convert_Angles(double Latitude, double Longitude, char *buffer)
{
	int ILatitude, ILongitude;

	if (Latitude > 90.0 || Latitude < -90.0)
		return FALSE;

	if (Longitude > 180.0 || Longitude < -180.0)
		return FALSE;

	Latitude  += 90.0;
	Longitude += 180.0;

	ILongitude = (int)(Longitude / FIELD_WIDTH);
	buffer[0]  = ILongitude + 'A';
	Longitude -= (double)ILongitude * FIELD_WIDTH;

	ILongitude = (int)(Longitude / SQUARE_WIDTH);
	buffer[2]  = ILongitude + '0';
	Longitude -= (double)ILongitude * SQUARE_WIDTH;

	ILongitude = (int)(Longitude / SUB_WIDTH);
	buffer[4]  = ILongitude + 'A';

	ILatitude = (int)(Latitude / FIELD_HEIGHT);
	buffer[1] = ILatitude + 'A';
	Latitude -= (double)ILatitude * FIELD_HEIGHT;

	ILatitude = (int)(Latitude / SQUARE_HEIGHT);
	buffer[3] = ILatitude + '0';
	Latitude -= (double)ILatitude * SQUARE_HEIGHT;

	ILatitude = (int)(Latitude / SUB_HEIGHT);
	buffer[5] = ILatitude + 'A';

	buffer[6] = '\0';

	return TRUE;
}

void Calc_Details(double slat, double slong, double dlat, double dlong, double *bearing, double *distance)
{
	double slatr, slongr;
	double dlatr, dlongr;
	double hangle;

	slatr = RAD(slat); slongr = RAD(slong);
	dlatr = RAD(dlat); dlongr = RAD(dlong);

	hangle    = acos(sin(slatr) * sin(dlatr) + cos(slatr) * cos(dlatr) * cos(slongr - dlongr));

	*bearing  = DEG(acos((sin(dlatr) - sin(slatr) * cos(hangle)) / (cos(slatr) * sin(hangle))));
	*distance = hangle * R;

	if (sin(dlongr - slongr) < 0.0)
		*bearing = 360.0 - *bearing;
}
