/*
 * xconvers - GTK+ convers client for amateur radio
 * Copyright (C) 2000-2001 Joop Stakenborg <pa4tu@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * utils.c - private functions that don't belong in other modules
 */

#include <gtk/gtk.h>
#include "support.h"

extern GtkWidget *mainwindow;

/*
 * Lookup a widget and set visible or invisible, depending on 'state'.
 */

void widget_visible(gchar *name, gboolean state)
{
  GtkWidget *widget;
  
  widget = lookup_widget(mainwindow, name);
  if (state) gtk_widget_show(widget); else gtk_widget_hide(widget);
}

/*
 * Needed by g_hash_table_foreach_remove, to free every key in the hash table.
 */

gboolean remove_calls(gchar *key, gpointer value, gpointer user_data)
{
  g_free(key);
  return(TRUE);
}
