/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1998-2000 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef MAIN_H
#define MAIN_H


#include <kapp.h>
#include <ktmainwindow.h>
#include <kmenubar.h>
#include <kstatusbar.h>

#include <qpopupmenu.h>
#include <qtimer.h>
#include <qsplitter.h>
#include <qaccel.h>
#include <qlist.h>

#include "output.h"
#include "global.h"
#include "monitor.h"
#include "dxcluster.h"
#include "dxwin.h"
#include "outputctrl.h"

#include "mondefs.h"


extern QColor colors[17];


#define ID_STATUS_COUNTRY 1
#define ID_STATUS_DIST 2
#define ID_STATUS_DEG 3


class TopLevel : public KTMainWindow
{
   Q_OBJECT;
public:
   TopLevel( const char *name=0 );
   ~TopLevel();
   void resizeEvent(QResizeEvent *e);
   void exitApplication();

   void showData(int type, char *buffer, int len);
   void updateStatusbar( const char *dxcall );

   void sendMonitor( char *str );
   void updateFonts();

public slots:
   void slotPrefFontsColors();
   void slotPrefDX();
   void slotPrefQSOSpy();
   void slotHelp();
   void slotAbout();
   void slotBeenden();
   void slotNewView();
   void slotDeleteView();
   void slotSaveViewList();

private:
   QPopupMenu *file, *help, *pref, *dxspy;
   KMenuBar *menubar;
   KStatusBar *statusbar;
   bool closeQuestion;
   QList<QAccel> *accels;

   Monitor *moni;
   OutputWidget *output;
   OutputWidget *dxoutput;
   OutputCtrl *outctrl;
   DXWin *dxwin;
   QTimer *timer;

   QWidget *pannerHome;
   QSplitter *splitter;
//   KNewPanner *panner;
   DXCluster *dx;

   void proceedDXLine(char *line);
   void checkQSOSpy( t_QSOMheard *data );
   void startQSOSpy( t_QSOMheard *data );
   bool isInList( QStrList *liste, char *call, int ssid);

   void setupMenuBar();
   void setupStatusBar();

protected:
   void closeEvent(QCloseEvent *e);
};



class DlgAbout : public QDialog
{
   Q_OBJECT;
public:
   DlgAbout();
   ~DlgAbout();
private:
   QLabel *monkt, *copyright;

   QPushButton *ok;
};


void init_globals();


#endif /* MAIN_H */

