/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2001 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
//---------------------------------------------------------------------------
#include "sendqueue.h"
#include "sendqueue.moc"

#include "channel.h"
#include "filetransfer.h"
#include "abin.h"
#include "auto7.h"
#include "main.h"
#include "didadit.h"
#include "yapp.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
//---------------------------------------------------------------------------
extern TopLevel *toplevel;
//---------------------------------------------------------------------------
SendQueue::SendQueue( Channel *channel ) : QObject()
{
	chan = channel;
   sqroot = NULL;
   strlen = 0;
   strdata = NULL;
}
//---------------------------------------------------------------------------
SendQueue::~SendQueue()
{
	clear();
}
//---------------------------------------------------------------------------
s_sqentry * SendQueue::getNewEntry()
{
   s_sqentry *tmp;


   if (sqroot == NULL)
   {
      // Erster Eintrag
      sqroot = (s_sqentry *)malloc(sizeof(s_sqentry));
      tmp = sqroot;
   }
   else
   {
      tmp = sqroot;
      while (tmp->next != NULL) tmp = tmp->next;

      tmp->next = (s_sqentry *)malloc(sizeof(s_sqentry));
      tmp = tmp->next;
   }

   tmp->next = NULL;
   tmp->data = NULL;
   tmp->type = -1;
   tmp->show = false;

   return tmp;
}
//---------------------------------------------------------------------------
const char * SendQueue::getData( int & len, bool & show, int & comp )
{
	static char text[256];


   if (strlen <= len)
	   getNextDataString();

   if (strlen == 0)
		return NULL;

   if (strlen <= len)
   {
   	memcpy(text, strdata, strlen);
      len = strlen;
      free(strdata);
      strdata = NULL;
      strlen = 0;
      show = strshow;
      comp = strcomp;
   }
   else
   {
	   memcpy(text, strdata, len);
      memmove(strdata, strdata+len, strlen-len);
      strlen -= len;
      show = strshow;
      comp = strcomp;
	}
	return text;
}
//---------------------------------------------------------------------------
void SendQueue::addString( const char *string, int len, int comp, bool show )
{
/*	if (strlen == 0 && sqroot == NULL)
   {
      strdata = (char *) malloc(len);
      memcpy(strdata, string, len );
      strlen = len;
      strshow = show;
      strcomp = comp;
      return;
   }

*/

   s_sqentry *entry = getNewEntry();

   entry->type = SQTYPE_TEXT;
   entry->show = show;
   entry->data = (s_sqtext *) malloc(sizeof(s_sqtext));
   ((s_sqtext *)entry->data)->len = len;
   ((s_sqtext *)entry->data)->data = (char *) malloc(len);
   memcpy(((s_sqtext *)entry->data)->data, string, len);
   ((s_sqtext *)entry->data)->comp = comp;
}
//---------------------------------------------------------------------------
void SendQueue::getNextDataString()
{
   if (sqroot == NULL) return;

   switch (sqroot->type)
   {
      case SQTYPE_TEXT:
         if (addNextTextline())
	         deleteNextEntry();
      	break;
		case SQTYPE_FILE:
         if (addNextTextFileData())
         	deleteNextEntry();
			break;
		case SQTYPE_FTRANS:
         if (addNextTransferFileData())
         	deleteNextEntry();
      	break;
   }
}
//---------------------------------------------------------------------------
bool SendQueue::addNextTextline()
{
   char *tmp;

   if (strlen > 0)
   {
   	if (strshow == sqroot->show &&
      	 strcomp == ((s_sqtext *)sqroot->data)->comp)
      {
		   tmp = strdata;
		   strdata = (char *) malloc(strlen+((s_sqtext *)sqroot->data)->len);
		   memcpy(strdata, tmp, strlen);
		   memcpy(strdata+strlen, ((s_sqtext *)sqroot->data)->data, ((s_sqtext *)sqroot->data)->len);
		   strlen += ((s_sqtext *)sqroot->data)->len;
			return true;
		}
		return false;
	}
   else
   {
	   strdata = (char *) malloc(((s_sqtext *)sqroot->data)->len);
	   memcpy(strdata, ((s_sqtext *)sqroot->data)->data, ((s_sqtext *)sqroot->data)->len);
	   strlen = ((s_sqtext *)sqroot->data)->len;
	   strshow = sqroot->show;
	   strcomp = ((s_sqtext *)sqroot->data)->comp;
      return true;
   }
}
//---------------------------------------------------------------------------
void SendQueue::deleteNextEntry()
{
   s_sqentry *tmp;

   tmp = sqroot;
   sqroot = sqroot->next;
   deleteThisEntry( tmp );
}
//---------------------------------------------------------------------------
void SendQueue::deleteThisEntry( s_sqentry *entry )
{
   switch (entry->type)
   {
   	case SQTYPE_TEXT:
      	free(((s_sqtext *)entry->data)->data);
      	free(entry->data);
      	break;
		case SQTYPE_FILE:
      	free(((s_sqfile *)entry->data)->fname);
         if (((s_sqfile *)entry->data)->fd != -1)
         	::close(((s_sqfile *)entry->data)->fd);
      	free(entry->data);
      	break;
		case SQTYPE_FTRANS:
      	free(((s_sqtrprot *)entry->data)->fname);
         delete ((s_sqtrprot *)entry->data)->trans;
         if (((s_sqtrprot *)entry->data)->sendinfo != NULL)
         {
         	free(((s_sqtrprot *)entry->data)->sendinfo->user);
         	free(((s_sqtrprot *)entry->data)->sendinfo->titel);
         	free(((s_sqtrprot *)entry->data)->sendinfo);
			}
      	free(entry->data);
      	break;
   }
   free(entry);
}
//---------------------------------------------------------------------------
// Fuegt ein Textfile zur Sendqueue hinzu. Default-Parameter fuer show=true;
void SendQueue::addTextFile( const char *filename, int comp, int size, bool show )
{
   s_sqentry *entry = getNewEntry();

   entry->type = SQTYPE_FILE;
   entry->show = show;
   entry->data = (s_sqfile *) malloc(sizeof(s_sqfile));
   ((s_sqfile *)entry->data)->fname = (char *) strdup(filename);
   ((s_sqfile *)entry->data)->comp = comp;
   ((s_sqfile *)entry->data)->fd = -1;
   ((s_sqfile *)entry->data)->size = size;
}
//---------------------------------------------------------------------------
bool SendQueue::addNextTextFileData()
{
	int len, i;
   char tmp[2000], *data;


   if (((s_sqfile *)sqroot->data)->fd == -1)
   {
   	// Datei oeffnen
      if ((((s_sqfile *)sqroot->data)->fd = open(((s_sqfile *)sqroot->data)->fname, O_RDONLY)) == -1)
      	return true;
   }

   len = read(((s_sqfile *)sqroot->data)->fd, tmp, 2000);

   if (len == 0)
   	return true;

   for (i=0; i<len; i++)
      if (tmp[i] == '\n') tmp[i] = '\r';

   if (strlen == 0)
   {
      strdata = (char *) malloc(len);
      memcpy(strdata, tmp, len);
      strlen = len;
   }
   else
   {
		data = strdata;
      strdata = (char *) malloc(len+strlen);
      memcpy(strdata, data, strlen);
      free(data);
      memcpy(strdata+strlen, tmp, len);
      strlen += len;
   }

   if (len != 2000)
   	return true;
	return false;
}
//---------------------------------------------------------------------------
void SendQueue::addFileTransfer( const char *filename, int protocol, s_sqsendinfo *info, int size )
{
   s_sqentry *entry = getNewEntry();

   entry->type = SQTYPE_FTRANS;
   entry->show = false;
   entry->data = (s_sqtrprot *) malloc(sizeof(s_sqtrprot));
   ((s_sqtrprot *)entry->data)->trans = NULL;
   ((s_sqtrprot *)entry->data)->proto = protocol;
   ((s_sqtrprot *)entry->data)->fname = (char *) strdup( filename );
   ((s_sqtrprot *)entry->data)->textroot = NULL;
   ((s_sqtrprot *)entry->data)->sendinfo = info;
   ((s_sqtrprot *)entry->data)->size = size;
   ((s_sqtrprot *)entry->data)->status = SQTRSTAT_NOSTOP;
}
//---------------------------------------------------------------------------
bool SendQueue::addNextTransferFileData()
{
   if (((s_sqtrprot *)sqroot->data)->trans == NULL)
   {
   	switch (((s_sqtrprot *)sqroot->data)->proto)
      {
      	case FTPROT_ABIN:
      		((s_sqtrprot *)sqroot->data)->trans = new ABinTX( chan, ((s_sqtrprot *)sqroot->data)->fname );
         	break;
			case FTPROT_DIDADIT:
      		((s_sqtrprot *)sqroot->data)->trans = new DIDADIT_TX( chan, ((s_sqtrprot *)sqroot->data)->fname, conf->getRBlocksize()*1024 );
         	break;
			case FTPROT_7PLUS:
      		((s_sqtrprot *)sqroot->data)->trans = new Auto7Plus( chan, ((s_sqtrprot *)sqroot->data)->fname, ((s_sqtrprot *)sqroot->data)->sendinfo );
         	break;
			case FTPROT_YAPP:
      		((s_sqtrprot *)sqroot->data)->trans = new YAPP_TX( chan, ((s_sqtrprot *)sqroot->data)->fname );
         	break;
      }

      connect( ((s_sqtrprot *)sqroot->data)->trans, SIGNAL(sendString(const char *, int, bool)),
			      this, SLOT(slotTransSendString(const char *, int, bool)));
		connect( chan, SIGNAL(receivedString(const char *, int)),
               ((s_sqtrprot *)sqroot->data)->trans, SLOT(slotReceivedString(const char *, int)));
		connect( chan, SIGNAL(sendFileTXData()),
      			this, SLOT(slotSendData()));
		connect( ((s_sqtrprot *)sqroot->data)->trans, SIGNAL(sendData()),
               this, SLOT(slotSendData()));
      connect( ((s_sqtrprot *)sqroot->data)->trans, SIGNAL(setLinemode(bool)),
               chan, SLOT(slotSetLinemode(bool)));
		connect( ((s_sqtrprot *)sqroot->data)->trans, SIGNAL(showStatus(FileTransfer *, const QString &, long, long, int)),
      			chan, SLOT(showStatus(FileTransfer *, const QString &, long, long, int)));
		connect( ((s_sqtrprot *)sqroot->data)->trans, SIGNAL(unshowStatus()),
      			chan, SLOT(unshowStatus()));
		connect( ((s_sqtrprot *)sqroot->data)->trans, SIGNAL(statusRxBytes(long)),
      			chan, SLOT(statusRxBytes(long)));
		connect( ((s_sqtrprot *)sqroot->data)->trans, SIGNAL(newTXData()),
      			this, SLOT(slotNewTXData()));
		connect( ((s_sqtrprot *)sqroot->data)->trans, SIGNAL(deleteFTData()),
      			this, SLOT(slotDeleteFTData()) );


		// Bimmeln
      toplevel->playSound( SOUND_FILE_START );

      ((s_sqtrprot *)sqroot->data)->trans->startSending();
   }



   if ((((s_sqtrprot *)sqroot->data)->status = ((s_sqtrprot *)sqroot->data)->trans->sentReady()) == SQTRSTAT_EMERGSTOP)
   {
      ((Channel *)chan)->slotSetLinemode( true );
printf("ready - emergency\n");
      // Bimmeln
      toplevel->playSound( SOUND_FILE_ABORT );
   	return true;
	}

   // Gucken, ob von der Transferklasse Daten gesendet werden sollen
   if (((s_sqtrprot *)sqroot->data)->status == SQTRSTAT_NOSTOP)
		((s_sqtrprot *)sqroot->data)->trans->getFileData();

   // Steht in der Queue fuer diesen Eintrag was drin?
	if (((s_sqtrprot *)sqroot->data)->textroot != NULL)
   {
   	sendTransferFileText();
      return false;
   }

   // Gucken, ob der Transfer fertig ist
   if ((((s_sqtrprot *)sqroot->data)->status = ((s_sqtrprot *)sqroot->data)->trans->sentReady()) != 0)
   {
printf("ready\n");
      ((Channel *)chan)->slotSetLinemode( true );
      // Bimmeln
      switch (((s_sqtrprot *)sqroot->data)->status)
      {
      	case SQTRSTAT_ABORT:
		      toplevel->playSound( SOUND_FILE_ABORT );
         	break;
      	case SQTRSTAT_STDSTOP:
		      toplevel->playSound( SOUND_FILE_READY );
         	break;
		}
   	return true;
	}

/*   if (((s_sqtrprot *)sqroot->data)->trans->sentReady())
   {
printf("ready\n");
   	return true;
	}*/


	return false;
}
//---------------------------------------------------------------------------
void SendQueue::slotTransSendString( const char *data, int len, bool show )
{
   s_sqtrtext *tmp;
   char *chtmp;

	if (((s_sqtrprot *)sqroot->data)->textroot == NULL)
   {
      // Erster Eintrag
      ((s_sqtrprot *)sqroot->data)->textroot = (s_sqtrtext *)malloc(sizeof(s_sqtrtext));
      tmp = ((s_sqtrprot *)sqroot->data)->textroot;
   }
   else
   {
      tmp = ((s_sqtrprot *)sqroot->data)->textroot;
      while (tmp->next != NULL) tmp = tmp->next;

      // Der letzte Eintrag wurde erreicht. Gucken, ob das show-Flag den
      // gleichen Wert wie das im String, den wir einfuegen wollen, hat.
      if (tmp->show == show)
      {
			chtmp = tmp->data;
         tmp->data = (char *) malloc(tmp->len+len);
         memcpy(tmp->data, chtmp, tmp->len);
         free(chtmp);
         memcpy(tmp->data+tmp->len, data, len);
         tmp->len += len;
      	return;
      }

      tmp->next = (s_sqtrtext *)malloc(sizeof(s_sqtrtext));
      tmp = tmp->next;
   }

   tmp->next = NULL;
   tmp->len = len;
   tmp->data = (char *) malloc( len );
   memcpy( tmp->data, data, len );
   tmp->show = show;
}
//---------------------------------------------------------------------------
void SendQueue::slotSendData()
{
	getNextDataString();
}
//---------------------------------------------------------------------------
bool SendQueue::isTransferActive()
{
	if (sqroot == NULL) return false;
   if (sqroot->type == SQTYPE_FTRANS) return true;
   return false;
}
//---------------------------------------------------------------------------
//   int SendQueue::whichFileTransfer()
// Welcher Transfer ist aktiv?
//
// Rueckgabe: 0, wenn kein Filetransfer stattfindet,
//            FTPROT_*, wenn ein Filetransfer stattfindet
int SendQueue::whichTransfer()
{
	if (sqroot == NULL) return 0;
   if (sqroot->type == SQTYPE_FTRANS)
   	return ((s_sqtrprot *)sqroot->data)->proto;
   return 0;
}
//---------------------------------------------------------------------------
void SendQueue::sendTransferFileText()
{
   s_sqtrtext *stmp;
	char *datatmp;


   // Nur was ausgeben, wenn auch was vorhanden ist :)
   if (((s_sqtrprot *)sqroot->data)->textroot == NULL) return;

	if (strlen == 0)
	{
		if (strshow != ((s_sqtrprot *)sqroot->data)->textroot->show)
		strcomp = COMP_NO;
		strshow = ((s_sqtrprot *)sqroot->data)->textroot->show;
		strlen = ((s_sqtrprot *)sqroot->data)->textroot->len;
		strdata = ((s_sqtrprot *)sqroot->data)->textroot->data;

		stmp = ((s_sqtrprot *)sqroot->data)->textroot;
		((s_sqtrprot *)sqroot->data)->textroot = ((s_sqtrprot *)sqroot->data)->textroot->next;
		free(stmp);
	}
	else
	{
		if (strshow == ((s_sqtrprot *)sqroot->data)->textroot->show)
		{
			strcomp = COMP_NO;

			datatmp = strdata;
			strdata = (char *) malloc(((s_sqtrprot *)sqroot->data)->textroot->len+strlen);
			memcpy(strdata, datatmp, strlen);
			free(datatmp);
			memcpy(strdata+strlen, ((s_sqtrprot *)sqroot->data)->textroot->data, ((s_sqtrprot *)sqroot->data)->textroot->len);
			strlen += ((s_sqtrprot *)sqroot->data)->textroot->len;

	      stmp = ((s_sqtrprot *)sqroot->data)->textroot;
	      ((s_sqtrprot *)sqroot->data)->textroot = ((s_sqtrprot *)sqroot->data)->textroot->next;
	      free(stmp->data);
			free(stmp);
		}
	}
}
//---------------------------------------------------------------------------
bool SendQueue::allSent()
{
	if (sqroot == NULL)
   	return true;
	else
   	return false;
}
//---------------------------------------------------------------------------
void SendQueue::clear()
{
	while (sqroot != NULL)
		deleteNextEntry();
}
//---------------------------------------------------------------------------
void SendQueue::slotNewTXData()
{
   getNextDataString();
}
//---------------------------------------------------------------------------
s_sqentry * SendQueue::getRoot()
{
	return sqroot;
}
//---------------------------------------------------------------------------
//   void SendQueue::deleteEntry( s_sqentry *entry )
//
// Loescht einen Eintrag aus der Queue. Links auf diesen und von diesem
// Eintrag sind nicht mehr vorhanden.
// Ist es der erste Eintrag, muss der laufende Transfer abgebrochen werden.
void SendQueue::deleteEntry( s_sqentry *entry )
{
	s_sqtrtext *trtext;


	if (entry == sqroot)
   {
   	// Noch ausstehende Daten entfernen
		while (((s_sqtrprot *)sqroot->data)->textroot != NULL)
      {
         if (((s_sqtrprot *)sqroot->data)->textroot->data != NULL)
         	free(((s_sqtrprot *)sqroot->data)->textroot->data);
			trtext = ((s_sqtrprot *)sqroot->data)->textroot;
         ((s_sqtrprot *)sqroot->data)->textroot = ((s_sqtrprot *)sqroot->data)->textroot->next;
         free(trtext);
      }

      if (strlen > 0)
      {
      	free(strdata);
         strlen = 0;
      }

   	if (entry->type == SQTYPE_FTRANS)
      {
	      ((s_sqtrprot *)entry->data)->trans->abortTransmission();
			sendTransferFileText();
		}
   }
   else
		deleteThisEntry( entry );
}
//---------------------------------------------------------------------------
void SendQueue::slotDeleteFTData()
{
	s_sqtrtext *trtext;

	while (((s_sqtrprot *)sqroot->data)->textroot != NULL)
	{
		if (((s_sqtrprot *)sqroot->data)->textroot->data != NULL)
			free(((s_sqtrprot *)sqroot->data)->textroot->data);
		trtext = ((s_sqtrprot *)sqroot->data)->textroot;
		((s_sqtrprot *)sqroot->data)->textroot = ((s_sqtrprot *)sqroot->data)->textroot->next;
		free(trtext);
	}
}
//---------------------------------------------------------------------------

