/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
//---------------------------------------------------------------------------
#ifndef SENDDATA_H
#define SENDDATA_H
//---------------------------------------------------------------------------
#include <qstring.h>
//---------------------------------------------------------------------------
class Channel;
//---------------------------------------------------------------------------
class SendData
{
public:
	SendData( Channel *chan );
   ~SendData();

   void sendString( const char *str );
   void sendString( const QString & str );
   void sendData( int len, const char *data );
	void sendData( const char *data, int len, bool show=false );
   void statusText( const char *str, int color );

   // In eine Empfangs-Klasse verschieben, sobald vorhandend
   void setReceiving( bool enable );

   // Zeigt den Text an und sendet ihn zur Gegenstation, wenn sie ein
   // Terminal ist. (Fuer Status-Texte wie z.B. "aborted" oder sowas.)
   void sendMessage( const char * text );

   Channel *getChannel();

private:
	Channel *chan;
};
//---------------------------------------------------------------------------
#endif
//---------------------------------------------------------------------------

