/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2001 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "remote.h"
#include "toolbox.h"
#include "channel.h"
#include "global.h"
#include "ax25k.h"
#include "version.h"
#include "main.h"
#include "ddate.h"
#include "infobar.h"

#include <stdio.h>
#include <stdlib.h>
#include <time.h>


extern TopLevel *toplevel;


typedef struct
{
  QString str;
  long flag;
} s_remotes;

#define ANZ_REMOTECMD 16
s_remotes RemoteCommands[ANZ_REMOTECMD]={
                   {"QUIT",    	REMOTE_QUIT},
                   {"VERSION", 	REMOTE_VERSION},
                   {"CS",      	REMOTE_CS},
                   {"INFO",    	REMOTE_INFO},
                   {"HELP",    	REMOTE_HELP},
                   {"NAME",    	REMOTE_NAME},
                   {"NEWS",    	REMOTE_NEWS},
                   {"ECHO",    	REMOTE_ECHO},
                   {"RTT",     	REMOTE_RTT},
                   {"COMP",    	REMOTE_COMP},
                   {"TALK",    	REMOTE_TALK},
                   {"DATE",    	REMOTE_DATE},
                   {"DDATE",   	REMOTE_DDATE},
                   {"COOKIE",  	REMOTE_COOKIE},
                   {"RING",    	REMOTE_RING},
                   {"ACTIVITY",	REMOTE_ACTIVITY}};
/*                   {"WRITE",REMOTE_WRITE},
                   {"READ",REMOTE_READ},
                   {"DIR",REMOTE_DIR},
*/



RemoteCmds::RemoteCmds( QWidget *channel )
{
   chan = channel;
}


RemoteCmds::~RemoteCmds()
{
}


// Jede empfangene Zeile wird an diese Funktion geschickt, wenn Remote-
// Befehle aktiviert sind.
void RemoteCmds::checkLine( const QString & data )
{
	QString command, param;
   int i;

   if (data.length() < 1) return;

   command = data;

   if ((i = command.find('\r')) != -1)
   	command.truncate( i );

	command = command.simplifyWhiteSpace();

   if ((i = command.find(' ')) > -1)
   {
      param = command.mid( i+1 );
      command.truncate( i );
   }

   command = command.upper();


   for (i=0; i<ANZ_REMOTECMD; i++)
   	if (command == RemoteCommands[i].str.left(command.length()))
      	break;

   if (i >= ANZ_REMOTECMD)
      sendString( "<LinKT>: Unknown command!\xD" );
   else
   {
      // Gucken, ob dieser Befehl ueberhaupt ausgefuehrt werden darf
      if ((((Channel *)chan)->userinfo->getRemotes() & RemoteCommands[i].flag) == 0)
      {
         // Nein, darf nicht.
         sendString( "<LinKT>: Permission denied.\xD" );
         return;
      }


      if (i<=ANZ_REMOTECMD)
      {
         switch(i)
         {
            case  0: cmdQuit(); break;
            case  1: cmdVersion(); break;
            case  2: cmdCS(); break;
            case  3: cmdInfo(); break;             // INFO
            case  4: cmdHelp(); break;             // HELP
            case  5: cmdName(param.latin1()); break;         // NAME <Name>
            case  6: cmdNews(); break;             // NEWS
            case  7: cmdEcho(param); break;         // ECHO
            case  8: cmdRTT(param.latin1()); break;          // RTT [<timestamp>]
            case  9: cmdComp(param.latin1()); break;         // COMP [ON|OFF|0|1]
            case 10: cmdTalk(param.latin1()); break;         // TALK <call> <text>
            case 11: cmdDate(); break;             // DATE
            case 12: cmdDDate(param.latin1()); break;        // DDATE [<day> <mon> <year>]
            case 13: cmdCookie(); break;           // COOKIE
            case 14: cmdRing(); break;		         // RING
            case 15: cmdActivity(); break;			// ACTIVITY
//            case  5: remote_write(chan,params); break;	//WRITE <filename>
//            case  6: remote_read(chan,params); break;	//READ <filename>
//            case 12: remote_dir(chan, params); break;	//DIR [directory]
            default: sendString( "<LinKT>: Unknown command!\xD" );
         }
      }
   }
}


void RemoteCmds::sendString( const char *str )
{
   ((Channel *)chan)->sendString( str );
}


void RemoteCmds::sendString( const QString & str )
{
   ((Channel *)chan)->sendString( str );
}



// Wenn CS_PROMPT 1 ist, wird ein Prompt ausgesendet
void RemoteCmds::sendPrompt()
{
	if ((((Channel *)chan)->getFlags() & CH_PROMPT) != 0)
	{
      sendString( ((Channel *)chan)->getCall()+" de "+((Channel *)chan)->getMycall()+">\r" );
	}
}


void RemoteCmds::cmdQuit()
{
   ((Channel *)chan)->sendMacrofile( conf->localDir()+"/qtext" );
   ((Channel *)chan)->discStnAuto();
}


void RemoteCmds::cmdVersion()
{
   struct tm sTm;
   int i;
   s_ports *porttmp;
   QString tmp, sendtext;
  
  
   sTm = *gmtime(&config->starttime);

   sendtext.sprintf( "LinKT - Linux Kde pr-Terminal V%s (%s)\r", LINKT_VERSION, DATE );
   sendtext += "Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ\r";
  

   tmp.sprintf( tmp, "Running since %.2i.%.2i.%.4i %.2i:%.2i:%.2i\r",
				sTm.tm_mday,sTm.tm_mon+1,sTm.tm_year+1900,sTm.tm_hour,sTm.tm_min,sTm.tm_sec );
	sendtext += tmp;



   porttmp = portlist;
   i = 0;
   while (porttmp != NULL)
   {
      if (porttmp->ax25 != NULL)
      {
         tmp.sprintf( "port %i: %s %i baud (%s)\r", i, porttmp->name, porttmp->baud, porttmp->desc );
         sendtext += tmp;
         i++;
      }
      porttmp = porttmp->next;
   }
  
   sendString( sendtext );
   sendPrompt();
}


void RemoteCmds::cmdCS()
{
	QString str;
   s_chanlist *chantmp;


   // Ueberschrift
   str = "      port     remote   local      name\xD" \
			"-------------------------------------------------------------\xD";

   chantmp = toplevel->getChanListPtr();
   while (chantmp != NULL)
   {
      if (chantmp->channel->getCall() != NULL)
      {
         if (chantmp->channel == (Channel *)chan)
         	str += "*";
         else
            str += " ";
			str +=  QString(" %1 %2 - %3").arg(chantmp->channel->getPort(), 8).arg(chantmp->channel->getCall(), 10). arg(chantmp->channel->getMycall(), -10);

         if (!chantmp->channel->userinfo->getName().isEmpty())
            str += " "+chantmp->channel->userinfo->getName();
			str += "\r";
      }

      chantmp = chantmp->next;
   }
   sendString( str );
   sendPrompt();
}


void RemoteCmds::cmdInfo()
{
   char tmp[500];

   sprintf(tmp,"%s/info.linkt", conf->localDir().latin1());
  
   if (!file_exist(tmp))
      sendString( "<LinKT>: No info available.\r" );
   else
     ((Channel *)chan)->sendMacrofile( tmp );

  sendPrompt();
}



void RemoteCmds::cmdHelp()
{
   char tmp[500];

   sprintf(tmp,"%s/help.linkt", conf->localDir().latin1());
  
   if (!file_exist(tmp))
      sendString( "<LinKT>: No help available.\r" );
   else
     ((Channel *)chan)->sendMacrofile( tmp );

  sendPrompt();
}


void RemoteCmds::cmdNews()
{
   char tmp[500];

   sprintf(tmp,"%s/news.linkt",conf->localDir().latin1());
  
   if (!file_exist(tmp))
      sendString( "<LinKT>: No news available.\r" );
   else
     ((Channel *)chan)->sendMacrofile( tmp );

  sendPrompt();
}



void RemoteCmds::cmdName( const QString & param )
{
	QString p;


   if (param.isEmpty())
   {
      if (((Channel *)chan)->userinfo->getName().isEmpty())
      	sendString( "<LinKT>: No name set.\r" );
      else
      	sendString( "<LinKT>: Name: "+((Channel *)chan)->userinfo->getName()+"\r" );
      sendPrompt();
      return;
   }

	// Maximal 50 Zeichen lang
   p = param;
   if (p.length() > 50)
   	p.truncate( 50 );
   ((Channel *)chan)->infobar->setName( p );
   ((Channel *)chan)->userinfo->setName( p );

   sendString( QString("<LinKT>: OK, %1, your name has been saved.\r").arg(param) );
   sendPrompt();
}


void RemoteCmds::cmdEcho( const QString & str )
{
	sendString( str+"\r" );
}


void RemoteCmds::cmdRTT(const QString & param )
{
	time_t rxtime, difftime;
	char *diffstr;
	QString tmp;
   bool ok;


	if (param.isEmpty())
  	{
		// Kein Parameter. Aktuelle Zeit mit //ECHO zurueck senden
		tmp.sprintf( "//ECHO //RTT %lX\r", time(NULL) );
		sendString( tmp );
		return;
	}
  
	rxtime = param.toLong( &ok, 16 );
	if (!ok)
	{
		sendString("<LinKT>: Wrong parameter.\r" );
		return;
	}

	if ((difftime = time(NULL) - rxtime) == 0)
   	tmp = QString("<LinKT>: RTT %1 <-> %2 <-> %3 is less than one second!\r")
   			.arg(((Channel *)chan)->getMycall()).
   			arg(((Channel *)chan)->getCall()).
   			arg(((Channel *)chan)->getMycall());
	else
	{
		diffstr = (char *) spec_time(difftime);
      tmp = QString("<LinKT>: RTT %1 <-> %2 <-> %3 is %4.\r")
      		.arg(((Channel *)chan)->getMycall())
      		.arg(((Channel *)chan)->getCall())
      		.arg(((Channel *)chan)->getMycall().arg(diffstr));
		free(diffstr);
	}

	sendString( tmp );
}



void RemoteCmds::cmdComp( const QString & param )
{
	int zahl;
   char tmp[50];
   bool ok;
   QString p = param.upper();


	if (p == "ON")
	{
		strcpy(tmp, "//COMP 1\r" );
		((Channel *)chan)->sendStringComp( strlen(tmp), tmp, true, COMP_NO );
		((Channel *)chan)->flags |= CH_COMP;
		return;
	}

	if (p == "OFF")
	{
		strcpy(tmp, "//COMP 0\r" );
		((Channel *)chan)->sendStringComp(strlen(tmp), tmp, true, COMP_SP);
		((Channel *)chan)->flags &= ~CH_COMP;
		return;
	}

	zahl = p.toInt( &ok );

   if (!ok) return;

	switch (zahl)
	{
		case 0:
			if ((((Channel *)chan)->flags & CH_COMP) == 0) return;
			((Channel *)chan)->flags &= ~CH_COMP;
			break;
		case 1:
			if ((((Channel *)chan)->flags & CH_COMP) == CH_COMP) return;
			((Channel *)chan)->flags |= CH_COMP;
			break;
	}
}


//   void RemoteCmds::cmdTalk( const QString & param )
//
// Mit einem anderen eingeloggten User uber //TALK <Rufzeichen> <Text> in
// Verbindung treten.
// Funktioniert nur mit Stationen, die als "Terminal" angemeldet sind.
void RemoteCmds::cmdTalk( const QString & param )
{
   int i;
   s_chanlist *chantmp;
   QString p = param.simplifyWhiteSpace();
   QString call, text, chancall;


   if ((i = p.find(' ')) == -1)
   {
      sendString( "<LinKT>: Syntax: //TALK <Call> <Text>\r" );
      return;
   }

	call = p.left( i ).upper();
	text = p.mid( i+1 );


   chantmp = toplevel->getChanListPtr();
   while (chantmp != NULL)
   {
      if (chantmp->channel->userinfo->getType() == TYPE_TERMINAL)
      {
      	chancall = chantmp->channel->getCall();
         if ((i = chancall.find('-')) > -1)
         	chancall.truncate( i );

            if (chancall == call)
            {
               chantmp->channel->sendString("-"+((Channel *)chan)->getCall()+"-: "+text+"\r");
               return;
            }
         }

      chantmp = chantmp->next;
   }

	sendString( QString("<LinKT>: %1 is not logged in.\r").arg(call));
}


char wday[][10] = {"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday",
                   "Saturday"};

void RemoteCmds::cmdDate()
{
   time_t t;
   struct tm *tm;
   char tmp[200];

   t = time(NULL);
   tm = localtime(&t);

   sprintf(tmp, "<LinKT>: %s, %.2i.%.2i.%.4i %.2i:%.2i:%.2i\r",
                wday[tm->tm_wday],
                tm->tm_mday, tm->tm_mon+1, tm->tm_year+1900,
                tm->tm_hour, tm->tm_min, tm->tm_sec);
   sendString( tmp );
}


void RemoteCmds::cmdDDate( const QString & param )
{
   time_t t;
   struct tm *tm;
   int day, mon, year;
   bool today=false;
   DDate ddate;
   QString p = param.simplifyWhiteSpace();



   if (sscanf(p.latin1(), "%i %i %i", &day, &mon, &year) != 3)
   {
      t = time(NULL);
      tm = localtime(&t);
      day = tm->tm_mday;
      mon = tm->tm_mon+1;
      year = tm->tm_year+1900;
      today = true;
   }
   else
   {
      if (day < 1 || day > 31 || mon < 1 || mon > 12)
      {
         sendString( "<LinKT>: Syntax: //DDATE [<day> <mon> <year>]\r" );
         return;
      }
   }

   sendString( "<LinKT>: "+ddate.getDate(mon, day, year, today)+"\r" );
}


void RemoteCmds::cmdCookie()
{
	QString tmp;

   ((Channel *)chan)->getCookie( tmp );
   tmp = "<LinKT>: Here is a cookie for you:\r" + tmp;
   sendString( tmp );
   sendPrompt();
}


void RemoteCmds::cmdRing()
{
   QString str;


   str = conf->getSound( SOUND_RING );
   if (str.isEmpty())
   {
     sendString( "<LinKT>: Sri, bell is off.\r" );
     return;
   }

	sendString( QString("<LinKT>: Ok, %1 is being called. Please wait.\r").arg(((Channel *)chan)->getMycall()) );
	toplevel->playSound( SOUND_RING );
}


void RemoteCmds::cmdActivity()
{
	QString tmp;


	tmp.sprintf("<LinKT>: Last activity was %s ago.\r", getReadableTime(time(NULL)-config->lastactivity) );
   sendString( tmp );
}



/*
void remote_write(int chan, char *param)
{
  char tmp[500],fullname[500];
  int fd;
  int i;
  
  
  if ((chaninfo[chan]->flags & (CH_AUTOBINRX|CH_AUTOBINTX)) != 0)
  {

    send_Textline(chan,"<LinKT>: No //WRITE while AutoBIN-Transfer.\r");

    return;
  }
  
  if (param[0] == '\0')
  {

    send_Textline(chan,"<LinKT>: Syntax: //WRITE <filename>\r");

    return;
  }
  
  
  // Eine Station von 'drauen' soll nur in einem einzigen Verzeichnis 'rummatschen drfen.
  // deshalb schneiden wir alle angegebenen Verzeichnisse ab, und packen das 'down'-Verzeichnis
  // davor.
  while ((i = POS('/',param)) != -1) COPY(param,param,i+1,strlen(param)-i-1); 
  while ((i = POS('\\',param)) != -1) COPY(param,param,i+1,strlen(param)-i-1); 
  
  sprintf(fullname,"%s/down/%s",config->maindir,param);
  
  
  if (file_exist(fullname))
  {

    sprintf(tmp,"<LinKT>: File '%s' already exists. Write aborted.\r",param);

    send_Textline(chan,tmp);
    return;
  }
  
  if ((fd = open(fullname,O_WRONLY|O_CREAT)) == -1)
  {

    sprintf(tmp,"<LinKT>: Cannot open '%s'.\r",param);

    send_Textline(chan,tmp);
    return;
  }
  
  // Zugriffsrechte einstellen
  fchmod(fd,S_IRUSR|S_IWUSR);
  

  sprintf(tmp,"<LinKT>: '%s' is open now. Close it with '***END' or CTRL-Z.\r",param);

  send_Textline(chan,tmp);
  
  chaninfo[chan]->flags |= CH_SAVE;
  chaninfo[chan]->saveplain = (s_saveplain *)malloc(sizeof(s_saveplain));
  chaninfo[chan]->saveplain->fd = fd;
  chaninfo[chan]->saveplain->filename = (char *)strdup(fullname);
  chaninfo[chan]->saveplain->local = 2;
  update_upper_statusline(TRUE);
}



void remote_read(int chan, char *param)
{
  char tmp[500];
  int i;

  if ((chaninfo[chan]->flags & (CH_AUTOBINRX|CH_AUTOBINTX)) != 0)
  {

    send_Textline(chan,"<LinKT>: No //READ while AutoBIN-Transfer.\r");

    return;
  }
  
  if (param[0] == '\0')
  {

    send_Textline(chan,"<LinKT>: Syntax: //READ <filename>\r");

    return;
  }
  
  while ((i = POS('/',param)) != -1) COPY(param,param,i+1,strlen(param)-i-1); 
  while ((i = POS('\\',param)) != -1) COPY(param,param,i+1,strlen(param)-i-1); 
  
  sprintf(tmp,"%s/up/%s",config->maindir,param);
  
  if (!file_exist(tmp))
  {

    sprintf(tmp,"'%s' is not available.\r",param);

    send_Textline(chan,tmp);
  }
  
  send_Plainfile(chan,tmp);
}



// Zeigt den Inhalt eines Verzeichnisses an. Das Verzeichnis ist immer Relativ zum
// Verzeichnis ./up!
void remote_dir(int chan, char *str)
{
  char dir[500],tmp[500];
  DIR *dirptr;
  struct dirent *entry;
  
  if (strlen(str) > 200) str[201] = '\0';
  
  if (strstr(str,"..") != NULL)
  {
    send_Textline(chan,"<LinKT>: Permission denied\r");
    return;
  }
  
  if (str[0] == '\0')
     sprintf(dir,"%s/up/",config->maindir);
  else
     sprintf(dir,"%s/up/%s/",config->maindir,str);
  
  dirptr = opendir(dir);
  
  sprintf(tmp,"\rDirectory %s:\xD",dir);
  send_Textline(chan,tmp);
  while ((entry = readdir(dirptr)) != NULL)
  {
    sprintf(tmp,"%s\xD",entry->d_name);
    send_Textline(chan,tmp);
  }
  
  check_send_prompt(chan);
  
  closedir(dirptr);
}

*/

