/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef GLOBAL_H
#define GLOBAL_H


#include <time.h>
#include <stdlib.h>

#include <qcolor.h>
#include <qfont.h>
#include <qlist.h>
#include <qwidget.h>
#include <qstring.h>
#include <string.h>
#include <klocale.h>

#include "cfg.h"

#define MAX_CHAN 250
#define FRAMESIZE 256


#define USE_NONBLOCKING

// Do you want to enable or disable sound?
#define ENABLE_SOUND 1
//#undef ENABLE_SOUND



/*
class connCall
{
public:
   connCall( const QString & rxcall ) { call = rxcall; }
   ~connCall() {}

   const QString & call() { return call; }
private:
	QString call;
};
*/

/*
typedef struct
{
   int txText;              // zu sendender Text
   int rxText;              // empfangener Text
   int statusText;          // Statustexte
   int background;          // Hintergrundfarbe
   bool qsowin_bold;        // Soll das QSO-Fenster fette Schriften bekommen?
   bool txwin_bold;         // Vorschreibfenster fette Schrift?
   int txwin;
   int txbackground;
   int gpgText;

   int qsoWinMarkColor;     // Farbe von markiertem Text im QSO-Fenster
   int qsoWinMarkBack;      // Hintergrund von markiertem Text im QSO-Fenster
   bool mark_bold;          // markierten Text fett schreiben?
} s_conf_colors;
*/




#define BARFLG_SHOW 1		// Buttonleiste ueberhaupt anzeigen?
#define BARFLG_BORDER 2		// Kaesten immer um die Buttons?

#define BARPOS_LEFT 1
#define BARPOS_RIGHT 2
#define BARPOS_TOP 3
#define BARPOS_BOTTOM 4

typedef struct
{
   int framesize;
   int awayStatus;
   time_t awayTime;
   time_t starttime;
   time_t lastactivity;
} s_config;

extern s_config *config;

// Dieses Fenster hatte gerade den Focus
extern QWidget *focusWidget;

typedef struct
{
	QColor color;
   QString str;
} s_colors;

extern s_colors colors[17];


// Hier werden die Informationen ueber den BoxCheck abgespeichert

#define BOXCHECK_SENDER 0
#define BOXCHECK_RUBRIK 1
#define BOXCHECK_MAILNR 2
#define BOXCHECK_DATUM 3
#define BOXCHECK_MBX 4
#define BOXCHECK_BYTES 5
#define BOXCHECK_LT 6
#define BOXCHECK_TITEL 7

// The following defines specify the type of the bbs. We
// distinguish between german-style, board oriented bbs
// like diebox, baybox, dpbox and old style rli-like bbs
// like fbb
#define BOXC_TYPE_DIEBOX 0 // bbs uses "boards"
#define BOXC_TYPE_RLI 1 //msg-number oriented bbs

typedef struct
{
   unsigned char pos;
   unsigned char len;
} s_checkpos;

typedef struct
{
   int pos;
   char zeichen;
} s_checkmust;


#define BCTYPE_BAYBOX 1
#define BCTYPE_F6FBB 2

#define BCFIELD_BOARD 1
#define BCFIELD_NUMBER 2
#define BCFIELD_LIFETIME 4
#define BCFIELD_SIZE 8
#define BCFIELD_SENDER 16
#define BCFIELD_TITLE 32


typedef struct _s_boxcheck
{
	struct _s_boxcheck *next;
	bool enabled;
	char *desc;						// Kurze Beschreibung
   int type;						// BCTYPE_*
   char *title;					// Titelzeile
   s_checkpos *board;
   s_checkpos *number;
   s_checkpos *lifetime;
   s_checkpos *size;
   s_checkpos *sender;
   s_checkpos *mailtitle;		// Titel der empfangenen Mail
   s_checkmust must[10];		// Maximal 10 feste Zeichen
   int mustcount;
   unsigned short minlen;
   int fields;
} s_boxcheck;

extern s_boxcheck *boxcheckroot;


#define COLOR_BLACK 0
#define COLOR_WHITE 1
#define COLOR_DARKGRAY 2
#define COLOR_GRAY 3
#define COLOR_LIGHTGRAY 4
#define COLOR_RED 5
#define COLOR_GREEN 6
#define COLOR_BLUE 7
#define COLOR_CYAN 8
#define COLOR_MAGENTA 9
#define COLOR_YELLOW 10
#define COLOR_DARKRED 11
#define COLOR_DARKGREEN 12
#define COLOR_DARKBLUE 13
#define COLOR_DARKCYAN 14
#define COLOR_DARKMAGENTA 15
#define COLOR_DARKYELLOW 16



extern Config *conf;


#endif   /* GLOBAL_H */

