/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *                                                                              
 * As a special exception, you have permission to link this program             
 * with the Qt library and distribute executables, as long as you               
 * follow the requirements of the GNU GPL in regard to all of the               
 * software in the executable aside from Qt.                                    
 */


#include "ax25k.h"
#include "ax25k.moc"

#include "../config.h"

#include <stdio.h>
#include <stdlib.h>
#include <syslog.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <sys/socket.h> 
#include <qsocketnotifier.h>


#include "toolbox.h"
#include "global.h"
#include "main.h"


#ifdef HAVE_BROKEN_AX25_H
#include "local_ax25.h"
#include <netrose/rose.h>
#elif HAVE_NETAX25_AX25_H
#include <netax25/ax25.h>
#include <netrose/rose.h>
#else
#include <linux/ax25.h>
#include <linux/rose.h>
#endif

#ifdef HAVE_NETAX25_AXLIB_H
   #include <netax25/axconfig.h>
   #include <netax25/axlib.h> 
#elif HAVE_AX25_AXUTILS_H
   #include <ax25/axconfig.h>
   #include <ax25/axutils.h>
#else
   #include <axconfig.h>
   #include <axutils.h>
#endif


#define DISC_TEXT "Sorry, access denied.\r"


extern TopLevel *toplevel;


// aus ax25k.h
s_ports *portlist;



/*
 *	ax25 -> ascii conversion
 */
char *ax25asc(ax25_address *a)
{
	static char buf[11];
	char c, *s;
	int n;

	for (n = 0, s = buf; n < 6; n++) {
		c = (a->ax25_call[n] >> 1) & 0x7F;

		if (c != ' ') *s++ = c;
	}
	
	*s++ = '-';

	if ((n = ((a->ax25_call[6] >> 1) & 0x0F)) > 9) {
		*s++ = '1';
		n -= 10;
	}
	
	*s++ = n + '0';
	*s++ = '\0';

	return buf;
}



//  void init_ax25()
// Laed die Port-Informationen aus dem Kernel-AX25 in die Port-Liste.
void init_ax25()
{		// TODO: Umbau auf QString
   char *port, *desc, *dev, *addr;
   s_ports *tmp;
   int baud, maxframe;
   char tmp2[1000],tmp3[100];
   int i;
   ax25_polling *poll;


   if (ax25_config_load_ports() == 0)
   {
      printf("ERROR: No AX.25 port data configurated\n\n");
      exit(1);
   }

   // Liste der Ports mit Infos dazu in die eigene Port-Liste aufnehmen
   port = NULL;
   do
   {
      if ((port = (char *)ax25_config_get_next(port)) != NULL)
      {
         desc = (char *)ax25_config_get_desc(port);
         KillSpacesLeft(desc);
         KillSpacesRight(desc);
         dev = (char *)ax25_config_get_dev(port);
         baud = ax25_config_get_baud(port);
         addr = (char *)ax25_config_get_addr(port);
         maxframe = ax25_config_get_window(port);

         if (strlen(desc)>49)
         {
            printf("ERROR! Too long description for port %s.\n",port);
            _exit(10);
         }

         if (strlen(port)>19)
         {
            printf("ERROR! Too long portname for port %s.\n",port);
            _exit(10);
         }
  
         if (portlist == NULL)
         {
            portlist = (s_ports *)malloc(sizeof(s_ports));
            tmp = portlist;
         }
         else
         {
            tmp = portlist;
            while (tmp->next != NULL) tmp = tmp->next;
            tmp->next = (s_ports*)malloc(sizeof(s_ports));
            tmp = tmp->next;
         }

         tmp->next = NULL;
         tmp->name = (char *)strdup(port);
         tmp->desc = desc;
         tmp->dev = dev;
         tmp->baud = baud;
         tmp->addr = addr;
         tmp->umschalten = false;
         tmp->ax25 = NULL;
         tmp->maxframe = maxframe;
      }
   }
   while (port != NULL);

   // Geladene Port-Liste ausgeben (damit der User was sieht)
   if (portlist == NULL)
   {
      printf("No ports available.\n");
      return;
   }

   printf("Ports found:\n");
   tmp = portlist;
   while (tmp != NULL)
   {
      printf("%19s %6d (%s)\n",tmp->name, tmp->baud, tmp->desc);
      tmp = tmp->next;
   }



   // Jetzt wird geguckt, welcher Port benutzt werden soll.

   if (conf->getPorts().isEmpty())
   {
      poll = new ax25_polling();
      return;     // kein Port ist aktiv
   }


   i = conf->getPorts().length();
   memcpy(tmp2+1,conf->getPorts().latin1(),i);
   tmp2[0] = ',';
   tmp2[i+1] = ',';
   tmp2[i+2] = '\0';

   tmp = portlist;
   while (tmp != NULL)
   {
      sprintf(tmp3,",%s,",tmp->name);
      if (strstr(tmp2, tmp3) != NULL)
      {
         // Der Port soll benutzt werden
         tmp->ax25 = new AX25(tmp->name, tmp->desc, tmp->dev, tmp->baud, tmp->addr);
      }
      tmp = tmp->next;
   }

   poll = new ax25_polling();
}



//  AX25(char *name, char *desc, char *dev, int baud, char *addr)
// Konstruktor AX25-Treiber. Oeffnet eine Verbindung zum gewuenschten
// Port.
AX25::AX25(char *name, char *desc, char *dev, int baud, char *addr)
{
   s_listCalls *tmp;


   info_name = name;
   info_desc = desc;
   info_dev = dev;
   info_baud = baud;
   info_addr = addr;

   listento = NULL;

   maxframe = 2;

   // Auf alle Rufzeichen hoeren, die in der entsprechenden Liste stehen
   for (tmp=conf->getListenCalls(); tmp; tmp=tmp->next)
      listenToCall(tmp->call);
}


AX25::~AX25()
{
	s_listento *tmp;

   while (listento != NULL)
   {
   	tmp = listento;
   	listento = listento->next;
      ::close(tmp->txfd);
      delete tmp->sockrx;
      free(tmp);

   }
}


//  void AX25::listenToCall(const char *call)
// Auf diesem Port wird auf das uebergebene Rufzeichen gelauscht.
void AX25::listenToCall(const char *call)
{
   s_listento *tmp;
   int fd,i;
   struct full_sockaddr_ax25 ax25;
   int addrlen;


   // Gucken, ob das uebergebene Call schon in der Liste fuer diesen
   // Port steht
   tmp = listento;
   while (tmp != NULL)
   {
      if (!strcmp(tmp->call,call)) return;
      tmp = tmp->next;
   }

   // Nein, das Rufzeichen steht noch nicht in der Liste. Eintragen.

   ax25.fsa_ax25.sax25_family = AF_AX25;
   ax25.fsa_ax25.sax25_ndigis = 1;
#ifdef HAVE_NETAX25_AXLIB_H
   ax25_aton_entry(info_addr,ax25.fsa_digipeater[0].ax25_call);
   ax25_aton_entry(call,ax25.fsa_ax25.sax25_call.ax25_call);
#else
   convert_call_entry(info_addr,ax25.fsa_digipeater[0].ax25_call);
   convert_call_entry(call,ax25.fsa_ax25.sax25_call.ax25_call);
#endif
   addrlen = sizeof(struct full_sockaddr_ax25);
  
   if ((fd = socket(AF_AX25,SOCK_SEQPACKET,0)) < 0)
   {
      syslog(LOG_ERR,"socket: %s\n", strerror(errno));
      return;
   }
  
   if (bind(fd,(struct sockaddr *)&ax25,addrlen) < 0)
   {
      syslog(LOG_ERR,"bind: %s\n",strerror(errno));
      ::close(fd);
      return;
   }

   if (listen(fd, SOMAXCONN) < 0)
   {
      syslog(LOG_ERR,"listen: %s\n",strerror(errno));
      ::close(fd);
      return;
   }

#ifdef USE_NONBLOCKING
   i = TRUE;
   ioctl(fd, FIONBIO, &i);
#endif

   if (listento == NULL)
   {
      listento = (s_listento *)malloc(sizeof(s_listento));
      tmp = listento;
   }
   else
   {
      tmp = listento;
      while (tmp->next != NULL) tmp = tmp->next;
      tmp->next = (s_listento *)malloc(sizeof(s_listento));
      tmp = tmp->next;
   }

   tmp->next = NULL;
   tmp->txfd = fd;
   strcpy(tmp->call,call);
   tmp->sockrx = new QSocketNotifier( fd, QSocketNotifier::Read, this );
   connect( tmp->sockrx, SIGNAL(activated(int)), this, SLOT(rxFrame(int)) );
}


void AX25::deleteListenTo( const char *call )
{
   s_listento *tmp,*last;

   if (!strcmp(listento->call, call))
   {
      // Erster Eintrag in der Liste
      ::close(listento->txfd);
      delete listento->sockrx;
      tmp = listento;
      listento = listento->next;
      free(tmp);
      return;
   }

   last = listento;
   tmp = listento->next;
   while (tmp != NULL)
   {
      if (!strcmp(tmp->call, call))
      {
         last->next = tmp->next;
         ::close(tmp->txfd);
         delete tmp->sockrx;
         free(tmp);
         return;
      }
      last = tmp;
      tmp = tmp->next;
   }
}


//  void AX25::rxFrame()
// Wenn etwas empfangen wurde, wird diese Funktion aufgerufen.
// Wahrscheinlich kommt dann ein neuer Connect 'rein.
void AX25::rxFrame(int socket)
{		// TODO: Umbau auf QString
#ifdef __GLIBC__
   socklen_t addrlen;
#else
   int addrlen;
#endif
   int fd;
   struct full_sockaddr_ax25 ax25;
   char call[100],*digis;
   char tmp[100],tmp2[100],tmp3[100];
   int k,i,len;
   s_listento *lttmp;
   char mycall[10];
   s_ports *porttmp;


   // Daten dieses Connects vom Kernel holen
#ifdef USE_NONBLOCKING
   i = TRUE;
   ioctl(socket, FIONBIO, &i);
#endif
   addrlen = sizeof(ax25);
   if ((fd = accept(socket, (struct sockaddr *)&ax25, &addrlen)) < 0)
   {
      #ifdef USE_NONBLOCKING
         i = FALSE;
         ioctl(socket, FIONBIO, &i);
      #endif
      return;
   }
#ifdef USE_NONBLOCKING
   i = FALSE;
   ioctl(socket, FIONBIO, &i);
#endif

#ifdef USE_NONBLOCKING
   i = TRUE;
   ioctl(fd, FIONBIO, &i);
#endif

   i = 0;

   // Rufzeichen der Gegenstation
   strcpy(call, ax25asc(&ax25.fsa_ax25.sax25_call));

   // SSID abhaengen und testen (!= 0)
   if ((i = POS('-',call)) != -1)
   {
      len = strlen(call)-i-1;
      COPY(tmp3,call,i+1,len);
      tmp3[len] = '\0';
      if (atoi(tmp3) == 0) call[i] = '\0';
   }


   // Gucken, ob das Call, das connected hat, sofort disconnected werden soll
   if (disconnectCall(call))
   {
      write(fd, DISC_TEXT, strlen(DISC_TEXT));
      ::close(fd);
      return;
   }

   // Digipeater
   if (ax25.fsa_ax25.sax25_ndigis > 0)
   {
      k = 0;
      tmp[0] = '\0';
      while (k < ax25.fsa_ax25.sax25_ndigis)
      {
         strcpy(tmp2, ax25asc(&ax25.fsa_digipeater[k]));
         


         // SSID abhngen und testen (!= 0)
         if ((i = POS('-',tmp2)) != -1)
         {
            len = strlen(tmp2)-i-1;
            COPY(tmp3,tmp2,i+1,len);
            tmp3[len] = '\0';
            if (atoi(tmp3) == 0) tmp2[i] = '\0';
         }

         if (k == 0)
            sprintf(tmp,"%s",tmp2);
         else
         {
            strcat(tmp," ");
            strcat(tmp,tmp2);
         }
         k++;
      }
      digis = (char *)strdup(tmp);
   }
   else
   {
      digis = (char *)malloc(1);
      digis[0] = '\0';
   }



   // Der Connect wurde angenommen. Jetzt ueberlassen wir der Klasse
   // Channel (channel.cpp) die weitere Verarbeitung.

   // Welches Rufzeichen wurde connected? (Mycall)
   lttmp = listento;
   while ((lttmp != NULL) && (socket != lttmp->txfd))
      lttmp = lttmp->next;

   if (lttmp == NULL)
      strcpy(mycall, conf->getTxMycall().latin1());
   else
      strcpy(mycall,lttmp->call);

   // Die Protokoll-Parameter setzen
   if (lttmp != NULL)
   {
      porttmp = portlist;
      while ((porttmp != NULL) && (!strcmp(porttmp->name,info_name)))
         porttmp = porttmp->next;
   }

   toplevel->addChannelList()->channel = new Channel( info_name, mycall, call, digis, fd, true );

   free( digis );
}


int AX25::getMaxframe()
{
   return maxframe;
}


int AX25::makeConnect( char *call, char *digis, char *mycall, char *port, int *error )
{
  struct full_sockaddr_ax25 ax25;
  int addrlen;
  struct full_sockaddr_ax25 ax25_d;
  int addrlen_d;
  int fd,i;
  char tmp[500];

  sprintf(tmp,"%s %s",call,digis);

#ifdef HAVE_NETAX25_AXLIB_H
  addrlen_d = ax25_aton(tmp,&ax25_d);
#else
  addrlen_d = convert_call(tmp,&ax25_d);
#endif
  if (addrlen_d == -1)
  {
     *error = 1;
     return -1;
  }


  fd = socket(AF_AX25,SOCK_SEQPACKET,0);
  if (fd < 0)
  {
     *error = 2;
     return -1;
  }
  
  ax25.fsa_ax25.sax25_family = AF_AX25;
  ax25.fsa_ax25.sax25_ndigis = 1;
#ifdef HAVE_NETAX25_AXLIB_H
  ax25_aton_entry(mycall,
                     ax25.fsa_ax25.sax25_call.ax25_call);
  ax25_aton_entry(ax25_config_get_addr(port),
                     ax25.fsa_digipeater[0].ax25_call);
#else
  convert_call_entry(mycall,
                     ax25.fsa_ax25.sax25_call.ax25_call);
  convert_call_entry(ax25_config_get_addr(port),
                     ax25.fsa_digipeater[0].ax25_call);
#endif
  addrlen = sizeof(struct full_sockaddr_ax25);
  
  
  if (bind(fd,(struct sockaddr *)&ax25,addrlen) == -1)
  {
    ::close(fd);
    *error = 3;
    return -1;
  }
  
#ifdef USE_NONBLOCKING
  i = TRUE;
  ioctl(fd,FIONBIO,&i);
#endif

  if (::connect(fd,(struct sockaddr *)&ax25_d,addrlen_d)) {
    if (errno != EINPROGRESS) {
      ::close(fd);
      *error = 4;
      return -1;
    }
  }
  
  return(fd);
}


int AX25::getTxfd(char *mycall)
{
   s_listento *tmp;

   tmp = listento;
   while ((tmp != NULL) && (!strcmp(mycall,tmp->call)))
      tmp = tmp->next;

   if (tmp == NULL) return -1;
   return tmp->txfd;
}


//  bool AX25::disconnectCall(char *call)
// Soll das Rufzeichen sofort wieder disconnected werden?
bool AX25::disconnectCall(char *call)
{
   s_listCalls *tmpcall;
   char tmp[15];

   for (tmpcall=conf->getDiscCalls(); tmpcall; tmpcall=tmpcall->next)
   {
      strcpy(tmp, tmpcall->call);
/*      if (POS('-', tmp) == -1)
         strcat(tmp, "-0");*/
      if (!strcmp(tmp, call)) return true;
   }

   return false;
}


//   void activate_ax25_port( s_ports *port )
//
// Ein AX.25-Port wird aktiviert
void activate_ax25_port( s_ports *port )
{
	port->ax25 = new AX25( port->name, port->desc, port->dev, port->baud, port->addr);
}


//   void deactivate_ax25_port( s_ports *port )
//
// Deaktiviert den angegebenen AX25-Port
void deactivate_ax25_port( s_ports *port )
{
	delete port->ax25;
   port->ax25 = NULL;
}


////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

ax25_polling::ax25_polling()
{
   just_polling = false;

   timer = new QTimer(this);
   connect(timer, SIGNAL(timeout()), this, SLOT(poll()));
   timer->start(50, false);
}


ax25_polling::~ax25_polling()
{
   delete timer;
}


void ax25_polling::poll()
{
   int axstate;
   int tries,/*unack,*/squeue;
   ax25_info_struct axinfo;
   int err;
   QList <Channel> disc;
   Channel *chantmp;

   if (just_polling) return;
   just_polling = true;

   s_chanlist *tmp=toplevel->getChanListPtr();

   while (tmp != NULL)
   {
      if ((err = ioctl(tmp->channel->getTxfd(), SIOCAX25GETINFO, &axinfo)) != -1)
      {
         tries = axinfo.n2count;
/*         if (axinfo.vs < axinfo.va)
            unack = 8 + p->vs - p->va;
         else
            unack = p->vs - p->va;*/
         squeue = axinfo.snd_q / 256;
         if ((squeue == 0) && (axinfo.snd_q > 0)) squeue = 1;

         switch (axinfo.state)
         {
            case 0:
            case 1:
              axstate = axinfo.state;
              break;
            case 2:
              axstate = 3;
              break;
            case 3:
              axstate = 4;
              break;
            case 4:
              axstate = 6;
              break;
            default:
              axstate = 0;
              break;
          }

          // Aenderungen an die Channel-Klasse zurueckgeben
//          tmp->channel->setUnack(unack);
          tmp->channel->setSQueue(squeue);
          tmp->channel->setTries(tries);
          if (axstate == 0)
             disc.append(tmp->channel);
          else
             tmp->channel->setStatus(axstate);
      }
      else
      {
         disc.append(tmp->channel);
      }
      tmp = tmp->next;
   }

   // Alle Kanaele, die disconnected werden sollen, jetzt disconnecten
   chantmp = disc.first();
   while (chantmp != NULL)
   {
      chantmp->setStatus(0);
      chantmp = disc.next();
   }

   just_polling = false;
}




