/*
 * lists.c -- Functions to implement a double linked list
 * XBoard $Id: lists.c,v 1.3 1998/05/24 05:14:31 mann Exp $
 *
 * Copyright 1995 Free Software Foundation, Inc.
 *
 * ------------------------------------------------------------------------
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ------------------------------------------------------------------------
 *
 * This file could well be a part of backend.c, but I prefer it this
 * way.
 */

#include "config.h"

#include <stdio.h>
#if STDC_HEADERS
# include <stdlib.h>
#endif /* not STDC_HEADERS */

#include "common.h"
#include "lists.h"



/* Check, if List l is empty; returns TRUE, if it is, FALSE
 * otherwise.
 */
int ListEmpty(l)
    List *l;
{
    return(l->head == (ListNode *) &l->tail);
}


/* Initialize a list. Must be executed before list is used.
 */
void ListNew(l)
    List *l;
{
    l->head = (ListNode *) &l->tail;
    l->tail = NULL;
    l->tailPred = (ListNode *) l;
}


/* Remove node n from the list it is inside.
 */
void ListRemove(n)
    ListNode *n;
{
    if (n->succ != NULL) {  /*  Be safe  */
	n->pred->succ = n->succ;
	n->succ->pred = n->pred;
	n->succ = NULL;     /*  Mark node as no longer being member */
	n->pred = NULL;     /*  of a list.                          */
    }
}


/* Delete node n.
 */
void ListNodeFree(n)
    ListNode *n;
{
    if (n) {
	ListRemove(n);
	free(n);
    }
}


/* Create a list node with size s. Returns NULL, if out of memory.
 */
ListNode *ListNodeCreate(s)
    size_t s;
{
    ListNode *n;

    if ((n = malloc(s))) {
	n->succ = NULL; /*  Mark node as not being member of a list.    */
	n->pred = NULL;
    }
    return(n);
}


/* Insert node n into the list of node m after m.
 */
void ListInsert(m, n)
    ListNode *m, *n;
{
    n->succ = m->succ;
    n->pred = m;
    m->succ = n;
    n->succ->pred = n;
}


/* Add node n to the head of list l.
 */
void ListAddHead(l, n)
    List *l;
    ListNode *n;
{
    ListInsert((ListNode *) &l->head, n);
}


/* Add node n to the tail of list l.
 */
void ListAddTail(l, n)
    List *l;
    ListNode *n;
{
    ListInsert((ListNode *) l->tailPred, n);
}


/* Return element with number n of list l. (NULL, if n doesn't exist.)
 * Counting starts with 0.
 */
ListNode *ListElem(l, n)
    List *l;
    int n;
{
    ListNode *ln;

    for (ln = l->head;  ln->succ;  ln = ln->succ) {
	if (!n--) {
	    return (ln);
	}
    }

    return(NULL);
}
