/*
 * GQmpeg
 * (C)1998, 1999 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License.
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at you own risk!
 */

#include "gqmpeg.h"

/* table to convert the fonts */
static gint letter_convert[] = { 30,48,47,61,60,57,56,47,44,45,66,50,58,46,58,52,
                                 31,32,33,34,35,36,37,38,39,40,-1,-1,-1,59,-1,-1,

                                 27,0 ,1 ,2 ,3 ,4 ,5 ,6 ,7 ,8 ,9 ,10,11,12,13,14,
                                 15,16,17,18,19,20,21,22,23,24,25,53,51,54,55,49,

                                 47,0 ,1 ,2 ,3 ,4 ,5 ,6 ,7 ,8 ,9 ,10,11,12,13,14,
                                 15,16,17,18,19,20,21,22,23,24,25,-1,-1,-1,-1,-1 };

static GdkPixmap *new_pixmap_at_size(gint x, gint y);
static void draw_pixmap(GdkPixmap *t, GdkPixmap *s, gint x, gint y,
				gint xo, gint yo, gint w, gint h);
static FontData *new_wamp_font(gchar *path, gint l, gint x, gint y);
static DigitData *new_wamp_digit(gchar *path, GdkPixmap *background);
static DigitData *new_wamp_digit_from_font(gchar *path);
static ButtonData *new_wamp_button(GdkPixmap *pixmapin, gint lit, gint x, gint y, gint ox, gint oy, gint lx, gint ly,
	void (*click_func)(void *), void (*press_func)(void *), void (*release_func)(void *));
static ButtonData *new_wamp_button_v(GdkPixmap *pixmapin, gint lit, gint x, gint y, gint ox, gint oy, gint lx, gint ly,
	void (*click_func)(void *), void (*press_func)(void *), void (*release_func)(void *));
static ItemData *new_wamp_item_monoster(gchar *path);
static ItemData *new_wamp_item_status(gchar *path);
static ButtonData *new_wamp_button_alt(GdkPixmap *pixmapin, gint x, gint y, gint ox, gint oy, gint lx, gint ly,
	void (*click_func)(void *), void (*press_func)(void *), void (*release_func)(void *));
static ButtonData *new_wamp_button_small(GdkPixmap *pixmapin, gint x, gint y, gint ox, gint oy,
	void (*click_func)(void *), void (*press_func)(void *), void (*release_func)(void *));
static SliderData *new_wamp_slider(gchar *path, gint prelight, gint length, gint x, gint y,
			ItemData *item,
			void (*press_func)(float), void (*release_func)(float),
			void (*move_func)(float));
static SliderData *new_wamp_vol_slider(gchar *path, gint prelight, gint length, gint x, gint y,
			ItemData *item,
			void (*press_func)(float), void (*release_func)(float),
			void (*move_func)(float));
static SliderData *new_wamp_bal_slider(gchar *path, gint prelight, gint length, gint x, gint y,
			ItemData *item,
			void (*press_func)(float), void (*release_func)(float),
			void (*move_func)(float));
static ItemData *new_wamp_vol_item(gchar *path);
static ItemData *new_wamp_bal_item(gchar *path);

static GdkPixmap *new_pixmap_at_size(gint x, gint y)
{
	GdkPixmap *pixmap;

	if (double_size_mode)
		{
		x *= 2;
		y *= 2;
		}

	pixmap = gdk_pixmap_new(display_area->window, x, y, -1);
	return pixmap;
}

static void draw_pixmap(GdkPixmap *t, GdkPixmap *s, gint x, gint y,
				gint xo, gint yo, gint w, gint h)
{
	if (double_size_mode)
		{
		x *= 2;
		y *= 2;
		xo *= 2;
		yo *= 2;
		w *= 2;
		h *= 2;
		}
	gdk_draw_pixmap(t ,display_area->style->fg_gc[GTK_WIDGET_STATE(display_area)],
                        s, xo, yo, x, y, w, h);
}

static FontData *new_wamp_font(gchar *path, gint l, gint x, gint y)
{
	FontData *font;
	GdkPixmap *pixmapin;
	GdkPixmap *pixmap;
	gint i;

	pixmapin = get_pixmap_from_file(path);
	if (!pixmapin) return NULL;
	pixmap = new_pixmap_at_size(160, 18);

	for (i=0; i<96; i++)
		{
		gint cp = letter_convert[i];
		gint xc, yc;
		gint xp, yp;
		yp = i / 32;
		xp = i - (yp * 32);
		if (cp >= 0)
			{
			yc = cp / 31;
			xc = cp - (yc * 31);
			}
		else
			{
			yc = 0;
			xc = 29;
			}
		draw_pixmap(pixmap, pixmapin, xp * 5, yp * 6, xc * 5, yc * 6, 5, 6);
		}

	gdk_imlib_free_pixmap(pixmapin);
	
	font = new_font(pixmap, l, FALSE, x, y);
	return font;
}

static DigitData *new_wamp_digit(gchar *path, GdkPixmap *background)
{
	GdkPixmap *pixmapin;
	GdkPixmap *pixmap;
	int i;

	pixmapin = get_pixmap_from_file(path);
	if (!pixmapin) return NULL;
	pixmap = new_pixmap_at_size(132, 13);

	for (i=0; i<11; i++)
		{
		draw_pixmap(pixmap, pixmapin, (i * 12) + 3, 0, i * 9, 0, 9, 13);
		draw_pixmap(pixmap, background, i * 12, 0, 87, 26, 3, 13);
		}

	gdk_imlib_free_pixmap(pixmapin);
	return new_digit(pixmap);
}

static DigitData *new_wamp_digit_from_font(gchar *path)
{
	GdkPixmap *pixmapin;
	GdkPixmap *pixmap;
	int i;

	pixmapin = get_pixmap_from_file(path);
	if (!pixmapin) return NULL;
	pixmap = new_pixmap_at_size(55, 6);

	for (i=0; i<10; i++)
		{
		draw_pixmap(pixmap, pixmapin, i * 5, 0, i * 5, 6, 5, 6);
		}
	draw_pixmap(pixmap, pixmapin, 50, 0, 150, 0, 5, 6);

	gdk_imlib_free_pixmap(pixmapin);
	return new_digit(pixmap);
}

static ButtonData *new_wamp_button(GdkPixmap *pixmapin, gint lit, gint x, gint y, gint ox, gint oy, gint lx, gint ly,
	void (*click_func)(void *), void (*press_func)(void *), void (*release_func)(void *))
{
	GdkPixmap *pixmap;
	pixmap = new_pixmap_at_size(lx * (2 + (2 * lit)) , ly);
	draw_pixmap(pixmap, pixmapin, 0, 0, ox, oy, lx, ly);
	draw_pixmap(pixmap, pixmapin, lx, 0, ox, oy +ly, lx, ly);

	if (lit)
		{
		draw_pixmap(pixmap, pixmapin, lx * 2, 0, ox, oy + (ly * 2), lx, ly);
		draw_pixmap(pixmap, pixmapin, lx * 3, 0, ox, oy + (ly * 3), lx, ly);
		}

	return new_button(pixmap, FALSE, lit, x, y, click_func, press_func, release_func);
}

static ButtonData *new_wamp_button_v(GdkPixmap *pixmapin, gint lit, gint x, gint y, gint ox, gint oy, gint lx, gint ly,
	void (*click_func)(void *), void (*press_func)(void *), void (*release_func)(void *))
{
	GdkPixmap *pixmap;
	pixmap = new_pixmap_at_size(lx * (2 + (2 * lit)) , ly);
	draw_pixmap(pixmap, pixmapin, 0, 0, ox, oy, lx, ly);
	draw_pixmap(pixmap, pixmapin, lx, 0, ox + lx, oy, lx, ly);

	if (lit)
		{
		draw_pixmap(pixmap, pixmapin, lx * 2, 0, ox, oy + (ly * 2), lx, ly);
		draw_pixmap(pixmap, pixmapin, lx * 3, 0, ox, oy + (ly * 3), lx, ly);
		}

	return new_button(pixmap, FALSE, lit, x, y, click_func, press_func, release_func);
}

static ItemData *new_wamp_item_monoster(gchar *path)
{
	gint width, height;
	gint s1, s2;
	GdkPixmap *pixmapin;
	GdkPixmap *pixmap;

	pixmapin = get_pixmap_from_file(path);
	if (!pixmapin) return NULL;
	gdk_window_get_size (pixmapin, &width, &height);
	pixmap = new_pixmap_at_size(56,36);
	if (width == 58 || (double_size_mode && width == 116))
		{
		s1 = 1;
		s2 = 29;
		}
	else
		{
		s1 = 0;
		s2 = 28;
		}
	draw_pixmap(pixmap, pixmapin,  0,  0, s2, 12, 28, 12);
	draw_pixmap(pixmap, pixmapin, 28,  0, s1, 12, 28, 12);
	draw_pixmap(pixmap, pixmapin,  0, 12, s2,  0, 28, 12);
	draw_pixmap(pixmap, pixmapin, 28, 12, s1, 12, 28, 12);
	draw_pixmap(pixmap, pixmapin,  0, 24, s2, 12, 28, 12);
	draw_pixmap(pixmap, pixmapin, 28, 24, s1,  0, 28, 12);

	gdk_imlib_free_pixmap(pixmapin);
	return new_item(pixmap, 3, 212, 41);	
}

static ItemData *new_wamp_item_status(gchar *path)
{
	GdkPixmap *pixmapin;
	GdkPixmap *pixmap;
	pixmapin = get_pixmap_from_file(path);
	if (!pixmapin) return NULL;
	pixmap = new_pixmap_at_size(9, 27);

	draw_pixmap(pixmap, pixmapin, 0, 0, 18, 0, 9, 9);
	draw_pixmap(pixmap, pixmapin, 0, 9, 9, 0, 9, 9);
	draw_pixmap(pixmap, pixmapin, 0, 18, 0, 0, 9, 9);

	gdk_imlib_free_pixmap(pixmapin);
	return new_item(pixmap, 3, 26, 28);
}

static ButtonData *new_wamp_button_alt(GdkPixmap *pixmapin, gint x, gint y, gint ox, gint oy, gint lx, gint ly,
	void (*click_func)(void *), void (*press_func)(void *), void (*release_func)(void *))
{
	GdkPixmap *pixmap;
	pixmap = new_pixmap_at_size(lx * 4, ly);
	draw_pixmap(pixmap, pixmapin, 0, 0, ox, oy, lx, ly);
	draw_pixmap(pixmap, pixmapin, lx, 0, ox, oy +ly, lx, ly);
	draw_pixmap(pixmap, pixmapin, lx * 2, 0, ox + lx *2, oy, lx, ly);
	draw_pixmap(pixmap, pixmapin, lx * 3, 0, ox + lx *2, oy + ly, lx, ly);

	return new_button(pixmap, FALSE, TRUE, x, y, click_func, press_func, release_func);
}

static ButtonData *new_wamp_button_small(GdkPixmap *pixmapin, gint x, gint y, gint ox, gint oy,
	void (*click_func)(void *), void (*press_func)(void *), void (*release_func)(void *))
{
	GdkPixmap *pixmap;
	pixmap = new_pixmap_at_size(20, 10);
	draw_pixmap(pixmap, pixmapin, 0, 0, ox, oy, 10, 10);
	draw_pixmap(pixmap, pixmapin, 10, 0, ox, oy, 10, 10);

	return new_button(pixmap, FALSE, FALSE, x, y, click_func, press_func, release_func);
}

static SliderData *new_wamp_slider(gchar *path, gint prelight, gint length, gint x, gint y,
			ItemData *item,
			void (*press_func)(float), void (*release_func)(float),
			void (*move_func)(float))
{
	GdkPixmap *pixmapin;
	GdkPixmap *pixmap;
	pixmapin = get_pixmap_from_file(path);
	if (!pixmapin) return NULL;
	pixmap = new_pixmap_at_size(306, 10);
	draw_pixmap(pixmap, pixmapin, 0, 0, 0, 0, 277, 10);
	draw_pixmap(pixmap, pixmapin, 277, 0, 278, 0, 29, 10);
	gdk_imlib_free_pixmap(pixmapin);
	return new_slider(pixmap, prelight, FALSE, FALSE, length, x, y, item,
		press_func, release_func, move_func);
}

static SliderData *new_wamp_vol_slider(gchar *path, gint prelight, gint length, gint x, gint y,
			ItemData *item,
			void (*press_func)(float), void (*release_func)(float),
			void (*move_func)(float))
{
	GdkPixmap *pixmapin;
	GdkPixmap *pixmap;
	pixmapin = get_pixmap_from_file(path);
	if (!pixmapin) return NULL;
	pixmap = new_pixmap_at_size(88, 11);
	draw_pixmap(pixmap, pixmapin, 0, 0, 3, 1, 60, 11);
	draw_pixmap(pixmap, pixmapin, 60, 0, 0, 422, 14, 11);
	draw_pixmap(pixmap, pixmapin, 74, 0, 15, 422, 14, 11);
	gdk_imlib_free_pixmap(pixmapin);
	return new_slider(pixmap, prelight, FALSE, FALSE, length, x, y, item,
		press_func, release_func, move_func);
}

static SliderData *new_wamp_bal_slider(gchar *path, gint prelight, gint length, gint x, gint y,
			ItemData *item,
			void (*press_func)(float), void (*release_func)(float),
			void (*move_func)(float))
{
	GdkPixmap *pixmapin;
	GdkPixmap *pixmap;
	pixmapin = get_pixmap_from_file(path);
	if (!pixmapin) return NULL;
	pixmap = new_pixmap_at_size(60, 11);
	draw_pixmap(pixmap, pixmapin, 0, 0, 11, 1, 32, 11);
	draw_pixmap(pixmap, pixmapin, 32, 0, 0, 422, 14, 11);
	draw_pixmap(pixmap, pixmapin, 46, 0, 15, 422, 14, 11);
	gdk_imlib_free_pixmap(pixmapin);
	return new_slider(pixmap, prelight, FALSE, FALSE, length, x, y, item,
		press_func, release_func, move_func);
}

static ItemData *new_wamp_vol_item(gchar *path)
{
	GdkPixmap *pixmapin;
	GdkPixmap *pixmap;
	gint i;
	pixmapin = get_pixmap_from_file(path);
	if (!pixmapin) return NULL;
	pixmap = new_pixmap_at_size(68, 336);

	for(i=0; i<28; i++)
		{
		draw_pixmap(pixmap, pixmapin, 0, i * 12, 0, 1 + i * 15, 68, 12);
		}

	gdk_imlib_free_pixmap(pixmapin);
	return new_item(pixmap, 28, 107, 58);
}

static ItemData *new_wamp_bal_item(gchar *path)
{
	GdkPixmap *pixmapin;
	GdkPixmap *pixmap;
	gint i;
	pixmapin = get_pixmap_from_file(path);
	if (!pixmapin) return NULL;
	pixmap = new_pixmap_at_size(38, 336);

	for(i=0; i<14; i++)
		{
		draw_pixmap(pixmap, pixmapin, 0, 156 - i * 12, 9, 1 + i * 30, 38, 12);
		}
	for(i=0; i<14; i++)
		{
		draw_pixmap(pixmap, pixmapin, 0, 168 + i * 12, 9, 1 + i * 30, 38, 12);
		}

	gdk_imlib_free_pixmap(pixmapin);
	return new_item(pixmap, 28, 177, 58);
}

SkinData *load_wamp_normal_skin(gchar *path)
{
	SkinData *s;
	GdkPixmap *background;
	GdkPixmap *pixmap;
	GdkPixmap *temp_pmap;
	gint width, height;
	gchar *buf, *buf2;

	s = new_skin();

	buf = g_strconcat(path, "/main.bmp", NULL);
	background = get_pixmap_from_file(buf);
	g_free(buf);

	if (!background)
		{
		free_skin(s);
		return NULL;
		}

	gdk_window_get_size (background, &width, &height);

	/* work-around for imlib's pixmap caching when show_extra_winamp_info changes */
	temp_pmap = background;
	background = gdk_pixmap_new(display_area->window, width, height, -1);
	draw_pixmap(background, temp_pmap, 0, 0, 0, 0, width, height);
	gdk_imlib_free_pixmap(temp_pmap);
	temp_pmap = NULL;

	buf2 = g_strconcat(path, "/titlebar.bmp", NULL);
	temp_pmap = get_pixmap_from_file(buf2);
	g_free(buf2);
	if (temp_pmap)
		{
		draw_pixmap(background, temp_pmap, 0, 0, 27, 0, 276, 14);
		gdk_imlib_free_pixmap(temp_pmap);
		}

	s->background = background;
	s->width = width;
	s->height = height;

	buf = g_strconcat(path, "/text.bmp", NULL);
	s->title = new_wamp_font(buf, 26, 133, 27);

	s->dig_small = new_wamp_digit_from_font(buf);
	g_free(buf);

	buf = g_strconcat(path, "/numbers.bmp", NULL);
	if (!isfile(buf))
		{
		g_free(buf);
		buf = g_strconcat(path, "/nums_ex.bmp", NULL);
		}
	s->dig_large = new_wamp_digit(buf, background);
	g_free(buf);

	buf = g_strconcat(path, "/cbuttons.bmp", NULL);
	pixmap = get_pixmap_from_file(buf);
	g_free(buf);

	if (pixmap)
		{
		s->prev = new_wamp_button(pixmap, FALSE, 16, 88, 0, 0, 22, 18,
				btn_prev_pressed, btn_prev_down, btn_prev_up);
		s->play = new_wamp_button(pixmap, FALSE, 38, 88, 22, 0, 24, 18,
				btn_play_pressed, NULL, NULL);
		s->pause = new_wamp_button(pixmap, FALSE, 62, 88, 46, 0, 23, 18,
				btn_pause_pressed, NULL, NULL);
		s->stop = new_wamp_button(pixmap, FALSE, 85, 88, 69, 0, 22, 18,
				btn_stop_pressed, NULL, NULL);
		s->next = new_wamp_button(pixmap, FALSE, 107, 88, 91, 0, 22, 18,
				btn_next_pressed, btn_next_down, btn_next_up);
		/* we are cheating a little and using the ff slot for a second playlist */
		s->ff = new_wamp_button(pixmap, FALSE, 136, 89, 114, 0, 22, 16,
				playlist_window_show, NULL, NULL);
		}

	gdk_imlib_free_pixmap(pixmap);
	buf = g_strconcat(path, "/shufrep.bmp", NULL);
	pixmap = get_pixmap_from_file(buf);
	g_free(buf);

	if (pixmap)
		{
		s->shuffle = new_wamp_button(pixmap, TRUE, 165, 89, 29, 0, 46, 15,
				btn_shuffle_pressed, NULL, NULL);
		s->repeat = new_wamp_button(pixmap, TRUE, 211, 89, 0, 0, 29, 15,
				btn_repeat_pressed, NULL, NULL);
		s->playlist = new_wamp_button_alt(pixmap, 242, 58, 23, 61, 23, 12,
				playlist_window_show, NULL, NULL);
		s->mixer = new_wamp_button_alt(pixmap, 219, 58, 0, 61, 23, 12,
				btn_mixer_pressed, NULL, NULL);
		}

	gdk_imlib_free_pixmap(pixmap);
	buf = g_strconcat(path, "/titlebar.bmp", NULL);
	pixmap = get_pixmap_from_file(buf);
	g_free(buf);

	if (pixmap)
		{
		s->iconify = new_wamp_button(pixmap, FALSE, 244, 3, 9, 0, 9, 9,
				btn_iconify_pressed, NULL, NULL);
		s->exit = new_wamp_button(pixmap, FALSE, 264, 3, 18, 0, 9, 9,
				gqmpeg_exit, NULL, NULL);
		s->skin_mode = new_wamp_button_v(pixmap, FALSE, 254, 3, 0, 18, 9, 9,
				mode_button_pressed, NULL, NULL);
		s->config = new_wamp_button(pixmap, FALSE, 6, 3, 0, 0, 9, 9,
				show_configuration_window, NULL, NULL);
		}

	gdk_imlib_free_pixmap(pixmap);

	buf = g_strconcat(path, "/monoster.bmp", NULL);
	s->stereo = new_wamp_item_monoster(buf);
	g_free(buf);

	s->min = new_number(s->dig_large, 2, FALSE, 45, 26);
	s->sec = new_number(s->dig_large, 2, TRUE, 75, 26);

	s->song_current = new_number(s->dig_small, 3, FALSE, 112, 27);

	s->input_bits = new_number(s->dig_small, 3, FALSE, 112, 43);
	s->input_hz = new_number(s->dig_small, 2, FALSE, 157, 43);

	if (show_extra_winamp_info)
		{
		s->cpu = new_number(s->dig_small, 2, FALSE, 47, 48);
		s->frame = new_number(s->dig_small, 5, FALSE, 67, 48);

		/* draw the labels */
		if (s->title)
			{
			FontData *font = s->title;
			draw_pixmap(background, font->pixmap, 32, 48, 15, 6, 5, 6); /* c */
			draw_pixmap(background, font->pixmap, 37, 48, 80, 6, 5, 6); /* p */
			draw_pixmap(background, font->pixmap, 42, 48, 105, 6, 5, 6); /* u */
			draw_pixmap(background, font->pixmap, 57, 48, 25, 0, 5, 6); /* % */
			draw_pixmap(background, font->pixmap, 62, 48, 0, 0, 5, 6); /* ' ' */
			}

		}

	buf = g_strconcat(path, "/playpaus.bmp", NULL);
	s->status = new_wamp_item_status(buf);
	g_free(buf);

	buf = g_strconcat(path, "/posbar.bmp", NULL);
	s->position = new_wamp_slider(buf, FALSE, 248, 16, 72, NULL,
			position_slider_moved, position_slider_released,
			position_slider_moved);
	g_free(buf);

	buf = g_strconcat(path, "/volume.bmp", NULL);
	s->volume_item = new_wamp_vol_item(buf);
	s->volume = new_wamp_vol_slider(buf, FALSE, 60, 110, 58, s->volume_item,
			volume_slider_moved, NULL,
			volume_slider_moved);
	g_free(buf);

	buf = g_strconcat(path, "/balance.bmp", NULL);
	if (!isfile(buf))
		{
		g_free(buf);
		buf = g_strconcat(path, "/volume.bmp", NULL);
		}
	s->balance_item = new_wamp_bal_item(buf);
	s->balance = new_wamp_bal_slider(buf, FALSE, 32, 180, 58, s->balance_item,
			balance_slider_moved, NULL,
			balance_slider_moved);
	g_free(buf);

	return s;
}

SkinData *load_wamp_small_skin(gchar *path)
{

	SkinData *s;
	GdkPixmap *background;
	GdkPixmap *pixmap;
	gint width, height;
	gchar *buf;

	s = new_skin();

	buf = g_strconcat(path, "/titlebar.bmp", NULL);
	pixmap = get_pixmap_from_file(buf);
	if (!pixmap)
		{
		g_free(buf);
		free_skin(s);
		return NULL;
		}
	g_free(buf);

	background = new_pixmap_at_size(275, 14);
	draw_pixmap(background, pixmap, 0, 0, 27, 29, 275, 14);
	gdk_imlib_free_pixmap(pixmap);

	gdk_window_get_size (background, &width, &height);

	s->background = background;
	s->width = width;
	s->height = height;

	buf = g_strconcat(path, "/text.bmp", NULL);
	s->title = new_wamp_font(buf, 22, 132, 27);

	s->dig_small = new_wamp_digit_from_font(buf);
	g_free(buf);

	buf = g_strconcat(path, "/titlebar.bmp", NULL);
	pixmap = get_pixmap_from_file(buf);
	g_free(buf);

	if (pixmap)
		{
		s->prev = new_wamp_button_small(pixmap, 166, 2, 192, 31,
				btn_prev_pressed, btn_prev_down, btn_prev_up);
		s->play = new_wamp_button_small(pixmap, 176, 2, 202, 31,
				btn_play_pressed, NULL, NULL);
		s->pause = new_wamp_button_small(pixmap, 186, 2, 212, 31,
				btn_pause_pressed, NULL, NULL);
		s->stop = new_wamp_button_small(pixmap, 196, 2, 222, 31,
				btn_stop_pressed, NULL, NULL);
		s->next = new_wamp_button_small(pixmap, 206, 2, 232, 31,
				btn_next_pressed, btn_next_down, btn_next_up);
		s->playlist = new_wamp_button_small(pixmap, 216, 2, 242, 31,
				playlist_window_show, NULL, NULL);

		s->iconify = new_wamp_button(pixmap, FALSE, 244, 3, 9, 0, 9, 9,
				btn_iconify_pressed, NULL, NULL);
		s->exit = new_wamp_button(pixmap, FALSE, 264, 3, 18, 0, 9, 9,
				gqmpeg_exit, NULL, NULL);
		s->skin_mode = new_wamp_button_v(pixmap, FALSE, 254, 3, 0, 27, 9, 9,
				mode_button_pressed, NULL, NULL);
		s->config = new_wamp_button(pixmap, FALSE, 6, 3, 0, 0, 9, 9,
				show_configuration_window, NULL, NULL);
		}

	gdk_imlib_free_pixmap(pixmap);

	s->min = new_number(s->dig_small, 2, FALSE, 133, 4);
	s->sec = new_number(s->dig_small, 2, TRUE, 148, 4);

	return s;
}

