/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */

#include "config.h"
#include <ctype.h>
#include <sys/stat.h>

#include "ggvutils.h"

/* Quote filename for system call */
gchar *ggv_quote_filename (const gchar *str)
{
        gchar c, *s, *t, *buf;

        s = (gchar *) str;
        t = buf = g_new (gchar, 2 * strlen (str) + 1);

        while ((c = *s++) != '\0') {
                switch (c) {
                case ' ':
                case '\t':
                case '\n': /* white space */
                case '\'':
                case '"':
                case '\\': /* quoting chars */
                case '|':
                case '&':
                case ';':  /* metacharacters */
                case '(':
                case ')':
                case '<':
                case '>':
                case '!':
                case '{':
                case '}':  /* reserved characters */
                case '*':
                case '[':
                case '?':
                case ']':  /* globbing chars */
                case '^':
                case '$':
                case '`':  /* expansion characters */
                        *t++ = '\\';
                        *t++ = c;
                        break;
                case '#':  /* comment char */
                        if (s == str)
                                *t++ = '\\';
                        *t++ = c;
                        break;
                default:
                        *t++ = c;
                        break;
                }
        }
                *t++ = '\0';
        return buf;
}

/* If file exists and is a regular file then return its length, else -1 */
gint ggv_file_length (const gchar *filename)
{
        struct stat stat_rec;

	if (filename && (stat (filename, &stat_rec) == 0)
	    && S_ISREG (stat_rec.st_mode))
		return stat_rec.st_size;
	else
                return -1;
}

/* Test if file exists, is a regular file and its length is > 0 */
gboolean ggv_file_readable (const char *filename)
{
        return (ggv_file_length (filename) > 0);
}
