/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.text.Collator;
import java.util.Enumeration;
import java.util.Locale;
import java.util.NoSuchElementException;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPEntryComparator;

public class LDAPCompareAttrNames
implements LDAPEntryComparator {
    String[] m_attrs;
    boolean[] m_ascending;
    Locale m_locale;
    Collator m_collator;

    public LDAPCompareAttrNames(String string) {
        this.m_attrs = new String[1];
        this.m_attrs[0] = string;
        this.m_ascending = new boolean[1];
        this.m_ascending[0] = true;
    }

    public LDAPCompareAttrNames(String string, boolean bl) {
        this.m_attrs = new String[1];
        this.m_attrs[0] = string;
        this.m_ascending = new boolean[1];
        this.m_ascending[0] = bl;
    }

    public LDAPCompareAttrNames(String[] stringArray) {
        this.m_attrs = stringArray;
        this.m_ascending = new boolean[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            this.m_ascending[n] = true;
            ++n;
        }
    }

    public LDAPCompareAttrNames(String[] stringArray, boolean[] blArray) {
        this.m_attrs = stringArray;
        this.m_ascending = blArray;
        if (this.m_ascending == null) {
            this.m_ascending = new boolean[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                this.m_ascending[n] = true;
                ++n;
            }
        }
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
        if (this.m_locale == null) {
            this.m_collator = null;
            return;
        }
        this.m_collator = Collator.getInstance(this.m_locale);
    }

    public boolean isGreater(LDAPEntry lDAPEntry, LDAPEntry lDAPEntry2) {
        if (lDAPEntry.equals(lDAPEntry2)) {
            return false;
        }
        return this.attrGreater(lDAPEntry, lDAPEntry2, 0);
    }

    boolean attrGreater(LDAPEntry lDAPEntry, LDAPEntry lDAPEntry2, int n) {
        Enumeration enumeration = lDAPEntry.getAttributeSet().getAttributes();
        Enumeration enumeration2 = lDAPEntry2.getAttributeSet().getAttributes();
        String string = null;
        String string2 = null;
        String string3 = this.m_attrs[n];
        boolean bl = this.m_ascending[n];
        try {
            LDAPAttribute lDAPAttribute;
            while (enumeration2.hasMoreElements()) {
                lDAPAttribute = (LDAPAttribute)enumeration2.nextElement();
                if (!string3.equalsIgnoreCase(lDAPAttribute.getName())) continue;
                string2 = (String)lDAPAttribute.getStringValues().nextElement();
                break;
            }
            while (enumeration.hasMoreElements()) {
                lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
                if (!string3.equalsIgnoreCase(lDAPAttribute.getName())) continue;
                string = (String)lDAPAttribute.getStringValues().nextElement();
                break;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        if (string2 == null ^ string == null) {
            return string != null;
        }
        if (string2 == null || string2.equalsIgnoreCase(string)) {
            if (n == this.m_attrs.length - 1) {
                return false;
            }
            return this.attrGreater(lDAPEntry, lDAPEntry2, n + 1);
        }
        if (this.m_collator != null) {
            if (bl) {
                return this.m_collator.compare(string, string2) > 0;
            }
            return this.m_collator.compare(string, string2) < 0;
        }
        if (bl) {
            return string.compareTo(string2) > 0;
        }
        return string.compareTo(string2) < 0;
    }
}

