/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.CORBA;

import com.visigenic.vbroker.CORBA.GiopInputStream;
import com.visigenic.vbroker.CORBA.GiopStream;
import com.visigenic.vbroker.CORBA.ORB;
import com.visigenic.vbroker.CORBA.OctetSequence;
import com.visigenic.vbroker.CORBA.OrbObject;
import com.visigenic.vbroker.IOP.IORHelper;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.omg.CORBA.Any;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TypeCode;

public class GiopInputStreamImpl
extends GiopInputStream
implements GiopStream,
OrbObject {
    ORB _orb;
    byte[] _bytes;
    int _offset;
    boolean _byteOrder = false;
    Dictionary _typeCodes;

    GiopInputStreamImpl() {
    }

    public void init(ORB oRB, java.lang.Object[] objectArray) {
        this._orb = oRB;
        this._bytes = (byte[])objectArray[0];
    }

    public int offset() {
        return this._offset;
    }

    public void offset(int n) {
        this._offset = n;
    }

    public boolean byteOrder() {
        return this._byteOrder;
    }

    public void byteOrder(boolean bl) {
        this._byteOrder = bl;
    }

    int computePad(int n) {
        int n2 = this._offset % n;
        if (n2 == 0) {
            return 0;
        }
        return n - n2;
    }

    public Dictionary typeCodes() {
        if (this._typeCodes == null) {
            this._typeCodes = new Hashtable();
        }
        return this._typeCodes;
    }

    public Object read_Object() {
        return this._orb.iorToObject(IORHelper.read(this));
    }

    public TypeCode read_TypeCode() {
        return this._orb.create_tc().read(this);
    }

    public Principal read_Principal() {
        return this._orb.create_Principal(this.readByteArray(this.read_long()));
    }

    public Any read_any() {
        TypeCode typeCode = this.read_TypeCode();
        Any any = this._orb.create_any();
        any.read_value(this, typeCode);
        return any;
    }

    public boolean read_boolean() {
        return this.read_octet() != 0;
    }

    public char read_char() {
        return (char)this.read_octet();
    }

    public char read_wchar() {
        return (char)this.read_short();
    }

    public byte read_octet() {
        try {
            byte by = this._bytes[this._offset++];
            return by;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MARSHAL(arrayIndexOutOfBoundsException.toString());
        }
    }

    public short read_ushort() {
        return this.read_short();
    }

    public short read_short() {
        try {
            int n = this.computePad(2);
            this._offset += n;
            int n2 = this._bytes[this._offset++] & 0xFF;
            int n3 = this._bytes[this._offset++] & 0xFF;
            int n4 = !this.byteOrder() ? (n2 << 8) + n3 : n2 + (n3 << 8);
            return (short)n4;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MARSHAL(arrayIndexOutOfBoundsException.toString());
        }
    }

    public int read_ulong() {
        return this.read_long();
    }

    public int read_long() {
        try {
            int n = this.computePad(4);
            this._offset += n;
            int n2 = this._bytes[this._offset++] & 0xFF;
            int n3 = this._bytes[this._offset++] & 0xFF;
            int n4 = this._bytes[this._offset++] & 0xFF;
            int n5 = this._bytes[this._offset++] & 0xFF;
            int n6 = !this.byteOrder() ? (n2 << 24) + (n3 << 16) + (n4 << 8) + n5 : n2 + (n3 << 8) + (n4 << 16) + (n5 << 24);
            return n6;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MARSHAL(arrayIndexOutOfBoundsException.toString());
        }
    }

    public long read_ulonglong() {
        return this.read_longlong();
    }

    public long read_longlong() {
        try {
            int n = this.computePad(8);
            this._offset += n;
            long l = this._bytes[this._offset++] & 0xFF;
            long l2 = this._bytes[this._offset++] & 0xFF;
            long l3 = this._bytes[this._offset++] & 0xFF;
            long l4 = this._bytes[this._offset++] & 0xFF;
            long l5 = this._bytes[this._offset++] & 0xFF;
            long l6 = this._bytes[this._offset++] & 0xFF;
            long l7 = this._bytes[this._offset++] & 0xFF;
            long l8 = this._bytes[this._offset++] & 0xFF;
            long l9 = !this.byteOrder() ? (l << 56) + (l2 << 48) + (l3 << 40) + (l4 << 32) + (l5 << 24) + (l6 << 16) + (l7 << 8) + l8 : l + (l2 << 8) + (l3 << 16) + (l4 << 24) + (l5 << 32) + (l6 << 40) + (l7 << 48) + (l8 << 56);
            return l9;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MARSHAL(arrayIndexOutOfBoundsException.toString());
        }
    }

    public float read_float() {
        return Float.intBitsToFloat(this.read_long());
    }

    public double read_double() {
        return Double.longBitsToDouble(this.read_longlong());
    }

    public String read_string() {
        int n = this.read_long();
        String string = n == 0 ? null : new String(this.readByteArray(n), 0, 0, n - 1);
        return string;
    }

    public String read_wstring() {
        String string;
        int n = this.read_long();
        if (n == 0) {
            string = null;
        } else {
            byte[] byArray = this.readByteArray(n);
            try {
                string = new DataInputStream(new ByteArrayInputStream(byArray)).readUTF();
            }
            catch (IOException iOException) {
                throw new MARSHAL("Invalid unicode string: " + new OctetSequence(byArray));
            }
        }
        return string;
    }

    public void read_octet_array(byte[] byArray, int n, int n2) {
        try {
            System.arraycopy(this._bytes, this._offset, byArray, n, n2);
            this._offset += n2;
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MARSHAL(arrayIndexOutOfBoundsException.toString());
        }
    }

    public byte[] readByteArray(int n) {
        byte[] byArray = null;
        try {
            byArray = new byte[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                this._orb.println("Forcing garbage collection due to limited memory...");
                System.gc();
                try {
                    byArray = new byte[n];
                }
                catch (OutOfMemoryError outOfMemoryError2) {
                    throw new NO_RESOURCES("Could not allocated " + n + " bytes");
                }
            }
        }
        this.read_octet_array(byArray, 0, n);
        return byArray;
    }

    public void read_boolean_array(boolean[] blArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            blArray[n3] = this.read_boolean();
            ++n3;
        }
    }

    public void read_char_array(char[] cArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            cArray[n3] = this.read_char();
            ++n3;
        }
    }

    public void read_wchar_array(char[] cArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            cArray[n3] = this.read_wchar();
            ++n3;
        }
    }

    public void read_short_array(short[] sArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            sArray[n3] = this.read_short();
            ++n3;
        }
    }

    public void read_ushort_array(short[] sArray, int n, int n2) {
        this.read_short_array(sArray, n, n2);
    }

    public void read_long_array(int[] nArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            nArray[n3] = this.read_long();
            ++n3;
        }
    }

    public void read_ulong_array(int[] nArray, int n, int n2) {
        this.read_long_array(nArray, n, n2);
    }

    public void read_longlong_array(long[] lArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            lArray[n3] = this.read_longlong();
            ++n3;
        }
    }

    public void read_ulonglong_array(long[] lArray, int n, int n2) {
        this.read_longlong_array(lArray, n, n2);
    }

    public void read_float_array(float[] fArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            fArray[n3] = this.read_float();
            ++n3;
        }
    }

    public void read_double_array(double[] dArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            dArray[n3] = this.read_double();
            ++n3;
        }
    }

    public int available() {
        int n = this._bytes.length - this.offset();
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    public void close() throws IOException {
    }

    public void mark(int n) {
    }

    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public boolean markSupported() {
        return false;
    }

    public long skip(long l) throws IOException {
        int n = this.available();
        if (l <= (long)n) {
            this._offset = (int)((long)this._offset + l);
            return l;
        }
        this._offset = this._bytes.length;
        return n;
    }

    public int read() throws IOException {
        if (this.available() > 0) {
            return this.read_octet() & 0xFF;
        }
        return -1;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            return (int)this.skip(n2);
        }
        int n3 = this.available();
        if (n3 > 0) {
            int n4;
            if (n3 < n2) {
                n2 = n3;
            }
            if ((n4 = byArray.length - n) < n2) {
                n2 = n4;
            }
            System.arraycopy(this._bytes, this._offset, byArray, n, n2);
            this._offset += n2;
            return n2;
        }
        return -1;
    }
}

