/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public final class StringBuffer
implements Serializable {
    private char[] value;
    private int count;
    private boolean shared;
    static final long serialVersionUID = 3388685877147921107L;

    public StringBuffer() {
        this(16);
    }

    public StringBuffer(int n) {
        this.value = new char[n];
        this.shared = false;
    }

    public StringBuffer(String string) {
        this(string.length() + 16);
        this.append(string);
    }

    public int length() {
        return this.count;
    }

    public int capacity() {
        return this.value.length;
    }

    private final void copyWhenShared() {
        if (this.shared) {
            char[] cArray = new char[this.value.length];
            System.arraycopy(this.value, 0, cArray, 0, this.count);
            this.value = cArray;
            this.shared = false;
        }
    }

    public synchronized void ensureCapacity(int n) {
        int n2 = this.value.length;
        if (n > n2) {
            int n3 = (n2 + 1) * 2;
            if (n > n3) {
                n3 = n;
            }
            char[] cArray = new char[n3];
            System.arraycopy(this.value, 0, cArray, 0, this.count);
            this.value = cArray;
            this.shared = false;
        }
    }

    public synchronized void setLength(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.ensureCapacity(n);
        if (this.count < n) {
            this.copyWhenShared();
            while (this.count < n) {
                this.value[this.count] = '\u0000';
                ++this.count;
            }
        }
        this.count = n;
    }

    public synchronized char charAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.value[n];
    }

    public synchronized void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0 || n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n < n2) {
            System.arraycopy(this.value, n, cArray, n3, n2 - n);
        }
    }

    public synchronized void setCharAt(int n, char c) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.copyWhenShared();
        this.value[n] = c;
    }

    public synchronized StringBuffer append(Object object) {
        return this.append(String.valueOf(object));
    }

    public synchronized StringBuffer append(String string) {
        if (string == null) {
            string = String.valueOf(string);
        }
        int n = string.length();
        this.ensureCapacity(this.count + n);
        this.copyWhenShared();
        string.getChars(0, n, this.value, this.count);
        this.count += n;
        return this;
    }

    public synchronized StringBuffer append(char[] cArray) {
        int n = cArray.length;
        this.ensureCapacity(this.count + n);
        this.copyWhenShared();
        System.arraycopy(cArray, 0, this.value, this.count, n);
        this.count += n;
        return this;
    }

    public synchronized StringBuffer append(char[] cArray, int n, int n2) {
        this.ensureCapacity(this.count + n2);
        this.copyWhenShared();
        System.arraycopy(cArray, n, this.value, this.count, n2);
        this.count += n2;
        return this;
    }

    public StringBuffer append(boolean bl) {
        return this.append(String.valueOf(bl));
    }

    public synchronized StringBuffer append(char c) {
        this.ensureCapacity(this.count + 1);
        this.copyWhenShared();
        this.value[this.count++] = c;
        return this;
    }

    public StringBuffer append(int n) {
        return this.append(String.valueOf(n));
    }

    public StringBuffer append(long l) {
        return this.append(String.valueOf(l));
    }

    public StringBuffer append(float f) {
        return this.append(String.valueOf(f));
    }

    public StringBuffer append(double d) {
        return this.append(String.valueOf(d));
    }

    public synchronized StringBuffer insert(int n, Object object) {
        return this.insert(n, String.valueOf(object));
    }

    public synchronized StringBuffer insert(int n, String string) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int n2 = string.length();
        this.ensureCapacity(this.count + n2);
        this.copyWhenShared();
        System.arraycopy(this.value, n, this.value, n + n2, this.count - n);
        string.getChars(0, n2, this.value, n);
        this.count += n2;
        return this;
    }

    public synchronized StringBuffer insert(int n, char[] cArray) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int n2 = cArray.length;
        this.ensureCapacity(this.count + n2);
        this.copyWhenShared();
        System.arraycopy(this.value, n, this.value, n + n2, this.count - n);
        System.arraycopy(cArray, 0, this.value, n, n2);
        this.count += n2;
        return this;
    }

    public StringBuffer insert(int n, boolean bl) {
        return this.insert(n, String.valueOf(bl));
    }

    public synchronized StringBuffer insert(int n, char c) {
        this.ensureCapacity(this.count + 1);
        this.copyWhenShared();
        System.arraycopy(this.value, n, this.value, n + 1, this.count - n);
        this.value[n] = c;
        ++this.count;
        return this;
    }

    public StringBuffer insert(int n, int n2) {
        return this.insert(n, String.valueOf(n2));
    }

    public StringBuffer insert(int n, long l) {
        return this.insert(n, String.valueOf(l));
    }

    public StringBuffer insert(int n, float f) {
        return this.insert(n, String.valueOf(f));
    }

    public StringBuffer insert(int n, double d) {
        return this.insert(n, String.valueOf(d));
    }

    public synchronized StringBuffer reverse() {
        this.copyWhenShared();
        int n = this.count - 1;
        int n2 = n - 1 >> 1;
        while (n2 >= 0) {
            char c = this.value[n2];
            this.value[n2] = this.value[n - n2];
            this.value[n - n2] = c;
            --n2;
        }
        return this;
    }

    public String toString() {
        return new String(this);
    }

    final void setShared() {
        this.shared = true;
    }

    final char[] getValue() {
        return this.value;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.value = (char[])this.value.clone();
        this.shared = false;
    }
}

