/* this file was generated by the MCOP idl compiler - DO NOT EDIT */

#ifndef ARTSFLOW_H
#define ARTSFLOW_H

#include "common.h"

namespace Arts {
enum AutoSuspendState {asNoSuspend = 0, asSuspend = 1, asSuspendStop = 2};
};
namespace Arts {
class SynthModule;
class Synth_PLAY;
class Synth_FREQUENCY;
class Synth_WAVE_SIN;
class Synth_MULTI_ADD;
class Synth_ADD;
class Synth_MUL;
class Synth_PLAY_WAV;
class ByteStreamToAudio;
class StereoEffect;
class StereoVolumeControl;
class StereoFFTScope;
class StereoEffectStack;

class SynthModule_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static SynthModule_base *_create(const std::string& subClass = "Arts::SynthModule");
	static SynthModule_base *_fromString(std::string objectref);
	static SynthModule_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline SynthModule_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::AutoSuspendState autoSuspend() = 0;
	virtual void start() = 0;
	virtual void stop() = 0;
	virtual void streamInit() = 0;
	virtual void streamStart() = 0;
	virtual void streamEnd() = 0;
};

class SynthModule_stub : virtual public SynthModule_base, virtual public Arts::Object_stub {
protected:
	SynthModule_stub();

public:
	SynthModule_stub(Arts::Connection *connection, long objectID);

	Arts::AutoSuspendState autoSuspend();
	void start();
	void stop();
	void streamInit();
	void streamStart();
	void streamEnd();
};

class SynthModule_skel : virtual public SynthModule_base, virtual public Arts::Object_skel {
public:
	SynthModule_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class SynthModule : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	SynthModule_base *_cache;
	inline SynthModule_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(SynthModule_base *)_pool->base->_cast(SynthModule_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline SynthModule(SynthModule_base* b) : Object(b), _cache(0) {}


public:
	typedef SynthModule_base _base_class;

	inline SynthModule() : Arts::Object(_Creator), _cache(0) {}
	inline SynthModule(const Arts::SubClass& s) :
		Arts::Object(SynthModule_base::_create(s.string())), _cache(0) {}
	inline SynthModule(const Arts::Reference &r) :
		Arts::Object(r.isString()?(SynthModule_base::_fromString(r.string())):(SynthModule_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline SynthModule(const Arts::DynamicCast& c) : Arts::Object(SynthModule_base::_fromString(c.object().toString())), _cache(0) {}
	inline SynthModule(const SynthModule& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline SynthModule(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static SynthModule null() {return SynthModule((SynthModule_base*)0);}
	inline static SynthModule _from_base(SynthModule_base* b) {return SynthModule(b);}
	inline SynthModule& operator=(const SynthModule& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline SynthModule_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_PLAY_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_PLAY_base *_create(const std::string& subClass = "Arts::Synth_PLAY");
	static Synth_PLAY_base *_fromString(std::string objectref);
	static Synth_PLAY_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_PLAY_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_PLAY_stub : virtual public Synth_PLAY_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_PLAY_stub();

public:
	Synth_PLAY_stub(Arts::Connection *connection, long objectID);

};

class Synth_PLAY_skel : virtual public Synth_PLAY_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue_left;                      // incoming stream
	float *invalue_right;                     // incoming stream

public:
	Synth_PLAY_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_PLAY : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_PLAY_base *_cache;
	inline Synth_PLAY_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_PLAY_base *)_pool->base->_cast(Synth_PLAY_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_PLAY(Synth_PLAY_base* b) : Object(b), _cache(0) {}


public:
	typedef Synth_PLAY_base _base_class;

	inline Synth_PLAY() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_PLAY(const Arts::SubClass& s) :
		Arts::Object(Synth_PLAY_base::_create(s.string())), _cache(0) {}
	inline Synth_PLAY(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_PLAY_base::_fromString(r.string())):(Synth_PLAY_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_PLAY(const Arts::DynamicCast& c) : Arts::Object(Synth_PLAY_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_PLAY(const Synth_PLAY& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_PLAY(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_PLAY null() {return Synth_PLAY((Synth_PLAY_base*)0);}
	inline static Synth_PLAY _from_base(Synth_PLAY_base* b) {return Synth_PLAY(b);}
	inline Synth_PLAY& operator=(const Synth_PLAY& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_PLAY_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_FREQUENCY_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_FREQUENCY_base *_create(const std::string& subClass = "Arts::Synth_FREQUENCY");
	static Synth_FREQUENCY_base *_fromString(std::string objectref);
	static Synth_FREQUENCY_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_FREQUENCY_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_FREQUENCY_stub : virtual public Synth_FREQUENCY_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_FREQUENCY_stub();

public:
	Synth_FREQUENCY_stub(Arts::Connection *connection, long objectID);

};

class Synth_FREQUENCY_skel : virtual public Synth_FREQUENCY_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *frequency;                         // incoming stream
	float *pos;                               // outgoing stream

public:
	Synth_FREQUENCY_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_FREQUENCY : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_FREQUENCY_base *_cache;
	inline Synth_FREQUENCY_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_FREQUENCY_base *)_pool->base->_cast(Synth_FREQUENCY_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_FREQUENCY(Synth_FREQUENCY_base* b) : Object(b), _cache(0) {}


public:
	typedef Synth_FREQUENCY_base _base_class;

	inline Synth_FREQUENCY() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_FREQUENCY(const Arts::SubClass& s) :
		Arts::Object(Synth_FREQUENCY_base::_create(s.string())), _cache(0) {}
	inline Synth_FREQUENCY(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_FREQUENCY_base::_fromString(r.string())):(Synth_FREQUENCY_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_FREQUENCY(const Arts::DynamicCast& c) : Arts::Object(Synth_FREQUENCY_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_FREQUENCY(const Synth_FREQUENCY& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_FREQUENCY(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_FREQUENCY null() {return Synth_FREQUENCY((Synth_FREQUENCY_base*)0);}
	inline static Synth_FREQUENCY _from_base(Synth_FREQUENCY_base* b) {return Synth_FREQUENCY(b);}
	inline Synth_FREQUENCY& operator=(const Synth_FREQUENCY& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_FREQUENCY_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_WAVE_SIN_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_WAVE_SIN_base *_create(const std::string& subClass = "Arts::Synth_WAVE_SIN");
	static Synth_WAVE_SIN_base *_fromString(std::string objectref);
	static Synth_WAVE_SIN_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_WAVE_SIN_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_WAVE_SIN_stub : virtual public Synth_WAVE_SIN_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_WAVE_SIN_stub();

public:
	Synth_WAVE_SIN_stub(Arts::Connection *connection, long objectID);

};

class Synth_WAVE_SIN_skel : virtual public Synth_WAVE_SIN_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *pos;                               // incoming stream
	float *outvalue;                          // outgoing stream

public:
	Synth_WAVE_SIN_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_WAVE_SIN : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_WAVE_SIN_base *_cache;
	inline Synth_WAVE_SIN_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_WAVE_SIN_base *)_pool->base->_cast(Synth_WAVE_SIN_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_WAVE_SIN(Synth_WAVE_SIN_base* b) : Object(b), _cache(0) {}


public:
	typedef Synth_WAVE_SIN_base _base_class;

	inline Synth_WAVE_SIN() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_WAVE_SIN(const Arts::SubClass& s) :
		Arts::Object(Synth_WAVE_SIN_base::_create(s.string())), _cache(0) {}
	inline Synth_WAVE_SIN(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_WAVE_SIN_base::_fromString(r.string())):(Synth_WAVE_SIN_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_WAVE_SIN(const Arts::DynamicCast& c) : Arts::Object(Synth_WAVE_SIN_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_WAVE_SIN(const Synth_WAVE_SIN& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_WAVE_SIN(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_WAVE_SIN null() {return Synth_WAVE_SIN((Synth_WAVE_SIN_base*)0);}
	inline static Synth_WAVE_SIN _from_base(Synth_WAVE_SIN_base* b) {return Synth_WAVE_SIN(b);}
	inline Synth_WAVE_SIN& operator=(const Synth_WAVE_SIN& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_WAVE_SIN_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_MULTI_ADD_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_MULTI_ADD_base *_create(const std::string& subClass = "Arts::Synth_MULTI_ADD");
	static Synth_MULTI_ADD_base *_fromString(std::string objectref);
	static Synth_MULTI_ADD_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_MULTI_ADD_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_MULTI_ADD_stub : virtual public Synth_MULTI_ADD_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_MULTI_ADD_stub();

public:
	Synth_MULTI_ADD_stub(Arts::Connection *connection, long objectID);

};

class Synth_MULTI_ADD_skel : virtual public Synth_MULTI_ADD_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float **invalue;                          // incoming stream
	float *outvalue;                          // outgoing stream

public:
	Synth_MULTI_ADD_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_MULTI_ADD : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_MULTI_ADD_base *_cache;
	inline Synth_MULTI_ADD_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_MULTI_ADD_base *)_pool->base->_cast(Synth_MULTI_ADD_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_MULTI_ADD(Synth_MULTI_ADD_base* b) : Object(b), _cache(0) {}


public:
	typedef Synth_MULTI_ADD_base _base_class;

	inline Synth_MULTI_ADD() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_MULTI_ADD(const Arts::SubClass& s) :
		Arts::Object(Synth_MULTI_ADD_base::_create(s.string())), _cache(0) {}
	inline Synth_MULTI_ADD(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_MULTI_ADD_base::_fromString(r.string())):(Synth_MULTI_ADD_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_MULTI_ADD(const Arts::DynamicCast& c) : Arts::Object(Synth_MULTI_ADD_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_MULTI_ADD(const Synth_MULTI_ADD& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_MULTI_ADD(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_MULTI_ADD null() {return Synth_MULTI_ADD((Synth_MULTI_ADD_base*)0);}
	inline static Synth_MULTI_ADD _from_base(Synth_MULTI_ADD_base* b) {return Synth_MULTI_ADD(b);}
	inline Synth_MULTI_ADD& operator=(const Synth_MULTI_ADD& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_MULTI_ADD_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_ADD_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_ADD_base *_create(const std::string& subClass = "Arts::Synth_ADD");
	static Synth_ADD_base *_fromString(std::string objectref);
	static Synth_ADD_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_ADD_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_ADD_stub : virtual public Synth_ADD_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_ADD_stub();

public:
	Synth_ADD_stub(Arts::Connection *connection, long objectID);

};

class Synth_ADD_skel : virtual public Synth_ADD_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue1;                          // incoming stream
	float *invalue2;                          // incoming stream
	float *outvalue;                          // outgoing stream

public:
	Synth_ADD_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_ADD : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_ADD_base *_cache;
	inline Synth_ADD_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_ADD_base *)_pool->base->_cast(Synth_ADD_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_ADD(Synth_ADD_base* b) : Object(b), _cache(0) {}


public:
	typedef Synth_ADD_base _base_class;

	inline Synth_ADD() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_ADD(const Arts::SubClass& s) :
		Arts::Object(Synth_ADD_base::_create(s.string())), _cache(0) {}
	inline Synth_ADD(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_ADD_base::_fromString(r.string())):(Synth_ADD_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_ADD(const Arts::DynamicCast& c) : Arts::Object(Synth_ADD_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_ADD(const Synth_ADD& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_ADD(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_ADD null() {return Synth_ADD((Synth_ADD_base*)0);}
	inline static Synth_ADD _from_base(Synth_ADD_base* b) {return Synth_ADD(b);}
	inline Synth_ADD& operator=(const Synth_ADD& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_ADD_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_MUL_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_MUL_base *_create(const std::string& subClass = "Arts::Synth_MUL");
	static Synth_MUL_base *_fromString(std::string objectref);
	static Synth_MUL_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_MUL_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_MUL_stub : virtual public Synth_MUL_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_MUL_stub();

public:
	Synth_MUL_stub(Arts::Connection *connection, long objectID);

};

class Synth_MUL_skel : virtual public Synth_MUL_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue1;                          // incoming stream
	float *invalue2;                          // incoming stream
	float *outvalue;                          // outgoing stream

public:
	Synth_MUL_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_MUL : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_MUL_base *_cache;
	inline Synth_MUL_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_MUL_base *)_pool->base->_cast(Synth_MUL_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_MUL(Synth_MUL_base* b) : Object(b), _cache(0) {}


public:
	typedef Synth_MUL_base _base_class;

	inline Synth_MUL() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_MUL(const Arts::SubClass& s) :
		Arts::Object(Synth_MUL_base::_create(s.string())), _cache(0) {}
	inline Synth_MUL(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_MUL_base::_fromString(r.string())):(Synth_MUL_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_MUL(const Arts::DynamicCast& c) : Arts::Object(Synth_MUL_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_MUL(const Synth_MUL& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_MUL(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_MUL null() {return Synth_MUL((Synth_MUL_base*)0);}
	inline static Synth_MUL _from_base(Synth_MUL_base* b) {return Synth_MUL(b);}
	inline Synth_MUL& operator=(const Synth_MUL& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_MUL_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_PLAY_WAV_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_PLAY_WAV_base *_create(const std::string& subClass = "Arts::Synth_PLAY_WAV");
	static Synth_PLAY_WAV_base *_fromString(std::string objectref);
	static Synth_PLAY_WAV_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_PLAY_WAV_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float speed() = 0;
	virtual void speed(float newValue) = 0;
	virtual std::string filename() = 0;
	virtual void filename(const std::string& newValue) = 0;
	virtual bool finished() = 0;
};

class Synth_PLAY_WAV_stub : virtual public Synth_PLAY_WAV_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_PLAY_WAV_stub();

public:
	Synth_PLAY_WAV_stub(Arts::Connection *connection, long objectID);

	float speed();
	void speed(float newValue);
	std::string filename();
	void filename(const std::string& newValue);
	bool finished();
};

class Synth_PLAY_WAV_skel : virtual public Synth_PLAY_WAV_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *left;                              // outgoing stream
	float *right;                             // outgoing stream

public:
	Synth_PLAY_WAV_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_PLAY_WAV : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_PLAY_WAV_base *_cache;
	inline Synth_PLAY_WAV_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_PLAY_WAV_base *)_pool->base->_cast(Synth_PLAY_WAV_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_PLAY_WAV(Synth_PLAY_WAV_base* b) : Object(b), _cache(0) {}


public:
	typedef Synth_PLAY_WAV_base _base_class;

	inline Synth_PLAY_WAV() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_PLAY_WAV(const Arts::SubClass& s) :
		Arts::Object(Synth_PLAY_WAV_base::_create(s.string())), _cache(0) {}
	inline Synth_PLAY_WAV(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_PLAY_WAV_base::_fromString(r.string())):(Synth_PLAY_WAV_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_PLAY_WAV(const Arts::DynamicCast& c) : Arts::Object(Synth_PLAY_WAV_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_PLAY_WAV(const Synth_PLAY_WAV& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_PLAY_WAV(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_PLAY_WAV null() {return Synth_PLAY_WAV((Synth_PLAY_WAV_base*)0);}
	inline static Synth_PLAY_WAV _from_base(Synth_PLAY_WAV_base* b) {return Synth_PLAY_WAV(b);}
	inline Synth_PLAY_WAV& operator=(const Synth_PLAY_WAV& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_PLAY_WAV_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float speed();
	inline void speed(float _newValue);
	inline std::string filename();
	inline void filename(const std::string& _newValue);
	inline bool finished();
};

class ByteStreamToAudio_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static ByteStreamToAudio_base *_create(const std::string& subClass = "Arts::ByteStreamToAudio");
	static ByteStreamToAudio_base *_fromString(std::string objectref);
	static ByteStreamToAudio_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline ByteStreamToAudio_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual long samplingRate() = 0;
	virtual void samplingRate(long newValue) = 0;
	virtual long channels() = 0;
	virtual void channels(long newValue) = 0;
	virtual long bits() = 0;
	virtual void bits(long newValue) = 0;
	virtual bool running() = 0;
};

class ByteStreamToAudio_stub : virtual public ByteStreamToAudio_base, virtual public Arts::SynthModule_stub {
protected:
	ByteStreamToAudio_stub();

public:
	ByteStreamToAudio_stub(Arts::Connection *connection, long objectID);

	long samplingRate();
	void samplingRate(long newValue);
	long channels();
	void channels(long newValue);
	long bits();
	void bits(long newValue);
	bool running();
};

class ByteStreamToAudio_skel : virtual public ByteStreamToAudio_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	Arts::ByteAsyncStream indata;             // incoming stream
	float *left;                              // outgoing stream
	float *right;                             // outgoing stream

	// handler for asynchronous streams
	virtual void process_indata(Arts::DataPacket<Arts::mcopbyte> *) = 0;

public:
	ByteStreamToAudio_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
	void notify(const Arts::Notification& notification);
};

};
#include "reference.h"
namespace Arts {
class ByteStreamToAudio : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	ByteStreamToAudio_base *_cache;
	inline ByteStreamToAudio_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(ByteStreamToAudio_base *)_pool->base->_cast(ByteStreamToAudio_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline ByteStreamToAudio(ByteStreamToAudio_base* b) : Object(b), _cache(0) {}


public:
	typedef ByteStreamToAudio_base _base_class;

	inline ByteStreamToAudio() : Arts::Object(_Creator), _cache(0) {}
	inline ByteStreamToAudio(const Arts::SubClass& s) :
		Arts::Object(ByteStreamToAudio_base::_create(s.string())), _cache(0) {}
	inline ByteStreamToAudio(const Arts::Reference &r) :
		Arts::Object(r.isString()?(ByteStreamToAudio_base::_fromString(r.string())):(ByteStreamToAudio_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline ByteStreamToAudio(const Arts::DynamicCast& c) : Arts::Object(ByteStreamToAudio_base::_fromString(c.object().toString())), _cache(0) {}
	inline ByteStreamToAudio(const ByteStreamToAudio& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline ByteStreamToAudio(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static ByteStreamToAudio null() {return ByteStreamToAudio((ByteStreamToAudio_base*)0);}
	inline static ByteStreamToAudio _from_base(ByteStreamToAudio_base* b) {return ByteStreamToAudio(b);}
	inline ByteStreamToAudio& operator=(const ByteStreamToAudio& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline ByteStreamToAudio_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline long samplingRate();
	inline void samplingRate(long _newValue);
	inline long channels();
	inline void channels(long _newValue);
	inline long bits();
	inline void bits(long _newValue);
	inline bool running();
};

class StereoEffect_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static StereoEffect_base *_create(const std::string& subClass = "Arts::StereoEffect");
	static StereoEffect_base *_fromString(std::string objectref);
	static StereoEffect_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline StereoEffect_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class StereoEffect_stub : virtual public StereoEffect_base, virtual public Arts::SynthModule_stub {
protected:
	StereoEffect_stub();

public:
	StereoEffect_stub(Arts::Connection *connection, long objectID);

};

class StereoEffect_skel : virtual public StereoEffect_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *inleft;                            // incoming stream
	float *inright;                           // incoming stream
	float *outleft;                           // outgoing stream
	float *outright;                          // outgoing stream

public:
	StereoEffect_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class StereoEffect : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	StereoEffect_base *_cache;
	inline StereoEffect_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(StereoEffect_base *)_pool->base->_cast(StereoEffect_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline StereoEffect(StereoEffect_base* b) : Object(b), _cache(0) {}


public:
	typedef StereoEffect_base _base_class;

	inline StereoEffect() : Arts::Object(_Creator), _cache(0) {}
	inline StereoEffect(const Arts::SubClass& s) :
		Arts::Object(StereoEffect_base::_create(s.string())), _cache(0) {}
	inline StereoEffect(const Arts::Reference &r) :
		Arts::Object(r.isString()?(StereoEffect_base::_fromString(r.string())):(StereoEffect_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline StereoEffect(const Arts::DynamicCast& c) : Arts::Object(StereoEffect_base::_fromString(c.object().toString())), _cache(0) {}
	inline StereoEffect(const StereoEffect& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline StereoEffect(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static StereoEffect null() {return StereoEffect((StereoEffect_base*)0);}
	inline static StereoEffect _from_base(StereoEffect_base* b) {return StereoEffect(b);}
	inline StereoEffect& operator=(const StereoEffect& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline StereoEffect_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class StereoVolumeControl_base : virtual public Arts::StereoEffect_base {
public:
	static unsigned long _IID; // interface ID

	static StereoVolumeControl_base *_create(const std::string& subClass = "Arts::StereoVolumeControl");
	static StereoVolumeControl_base *_fromString(std::string objectref);
	static StereoVolumeControl_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline StereoVolumeControl_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float scaleFactor() = 0;
	virtual void scaleFactor(float newValue) = 0;
	virtual float currentVolumeLeft() = 0;
	virtual float currentVolumeRight() = 0;
};

class StereoVolumeControl_stub : virtual public StereoVolumeControl_base, virtual public Arts::StereoEffect_stub {
protected:
	StereoVolumeControl_stub();

public:
	StereoVolumeControl_stub(Arts::Connection *connection, long objectID);

	float scaleFactor();
	void scaleFactor(float newValue);
	float currentVolumeLeft();
	float currentVolumeRight();
};

class StereoVolumeControl_skel : virtual public StereoVolumeControl_base, virtual public Arts::StereoEffect_skel {
public:
	StereoVolumeControl_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class StereoVolumeControl : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	StereoVolumeControl_base *_cache;
	inline StereoVolumeControl_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(StereoVolumeControl_base *)_pool->base->_cast(StereoVolumeControl_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline StereoVolumeControl(StereoVolumeControl_base* b) : Object(b), _cache(0) {}


public:
	typedef StereoVolumeControl_base _base_class;

	inline StereoVolumeControl() : Arts::Object(_Creator), _cache(0) {}
	inline StereoVolumeControl(const Arts::SubClass& s) :
		Arts::Object(StereoVolumeControl_base::_create(s.string())), _cache(0) {}
	inline StereoVolumeControl(const Arts::Reference &r) :
		Arts::Object(r.isString()?(StereoVolumeControl_base::_fromString(r.string())):(StereoVolumeControl_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline StereoVolumeControl(const Arts::DynamicCast& c) : Arts::Object(StereoVolumeControl_base::_fromString(c.object().toString())), _cache(0) {}
	inline StereoVolumeControl(const StereoVolumeControl& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline StereoVolumeControl(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static StereoVolumeControl null() {return StereoVolumeControl((StereoVolumeControl_base*)0);}
	inline static StereoVolumeControl _from_base(StereoVolumeControl_base* b) {return StereoVolumeControl(b);}
	inline StereoVolumeControl& operator=(const StereoVolumeControl& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::StereoEffect() const { return Arts::StereoEffect(*_pool); }
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline StereoVolumeControl_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float scaleFactor();
	inline void scaleFactor(float _newValue);
	inline float currentVolumeLeft();
	inline float currentVolumeRight();
};

class StereoFFTScope_base : virtual public Arts::StereoEffect_base {
public:
	static unsigned long _IID; // interface ID

	static StereoFFTScope_base *_create(const std::string& subClass = "Arts::StereoFFTScope");
	static StereoFFTScope_base *_fromString(std::string objectref);
	static StereoFFTScope_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline StereoFFTScope_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::vector<float> * scope() = 0;
};

class StereoFFTScope_stub : virtual public StereoFFTScope_base, virtual public Arts::StereoEffect_stub {
protected:
	StereoFFTScope_stub();

public:
	StereoFFTScope_stub(Arts::Connection *connection, long objectID);

	std::vector<float> * scope();
};

class StereoFFTScope_skel : virtual public StereoFFTScope_base, virtual public Arts::StereoEffect_skel {
public:
	StereoFFTScope_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class StereoFFTScope : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	StereoFFTScope_base *_cache;
	inline StereoFFTScope_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(StereoFFTScope_base *)_pool->base->_cast(StereoFFTScope_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline StereoFFTScope(StereoFFTScope_base* b) : Object(b), _cache(0) {}


public:
	typedef StereoFFTScope_base _base_class;

	inline StereoFFTScope() : Arts::Object(_Creator), _cache(0) {}
	inline StereoFFTScope(const Arts::SubClass& s) :
		Arts::Object(StereoFFTScope_base::_create(s.string())), _cache(0) {}
	inline StereoFFTScope(const Arts::Reference &r) :
		Arts::Object(r.isString()?(StereoFFTScope_base::_fromString(r.string())):(StereoFFTScope_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline StereoFFTScope(const Arts::DynamicCast& c) : Arts::Object(StereoFFTScope_base::_fromString(c.object().toString())), _cache(0) {}
	inline StereoFFTScope(const StereoFFTScope& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline StereoFFTScope(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static StereoFFTScope null() {return StereoFFTScope((StereoFFTScope_base*)0);}
	inline static StereoFFTScope _from_base(StereoFFTScope_base* b) {return StereoFFTScope(b);}
	inline StereoFFTScope& operator=(const StereoFFTScope& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::StereoEffect() const { return Arts::StereoEffect(*_pool); }
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline StereoFFTScope_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline std::vector<float> * scope();
};

class StereoEffectStack_base : virtual public Arts::StereoEffect_base {
public:
	static unsigned long _IID; // interface ID

	static StereoEffectStack_base *_create(const std::string& subClass = "Arts::StereoEffectStack");
	static StereoEffectStack_base *_fromString(std::string objectref);
	static StereoEffectStack_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline StereoEffectStack_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual long insertTop(Arts::StereoEffect effect, const std::string& name) = 0;
	virtual long insertBottom(Arts::StereoEffect effect, const std::string& name) = 0;
	virtual void remove(long ID) = 0;
};

class StereoEffectStack_stub : virtual public StereoEffectStack_base, virtual public Arts::StereoEffect_stub {
protected:
	StereoEffectStack_stub();

public:
	StereoEffectStack_stub(Arts::Connection *connection, long objectID);

	long insertTop(Arts::StereoEffect effect, const std::string& name);
	long insertBottom(Arts::StereoEffect effect, const std::string& name);
	void remove(long ID);
};

class StereoEffectStack_skel : virtual public StereoEffectStack_base, virtual public Arts::StereoEffect_skel {
public:
	StereoEffectStack_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class StereoEffectStack : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	StereoEffectStack_base *_cache;
	inline StereoEffectStack_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(StereoEffectStack_base *)_pool->base->_cast(StereoEffectStack_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline StereoEffectStack(StereoEffectStack_base* b) : Object(b), _cache(0) {}


public:
	typedef StereoEffectStack_base _base_class;

	inline StereoEffectStack() : Arts::Object(_Creator), _cache(0) {}
	inline StereoEffectStack(const Arts::SubClass& s) :
		Arts::Object(StereoEffectStack_base::_create(s.string())), _cache(0) {}
	inline StereoEffectStack(const Arts::Reference &r) :
		Arts::Object(r.isString()?(StereoEffectStack_base::_fromString(r.string())):(StereoEffectStack_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline StereoEffectStack(const Arts::DynamicCast& c) : Arts::Object(StereoEffectStack_base::_fromString(c.object().toString())), _cache(0) {}
	inline StereoEffectStack(const StereoEffectStack& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline StereoEffectStack(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static StereoEffectStack null() {return StereoEffectStack((StereoEffectStack_base*)0);}
	inline static StereoEffectStack _from_base(StereoEffectStack_base* b) {return StereoEffectStack(b);}
	inline StereoEffectStack& operator=(const StereoEffectStack& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::StereoEffect() const { return Arts::StereoEffect(*_pool); }
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline StereoEffectStack_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline long insertTop(Arts::StereoEffect effect, const std::string& name);
	inline long insertBottom(Arts::StereoEffect effect, const std::string& name);
	inline void remove(long ID);
};

// Forward wrapper calls to _base classes:

inline Arts::AutoSuspendState Arts::SynthModule::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::SynthModule::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::SynthModule::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::SynthModule::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::SynthModule::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::SynthModule::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_PLAY::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_PLAY::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_PLAY::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_PLAY::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_PLAY::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_PLAY::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_FREQUENCY::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_FREQUENCY::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_FREQUENCY::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_FREQUENCY::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_FREQUENCY::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_FREQUENCY::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_WAVE_SIN::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_WAVE_SIN::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_WAVE_SIN::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_WAVE_SIN::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_WAVE_SIN::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_WAVE_SIN::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_MULTI_ADD::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_MULTI_ADD::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_MULTI_ADD::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_MULTI_ADD::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_MULTI_ADD::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_MULTI_ADD::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_ADD::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_ADD::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_ADD::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_ADD::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_ADD::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_ADD::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_MUL::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_MUL::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_MUL::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_MUL::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_MUL::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_MUL::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_PLAY_WAV::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_PLAY_WAV::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_PLAY_WAV::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_PLAY_WAV::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_PLAY_WAV::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_PLAY_WAV::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::Synth_PLAY_WAV::speed()
{
	return _cache?static_cast<Arts::Synth_PLAY_WAV_base*>(_cache)->speed():static_cast<Arts::Synth_PLAY_WAV_base*>(_method_call())->speed();
}

inline void Arts::Synth_PLAY_WAV::speed(float _newValue)
{
	 _cache?static_cast<Arts::Synth_PLAY_WAV_base*>(_cache)->speed(_newValue):static_cast<Arts::Synth_PLAY_WAV_base*>(_method_call())->speed(_newValue);
}

inline std::string Arts::Synth_PLAY_WAV::filename()
{
	return _cache?static_cast<Arts::Synth_PLAY_WAV_base*>(_cache)->filename():static_cast<Arts::Synth_PLAY_WAV_base*>(_method_call())->filename();
}

inline void Arts::Synth_PLAY_WAV::filename(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Synth_PLAY_WAV_base*>(_cache)->filename(_newValue):static_cast<Arts::Synth_PLAY_WAV_base*>(_method_call())->filename(_newValue);
}

inline bool Arts::Synth_PLAY_WAV::finished()
{
	return _cache?static_cast<Arts::Synth_PLAY_WAV_base*>(_cache)->finished():static_cast<Arts::Synth_PLAY_WAV_base*>(_method_call())->finished();
}

inline Arts::AutoSuspendState Arts::ByteStreamToAudio::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::ByteStreamToAudio::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::ByteStreamToAudio::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::ByteStreamToAudio::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::ByteStreamToAudio::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::ByteStreamToAudio::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline long Arts::ByteStreamToAudio::samplingRate()
{
	return _cache?static_cast<Arts::ByteStreamToAudio_base*>(_cache)->samplingRate():static_cast<Arts::ByteStreamToAudio_base*>(_method_call())->samplingRate();
}

inline void Arts::ByteStreamToAudio::samplingRate(long _newValue)
{
	 _cache?static_cast<Arts::ByteStreamToAudio_base*>(_cache)->samplingRate(_newValue):static_cast<Arts::ByteStreamToAudio_base*>(_method_call())->samplingRate(_newValue);
}

inline long Arts::ByteStreamToAudio::channels()
{
	return _cache?static_cast<Arts::ByteStreamToAudio_base*>(_cache)->channels():static_cast<Arts::ByteStreamToAudio_base*>(_method_call())->channels();
}

inline void Arts::ByteStreamToAudio::channels(long _newValue)
{
	 _cache?static_cast<Arts::ByteStreamToAudio_base*>(_cache)->channels(_newValue):static_cast<Arts::ByteStreamToAudio_base*>(_method_call())->channels(_newValue);
}

inline long Arts::ByteStreamToAudio::bits()
{
	return _cache?static_cast<Arts::ByteStreamToAudio_base*>(_cache)->bits():static_cast<Arts::ByteStreamToAudio_base*>(_method_call())->bits();
}

inline void Arts::ByteStreamToAudio::bits(long _newValue)
{
	 _cache?static_cast<Arts::ByteStreamToAudio_base*>(_cache)->bits(_newValue):static_cast<Arts::ByteStreamToAudio_base*>(_method_call())->bits(_newValue);
}

inline bool Arts::ByteStreamToAudio::running()
{
	return _cache?static_cast<Arts::ByteStreamToAudio_base*>(_cache)->running():static_cast<Arts::ByteStreamToAudio_base*>(_method_call())->running();
}

inline Arts::AutoSuspendState Arts::StereoEffect::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::StereoEffect::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::StereoEffect::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::StereoEffect::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::StereoEffect::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::StereoEffect::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::StereoVolumeControl::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::StereoVolumeControl::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::StereoVolumeControl::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::StereoVolumeControl::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::StereoVolumeControl::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::StereoVolumeControl::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::StereoVolumeControl::scaleFactor()
{
	return _cache?static_cast<Arts::StereoVolumeControl_base*>(_cache)->scaleFactor():static_cast<Arts::StereoVolumeControl_base*>(_method_call())->scaleFactor();
}

inline void Arts::StereoVolumeControl::scaleFactor(float _newValue)
{
	 _cache?static_cast<Arts::StereoVolumeControl_base*>(_cache)->scaleFactor(_newValue):static_cast<Arts::StereoVolumeControl_base*>(_method_call())->scaleFactor(_newValue);
}

inline float Arts::StereoVolumeControl::currentVolumeLeft()
{
	return _cache?static_cast<Arts::StereoVolumeControl_base*>(_cache)->currentVolumeLeft():static_cast<Arts::StereoVolumeControl_base*>(_method_call())->currentVolumeLeft();
}

inline float Arts::StereoVolumeControl::currentVolumeRight()
{
	return _cache?static_cast<Arts::StereoVolumeControl_base*>(_cache)->currentVolumeRight():static_cast<Arts::StereoVolumeControl_base*>(_method_call())->currentVolumeRight();
}

inline Arts::AutoSuspendState Arts::StereoFFTScope::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::StereoFFTScope::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::StereoFFTScope::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::StereoFFTScope::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::StereoFFTScope::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::StereoFFTScope::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline std::vector<float> * Arts::StereoFFTScope::scope()
{
	return _cache?static_cast<Arts::StereoFFTScope_base*>(_cache)->scope():static_cast<Arts::StereoFFTScope_base*>(_method_call())->scope();
}

inline Arts::AutoSuspendState Arts::StereoEffectStack::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::StereoEffectStack::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::StereoEffectStack::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::StereoEffectStack::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::StereoEffectStack::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::StereoEffectStack::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline long Arts::StereoEffectStack::insertTop(Arts::StereoEffect effect, const std::string& name)
{
	return _cache?static_cast<Arts::StereoEffectStack_base*>(_cache)->insertTop(effect, name):static_cast<Arts::StereoEffectStack_base*>(_method_call())->insertTop(effect, name);
}

inline long Arts::StereoEffectStack::insertBottom(Arts::StereoEffect effect, const std::string& name)
{
	return _cache?static_cast<Arts::StereoEffectStack_base*>(_cache)->insertBottom(effect, name):static_cast<Arts::StereoEffectStack_base*>(_method_call())->insertBottom(effect, name);
}

inline void Arts::StereoEffectStack::remove(long ID)
{
	 _cache?static_cast<Arts::StereoEffectStack_base*>(_cache)->remove(ID):static_cast<Arts::StereoEffectStack_base*>(_method_call())->remove(ID);
}

};
#endif /* ARTSFLOW_H */
