# z8530drv.conf - initialization for the Z8530 SCC driver v 2.4
#
# Lines must not be longer than 255 bytes!
#
#
# Hardware section
#
# SCC chip 1
#
chip	1
data_a  0x300			# data port A
ctrl_a  0x304			# control port A
data_b  0x301			# data port B
ctrl_b  0x305			# control port B
irq     5			# IRQ No. 5 (#)
pclock  4915200			# clock (+)
board   BAYCOM                  # hardware type (*)
escc    no			# enhanced SCC chip? (8580/85180/85280) (*)
vector  no			# latch for interrupt vector ($)
special no			# address of special function register (*)
option  0			# option to set via sfr (*)
#
# (*) option, default value is 0
# (+) option, default is 4915200
#
# SCC chip 2
#
chip	2
data_a  0x302
ctrl_a  0x306
data_b  0x303
ctrl_b  0x307
board   BAYCOM
#
# (#) all chips can share one interrupt, or you may use multiple INTs,
#     but there must be at least one IRQ defined in this system.
# ($) only one Vector Latch for all Chips is allowed.
#
#
# Software section
#
# The order of entries IS important!
#
# 	first     : DEVICE
# 	then      : MODEM section
# 	after that: Level 1 parameters
#
# Definition of /dev/scc0
#
device	/dev/scc0
#
# MODEM related stuff
#
speed	1200			# 1200 baud
clock	dpll			# clock source: use the dpll
mode	nrzi			# normal NRZI operation
#
# Level 1 parameters
#
txdelay 36			# You should know about these already!
persist 64
slot	8
tail	8
fulldup	0
wait    12
min	3
maxkey	7
idle	3
maxdef  120
group   0
txoff   off
softdcd on			# use software dcd
#
#
# Definition of /dev/scc1
#
#
device	/dev/scc1
#
speed	1200
clock	dpll
mode	nrzi
#
txdelay 36
persist 64
slot	8
tail	8
fulldup	0
wait    12
min	3
maxkey	7
idle	3
maxdef  120
group   0
txoff   off
softdcd off
#
#
# Definiton of /dev/scc2
#
#
device	/dev/scc2
#
speed	4800
clock	divider
mode	nrzi
#
txdelay 20
persist 64
slot	8
tail	8
fulldup	0
wait    12
min	3
maxkey	7
idle	3
maxdef  120
group   0
txoff   off
softdcd off
#
#
# Definition of /dev/scc3
#
#
device	/dev/scc3
speed	9600
clock	ext
mode	nrz
#
txdelay 8
persist 64
slot	8
tail	8
fulldup	0
wait    2
min	3
maxkey	7
idle	3
maxdef  120
group   0
txoff   off
softdcd off
#
# End of File
#
