#include "ksprefs.h"

#include <qlayout.h>
#include <kapp.h>
#include <klocale.h>

KSPrefs::KSPrefs(QWidget * parent, const char * name)
  : QTabDialog(parent, name)
{
  setCaption(i18n("kSirc Prefrences"));

//  pTab = new("QTabDialog") QTabDialog(0x0, "prefstabs");
//  pTab->show();

  // Start Sub Dialog items.
  pGeneral = new("general") general(this);
  pStart = new("StartUp") StartUp(this);
  pServerChannel = new("ServerChannel") ServerChannel(this);
  pMenu = new("UserMenuRef") UserMenuRef(this);
  pFilters = new("DefaultFilters") DefaultFilters(this);

  this->setCancelButton(i18n("Cancel"));
  this->setOkButton(i18n("OK"));
  this->addTab(pGeneral, i18n("&General"));
  this->addTab(pStart, i18n("&StartUp"));
  this->addTab(pServerChannel, i18n("Servers/&Channels"));
  this->addTab(pMenu, i18n("&User Menu"));
  this->addTab(pFilters, i18n("&Default Filters"));

  connect(this, SIGNAL(applyButtonPressed()),
          pGeneral, SLOT(slot_apply()));
  connect(this, SIGNAL(applyButtonPressed()),
	  pStart, SLOT(slot_apply()));
  connect(this, SIGNAL(applyButtonPressed()),
	  pServerChannel, SLOT(slot_apply()));
  connect(this, SIGNAL(applyButtonPressed()),
	  pFilters, SLOT(slot_apply()));


  // Connect this one last since it deletes the widget.
  connect(this, SIGNAL(applyButtonPressed()),
	  this, SLOT(slot_apply()));
  connect(this, SIGNAL(cancelButtonPressed()),
	  this, SLOT(slot_cancel()));
  connect(this, SIGNAL(defaultButtonPressed()),
	  this, SLOT(slot_cancel()));

}

KSPrefs::~KSPrefs(){
//  delete pTab;
//  pTab = 0;
}

void KSPrefs::resizeEvent ( QResizeEvent * )
{
//  pTab->setGeometry(0, 0, width(), height());
//  pGeneral->resize(pTab->width(),pTab->height());
}

void KSPrefs::slot_apply()
{
  emit update();
  delete this;
}

void KSPrefs::slot_cancel()
{
  emit update();
  delete this;
}

void KSPrefs::hide()
{
  delete this;
}


