/*
* unixdrop.h -- Declaration of class KUnixDrop.
* Generated by newclass on Sun Nov 30 23:28:07 EST 1997.
*/
#ifndef SSK_UNIXDROP_H
#define SSK_UNIXDROP_H

class QDateTime;
class QFileInfo;
class QWidget;
class KDropDialog;

#include<qstring.h>

#include"polldrop.h"

/**
 * Implements Maildrop monitor for UNIX mailboxes.
 * @short Maildrop monitor for UNIX mailboxes.
 * @author Sirtaj Singh Kang (taj@kde.org)
 * @version $Id: unixdrop.h,v 1.1 1999/07/22 18:17:11 tibirna Exp $
 */
class KUnixDrop : public KPollableDrop
{
private:
	bool touched();
	bool locked();
	int doCount();

	QDateTime	*_lastMod;
	QFileInfo	*_info;
	QFileInfo	*_lockInfo;
	unsigned	_lastSize;

	QString		_file;
	bool		_valid;
	char		*_buffer;

	char *lineBuffer();

public:
	static const char *FileConfigKey;

public:
	/**
	* KUnixDrop Constructor
	*/
	KUnixDrop();

	virtual ~KUnixDrop();

	virtual void recheck();

	virtual bool valid();

	const char *file() const { return _file; }
	void setFile( const char *file );

	virtual const char *type() const { return "mbox"; }

	virtual KMailDrop *clone() const;

	virtual bool readConfigGroup ( const KConfigBase& cfg );
	virtual bool writeConfigGroup ( KConfigBase& cfg ) const;

	virtual void addConfigPage( KDropCfgDialog * );

private:
	KUnixDrop& operator=( const KUnixDrop& other );

};


#endif // SSK_UNIXDROP_H
