
#include<assert.h>
#include<ctype.h>

#include<qstring.h>

#include<kconfig.h>
#include<kapp.h>

#include"kornset.h"

KornSettings::KornSettings( KConfigBase *config )
	: _config( config ), 
	_layout( Horizontal ),
	_posSet( false ),
	_valid ( true )
{
//	_noMouse	= checkNoMouse();
}


bool KornSettings::readConfig()
{
	_config->setGroup("Korn");

// saved layout

	if ( _config->hasKey( "layout" ) ){
		QString layoutStr = _config->readEntry( "layout" );

		layoutStr = layoutStr.stripWhiteSpace();

		char style = toupper(layoutStr.data()[0]);

		if( style == 'V' ) {
			_layout = Vertical;
		}
		else if ( style == 'D' ) {
			_layout = Dock;
		}
		else {
			_layout = Horizontal;
		}
	}
	else {
		_layout = Dock;
	}

// Saved geometry

	_remember = _config->readNumEntry("rememberPos", 0);

	if( _remember && _config->hasKey("posX") ) {
		_geom.setX( _config->readNumEntry("posX") );
		_geom.setY( _config->readNumEntry("posY") );
		_posSet = TRUE;

	} else {
		_posY = _posX = 0;
	}

	return true;
}

bool KornSettings::writeConfig() const
{
	const char *str="";

	// save layout
	switch ( layout() ) {
		case Horizontal:
			str = "Horizontal";
			break;
		case Vertical:
			str = "Vertical";
			break;
		case Dock:
			str = "Docked";
			break;
	}
	_config->writeEntry( "layout", str );

	return true;
}
