#include "EditUpload.moc"
#include "ftpaccess.h"
#include <qwidget.h>
#include <qlabel.h>
#include <klocale.h>
#include <kapp.h>
#include <qtooltip.h>
#include <pwd.h>
#include <grp.h>

EditUpload::EditUpload(ftpupload *u, QWidget * parent, char * wname): QWidget(parent, wname)
{
	int y=5;
	if(u==0)
		upl=new ftpupload;
	else
		upl=u;
	resize(480,390); setFixedSize(480,390);
	this->setCaption(i18n("Edit upload"));
	rootDir=new InputFileCtl(i18n("For users with root d&irectory:"),upl->getRootDir(),true,0,this);
	rootDir->setGeometry(5,y,width()-10,rootDir->height());
	y+=rootDir->height();
	dir=new InputFileCtl(i18n("&Directory (may be globbed):"),upl->getDirGlob(),true,i18n("Se&lect"),this);
	dir->setGeometry(5,y,width()-10,dir->height());
	y+=dir->height()+5;
        mayUpload=new QCheckBox(i18n("&Permit uploads; permissions:"),this);
	mayUpload->setGeometry(5,y,mayUpload->sizeHint().width(),mayUpload->height());
	mayUpload->setChecked(upl->getAllow());
	permissions=new Permissions(upl->getMode(),this);
        permissions->setGeometry(mayUpload->x()+mayUpload->width()+5,y,width()-mayUpload->x()-mayUpload->width()-10,permissions->sizeHint().height());
        y+=permissions->height()+5;
	chown=new QCheckBox(i18n("&Change owner of uploaded files:"),this);
	chown->setGeometry(5,y,chown->sizeHint().width(),chown->height());
	if(upl->getOwner()!=QString::null)
		chown->setChecked(true);
        connect(chown,SIGNAL(clicked()),SLOT(chownPressed()));
        chownTo=new QListBox(this);
        chownTo->setGeometry(10+chown->width(),y,width()-15-chown->width(),mayUpload->height()*2);
        connect(chownTo,SIGNAL(highlighted(const QString&)),SLOT(chownToPressed(const char *)));
	y+=chownTo->height();
        {
            passwd *p;
            while((p=getpwent())!=0)
                  chownTo->insertItem(p->pw_name);
            endpwent();
        }
	if(upl->getOwner()!=QString::null) {
		QString o=upl->getOwner();
		for(unsigned int i=0;i<chownTo->count();i++)
			if(strcasecmp(o,chownTo->text(i))==0)
				chownTo->setSelected(i,true);
	}
        chgrp=new QCheckBox(i18n("C&hange group of uploaded files:"),this);
        chgrp->setGeometry(5,y,chgrp->sizeHint().width(),chgrp->height());
	if(upl->getGroup()!=QString::null)
		chgrp->setChecked(true);
        connect(chgrp,SIGNAL(clicked()),SLOT(chgrpPressed()));
	chgrpTo=new QListBox(this);
        chgrpTo->setGeometry(10+chgrp->width(),y,width()-15-chgrp->width(),mayUpload->height()*2);
        connect(chgrpTo,SIGNAL(highlighted(const QString&)),SLOT(chgrpToPressed(const char *)));
	y+=chgrpTo->height()+5;
        {
            group *g;
            while((g=getgrent())!=0)
                chgrpTo->insertItem(g->gr_name);
            endgrent();
        }
	if(upl->getGroup()!=QString::null) {
		QString g=upl->getGroup();
		for(unsigned int i=0;i<chgrpTo->count();i++)
			if(strcasecmp(g.ascii(),chgrpTo->text(i))==0)
				chownTo->setSelected(i,true);
	}
        permitDirs=new QCheckBox(i18n("Permit creating new d&irectories"),this);
        permitDirs->setGeometry(5,y,permitDirs->sizeHint().width(),permitDirs->height());
	permitDirs->setChecked(upl->getPermitDirs());
        y+=permitDirs->height();
        ok=new QPushButton(i18n("&OK"),this);
        ok->setGeometry(5,y,width()/2-10,ok->height());
        connect(ok,SIGNAL(clicked()),SLOT(okButtonPressed()));
        cancel=new QPushButton(i18n("&Cancel"),this);
        cancel->setGeometry(width()/2+5,y,width()/2-10,cancel->height());
        connect(cancel,SIGNAL(clicked()),SLOT(cancelButtonPressed()));
        show();
}
EditUpload::~EditUpload()
{
}
char const * getqlbtxt(QListBox const * const l)
{
	for(unsigned int i=0; i<l->count(); i++)
		if(l->isSelected(i))
			return l->text(i);
	return 0;
}
void EditUpload::okButtonPressed()
{
    upl->setRootDir(rootDir->text());
    upl->setDirGlob(dir->text());
    upl->setAllow(mayUpload->isChecked());
    if(strlen(getqlbtxt(chownTo))>0)
        upl->setOwner(getqlbtxt(chownTo));
    else
        upl->setOwner(0);
    if(strlen(getqlbtxt(chgrpTo))>0)
        upl->setGroup(getqlbtxt(chgrpTo));
    else
        upl->setGroup(0);
    upl->setMode(permissions->value());
    upl->setPermitDirs(permitDirs->isChecked());
//    upl->setDMode(permissionsDir->value());
    emit EditUploadDone(upl);
    delete this;
}
void EditUpload::cancelButtonPressed()
{
	delete this;
}
void EditUpload::chownPressed()
{
    chownTo->setEnabled(chown->isChecked());
    if(!chown->isEnabled())
        for(unsigned int i=0;i<chownTo->count();i++)
            chownTo->setSelected(i,false);
}
void EditUpload::chownToPressed(const char *)
{
    chown->setChecked(true);
}
void EditUpload::chgrpPressed()
{
    chgrpTo->setEnabled(chgrp->isChecked());
    if(!chgrp->isEnabled())
        for(unsigned int i=0;i<chgrpTo->count();i++)
            chgrpTo->setSelected(i,false);
}
void EditUpload::chgrpToPressed(const char *)
{
    chgrp->setChecked(true);
}
