#include <qpopupmenu.h>
#include <qheader.h>
#include <qdragobject.h>
#include <kglobalsettings.h>
#include <kcmenumngr.h>
#include <kcursor.h>
#include <kapp.h>

#include "kdltooltip.h"
#include "kndraglist.h"


K2ListViewItem::K2ListViewItem (bool drag, bool drop, QPopupMenu* menu)
  : mContextMenu (menu),
	mDragEnabled (drag),
	mDropEnabled (drop),
	mMenuIndex (0)
{
  
}

void K2ListViewItem::showContextMenu (const QPoint& pos) const
{
  if (mContextMenu)
    mContextMenu->exec (pos, mMenuIndex);
}
  
void K2ListViewItem::setDragEnabled (bool allow)
{
  mDragEnabled = allow;
}

void K2ListViewItem::setDropEnabled (bool allow)
{
  mDropEnabled = allow;
}

void K2ListViewItem::setPopupMenuAtIndex (int index)
{
  mMenuIndex = (index > 0) ? index : 0;
}

// K2ListView

K2ListView::K2ListView (QWidget* parent, const char* name)
  : KListView (parent, name),
	mContextMenu (0L),
	mDisplayToolTips (false),
	mMarkerWidth (4),
	mMenuIndex (0),
	mDNDDelay (KGlobalSettings::dndEventDelay()),
	mDisplayMenuOnPress (KContextMenuManager::showOnButtonPress())
{
  setDropVisualizer (true);
  setDragEnabled (true);
  
//   // catch changed settings
//   connect (kapp, SIGNAL (settingsChanged (int)), this, SLOT (settingsChanged (int)));

//   connect (this, SIGNAL(rightButtonPressed(QListViewItem*, const QPoint&, int)),
// 		   this, SLOT(showItemContextMenu(QListViewItem*, const QPoint&, int)));

//   connect (this, SIGNAL(rightButtonPressed(QListViewItem*, const QPoint&, int)),
// 		   this, SLOT(showContextMenu(QListViewItem*, const QPoint&, int)));

//   connect (this, SIGNAL(contentsMoving(int,int)),
// 		   this, SLOT(clearInsertMarker()));

  setDragAutoScroll(true);

  setAcceptDrops(true);
  viewport()->setAcceptDrops (true);

  // enable tooltips
  new KDLToolTip (this);
}

K2ListView::~K2ListView() 
{
  // nothing yet
}

// void K2ListView::contentsDragEnterEvent (QDragEnterEvent* e)
// {
//   if (isEnabled() && acceptDrag(e))
// 	{
// 	  e->accept();

// 	  mDragging = true;
// 	}
//   else
// 	e->ignore();
// }


// void K2ListView::contentsMouseMoveEvent (QMouseEvent* e)
// {
//   if (!isActiveWindow())
//  	return;

//   KListView::contentsMouseMoveEvent (e);
//   // COPIED_VERBATIM_FROM_KListView
// //   QPoint vp = contentsToViewport(e->pos());
// //   QListViewItem *item = itemAt( vp );
 
// //   //do we process cursor changes at all?
// //   if ( item && m_bChangeCursorOverItem && m_bUseSingle )
// // 	{
// // 	  //Cursor moved on a new item or in/out the execute area
// // 	  if( (item != m_pCurrentItem) ||
// // 		  (isExecuteArea(vp) != m_cursorInExecuteArea) ) {
 
// // 		m_cursorInExecuteArea = isExecuteArea(vp);
 
// // 		if( m_cursorInExecuteArea ) //cursor moved in execute area
// // 		  viewport()->setCursor( KCursor().handCursor() );
// // 		else //cursor moved out of execute area
// // 		  viewport()->setCursor( oldCursor );
// // 	  }
// // 	}
// //   QListView::contentsMouseMoveEvent (e);
//   // END COPIED_VERBATIM_FROM_KListView

//   // Only interested in LMB
//   if (!(e->state() & LeftButton)) return;
    
//   // Check whether the user has moved far enough.
//   const int x = e->x(); const int y = e->y();  

//   QListViewItem* i = where (e->pos());

//   if (i &&
// 	  (x > mOldPos.x()+mDNDDelay || x < mOldPos.x()-mDNDDelay ||
// 	   y > mOldPos.y()+mDNDDelay || y < mOldPos.y()-mDNDDelay))
// 	{
// 	  startDrag (i);
// 	  mOldPos = QPoint();
// 	}
// }

// void K2ListView::contentsMousePressEvent (QMouseEvent* e)
// {
//   if (e->state() && LeftButton)
// 	mOldPos = e->pos();

//   KListView::contentsMousePressEvent (e);
// }

// void K2ListView::contentsMouseReleaseEvent (QMouseEvent* e)
// {
//   if (e->state() && LeftButton)
// 	mOldPos = QPoint();

//   KListView::contentsMouseReleaseEvent (e);
// }

// void K2ListView::contentsDragLeaveEvent (QDragLeaveEvent*)
// {
//   clearInsertMarker();
//   mDragging = false;
// }

// void K2ListView::contentsDragMoveEvent (QDragMoveEvent* e)
// {
//   if (acceptDrag(e))
// 	{
// 	  e->accept();
	  
// 	  QListViewItem* i = itemAt (contentsToViewport(e->pos()));
	  
// 	  if (i)
// 		{
// 		  paintInsertMarker(i, e->pos());
// 		}
// 	  else if (firstChild())
// 		{
// 		  QListViewItem* last = 0L;

// 		  for (QListViewItemIterator it (this);
// 			   it.current();
// 			   ++it)
// 			{
// 			  last = it.current();
// 			}

// 		  paintInsertMarker (last, itemRect(last).bottomLeft());
// 		}
// 	  else
// 		{
// 		  paintInsertMarker (0L, QPoint (0, 0));
// 		}
// 	}
//   else
// 	e->ignore();
// }

// void K2ListView::contentsDropEvent (QDropEvent* e)
// {
//   mDragging = false;

//   clearInsertMarker();

//   if (acceptDrag (e))
// 	{
// 	  emit dropped (e);
// 	}
// }

bool K2ListView::acceptDrag (QDropEvent*) const
{
  return acceptDrops() && true;
}

// void K2ListView::showItemContextMenu (QListViewItem* item, const QPoint& pos, int)
// {
//   K2ListViewItem* i = dynamic_cast<K2ListViewItem*> (item);

//   if (i)
//     i->showContextMenu(pos);
// }

// void K2ListView::showContextMenu (QListViewItem* item, const QPoint& pos, int)
// {
//   if (!item && mContextMenu)
// 	mContextMenu->exec (pos, mMenuIndex);
// }

QListViewItem* K2ListView::where (const QPoint& pos)
{
  QListViewItem* result = itemAt (contentsToViewport(pos));
  
  if (result)
	{
      if (!(pos.x() > header()->cellPos( header()->mapToActual( 0 ) ) +
			treeStepSize() * (result->depth() + ( rootIsDecorated() ? 1 : 0) ) + itemMargin() ||
			pos.x() < header()->cellPos (header()->mapToActual (0))))
		{
		  result = 0L;
		}
	}
  
  return result;
}

QDragObject* K2ListView::dragObject ()
{
  return 0L;
}

void K2ListView::startDrag ()
{
  QDragObject* d = dragObject();

  if (d)
	{
	  d->drag();
	}
}

void K2ListView::clearInsertMarker ()
{
  if (mOldInsertMarker.isValid())
	{
	  viewport()->repaint(mOldInsertMarker);
	  mOldInsertMarker = QRect();
	}
}

// K2ListView::drawDropVisualizer (QPainter* p,
// 									 QListViewItem* parent, QListViewItem* after)
// {
// //   QRect insertmarker;

// //   if (i)
// // 	{
// // 	  insertmarker = itemRect (i);
// // 	  const bool insertBelow = below (insertmarker,  contentsToViewport(pos));

// // 	  if (insertBelow)
// // 		{
// // 		  insertmarker.setLeft (0);
// // 		  insertmarker.setRight (viewport()->width());
// // 		  insertmarker.setTop (insertmarker.bottom() - mMarkerWidth/2 + 1);
// // 		  insertmarker.setBottom (insertmarker.bottom() + mMarkerWidth/2);
// // 		}
// // 	  else
// // 		{
// // 		  insertmarker.setLeft (0);
// // 		  insertmarker.setRight (viewport()->width());
// // 		  insertmarker.setBottom (insertmarker.top() + mMarkerWidth/2 - 1);
// // 		  insertmarker.setTop (insertmarker.top() - mMarkerWidth/2);
// // 		}
// // 	}
// //   else
// // 	{
// // 	  insertmarker = QRect (0, 0, viewport()->width(), mMarkerWidth/2);
// // 	}

// //   if (mOldInsertMarker.isValid() && mOldInsertMarker != insertmarker)
// // 	viewport()->repaint(mOldInsertMarker, true);
  
// //   QPainter p;
// //   p.begin(viewport());
// //   p.fillRect(insertmarker, Dense4Pattern);
// //   p.end();
  
// //   mOldInsertMarker = insertmarker;
//   return KListView::drawDropVisualizer (p, parent, after);
// }

// void K2ListView::setPopupMenuAtIndex (int index)
// {
//   mMenuIndex = (index > 0) ? index : 0;
// }

void K2ListView::settingsChanged (int category)
{
  mDNDDelay = KGlobalSettings::dndEventDelay();
  mDisplayMenuOnPress = KContextMenuManager::showOnButtonPress();
}
