#pragma implementation

/*

    Requires the Qt widget libraries, available at no cost at
    http://www.troll.no

    Copyright (C) 1997-2000 Peter Putzer
                            putzer@kde.org

	$Id: TopWidget.cpp,v 1.52 2000/06/07 21:35:33 putzer Exp $

    This program is free software; you can redistribute it and/or modify
    it under the terms of version 2 of the GNU General Public License
    as published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/****************************************************************
**
** KSysV
** Toplevel Widget
**
****************************************************************/

#include <qpopmenu.h>
#include <qkeycode.h>
#include <qmsgbox.h>
#include <qfontmetrics.h>
#include <qpainter.h>
#include <qmultilinedit.h>
#include <qdatetime.h>
#include <qprinter.h>
#include <qbuttongroup.h>
#include <qclipboard.h>
#include <qprintdialog.h>
#include <qcheckbox.h>
#include <qhbox.h>
#include <qregexp.h>
#include <qdatastream.h>
#include <qpixmapcache.h>
#include <qtextview.h>
#include <qfileinfo.h>
#include <qtextstream.h>
#include <qprogressdialog.h>

#include <ktoolbar.h>
#include <kkeydialog.h>
#include <kmenubar.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kdebug.h>
#include <kapp.h>
#include <kglobal.h>
#include <khelpmenu.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kstdaccel.h>
#include <kedittoolbar.h>
#include <kiconloader.h>
#include <kfiledialog.h>

#include "ServiceDlg.h"
#include "PreferencesDialog.h"
#include "ActionList.h"
#include "ksv_core.h"
#include "ksv_conf.h"
#include "About.h"
#include "RunlevelAuthIcon.h"
#include "ksvdraglist.h"
#include "Constants.h"
#include "ConfigWizard.h"
#include "OldView.h"
#include "TopWidget.h"


struct Status
{
  enum {
    Changed, Progress, Checklist, Writable
  };
};

KSVTopLevel::KSVTopLevel()
  : KTMainWindow(),
    mConfig(KSVConfig::self()),
	mView (0L),
    mPreferences(0L),
	mEditUndo (0L), mEditCut (0L), mEditCopy (0L), mEditPaste (0L),
	mFileNew (0L), mFilePrintLog (0L), mFileSave (0L), mFileQuit (0L),
	mToolsStartService (0L), mToolsStopService (0L), mToolsRestartService (0L), mToolsEditService (0L),
	mOptionsTools (0L), mOptionsStatus (0L), mOptionsToggleLog (0L),
    mUndoList (new ActionList (this, "UndoList")),
	mRedoList (new ActionList (this, "RedoList")),
	mStartDlg (new ServiceDlg (i18n("Start Service"),
							   i18n("&Choose which service to start:"),
							   this)),
	mStopDlg (new ServiceDlg (i18n("Stop Service"),
							  i18n("&Choose which service to stop:"),
							  this)),
	mRestartDlg (new ServiceDlg (i18n("Restart Service"),
								 i18n("&Choose which service to restart:"),
								 this)),
	mEditDlg (new ServiceDlg (i18n("Edit Service"),
							  i18n("&Choose which service to edit:"),
							  this)),
	mAdvanced (0),
	mProgress (new QProgressDialog ("", QString::null, // is set later
									10, this, 0L, true))
{
  kapp->setMainWidget (this);

  setCaption(false);
  
  initActions(); // order dependency
  mView = new KSVContent (this, "Content"); // order dependency
  initTools(); // order dependency
  initStatusBar(); // order dependency

  setView(mView, false);

  // ensure that the statusbar gets updated correctly
  connect (mView, SIGNAL(sigRun(const QString&)), this, SLOT(slotUpdateRunning(const QString&)));
  connect (mView, SIGNAL(sigStop()), statusBar(), SLOT(clear()));
  connect (mView, SIGNAL(cannotGenerateNumber()), this, SLOT(catchCannotGenerateNumber()));
  connect (mView, SIGNAL(sigChanged()), this, SLOT(slotChanged()));
  connect (mView, SIGNAL(undoAction(KSVAction*)), mUndoList, SLOT(push(KSVAction*)));
  connect (mView, SIGNAL(logChanged()), this, SLOT(enableLogActions()));

  // cut & copy
  connect (mView, SIGNAL(selected(KSVItem*)),
		   this, SLOT(dispatchCutCopy(KSVItem*)));

  connect (mView, SIGNAL(selectedScripts(KSVItem*)),
		   this, SLOT(dispatchCopyScripts(KSVItem*)));

  dispatchCutCopy(0L); // disable cut & copy on startup

  // undo
  connect (mUndoList, SIGNAL(empty()), this, SLOT(disableUndo()));
  connect (mUndoList, SIGNAL(filled()), this, SLOT(enableUndo()));

  // and redo
  connect (mRedoList, SIGNAL(empty()), this, SLOT(disableRedo()));
  connect (mRedoList, SIGNAL(filled()), this, SLOT(enableRedo()));
  
  setUndo (false); // nothing to undo yet
  setRedo (false); // nor to redo, either

  // paste
  connect (kapp->clipboard(), SIGNAL (dataChanged()),
		   this, SLOT (dispatchPaste()));
  dispatchPaste(); // disable paste on startup

  // init mView according to saved preferences
  slotReadConfig();
  initView();

  setMinimumSize(600,400);

  // restore size and position
  move(mConfig->position()); // doesnt seem to work while unmapped
  resize(mConfig->size());

  // restore toolbar position
  //  tools_->setBarPos(conf->getToolPosition());
  //  menu_->setMenuBarPos(conf->getMenuPosition());

  // set enabled or disabled, depending on AuthIcon
  mView->multiplexEnabled (mAuth->status());

  // progress dialog
  mProgress->setAutoReset (true);
  mProgress->setAutoClose (true);
  mProgress->setCaption (kapp->makeStdCaption (i18n("Clearing Configuration")));

  // make progress bar update itself
  connect (mView, SIGNAL(initProgress(int, const QString&)),
		   this, SLOT(initProgress(int, const QString&)));
  connect (mView, SIGNAL (advance(int)), this, SLOT (fwdAdvance(int)));
  connect (this, SIGNAL (progress (int)), mProgress, SLOT (setProgress (int)));
  connect (mView, SIGNAL(endProgress()), mProgress, SLOT (reset()));
}

KSVTopLevel::~KSVTopLevel()
{
  mUndoList->clear();
  mRedoList->clear();
}

void KSVTopLevel::initTools()
{
  connect (mStartDlg, SIGNAL(doAction(const QString&)),
		   mView, SLOT(startService(const QString&)));
  connect (mStopDlg, SIGNAL(doAction(const QString&)),
		   mView, SLOT(editService(const QString&)));
  connect (mRestartDlg, SIGNAL(doAction(const QString&)),
		   mView, SLOT(restartService(const QString&))); 
  connect (mEditDlg, SIGNAL(doAction(const QString&)),
		   mView, SLOT(editService(const QString&)));

  connect (mStartDlg, SIGNAL (display (bool)),
		   this, SLOT (dispatchStartService (bool)));
  connect (mStopDlg, SIGNAL (display (bool)),
		   this, SLOT (dispatchStopService (bool)));
  connect (mRestartDlg, SIGNAL (display (bool)),
		   this, SLOT (dispatchRestartService (bool)));
  connect (mEditDlg, SIGNAL (display (bool)),
		   this, SLOT (dispatchEditService (bool)));

}

void KSVTopLevel::initActions ()
{
  // setup File menu
  mFileNew = KStdAction::openNew(this, SLOT(slotClearChanges()), actionCollection());
  mFileNew->setText (i18n("&New Configuration..."));

  mFileSave = KStdAction::save(this, SLOT(slotAcceptChanges()), actionCollection());
  mFileSave->setText (i18n("&Save Configuration..."));

  mFileSaveLog = KStdAction::save (this, SLOT(slotSaveLog()), actionCollection(), "ksysv_save_log");
  //  mFileSaveLog = KStdAction::saveAs (this, SLOT(slotSaveLog()), actionCollection());
  mFileSaveLog->setText (i18n("Save &Log..."));
  mFileSaveLog->setAccel (Key_L+CTRL);
  //  mFileSaveLog = new KAction (i18n("Save &Log..."), QIconSet (BarIcon("filesave")), 0, this,
  //							  SLOT(slotSaveLog()), actionCollection(), "ksysv_save_log");

  //KStdAction::saveAs(this, SLOT(slotSaveLog()), actionCollection(), "my_save")->setText("Save &Log...");
//   //  KStdAction::close(this, SLOT(file_close()), actionCollection());
  mFilePrintLog = KStdAction::print(this, SLOT(printLog()), actionCollection(), "ksysv_print_log");
  mFilePrintLog->setText( i18n("&Print Log..."));
//   //  KStdAction::mail(this, SLOT(mail()), actionCollection());
//   //  (void)new KAction(i18n("Open &URL..."), 0, this, SLOT(file_open_url()),
// //   //				actionCollection(), "file_open_url");
// //   (void)new KAction(i18n("Save &To URL..."), 0, this, SLOT(file_save_url()),
// // 					actionCollection(), "save_to_url");
  mFileQuit = KStdAction::quit(this, SLOT(close()), actionCollection());
  
  // setup edit menu
  mEditUndo = KStdAction::undo(this, SLOT(editUndo()), actionCollection());
  mEditRedo = KStdAction::redo(this, SLOT(editRedo()), actionCollection());
  mEditCut = KStdAction::cut(this, SLOT(editCut()), actionCollection());
  mEditCopy = KStdAction::copy(this, SLOT(editCopy()), actionCollection());
  mEditPaste = KStdAction::paste(this, SLOT(editPaste()), actionCollection());
  mPasteAppend = KStdAction::paste (this, SLOT (pasteAppend()),
									actionCollection(), "ksysv_paste_append");

  //  KStdAction::selectAll(this, SLOT(select_all()), actionCollection());

//   new KAction (i18n("&Test"), 0, this, SLOT(print()), actionCollection(), "my_print");
//   // setup Tools menu
// //   KStdAction::spelling(this, SLOT(spellcheck()), actionCollection());
  
// //   // setup Go menu
// //   KStdAction::gotoLine(this, SLOT(gotoLine()), actionCollection());
  
  // setup Settings menu
  mOptionsTools = KStdAction::showToolbar(this, SLOT(toggleTools()), actionCollection());
  mOptionsStatus = KStdAction::showStatusbar(this, SLOT(toggleStatus()), actionCollection());
  KStdAction::keyBindings (this, SLOT(configureKeys()), actionCollection());
  KStdAction::configureToolbars (this, SLOT(configureToolbars()), actionCollection());
  KStdAction::saveOptions(this, SLOT(saveOptions()), actionCollection());
  KStdAction::preferences(this, SLOT(slotShowConfig()), actionCollection());
  mOptionsToggleLog = new KToggleAction (i18n("Show &Log"), "toggle_log", 0,
										 this, SLOT (toggleLog()),
										 actionCollection (), "ksysv_toggle_log");

  // edit menu
//   ToolsMenu_->insertItem(i18n("&Start Service..."), mStartDlg, SLOT(show()));
//   ToolsMenu_->insertItem(i18n("S&top Service..."), mStopDlg, SLOT(show()));
//   ToolsMenu_->insertItem(i18n("&Restart Service..."), remStartDlg, SLOT(show()));
//   ToolsMenu_->insertSeparator();
//   ToolsMenu_->insertItem(i18n("&Edit Service..."), mEditDlg, SLOT(show()));
  mToolsStartService = new KToggleAction (i18n("&Start Service..."), "ksysv_start", 0,
										 mStartDlg, SLOT (show()),
										 actionCollection(), "ksysv_start_service");
  mToolsStopService = new KToggleAction (i18n("&Stop Service..."), "ksysv_stop", 0,
										mStopDlg, SLOT (show()),
										actionCollection(), "ksysv_stop_service");

  mToolsRestartService = new KToggleAction (i18n("&Restart Service..."), 0,
										   mRestartDlg, SLOT (show()),
										   actionCollection(), "ksysv_restart_service");

  mToolsEditService = new KToggleAction (i18n("&Edit Service..."), 0,
										mEditDlg, SLOT (show()),
										actionCollection(), "ksysv_edit_service");

  createGUI(xmlFile());

  KAction* aboutKSysV = actionCollection()->action (KStdAction::stdName (KStdAction::AboutApp));
  if (aboutKSysV)
	{
	  disconnect (aboutKSysV, SIGNAL (activated()), 0, 0);
	  connect (aboutKSysV, SIGNAL (activated()), AboutDlg::self(), SLOT (show()));
	}
}

bool KSVTopLevel::queryExit() {
  uint res = KMessageBox::Yes;

  if (mChanged) {
    res = KMessageBox::warningYesNo(kapp->mainWidget(),
				    i18n("There are unsaved changes.\nAre you sure you want to quit?"),
				    i18n("Quit"),
				    i18n("&Quit"),
				    i18n("&Cancel"));

  }

  qApp->processEvents();
  return res == KMessageBox::Yes;
}

void KSVTopLevel::slotClearChanges()
{
  if (mChanged && 
      KMessageBox::Yes ==
      KMessageBox::questionYesNo(kapp->mainWidget(),
				 i18n("Do you really want to clear all unsaved changes?"),
				 i18n("New Configuration"),
				 i18n("C&lear"),
				 i18n("&Cancel")))
    {
      mUndoList->undoAll();
	  mRedoList->clear();
    }
}

void KSVTopLevel::slotAcceptChanges() {
  if (KMessageBox::Yes ==
      KMessageBox::warningYesNo(kapp->mainWidget(),
				i18n("You're about to save the changes made to your init "
				     "configuration.\nPlease realize that wrong settings could "
				     "result in your system being unbootable.\n\n"
				     "Do you wish to continue?"),
				i18n("Save Configuration"),
				i18n("&Save"),
				i18n("&Cancel")))
    {
      mView->slotWriteSysV();
      initView();
    }
}

void KSVTopLevel::initView()
{
  dispatchCutCopy(0L); // disabling cut&copy
  mUndoList->clear();
  mRedoList->clear();
  mView->reInit();
  setChanged(false);

  // disable ToolsMenu_ entries when they can't do anything
  ServiceDlg* tmp = new ServiceDlg ("","", this);

  tmp->resetChooser (mView->scripts, false);
  if (!tmp->count())
    {
	  mToolsStartService->setEnabled (false);
	  mToolsStopService->setEnabled (false);
	  mToolsRestartService->setEnabled (false);
    }
  else
    {
	  mToolsStartService->setEnabled (true);
	  mToolsStopService->setEnabled (true);
	  mToolsRestartService->setEnabled (true);
    }

  tmp->resetChooser (mView->scripts, true);
  if (!tmp->count())
    {
	  mToolsEditService->setEnabled (false);
    }
  else
    {

	  mToolsEditService->setEnabled (true);
    }
  delete tmp;

  // reset tools
  mStartDlg->resetChooser (mView->scripts, false);
  mStopDlg->resetChooser (mView->scripts, false);
  mRestartDlg->resetChooser (mView->scripts, false);
  mEditDlg->resetChooser (mView->scripts, true);
}

void KSVTopLevel::initStatusBar()
{
  KStatusBar* status = statusBar();

  QHBox* visBox = new QHBox (status);
  QButtonGroup* group = new QButtonGroup (this);
  group->hide();
  connect (group, SIGNAL (clicked (int)), this, SLOT (toggleRunlevel (int)));

  new QLabel (i18n(" Show Runlevels "), visBox);
  for (int i = 0; i < RUNLEVEL_NR; ++i)
	{
	  QString label; label.setNum (i);

	  mVisible[i] = new QCheckBox (label, visBox, label);
	  mVisible[i]->setChecked (mConfig->showRunlevel (i));
	  
	  group->insert (mVisible[i]);
	}

  //  mProgress->setMinimumWidth(130);

  QHBox* authIconBox = new QHBox (status);
  QWidget* strut = new QWidget (authIconBox);
  strut->setFixedWidth (KDialog::spacingHint());
  mAuth = new RunlevelAuthIcon (mConfig->scriptPath(), mConfig->runlevelPath(), authIconBox);
  connect (mAuth, SIGNAL (authChanged(bool)), mView, SLOT(multiplexEnabled(bool)));

  status->addWidget (authIconBox, Status::Writable);
  status->insertItem (i18n(" Changed"), Status::Changed, 100);
  //  status->addWidget(mProgress, Status::Progress);
  status->addWidget (visBox, Status::Checklist);
  
  status->setItemAlignment (Status::Changed, AlignLeft | AlignVCenter);
//   status->setAlignment( Status::Progress, AlignRight );
//   status->setAlignment( Status::Rest, AlignRight );

  status->changeItem("", Status::Changed);
  //  statusBar()->changeItem("", Status::Rest);
}

void KSVTopLevel::slotShowConfig()
{
  // FIXME

  KSVPreferences* test = KSVPreferences::self();
  test->exec();
//   if (!mPreferences)
//     (mPreferences = new KSVPrefDlg(this, "Preferences"))->hide();

//   mPreferences->reReadConfig();
  
//   if (mPreferences->exec() == QDialog::Accepted)
// 	{
	  
// 	  mConfig->setScriptPath( mPreferences->scriptPath() );
// 	  mConfig->setRunlevelPath( mPreferences->runlevelPath() );
	  
// 	  if (mPreferences->isColorChanged())
// 		{
// 		  mConfig->setNewColor(mPreferences->newColor());
// 		  mConfig->setChangedColor(mPreferences->changedColor());
		  
// 		  mView->setNewColor(mConfig->newColor());
// 		  mView->setChangedColor(mConfig->changedColor());
// 		  QPixmapCache::clear(); // unfortunately, this is necessary
// 		  mView->repaintRunlevels(false);
// 		}
	  
// 	}
//   else
//     mPreferences->reReadConfig();
}

void KSVTopLevel::slotChanged() {
  setChanged(true);
}

void KSVTopLevel::slotReadConfig() {
  setLog(mConfig->showLog());
  setStatus(mConfig->showStatus());
  setTools(mConfig->showTools());
}

void KSVTopLevel::toggleLog() {
  const bool value = !mConfig->showLog();
  setLog(value);
}

void KSVTopLevel::toggleStatus() {
  setStatus (!statusBar()->isVisible());
}

void KSVTopLevel::toggleTools() {
  setTools (!toolBar()->isVisible());
}

void KSVTopLevel::fwdAdvance (int i)
{
  mAdvanced += i;

  emit progress (mAdvanced);
}

void KSVTopLevel::saveOptions()
{
  mConfig->writeSettings();
}

void KSVTopLevel::slotUpdateRunning (const QString& text)
{
  statusBar()->changeItem(text, Status::Changed);
}

void KSVTopLevel::editCut() {
  KSVDragList* list = mView->getOrigin();

  if (list && list->currentItem())
	{
	  KSVDrag* mime = new KSVDrag (*list->currentItem()->data(), 0L, 0L);
	  kapp->clipboard()->setData (mime);
	  
	  KSVData data = *list->currentItem()->data();
	  delete list->currentItem();
		  
	  mUndoList->push (new RemoveAction (list, &data));
	  setChanged (true);
	}
}

void KSVTopLevel::editCopy()
{
  KSVDragList* list = mView->getOrigin();

  if (list)
	{
	  KSVDrag* mime = new KSVDrag (*static_cast<KSVItem*> (list->currentItem()), 0L, 0L);
	  kapp->clipboard()->setData (mime);
	}
}

void KSVTopLevel::editPaste()
{
  KSVDragList* list = mView->getOrigin();
  
  if (list)
    {
	  KSVData data;
	  
	  if (KSVDrag::decodeNative (kapp->clipboard()->data(), data))
		{
		  KSVAction* action = 0L;

		  if (list->insert (data, list->currentItem(), action))
			{
			  setChanged (true);
			  mUndoList->push (new AddAction (list, list->match (data)->data()));
			}
		}
	}
  else
    qFatal("Bug: could not get origin of \"Paste\" event.\n" \
		   "Please notify the maintainer of this program,\n" \
		   "Peter Putzer <putzer@kde.org>.");
}

void KSVTopLevel::setChanged (bool val)
{
  mChanged = val;
  // for session management
  setCaption(val);

  mFileNew->setEnabled (val);
  mFileSave->setEnabled (val);

  // update statusbar
  QString barTxt = val ? i18n(" Changed") : QString::null;
  statusBar()->changeItem(barTxt, Status::Changed);

  // clear messages
  statusBar()->clear();
}

void KSVTopLevel::properties()
{
  KSVDragList* list = mView->getOrigin();

  if (list)
    mView->infoOnData(dynamic_cast<KSVItem*>(list->currentItem()));
}

void KSVTopLevel::scriptProperties()
{
  KSVDragList* list = mView->getOrigin();

  if (list)
    mView->slotScriptProperties(list->currentItem());
}

void KSVTopLevel::editUndo ()
{
  KSVAction* action = mUndoList->top();

  mUndoList->undoLast();

  mRedoList->push (action);
}

void KSVTopLevel::editRedo ()
{
  KSVAction* action = mRedoList->top();
  
  mRedoList->redoLast();
  
  setChanged (true);
  mUndoList->push (action);
}

void KSVTopLevel::setCut (bool val)
{
  mEditCut->setEnabled (val);
}

void KSVTopLevel::setCopy (bool val)
{
  mEditCopy->setEnabled (val);
}

void KSVTopLevel::setPaste (bool val)
{
  mEditPaste->setEnabled (val);
  mPasteAppend->setEnabled (val);
}

void KSVTopLevel::setUndo( bool val ) {
  mEditUndo->setEnabled (val);
}

void KSVTopLevel::setRedo (bool val)
{
  mEditRedo->setEnabled (val);
}

void KSVTopLevel::setLog( bool val ) {
  mConfig->setShowLog(val);
  
  mOptionsToggleLog->setChecked (val);
  
  mView->setDisplayScriptOutput(val);
}

void KSVTopLevel::setStatus( bool val ) {
  if (val)
	statusBar()->show();
  else
	statusBar()->hide();

  mConfig->setShowStatus (val);
  mOptionsStatus->setChecked (val);
}

void KSVTopLevel::setTools( bool val ) {
  if (val)
	toolBar()->show();
  else
	toolBar()->hide();


  mConfig->setShowTools (val);
  mOptionsTools->setChecked (val);
}

void KSVTopLevel::initProgress (int max, const QString& label)
{
  mAdvanced = 0;
  mProgress->setTotalSteps (max);
  mProgress->setLabelText (label);
  mProgress->setFixedSize (mProgress->sizeHint());
  mProgress->show();

  emit progress (mAdvanced);
}

void KSVTopLevel::print()
{
  kdDebug() << "Printing not implemented." << endl;
}

void KSVTopLevel::printLog()
{  
//   static QPrinter prt;
//   prt.setDocName(kapp->caption() + " Log File");
//   prt.setCreator(kapp->caption());

//   static QPrintDialog* dlg = new QPrintDialog (&prt, this, "KSysV Print Dialog");
//   dlg->setCaption(kapp->makeStdCaption (i18n("Print Log")));
  
//   char buf[200];
//   if ( dlg->exec() == QDialog::Accepted )
//     {
//       int y =10;
//       QPainter p;
//       p.begin( &prt );
  
//       p.setFont (QFont("courier", 10, QFont::Bold));
//       QFontMetrics fm = p.fontMetrics();

//       p.drawText (10, y, "KDE System V Init Editor Log");
//       y += fm.lineSpacing();

//       p.drawText (10, y, QDateTime::currentDateTime().toString());
//       y += fm.lineSpacing() * 2; // an extra empty line

//       p.setFont (QFont("courier", 10));
//       fm = p.fontMetrics();
      
//       const int numlines = mView->logLines();
//       for(int i = 0; i< numlines; i++){
// 	y += fm.ascent();
	
// 	QString line = mView->logLine(i);
// 	line.replace( QRegExp("\t"), "        " );
// 	strncpy(buf,line.data(),160);
	
// 	for (int j = 0 ; j <150; j++)
// 	  {
// 	    if (!isprint(buf[j]))
// 	      buf[j] = ' ';
// 	  }
	
// 	buf[line.length()] = '\0';
// 	p.drawText( 10, y, buf );
// 	y += fm.descent();
//       }
      
//       p.end();        
//     }
}

void KSVTopLevel::catchCannotGenerateNumber() {
  statusBar()->message(i18n("Could not generate sorting number. Please change manually."), 5000);
}

void KSVTopLevel::closeEvent (QCloseEvent* e)
{
  if (mView->isInitializing())
    {
      // do not allow a close during clearing => otherwise we get a segfault
	  e->ignore();
      return;
    }

  KTMainWindow::closeEvent (e);
}

void KSVTopLevel::dispatchCutCopy (KSVItem* d)
{
  if (!d)
    {
      setCopy(false);
      setCut(false);
    }
  else
    {
      setCopy(true);
      setCut(true);
    }

  dispatchPaste();
}

void KSVTopLevel::dispatchCopyScripts (KSVItem* d)
{
  if (!d)
    setCopy(false);
  else
    setCopy(true);

  setCut(false);
  
  dispatchPaste();
}

void KSVTopLevel::dispatchPaste ()
{
  QMimeSource* mime = kapp->clipboard()->data();

  if (mime && mime->provides ("application/x-ksysv") && !mView->scripts->isOrigin())
	setPaste (true);
  else
	setPaste (false);
}

void KSVTopLevel::enableUndo()
{
  setUndo(true);
}

void KSVTopLevel::disableUndo()
{
  setUndo(false);
  setChanged(false);
}

void KSVTopLevel::enableRedo()
{
  setRedo (true);
}

void KSVTopLevel::disableRedo ()
{
  setRedo (false);
}

void KSVTopLevel::slotSaveLog()
{
  static QString filter = "*.log|" + QString(kapp->caption() + i18n(" log files") + " (*.log)");

  QString filename = KFileDialog::getSaveFileName(0L, filter, this);

  if (filename.isEmpty())
    return;
  else if (filename.right(4) != ".log")
    filename += ".log";

  QFile file(filename);

  file.open( IO_WriteOnly | IO_Raw );
  QTextStream s(&file);

  s << "KDE System V Init Editor"
    << endl
    << QDateTime::currentDateTime().toString()
    << endl << endl
    << mView->log()
    << endl;

  file.close();
}

void KSVTopLevel::show()
{
  KTMainWindow::show();

#if 0 // we need this in the future...

  // configuration wizard if this is the first start
  static bool first = true;
  
  if (first )//&& !mConfig->isConfigured())
    {
      ConfigWizard* w = new ConfigWizard(this, "ConfigWizard");

      w->exec();
      
      mConfig->setConfigured(true);
      mConfig->writeConfig();
      first = false;
    }

#endif // if 0

}

void KSVTopLevel::enableLogActions ()
{
  mFileSaveLog->setEnabled (true);
  mFilePrintLog->setEnabled (true);
}

void KSVTopLevel::checkScriptMenu (QPopupMenu* menu, int row)
{
 //  KSVItem* i = mView->scripts->at(row);

//   if (i)
//     {
//       QFileInfo info (i->filenameAndPath());

//       if (info.isReadable() && info.isWritable())
// 	menu->setItemEnabled (PopMenu::EditService, true);
//       else
// 	menu->setItemEnabled (PopMenu::EditService, false);

//       if (info.isExecutable())
// 	{
// 	  menu->setItemEnabled (PopMenu::StartService, true);
// 	  menu->setItemEnabled (PopMenu::StopService, true);
// 	  menu->setItemEnabled (PopMenu::RestartService, true);
// 	}
//       else
// 	{
// 	  menu->setItemEnabled (PopMenu::StartService, false);
// 	  menu->setItemEnabled (PopMenu::StopService, false);
// 	  menu->setItemEnabled (PopMenu::RestartService, false);
// 	}
//     }
}

void KSVTopLevel::setCaption (bool changed)
{
  setPlainCaption (kapp->makeStdCaption(KSVCore::hostname(), true, changed));
}

void KSVTopLevel::configureKeys ()
{
  // remove unwanted (internal) actions
  KActionCollection coll = *actionCollection();
  coll.take(mPasteAppend);

  KKeyDialog::configureKeys (&coll, xmlFile(), true, this);
}

void KSVTopLevel::configureToolbars ()
{
  KEditToolbar* dlg = new KEditToolbar (actionCollection(), xmlFile(), this);

  if (dlg->exec())
	{
	  createGUI (xmlFile());
	}

  delete dlg;
}

void KSVTopLevel::dispatchEditService (bool val)
{
  mToolsEditService->setChecked (val);
}

void KSVTopLevel::dispatchStartService (bool val)
{
  mToolsStartService->setChecked (val);
}

void KSVTopLevel::dispatchStopService (bool val)
{
  mToolsStopService->setChecked (val);
}

void KSVTopLevel::dispatchRestartService (bool val)
{
  mToolsRestartService->setChecked (val);
}

void KSVTopLevel::pasteAppend ()
{
  mView->pasteAppend ();
}

void KSVTopLevel::toggleRunlevel (int index)
{
  bool state = mVisible[index]->isChecked();

  if (state)
	mView->showRunlevel (index);
  else
	mView->hideRunlevel (index);

  mConfig->setShowRunlevel (index, state);
}
