// (c) 2000 Peter Putzer <putzer@kde.org>

#pragma implementation

#include <qtimer.h>
#include <qfileinfo.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <kdialog.h>
#include <klocale.h>

#include "RunlevelAuthIcon.h"
#include "RunlevelPixmaps.h"

RunlevelAuthIcon::RunlevelAuthIcon (const QString& scriptPath, const QString& runlevelPath,
									QWidget* parent, const char* name)
  : KAuthIcon (parent, name),
	mTimer (new QTimer (this)),
	mScriptInfo (new QFileInfo (scriptPath)),
	mOld (false),
	mInterval (1000)
{
  lockText = i18n("Editing disabled. Please check your permissions.");
  openLockText = i18n("Editing enabled.");

  lockLabel->setText (lockText);
  lockLabel->hide();

  lockPM = QPixmap (lock2_xpm);
  openLockPM = QPixmap (unlock2_xpm);
  lockBox->setPixmap (lockPM);

  lockBox->setMargin (1);
  lockBox->setFrameStyle (QFrame::NoFrame);
  lockBox->setFixedSize (lockBox->sizeHint());


  connect (mTimer, SIGNAL (timeout()), this, SLOT (timerEvent()));
  mTimer->start (mInterval);

  for (int i = 0; i < RUNLEVEL_NR; ++i)
	{
	  mRLInfo[i] = new QFileInfo ((runlevelPath + "/rc%1.d").arg(i));
	}

  updateStatus();
  layout->activate();
}

RunlevelAuthIcon::~RunlevelAuthIcon ()
{
  delete mScriptInfo;

  for (int i = 0; i < RUNLEVEL_NR; ++i)
	{
	  delete mRLInfo[i];
	}
}

void RunlevelAuthIcon::updateStatus ()
{
  bool res = status();

  if (mOld != res)
	{
	  lockBox->setPixmap (res ? openLockPM : lockPM);
	  lockLabel->setText (res ? openLockText : lockText);

	  QToolTip::remove (this);
	  QToolTip::add (this, lockLabel->text());

	  emit authChanged (res);
	}

  mOld = res;
}

bool RunlevelAuthIcon::status () const
{
  bool result = mScriptInfo->isWritable();

  for (int i = 0; i < RUNLEVEL_NR; ++i)
	{
	  result = result && mRLInfo[i]->isWritable();
	}

  return result;
}

void RunlevelAuthIcon::timerEvent ()
{
  for (int i = 0; i < RUNLEVEL_NR; ++i)
	{
	  mRLInfo[i]->refresh();
	}
  
  mScriptInfo->refresh();

  updateStatus();
}

void RunlevelAuthIcon::setScriptPath (const QString& path)
{
  mTimer->stop();

  mScriptInfo->setFile (path);

  mTimer->start(mInterval);
}

void RunlevelAuthIcon::setRunlevelPath (const QString& path)
{
  mTimer->stop();

  for (int i = 0; i < RUNLEVEL_NR; ++i)
	{
	  mRLInfo[i]->setFile ((path + "/rc%1.d").arg(i));
	}

  mTimer->start(mInterval);
}

void RunlevelAuthIcon::setRefreshInterval (int interval)
{
  mInterval = interval;

  mTimer->stop();
  mTimer->start (mInterval);
}
