/***************************************************************************
                          PropDlg.cpp  -  description
                             -------------------
    begin                : Sun Oct 3 1999
    copyright            : (C) 1997-99 by Peter Putzer
    email                : putzer@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2.                              *
 *                                                                         *
 ***************************************************************************/

#pragma implementation

#include <qlabel.h>
#include <qpushbt.h>
#include <qlayout.h>
#include <qspinbox.h>
#include <qlineedit.h>
#include <kbuttonbox.h>
#include <kapp.h>
#include <klocale.h>
#include "ksv_core.h"
#include "ksvdraglist.h"
#include "PropDlg.h"

#define HALF 5
#define FULL 2*HALF
#define MINIMAL 1
#define MIN_SIZE(A) A->setMinimumSize(A->sizeHint())

KSVPropDlg::KSVPropDlg(KSVItem* data, QWidget* parent, const char* name)
  : KDialogBase(parent, name, true, i18n("%1 - Properties").arg(data->label()),
				Ok|Cancel, Ok, false)
{
  QWidget* page = new QWidget (this);
  setMainWidget (page);

  QBoxLayout* topLayout = new QVBoxLayout (page, 0, spacingHint());

  QBoxLayout* content = new QVBoxLayout( HALF );
  topLayout->addLayout(content, FULL);

  // add the "content" widgets
  QLabel* name_l = new QLabel(i18n("&Name"), page);
  MIN_SIZE(name_l);
  QLabel* target_l = new QLabel(i18n("&Points to"), page);
  MIN_SIZE(target_l);
  QLabel* number_l = new QLabel(i18n("&Sorting number"), page);
  MIN_SIZE(number_l);

  name_le = new QLineEdit( page );
  MIN_SIZE(name_le);
  target_le = new QLineEdit( page );
  MIN_SIZE(target_le);
  number_il = new QSpinBox(0, 99, 1, page, "Sorting Number");
  number_il->setWrapping(true);
  name_l->setBuddy(name_le);
  target_l->setBuddy(target_le);
  number_l->setBuddy(number_il);

  content->addWidget(name_l);
  content->addWidget(name_le, MINIMAL);
  content->addWidget(target_l);
  content->addWidget(target_le, MINIMAL);
  content->addWidget(number_l);

  QBoxLayout* numberLayout = new QHBoxLayout( HALF );
  content->addLayout(numberLayout, MINIMAL);

  number_il->setRange(0, 99);
  MIN_SIZE(number_il);
  number_il->setMinimumWidth(50);

  numberLayout->addWidget(number_il, MINIMAL);
  numberLayout->addStretch(FULL);

  // description of service
  QString label;
  KSVCore::getServiceDescription (data->label(), label);
  
  QLabel* desc = new QLabel (label, page);
  desc->setFrameStyle (QFrame::Box|QFrame::Sunken);
  desc->setAlignment (WordBreak | AlignLeft | AlignVCenter);
  desc->setMinimumWidth (kapp->desktop()->width() / 6);
  desc->setMinimumHeight (desc->sizeHint().height());

  content->addWidget (desc);
  //delete tmp;

  // some space between buttons and content
//   content->addStretch(FULL);

// //   // add ok and cancel buttons
//   KButtonBox* buttons = new KButtonBox(page);
//   buttons->addStretch(FULL);
//   QPushButton* ok_bt = buttons->addButton(i18n("OK"));
//   QPushButton* cancel_bt = buttons->addButton(i18n("Cancel"));
//   buttons->layout();

//   topLayout->addWidget(buttons);

//   topLayout->activate();

//   // some button/dialog stuff
//   ok_bt->setAutoDefault(TRUE);
//   cancel_bt->setAutoDefault(TRUE);
//   ok_bt->setDefault(TRUE);

//   connect(ok_bt, SIGNAL(clicked()), this, SLOT(accept()));
//   connect(cancel_bt, SIGNAL(clicked()), this, SLOT(reject()));

  // set content
  datum = data;
  name_le->setText(datum->label());
  target_le->setText(datum->filename());
  number_il->setValue(datum->number());

//   // set caption to "foobar - Properties"
//   setCaption(i18n("%1 - Properties").arg(datum->label()));

//   // make fixed size... I dont think we need the extra space
//   topLayout->freeze(minimumSize().width() * 1.3f, minimumSize().height() * 1.1f);
  setMinimumSize (sizeHint());
}

// Destructor

KSVPropDlg::~KSVPropDlg() {

}

void KSVPropDlg::accept() {
  bool _changed = false;

  if (datum->label() != name_le->text())
    {
      datum->setLabel(name_le->text());
      _changed = true;
    }

  if (datum->number() != number_il->value())
    {
      datum->setNumber(number_il->value());
      _changed = true;
    }

  if (datum->filename() != target_le->text())
    {
      datum->setFilename(target_le->text());
      _changed = true;
    }

  if (_changed)
    emit changed(datum);

  QDialog::accept();
}

void KSVPropDlg::setEnabled( bool val )
{
  name_le->setEnabled(val);
  number_il->setEnabled(val);
  target_le->setEnabled(val);
}




