//////////////////////////////////////////////////////////////         
//      $Id: utils.cpp,v 1.9 1999/08/15 13:29:26 toivo Exp $ 
//
// Author: Toivo Pedaste
//
#include "../config.h"
#include <kpackage.h>
#include <qmessagebox.h>
#include <klocale.h>

#include "utils.h"
#include "kplview.h"

void KpMsgE( const QString &msg, bool stop)
{
 KpMsg( "Error", msg,  stop);
}

void KpMsg(const QString &lab, const QString &msg, bool stop)
{
  if (stop)
    QMessageBox::critical(kpkg, lab, msg, i18n("OK"));
  else
    QMessageBox::information(kpkg, lab, msg, i18n("OK"));
}

char *getGroup(char **gs)
{
  char *gsc = strdup(*gs);
  char *p=gsc;
  while(*p && *p != '/')
    {
      p++;
      (*gs)++;
    }
  *p='\0';
  if(**gs)
    (*gs)++;
  return gsc;
}


KPLVItem *findGroup(char *name, KPLVItem *search)
{
  if(!search)
    return NULL;

  do {
    if(strcmp(name, search->text(0)) == 0) {
      return search;
    }
  } while( (search=search->nextSibling()) != NULL);

  return NULL;
}



