//////////////////////////////////////////////////////////////
// 	$Id: rpmInterface.h,v 1.9 2000/01/07 15:36:42 toivo Exp $	
//
// Author: Toivo Pedaste
//
//////////////////////////////////////////////////////////////

#ifndef RPM_IFACE_H
#define RPM_IFACE_H

#include "../config.h"

#ifdef HAVE_RPM
#include <rpm/rpmlib.h>
#else
  typedef struct  Header{
};
#endif

#include <qlist.h>

#include "packageInfo.h"
#include "pkgInterface.h"

class KDir;
class cacheObj;

class RPM : public pkgInterface
{
 Q_OBJECT

public:
  RPM();
  ~RPM();
  
  bool isType(char *buf, const QString &fname);
  param *initinstallOptions();
  param *inituninstallOptions();
  packageInfo *getPackageInfo(char mode, const QString &name, const QString &version);
  QStringList *getFileList(packageInfo *p);
  QStringList *depends(const QString &name, int src);
  QStringList *verify(packageInfo *p, const QStringList &files);

  int uninstall(int uninstallFlags, QList<packageInfo> *p);
  int uninstall(int uninstallFlags, packageInfo *p);
  int doUninst(int uninstallFlags, const QStringList &files);

  int install(int installFlags, QList<packageInfo> *p);
  int install(int installFlags, packageInfo *p);
  int doinst(int installFlags, const QStringList &files);

  QString FindFile(const QString &name);
  void collectDepends(packageInfo *p, const QString &name, int src);
  bool parseName(QString name, QString *n, QString *v);

  QString provMap(QString p);

public slots:
  void setLocation();
  void setAvail(LcacheObj *);

private:
  packageInfo* collectInfo(Header h);
  QStringList* collectFileList(Header h);
  void listInstalledPackages(QList<packageInfo> *pki);

  QDict<QString> provides;
  bool rpmSetup;
 };

#endif



