///////////////////////////////////////////////////////////////////////////
// $Id: managementWidget.cpp,v 1.36 2000/06/05 14:27:25 toivo Exp $	
// File  : managementWidget.cpp
// Author: Damyan Pepper
// Author: Toivo Pedaste
//
// See managementWidget.h for more information

#include <qsplitter.h>
#include <qstack.h>

#include <klocale.h>

// kpackage.headers
#include "kpackage.h"
#include "kplview.h"
#include "managementWidget.h"
#include "pkgInterface.h"
#include "pkguninstallDialog.h"
#include "packageDisplay.h"
#include "packageProperties.h"
#include "installationWidget.h"
#include "options.h"

extern Params *params;

// constructor -- initialise variables
managementWidget::managementWidget(QWidget *parent, const char *name)
  : QFrame(parent,name)
{
  package=0;
  installedPackages=0;
  QStack<QString> stack();

  tType[0] = i18n("Installed");
  tType[1] = i18n("Updated");
  tType[2] = i18n("New");
  tType[3] = i18n("All");

  dirInstPackages = new QDict<packageInfo>(7717);
  dirUninstPackages = new QDict<packageInfo>(7717);
  dirInfoPackages = new QDict<packageInfo>(7717);
  setupWidgets();
}

managementWidget::~managementWidget()
{
  //  if(installedPackages)
  //      delete installedPackages;
  //  delete dirInstPackages;
  //  delete dirUninstPackages;
}

void managementWidget::resizeEvent(QResizeEvent *)
{
  arrangeWidgets();
}


void managementWidget::setupWidgets()
{
  QTab t;

  top = new QBoxLayout(this,QBoxLayout::TopToBottom);
  vPan  = new QSplitter(QSplitter::Horizontal, this);
  top->addWidget(vPan);

  // the left panel
  leftpanel = new QFrame(vPan);
  leftbox = new QBoxLayout(leftpanel,QBoxLayout::TopToBottom);

  QTabBar *ltab = new QTabBar(leftpanel);

  readTreeType();
  treeList = new KPQListView(leftpanel);

  treeList->setFrameStyle(QFrame::Panel|QFrame::Sunken);
  treeList->setLineWidth(2);
  treeList->setItemMargin(2);
  treeList->addColumn(i18n("Package"));
  treeList->setColumnWidthMode(0,QListView::Manual);
  treeList->addColumn(i18n("Mark"));
  treeList->setColumnWidthMode(1,QListView::Manual);
  treeList->addColumn(i18n("Size"));
  treeList->setColumnWidthMode(2,QListView::Manual);
  treeList->addColumn(i18n("Version"));
  treeList->setColumnWidthMode(3,QListView::Manual);
  treeList->addColumn(i18n("Old Version"));
  treeList->setColumnWidthMode(4,QListView::Manual);
  //  treeList->setAllColumnsShowFocus(TRUE);
  treeList->setRootIsDecorated(TRUE);
  readTreePos();
  treeList->update();
  treeList->show();

  for (int i = 0; i < 4; i++) {
    QTab *t = new QTab();
    t->label = tType[i];
    ltab->addTab(t);
  }
  connect(ltab,SIGNAL(selected (int)),SLOT(tabChanged(int)));
  ltab->setCurrentTab(treeType);


  //  ltab->tabBar.setCurrentTab(treeType);
  leftbox->addWidget(ltab,10);
  leftbox->addWidget(treeList,10);

  leftbox->addStretch();

  lbuttons = new QBoxLayout(QBoxLayout::LeftToRight);

  luinstButton = new QPushButton(i18n("Uninstall marked"),leftpanel);
  luinstButton->setEnabled(TRUE);
  connect(luinstButton,SIGNAL(clicked()),
	  SLOT(uninstallMultClicked()));
  linstButton = new QPushButton(i18n("Install marked"),leftpanel);
  linstButton->setEnabled(TRUE);
  connect(linstButton,SIGNAL(clicked()),
	  SLOT(installMultClicked()));

  leftbox->addLayout(lbuttons,0); // top level layout as child

  // Setup the `buttons' layout
  lbuttons->addWidget(linstButton,1,AlignBottom);
  lbuttons->addWidget(luinstButton,1,AlignBottom);
  lbuttons->addStretch(1);

  connect(treeList, SIGNAL(selectionChanged(QListViewItem *)),
	  SLOT(packageHighlighted(QListViewItem *)));

  // the right panel
  rightpanel = new QFrame(vPan);
  rightbox = new QBoxLayout(rightpanel,QBoxLayout::TopToBottom);

  packageDisplay = new packageDisplayWidget(rightpanel);
  //  packageDisplay->setFrameStyle(QFrame::Panel|QFrame::Sunken);
  //  packageDisplay->setLineWidth(2);
  connect(this, SIGNAL(changePackage(packageInfo *)),
	  packageDisplay, SLOT(changePackage(packageInfo *)));

  rbuttons = new QBoxLayout(QBoxLayout::LeftToRight);

  uinstButton = new QPushButton(i18n("Uninstall"),rightpanel);
  uinstButton->setEnabled(FALSE);
  connect(uinstButton,SIGNAL(clicked()),
	  SLOT(uninstallSingleClicked()));
  instButton = new QPushButton(i18n("Examine"),rightpanel);
  instButton->setEnabled(FALSE);
  connect(instButton,SIGNAL(clicked()),
	  SLOT(installSingleClicked()));


  // Setup the `right panel' layout
  rightbox->addWidget(packageDisplay,10);
  rightbox->addLayout(rbuttons,0); // top level layout as child

  // Setup the `buttons' layout
  rbuttons->addWidget(instButton,1);
  rbuttons->addWidget(uinstButton,1);
  rbuttons->addStretch(1);
}

////////////////////////////////////////////////////////////////
void managementWidget::writePSeparator()
{
  KConfig *config = kapp->config();

  config->setGroup("Kpackage");

  config->writeEntry("panel1Width",vPan->sizes().first());
  config->writeEntry("panel2Width",vPan->sizes().last());
}

void managementWidget::readPSeparator()
{
  KConfig *config = kapp->config();

  config->setGroup("Kpackage");

  int w1 = config->readNumEntry("panel1Width",200);
  int w2 = config->readNumEntry("panel2Width",200);

  QValueList<int> size;
  size << w1 << w2;
  vPan->setSizes(size);
}

////////////////////////////////////////////////////////////////
void managementWidget::writeTreeType()
{
  KConfig *config = kapp->config();

  config->setGroup("Kpackage");

  config->writeEntry("Package_Display",treeType);
}

void managementWidget::readTreeType()
{
  KConfig *config = kapp->config();

  config->setGroup("Kpackage");

  treeType = config->readNumEntry("Package_Display",3);

}

///////////////////////////////////////////////////////////////////
void managementWidget::setupInstButton(packageInfo *p)
{
  if (p->packageState != packageInfo::INSTALLED &&
      package->getProperty("filename") ) {

    instButton->setEnabled(TRUE);
    uinstButton->setEnabled(FALSE);
  } else {
    instButton->setEnabled(FALSE);
    uinstButton->setEnabled(TRUE);
  }
}

void managementWidget::arrangeWidgets()
{
  // this is done automatically by the layout managers
}

void managementWidget::tabChanged(int tab)
{
  treeType = tab;
  sweep();
}


// Collect data from package.
void managementWidget::collectData(bool refresh)
{
  int i;

  if (!refresh && installedPackages)
    return; // if refresh not required already initialised

  QApplication::setOverrideCursor( waitCursor );

// stop clear() sending selectionChanged signal
  disconnect(treeList, SIGNAL(selectionChanged(QListViewItem *)),
	  this, SLOT(packageHighlighted(QListViewItem *)));
  treeList->hide();    // hide list tree
  treeList->clear();   // empty it
  connect(treeList, SIGNAL(selectionChanged(QListViewItem *)),
	  SLOT(packageHighlighted(QListViewItem *)));

  packageDisplay->noPackage();

  // Delete old list if necessary
  if(installedPackages) {
    delete installedPackages;
  }

  installedPackages = new QList<packageInfo>;
  installedPackages->setAutoDelete(TRUE);

  dirInstPackages->clear();
  dirUninstPackages->clear();
  // List installed packages
  for (i = 0; i < kpinterfaceN; i++)  {
    kpinterface[i]->listPackages(installedPackages);
  }

  // Rebuild the list tree
  rebuildListTree();

  QApplication::restoreOverrideCursor();
}

// Rebuild the list tree
void managementWidget::rebuildListTree()
{
  packageInfo *i;
  int  n = 0;

  kpackage->setStatus(i18n("Building package tree"));
  kpackage->setPercent(0);


  // place all the packages found
  int count = installedPackages->count();

  for(i=installedPackages->first(); i!=0; i=installedPackages->next())
    {
      i->place(treeList,TRUE);

      int num = (n*100)/count;
      if (!(num % 5))
	kpackage->setPercent(num);
      n++;
    }
  treeList->show();		// show the list tree
  kpackage->setPercent(100);	// set the progress
  sweep();
}

// A package has been highlighted in the list tree
void managementWidget::packageHighlighted(QListViewItem *item)
{

  KPLVItem *sel = (KPLVItem *)item;

  if (!sel || sel->childCount()) {
    emit changePackage(NULL);
  } else if (sel) {

    if (!notPress) {
      int n = stack.at();
      int num = stack.count();
      for (int i = num - 1; i >= n; i--) {
	stack.remove(i);
      }
      kpkg->disableNext();
    }

    // Disable the tree list while we do this
    treeList->setEnabled(FALSE);
    // Tell everything that is interested to change packages
    emit changePackage(sel->info);

    // Keep copy of the package
    package = sel->info;
    if (package) {
      setupInstButton(package);
    }

    // Re-enable the treeList and uninstall button
    treeList->setEnabled(TRUE);

    if (!notPress) {
      stack.append(sel);
    }
  }

  notPress = false;
  // Update the status bar
  kpackage->setPercent(100);
}

/////////////////////////////////////////////////////////////////////////
// install has been clicked

void managementWidget::installSingleClicked()
{
  if (package) {
    QString url = package->getUrl();
    if (!url.isEmpty()) {
      kpackage->openNetFile(url);
    } else {
      KpMsgE(i18n("Filename not available\n"),TRUE);
    }
  }
}

// install has been clicked
void managementWidget::installMultClicked()
{
  int  i;
  KPLVItem *it;
  packageInfo *inf;
  QList<packageInfo> **lst = new QList<packageInfo>*[kpinterfaceN];

  selList.clear();
  findMarked(treeList->firstChild());
  for (i = 0; i < kpinterfaceN; i++) {
    lst[i] = new QList<packageInfo>;
    for (it = selList.first(); it != 0; it = selList.next()) {
      if (it->info->interface == kpinterface[i] &&
	  it->childCount() == 0 &&
	  (it->info->packageState == packageInfo::UPDATED ||
	   it->info->packageState == packageInfo::NEW)
	  ) {
	lst[i]->insert(0,it->info);
      }
    }
  }
  selList.clear();

  for (i = 0; i < kpinterfaceN; i++) {
    if (lst[i]->count() > 0) {
      kpinterface[i]->installationMult->setup(lst[i],kpinterface[i]->head);
      if (kpinterface[i]->installationMult->exec()) {
	for (inf = lst[i]->first(); inf != 0; inf = lst[i]->next()) {
	  updatePackage(inf,TRUE);
	}
      }
      delete lst[i];
    }
  }
  delete [] lst;
}

/////////////////////////////////////////////////////////////////////////////
// Uninstall has been clicked

void managementWidget::uninstallSingleClicked()
{
  int result;

  if (package)			// check that there is a package to uninstall
    {
      package->interface->uninstallation->setup(package);
      result = package->interface->uninstallation->exec();

      if(result == QDialog::Accepted) // execute it
	{			// it was accepted, so the package has been
				// uninstalled
	  updatePackage(package,FALSE);

	  emit changePackage(NULL); // change package to no package
	  package = NULL;
	  instButton->setEnabled(FALSE); // disable uninstall button
	}
    }
  kpackage->setPercent(100);
}

void managementWidget::uninstallMultClicked()
{
  int  i;
  KPLVItem *it;
  packageInfo *inf;
  QList<packageInfo> **lst = new QList<packageInfo>*[kpinterfaceN];

  selList.clear();
  findMarked(treeList->firstChild());
  for (i = 0; i < kpinterfaceN; i++) {
    lst[i] = new QList<packageInfo>;
    for (it = selList.first(); it != 0; it = selList.next()) {
      if (it->info->interface == kpinterface[i] &&
	  it->childCount() == 0 &&
	  (it->info->packageState == packageInfo::INSTALLED ||
	   it->info->packageState == packageInfo::BAD_INSTALL)
	  ) {
	lst[i]->insert(0,it->info);
      }
    }
  }
  selList.clear();

  for (i = 0; i < kpinterfaceN; i++) {
    if (lst[i]->count() > 0) {
      kpinterface[i]->uninstallationMult->setup(lst[i],kpinterface[i]->head);
      if (kpinterface[i]->uninstallationMult->exec()) {
	for (inf = lst[i]->first(); inf != 0; inf = lst[i]->next()) {
	  updatePackage(inf,FALSE);
	}
	delete lst[i];
      }
    }
  }
  delete [] lst;
}

///////////////////////////////////////////////////////////////////////////
void managementWidget::sweep()
{
  KPLVItem  *item = treeList->firstChild();

  if (!item)
    return;

  do {
      sweepChild(item->firstChild());
  } while ((item = item->nextSibling()));
}

int  managementWidget::sweepChild(KPLVItem *it)
{
  int ret, shown = 0;

  do {
    if (it->childCount() > 0) {
      ret = sweepChild(it->firstChild());
      if (!ret) {
	it->hide();
      } else {
	it->show();
      }
      shown += ret;
    } else {
      //      printf("S=%s d=%d\n",(it->info->getProperty("name")).ascii(),it->info->display(treeType));
      if (!it->info->display(treeType)) {
	it->hide();
      } else {
	it->show();
	shown++;
      }	
    }
  } while ((it = it->nextSibling()));
  return shown;
}

///////////////////////////////////////////////////////////////////////////
KPLVItem *managementWidget::search(const char *str, const char* head,
				KPLVItem  *start)
{
  KPLVItem  *item = treeList->firstChild();

  searchCitem = start;
  searchSkip = FALSE;
  searchSubstr = FALSE;
  searchStr = str;
  searchResult = 0;

  do {
    if (!strcmp(item->text(0),head)) {
      searchChild(item->firstChild());
      if (searchResult != 0)
	return searchResult;
    }
  } while ((item = item->nextSibling()));
  return 0;
}

KPLVItem *managementWidget::search(const char *str, bool subStr, bool wrap,
			     bool start=FALSE)
{
  if (!treeList->firstChild())
    return 0;

  if (start)
    searchCitem = 0;
  else
    searchCitem = treeList->currentItem();
  searchSkip = !wrap;
  searchSubstr = subStr;
  searchStr = str;
  searchResult = 0;

  searchChild(treeList->firstChild());

  return changePack(searchResult);
}

bool managementWidget::searchChild(KPLVItem *it)
{
  do {
    if (!searchSkip) {
      QString s = it->text(0);
      if ((it->childCount() == 0) && (it->info->display(treeType)) &&
	  (searchSubstr ? s.contains(searchStr,FALSE) : s == searchStr)) {
	searchResult = it;
	return TRUE;
      }
    }

    if (searchCitem == it) {
      if (searchSkip) {
	searchSkip = FALSE;
      } else {
	return TRUE;
      }
    }

    if (it->childCount() > 0) {
      if (searchChild(it->firstChild()))
	return TRUE;
    }
  } while ((it = it->nextSibling()));
  return FALSE;
}

///////////////////////////////////////////////////////////////////////////
KPLVItem *managementWidget::changePack(KPLVItem *searchResult, bool push)
{
  if (searchResult) {
    QListViewItem *i;

    i = searchResult;
    while ((i = i->parent())) {
      i->setOpen(TRUE);	
    }
    if (push) {
      stack.append(searchResult);
      kpkg->enablePrevious();
    }

    notPress = true;
    treeList->setSelected(searchResult,TRUE);
    treeList->setCurrentItem(searchResult);
    treeList->ensureItemVisible(searchResult);
    return searchResult;
  } else {
    return 0;
  }
}

void managementWidget::next()
{
  int n = stack.at();
  KPLVItem *s = stack.at(n + 1);
  if (s) {
    changePack(s, false);
  }
  if (n >= int(stack.count() - 2)) {
    kpkg->disableNext();
  }
  if (n >= 0) {
    kpkg->enablePrevious();
  }
}

void managementWidget::previous()
{
  int n = stack.at();
  KPLVItem *s = stack.at(n-1);

  if (s) {
    changePack(s, false);
    kpkg->enableNext();
  }
  if (n <= 1) {
    kpkg->disablePrevious();
  }
  if (n < int(stack.count() - 2)) {
    kpkg->enableNext();
  }

}


///////////////////////////////////////////////////////////////////////////
KPLVItem *managementWidget::updatePackage(packageInfo *pki, bool install)
{
  QString version;

  if (installedPackages) {
    QString name(pki->getProperty("name"));
    if (pki->hasProperty("version"))
      version = pki->getProperty("version");
    else
      version = "";
    pkgInterface *interface = pki->interface;
    packageInfo *pnew = interface->getPackageInfo('i', name, version);
    packageInfo *ptree;
    QString dirIndex =  name + interface->typeID;

    if (install) {
      if (pnew) {
	if (pnew->packageState !=  packageInfo::BAD_INSTALL) {
	  ptree = dirInstPackages->find(dirIndex); // remove installed entry
	  dirInstPackages->remove(dirIndex);
	  if (ptree) {
	    if (ptree->getItem())
	      delete ptree->getItem();
	  }

	  ptree = dirUninstPackages->find(dirIndex); // remove uninstalled entry
	  dirUninstPackages->remove(dirIndex);
	  if (ptree) {
	    if (ptree->getItem())
	      delete ptree->getItem();	
	  }
	}

	dirInstPackages->insert(dirIndex,pnew);

	KPLVItem *q = pnew->place(treeList,TRUE);
	installedPackages->insert(0,pnew);
	if (!q) {
	  //          printf("NOTP=%s \n",pnew->getProperty("name").ascii());
	} else {
	  sweep();
	  return q;
	}
      }
    } else {
      if (!pnew) {
	dirInstPackages->remove(dirIndex);
	KPLVItem  *qt = pki->getItem();
	if (qt) {
	  treeList->setSelected(qt,false);
	  if (treeList->markPkg == qt)
	    treeList->markPkg = 0;
	  delete qt;
	} else {
	  kdDebug() << "DEL=" << name.data() << endl;
	}
      } else {
	delete pnew;
      }
    }
  }
  sweep();
  return 0;
}

///////////////////////////////////////////////////////////////////////////
void managementWidget::clearMarked(KPLVItem *item)
{
  while (item) {
    if (item->childCount() > 0) {
      clearMarked(item->firstChild());
    }
    item->setMark(false);
    item = item->nextSibling();
  }
}

void managementWidget::findMarked(KPLVItem *item)
{
  while (item) {
    if (item->childCount() > 0) {
      findMarked(item->firstChild());
    }
    if (item->marked) {
      selList.insert(0,item);
    }
    item = item->nextSibling();
  }
}

///////////////////////////////////////////////////////////////////////////
void managementWidget::expandTree(KPQListView *list)
{
 KPLVItem *item = list->firstChild();

  while (item) {
    if (item->childCount() > 0) {
      item->setOpen(TRUE);
      expandTree(item);
    }
  item = item->nextSibling();
  }
}


void managementWidget::expandTree(KPLVItem *pitem)
{
  KPLVItem *item = pitem->firstChild();

  while (item) {
    if (item->childCount() > 0) {
      item->setOpen(TRUE);
      expandTree(item);
    }
    item = item->nextSibling();
  }
}

void managementWidget::collapseTree(KPQListView *list)
{
  KPLVItem *item = list->firstChild();

  while (item) {
    if (item->childCount() > 0) {
      collapseTree(item);
    }
  item = item->nextSibling();
  }
}

void managementWidget::collapseTree(KPLVItem *pitem)
{
  int n = 0;
  KPLVItem *item = pitem->firstChild();

  while (item) {
    if (item->childCount() > 0) {
      n++;
      collapseTree(item);
    }
    item = item->nextSibling();
  };
  if (n)
    pitem->setOpen(TRUE);
  else
    pitem->setOpen(FALSE);
}

///////////////////////////////////////////////////////////////////////////
void managementWidget::writeTreePos()
{
  int i;

  KConfig *config = kapp->config();

  config->setGroup("Treelist");

  QString colpos;
  for (i = 0; i < 5; i++) {
    colpos.setNum(i);
    config->writeEntry(colpos,treeList->columnWidth(i));
  }
}

void managementWidget::readTreePos()
{
  int i, n;
  int num[] = {185,37,54,95,95};

  KConfig *config = kapp->config();

  config->setGroup("Treelist");

  QString colpos;
  for (i = 0; i < 5; i++) {
    colpos.setNum(i);
    n = config->readNumEntry(colpos.data(),num[i]);
    treeList->setColumnWidth(i,n);
  }
}


