/*
    KTop, the KDE Task Manager
   
	Copyright (c) 1999 Chris Schlaeger <cs@kde.org>
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

	$Id: Command.h,v 1.2 2000/01/07 16:17:29 cschlaeg Exp $
*/

#ifndef _Command_h_
#define _Command_h_

typedef void (*cmdExecutor)(const char*);

void initCommand(void);

void exitCommand(void);

void registerCommand(const char* command, cmdExecutor ex);

void registerMonitor(const char* command, const char* type, cmdExecutor ex,
					 cmdExecutor iq);

void executeCommand(const char* command);

void printMonitors(const char* cmd);

#endif
