/*
    $Id: kfontlist.cpp,v 1.16 2000/05/02 21:27:00 bieker Exp $

    Copyright (C) 1997 Bernd Johannes Wuebben <wuebben@math.cornell.edu>
    Copyright (C) 2000 Hans Petter Bieker <bieker@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
 
#include <qstrlist.h> 
#include <qlayout.h> 

#include "kfontlist.h"
#include "main.h"

KFontList::KFontList (QWidget * parent, const char *name)
    : QWidget (parent, name)
{
  QVBoxLayout *top = new QVBoxLayout(this,10,10);

  listbox = new QListBox(this);
  setMinimumSize(100, 100);
  top->addWidget(listbox);

  queryFonts();
}

void KFontList::queryFonts()
{
  QStrList *fontlist = KFontList_GetXFonts(); // get all global X-Fonts
  listbox->clear();
  listbox->insertStrList(fontlist);
  
  delete fontlist;
}

#include "kfontlist.moc"



