/* This file implements the method to save a file..
 *
 * the KDE addressbook
 * copyright:  (C) Mirko Sucker, 1998, 1999, 2000
 * mail to:    Mirko Sucker <mirko@kde.org>
 * requires:   recent C++-compiler, at least Qt 2.0
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.
 
 You should have received a copy of the GNU Library General Public License
 along with this library; see the file COPYING.LIB.  If not, write to
 the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 * $Revision: 1.5 $
 */

#include <kmessagebox.h>
#include <klocale.h>
#include <kabapi.h>
#include "kab_topwidget.h"
#include "look_basic.h"

void TopLevelWidget::save()
{
  // ###########################################################################
  AddressBook::Entry entry;
  // WORK_TO_DO:
  // ----- remember last visible entry:
  // ----- save the database:
  AddressBook *book=api->addressbook();
  if(modified)
    {
      // ----- put the new entry into the database:
      //       preload it with the old contents
      if(book->getEntry(*current, entry)!=AddressBook::NoError)
	{
	  emit(setStatus(i18n("Internal error.")));
	}
      //       get all values from the current view:
      view->getEntry(entry);
      //       and store it:
      switch(book->change(*current, entry))
	{
	case AddressBook::NoError:
	  emit(setStatus(i18n("Entry stored.")));
	  break;
	case AddressBook::PermDenied:
	  emit(setStatus(i18n("Permission denied.")));
	  return;
	default:
	  emit(setStatus(i18n("Internal error.")));
	  return;
	}
    }
  if(book->save("", true)!=AddressBook::NoError)
    {
      KMessageBox::sorry
	(this, i18n("The file could not be saved (permission denied)."),
	 i18n("kab: File error"));
    }
  // ----- finally say something and remember state:
  setStatus(i18n("File saved."));
  modified=false;
  // ###########################################################################
}

