/*
Donut Bump Mapping Demo
This demo shows how to use a bump mapping technique using Glide(tm)
Copyright (C) 1999  3Dfx Interactive, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef __MATHUTIL_H__
#define __MATHUTIL_H__

enum Axis
{
	X = 0,
	Y,
	Z,
	W
};

typedef float Vector[4];
typedef float Matrix[4][4];

#define PI              3.141594f

#define ABS(a)  ((a) >= 0 ? (a) : (-(a)))

#ifndef MIN
#define MIN(a, b)  ((a) < (b) ? (a) : (b))
#endif

#ifndef MAX
#define MAX(a, b)  ((a) > (b) ? (a) : (b))
#endif

#define CLAMP(a, min, max)  ( ((a) < (min)) ? (min) : ( ((a) > (max)) ? (max) : (a) ) )

#define DEG_TO_RAD(deg) ((deg)*(PI/180.0f))
#define RAD_TO_DEG(rad) ((rad)*(180.0f/PI))

#define SQR(f)  ((f)*(f))

#ifndef USE_GLIDE3
// glide2x needs 12.4 x, y coords
#define SNAP(f)  ((f) + (float)(3<<18))
#endif // !USE_GLIDE3
/*
__declspec(naked) inline float fsqrt(float f)
{
	__asm
	{
		fld			dword ptr [esp + 4]
		fsqrt
		ret
	}
}
*/

#define fsqrt(f)  ((float)sqrt(f))

/*
__declspec(naked) inline void fsincos(float angle, float *sin_angle, float *cos_angle)
{
	__asm
	{
		fld			dword ptr [esp + 4]
		fsincos
		mov			ecx, [esp + 8]
		mov			edx, [esp + 12]
		fstp		dword ptr [edx]
		fstp		dword ptr [ecx]
		ret
	}
}
*/
// function prototypes
void fsincos(float angle, float *sin_angle, float *cos_angle);
float fsqrt_inv(float f);
float DotProduct(Vector a, Vector b);
void CrossProduct(Vector v, Vector v1, Vector v2);
float NormZ(float *v0, float *v1, float *v2);
float Magnitude(Vector v);
float Distance(Vector v0, Vector v1);
void Normalize(Vector v);
void FastApproxNormalize(Vector v);
void RotateByXAxis(Vector res, Vector point, float angle);
void RotateByYAxis(Vector res, Vector point, float angle);
void RotateByZAxis(Vector res, Vector point, float angle);
void RotateByAxis(Vector res, Vector point, float angle, Vector rotation_axis);
void Transpose(Matrix res, Matrix m);
void MatMultMat4x4(Matrix res, Matrix m1, Matrix m2);
void MatMultMat3x4(Matrix res, Matrix m1, Matrix m2);
void MatMultVec3x3_2(Vector res, Matrix m, Vector v);
void MatMultVec3x4_3(Vector res, Matrix m, Vector v);
void MatMultVec3x4_4(Vector res, Matrix m, Vector v);
void MatMultVec4x4_3(Vector res, Matrix m, Vector v);
void MatMultVec4x4_4(Vector res, Matrix m, Vector v);
void IdentityMat(Matrix m);
void ScaleMat(Matrix m, float sx, float sy, float sz);
void TranslateMat(Matrix m, float dx, float dy, float dz);
void RotateXMat(Matrix m, float angle);
void RotateYMat(Matrix m, float angle);
void RotateZMat(Matrix m, float angle);
void ViewportMat(Matrix m, float min_x, float max_x, float min_y, float max_y, float min_z, float max_z);
void OrthoMat(Matrix m, float left_plane, float right_plane, float bottom_plane, float top_plane, float near_plane, float far_plane);
void FrustumMat(Matrix m, float left_plane, float right_plane, float bottom_plane, float top_plane, float near_plane, float far_plane);
void PerspectiveMat(Matrix m, float fovy, float aspect_ratio, float near_plane, float far_plane);
void ParallelMat(Matrix m, float fovy, float aspect_ratio, float near_plane, float far_plane);
void MatrixCopy(Matrix dst, Matrix src);


#endif // __MATHUTIL_H__
