/**
 *
 * $Id: Uil.c,v 1.4 1997/09/05 01:32:43 miers Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

static char *rcsid = "$Id: Uil.c,v 1.4 1997/09/05 01:32:43 miers Exp $";

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

#include <uil/UilDef.h>
#include <uil/UilSymDef.h>
#include <XmI/UilI.h>

/*
 * from uillex
 */
extern Uil_parse_data *parse_init(Uil_command_type *cmd,
				  Uil_compile_desc_type *desc);
extern int next_lexeme(Uil_parse_data *pd);
extern void parse_destroy(Uil_parse_data *pd);
extern Uil_status_type parse_module(Uil_parse_data *pd);
extern void dump_node(sym_entry_type *node_entry);


/*
 * compile a UIL file
 */
Uil_status_type
Uil(Uil_command_type *command_desc, Uil_compile_desc_type *compile_desc,
    Uil_continue_type(*message_cb)(), char *message_data,
    Uil_continue_type(*status_cb) (), char *status_data)
{
    Uil_parse_data *pd;
    Uil_status_type status;

    if ((pd = parse_init(command_desc, compile_desc)) == NULL)
    {
	return Uil_k_severe_status;
    }

    status = parse_module(pd);

    parse_destroy(pd);

    return status;
}

/*
 * dump a Uil generated symbol table
 */
void
UilDumpSymbolTable(sym_entry_type *node_entry)
{
    dump_node(node_entry);
}
