#include <stdio.h>
#include <string.h>

char pathname[1024];
static int ispipe;

void fpclose(FILE *fp) {
	if (ispipe)
	     pclose(fp);
	else
	     fclose(fp);
}

/* find input file; leave name in pathname[] */
FILE *findfile(char *fnam, char **dirpath, char **suffixes) {
        char **dp, **sp;
	FILE *fp;

	/* We might strip a `.gz' if given explicitly,
	   as in "loadkeys ./keymap.gz".  Maybe later. */

	ispipe = 0;
	for (dp = dirpath; *dp; dp++) {
	    if (*fnam == '/' && **dp)
	      continue;
	    for (sp = suffixes; *sp; sp++) {
		if (strlen(*dp) + strlen(fnam) + strlen(*sp) + 1
		    > sizeof(pathname))
		  continue;
		sprintf(pathname, "%s%s%s", *dp, fnam, *sp);
		if((fp = fopen(pathname, "r")) != NULL)
		  return fp;
	    }
	}

	/* cannot find file - maybe it was compressed? */
	ispipe = 1;
	for (dp = dirpath; *dp; dp++) {
	    if (*fnam == '/' && **dp)
	      continue;
	    for (sp = suffixes; *sp; sp++) {
		if (strlen(*dp) + strlen(fnam) + strlen(*sp) + 4
		    > sizeof(pathname))
		  continue;
		sprintf(pathname, "%s%s%s.gz", *dp, fnam, *sp);
		if((fp = fopen(pathname, "r")) != NULL) {
		     char cmd[sizeof(pathname) + 40];

		     fclose(fp);
		     sprintf(cmd, "gzip -d -c %s", pathname);
		     fp = popen(cmd, "r");
		     return fp;
		}
	    }
	}
	return NULL;
}
