#ifndef _DIRENT_H
#define _DIRENT_H

/* Emulating UNIX calls opendir() readdir() and closedir() */

typedef long DIR;

struct dirent {
	u_int8_t	d_type; 			/* file type, see below */
	u_int8_t	d_namlen;			/* length of string in d_name */
	char		d_name[_MAX_PATH];	/* name must be no longer than this */
};

DIR *opendir(const char *name);
struct dirent* readdir(DIR *dir);
void closedir(DIR *dir);

#endif