
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <limits.h>
#include "history.h"
#ifndef SKIPCONFIG
#include "../myconfig.h"
#endif
#ifdef SKIPGNOME
#undef USE_GNOME
#endif

#define snprintf g_snprintf

#ifdef MEMORY_DEBUG

#define malloc   xchat_malloc
#define free     xchat_free
#define g_malloc xchat_malloc
#define g_free   xchat_free

void *xchat_malloc (int size);
void free (void *buf);

#endif /* MEMORY_DEBUG */

#ifdef SOCKS
#include <socks.h>
#endif

#ifdef USE_GNOME

#include <gnome.h>
#undef GNOME_APP
#define GNOME_APP(n) ((GnomeApp*)n)

#else

#include "fake_gnome.h"
#ifdef ENABLE_NLS
#  include <libintl.h>
#  define _(x) gettext(x)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define N_(String) (String)
#  define _(x) (x)
#endif

#endif /* !USE_GNOME */

#ifdef __EMX__ /* for o/s 2 */
#define OFLAGS O_BINARY
#else
#define OFLAGS 0
#endif

#undef GTK_WINDOW
#undef GTK_BOX
#undef GTK_OBJECT
#undef GTK_CONTAINER
#undef GTK_CLIST
#undef GTK_TEXT
#undef GTK_LABEL
#undef GTK_ENTRY
#undef GTK_WIDGET
#undef GTK_MENU_BAR
#undef GTK_DIALOG
#undef GTK_FILE_SELECTION
#undef GTK_PANED
#undef GTK_TABLE
#undef GTK_DRAWING_AREA
#undef GTK_FONT_SELECTION_DIALOG
#undef GTK_SCROLLED_WINDOW
#undef GTK_TOGGLE_BUTTON
#undef GTK_NOTEBOOK
#undef GTK_MENU_ITEM
#undef GTK_CTREE

#define GTK_WINDOW(n) ((GtkWindow *)n)
#define GTK_BOX(n) ((GtkBox *)n)
#define GTK_OBJECT(n) ((GtkObject *)n)
#define GTK_CONTAINER(n) ((GtkContainer *)n)
#define GTK_CLIST(n) ((GtkCList *)n)
#define GTK_TEXT(n) ((GtkText *)n)
#define GTK_LABEL(n) ((GtkLabel *)n)
#define GTK_ENTRY(n) ((GtkEntry *)n)
#define GTK_WIDGET(n) ((GtkWidget *)n)
#define GTK_MENU_BAR(n) ((GtkMenuBar *)n)
#define GTK_DIALOG(n) ((GtkDialog *)n)
#define GTK_FILE_SELECTION(n) ((GtkFileSelection *)n)
#define GTK_PANED(n) ((GtkPaned *)n)
#define GTK_TABLE(n) ((GtkTable *)n)
#define GTK_DRAWING_AREA(n) ((GtkDrawingArea *)n)
#define GTK_FONT_SELECTION_DIALOG(n) ((GtkFontSelectionDialog *)n)
#define GTK_SCROLLED_WINDOW(n) ((GtkScrolledWindow *)n)
#define GTK_TOGGLE_BUTTON(n) ((GtkToggleButton *)n)
#define GTK_NOTEBOOK(n) ((GtkNotebook*)n)
#define GTK_MENU_ITEM(n) ((GtkMenuItem*)n)
#define GTK_CTREE(n) ((GtkCTree*)n)

#define	FONTNAMELEN	127

struct nbexec
{
   int myfd, childfd;
   int childpid;
   int tochannel;               /* making this int keeps the struct 4-byte aligned */
   gint iotag;
   struct session *sess;
};

struct xchatprefs
{
   char nick1[64];
   char nick2[64];
   char nick3[64];
   char realname[127];
   char username[127];
   char awayreason[256];
   char quitreason[256];
   char font_normal[FONTNAMELEN + 1];
   char font_bold[FONTNAMELEN + 1];
   char dialog_font_normal[FONTNAMELEN + 1];
   char dialog_font_bold[FONTNAMELEN + 1];
   char doubleclickuser[256];
   char sounddir[PATH_MAX + 1];
   char soundcmd[PATH_MAX + 1];
   char background[PATH_MAX + 1];
   char background_dialog[PATH_MAX + 1];
   char dccdir[PATH_MAX + 1];
   char bluestring[64];
   char dnsprogram[72];
   char hostname[127];
   char ipaddress[16];

   int bufsize;
   int zvt_lines;
   int notify_timeout;
   int dcctimeout;
   int dccstalltimeout;
   int mainwindow_left;
   int mainwindow_top;
   int mainwindow_width;
   int mainwindow_height;
   int dccpermissions;
   int recon_delay;
   int bantype;
   unsigned char nu_color;
   unsigned char bt_color;
   guint32 my_ip;
   guint32 local_ip;
   char local_name[127];

   unsigned int nopanel;
   unsigned int autosave;
   unsigned int autodialog;
   unsigned int autosave_url;
   unsigned int autoreconnect;
   unsigned int invisible;
   unsigned int servernotice;
   unsigned int wallops;
   unsigned int skipmotd;
   unsigned int away;
   unsigned int autorejoin;
   unsigned int colorednicks;
   unsigned int nochanmodebuttons;
   unsigned int nouserlistbuttons;
   unsigned int nickcompletion;
   unsigned int tabnicks;
   unsigned int tabchannels;
   unsigned int nopaned;
   unsigned int autodccchat;
   unsigned int autodccsend;
   unsigned int autoresume;
   unsigned int noautoopendccsendwindow;
   unsigned int noautoopendccrecvwindow;
   unsigned int noautoopendccchatwindow;
   unsigned int zvt;
   unsigned int transparent;
   unsigned int tint;
   unsigned int dialog_zvt;
   unsigned int dialog_transparent;
   unsigned int dialog_tint;
   unsigned int stripcolor;
   unsigned int timestamp;
   unsigned int fastdccsend;
   unsigned int skipserverlist;
   unsigned int filterbeep;
   unsigned int tabsatbottom;
   unsigned int beepmsg;
   unsigned int privmsgtab;
   unsigned int logging;
   unsigned int newtabstofront;
   unsigned int dccwithnick;
   unsigned int hilitenotify;
   unsigned int hidever;
   unsigned int ip_from_server;
   unsigned int detecthost;
   unsigned int detectip;
   unsigned int panelize_hide;
   unsigned int panel_vbox;
   unsigned int raw_modes;
   unsigned int no_server_logs;
   unsigned int show_away_once;
   unsigned int show_away_message;
   unsigned int nouserhost;
   unsigned int use_server_tab;
};

struct setup
{
   GtkWidget *settings_window;
   GtkWidget *nu_color;
   GtkWidget *bt_color;

   GtkWidget *font_normal;
   GtkWidget *font_bold;

   GtkWidget *dialog_font_normal;
   GtkWidget *dialog_font_bold;

   GtkWidget *entry_bluestring;
   GtkWidget *entry_doubleclickuser;
   GtkWidget *entry_zvt_lines;
   GtkWidget *entry_quit;
   GtkWidget *entry_away;
   GtkWidget *entry_bufsize;
   GtkWidget *entry_timeout;
   GtkWidget *entry_dccdir;
   GtkWidget *entry_dcctimeout;
   GtkWidget *entry_dccstalltimeout;
   GtkWidget *entry_permissions;
   GtkWidget *entry_dnsprogram;
   GtkWidget *entry_recon_delay;

   GtkWidget *entry_sounddir;
   GtkWidget *entry_soundcmd;

   GtkWidget *entry_mainw_left;
   GtkWidget *entry_mainw_top;
   GtkWidget *entry_mainw_width;
   GtkWidget *entry_mainw_height;

   GtkWidget *entry_hostname;
   GtkWidget *entry_ipaddress;

   GtkWidget *background;
   GtkWidget *background_dialog;

   GtkWidget *check_transparent;
   GtkWidget *check_tint;
   GtkWidget *check_detecthost;
   GtkWidget *check_detectip;
   GtkWidget *check_ip;

   GtkWidget *dialog_check_transparent;
   GtkWidget *dialog_check_tint;

   GtkWidget *cancel_button;

   struct xchatprefs prefs;
};

#define flag_t flag_wid[0]
#define flag_n flag_wid[1]
#define flag_s flag_wid[2]
#define flag_i flag_wid[3]
#define flag_p flag_wid[4]
#define flag_m flag_wid[5]
#define flag_l flag_wid[6]
#define flag_k flag_wid[7]

struct session
{
   GtkWidget *window;
   GtkWidget *vbox;
   GtkWidget *menu;
   GtkWidget *tbox;
   GtkWidget *changad;
   GtkWidget *topicgad;         /* FIXME: Pseudo union with ipgad --AGL */
   GtkWidget *textgad;
   GtkWidget *namelistgad;
   GtkWidget *nickgad;
   GtkWidget *inputgad;
   GtkWidget *namelistinfo;
   GtkWidget *paned;
   GtkWidget *vscrollbar;
   GtkWidget *op_box;
   GtkWidget *op_xpm;
   GtkWidget *userlistbox;
   GtkWidget *nl_box;
   GtkWidget *button_box;
   GtkWidget *bar;
   GtkWidget *leftpane;
   GtkWidget *confbutton;       /* conference mode button */
   int userlisthidden;

   GtkWidget *flag_wid[8];

   GtkWidget *limit_entry;      /* +l */
   GtkWidget *key_entry;        /* +k */
#ifdef USE_PANEL
   GtkWidget *panel_button;
#endif

   struct server *server;
   struct user *userlist;
   char channel[202];
   char waitchannel[202];       /* waiting to join this channel */
   char nick[202];
   char willjoinchannel[202];   /* /join done for this channel */
   char channelkey[64];         /* XXX correct max length? */
   int logfd;

   char lastnick[64];           /* last nick you /msg'ed */

   struct history history;

   int ops;                     /* num. of ops in channel */
   int total;                   /* num. of users in channel */

   char *quitreason;

   struct setup *setup;
   struct nbexec *running_exec;

   int is_shell:1;
   int is_tab:1;                /* is this a tab or toplevel window? */
   int is_dialog:1;
   int is_server:1;		  /* for use_server_tab feature */
   int new_data:1;              /* new data avail? (red tab) */
   int nick_said:1;             /* your nick mentioned? (green tab) */
   int zvt:1;                   /* using zvt instead of gtk_text? */
   int ignore_date:1;
   int ignore_mode:1;
   int ignore_names:1;
   int end_of_names:1;
   int doing_who:1;             /* /who sent on this channel */
};

struct server
{
   int port;
   int sok;
   int childread;
   int childpid;
   gint iotag;
   gint bartag;
   char hostname[128];          /* real ip number */
   char servername[128];        /* what the server says is its name */
   char password[86];
   char nick[64];
   char linebuf[2048];
   long pos;
   int nickcount;

   GSList *outbound_queue;
   time_t last_send;
   int bytes_sent;              /* this second only */

   struct session *front_session;

   GtkWidget *rawlog_window;
   GtkWidget *rawlog_textlist;

   GtkWidget *chanlist_wild;
   GtkWidget *chanlist_window;
   GtkWidget *chanlist_list;
   GtkWidget *chanlist_refresh;
   int chanlist_minusers;

   int motd_skipped:1;
   int connected:1;
   int connecting:1;
   int no_login:1;
   int skip_next_who:1;         /* used for "get my ip from server" */
   int inside_whois:1;
   int doing_who:1;             /* /dns has been done */
   int end_of_motd:1;		/* end of motd reached (logged in) */
};

struct DCC
{
   struct server *serv;
   char type;                   /* 0 = SEND  1 = RECV  2 = CHAT */
   char stat;                   /* 0 = QUEUED  1 = ACTIVE  2 = FAILED  3 = DONE */
   long sok;
   gint iotag;
   gint wiotag;
   unsigned long addr;
   unsigned long size;
   unsigned long resumable;
   unsigned long ack;
   unsigned long oldack;
   unsigned long pos;
   unsigned long oldpos;
   unsigned long starttime;
   unsigned long offertime;
   unsigned long lasttime;
   long port;
   long cps;
   gfloat perc;
   char file[128];
   char destfile[PATH_MAX + 1];
   char nick[64];
   int fp;                      /* file pointer */
   struct dccdraw *dccdraw;
   struct dcc_chat *dccchat;
   struct sockaddr_in SAddr;
   int fastsend:1;
};

typedef int (*cmd_callback) (struct session * sess, char *tbuf, char *word[], char *word_eol[]);

struct commands
{
   char *name;
   cmd_callback callback;
   char needserver;
   char needchannel;
   char *help;
};

struct away_msg
{
   struct server *server;
   char nick[64];
   char *message;
};
