/*******************************************************
 Modification of source written originally by Matt Smith
 (mds1281@ritvax.isc.rit.edu). GTK Support is currently
 being added by Jeremy Wise, jwise@pathwaynet.com.

 If distribution of this source code conflicts with the
 ICQ, GNU or any other licenses, please let me know
 immediately, as I will cease the distribution.
*******************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>

#include <unistd.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/time.h>

#include <fcntl.h>
#include <time.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <assert.h>

#include <gdk/gdk.h>

#ifdef HAVE_SOCKS5
#define SOCKS
#include <socks.h>
#endif

#include "tcp.h"

#include "events.h"

#include "gnomeicu.h"
#include "gtkfunc.h"

#include "pixmaps.h"
#include "msg_queue.h"

#include "applet.h"

typedef struct
{
	gpointer data;
	int i;
} dataandint;
      
GtkWidget *found_list;

typedef struct
{
	GtkWidget *dlg;
	GtkWidget *msg;
	GtkWidget *file;
	struct sokandlb *data;
	int uin;
} file_request_info;

int start_new_info = TRUE;

void add_user_from_info( GtkWidget *widget, dataandint *data );
void icq_allow_auth( GtkWidget *widget, int sock );
void icq_accept_chat( GtkWidget *widget, int cindex );
void icq_refuse_chat( GtkWidget *widget, int cindex );
void icq_accept_file( GtkWidget *widget, int cindex );
void icq_refuse_file( GtkWidget *widget, int cindex );
void begin_search( GtkWidget *widget, gpointer *entries );
void icq_refresh_list( GtkWidget *widget, struct sokandlb *data );
void send_file_request(GtkWidget *widget, file_request_info *data);
void file_chooser_set_retval( GtkWidget *widget, file_request_info *data);
void file_choose( GtkWidget *widget, file_request_info *data );
int ctrl_enter_cb( GtkWidget *widget, GdkEventKey *ev, int sock );
void clear_i_window( GtkWidget *wigdet, gpointer data );

void display_url( GtkWidget *widget, char *url )
{
#ifdef TRACE_FUNCTION
	g_print( "display_url\n" );
#endif

	gnome_url_show( url );
}

void add_user_from_info( GtkWidget *widget, dataandint *data )
{
	char name[16];

#ifdef TRACE_FUNCTION
	g_print( "add_user_from_info\n" );
#endif

	sprintf( name, "%d", data->i );
	Add_User( GPOINTER_TO_INT( data->data ), data->i, name );
}

void icq_allow_auth( GtkWidget *widget, int sock )
{
#ifdef TRACE_FUNCTION
	g_print( "icq_allow_auth\n" );
#endif

	icq_sendauthmsg( sock, GPOINTER_TO_INT( gtk_object_get_data( GTK_OBJECT( widget ), "uin" ) ) );
}

void icq_accept_chat( GtkWidget *widget, int cindex )
{
	int sock = Contacts[ cindex ].sok;
	DWORD seq = Contacts[ cindex ].chat_seq;

#ifdef TRACE_FUNCTION
	g_print( "icq_accept_chat\n" );
#endif

	TCPAcceptChat( sock, cindex, seq );
}

void icq_refuse_chat( GtkWidget *widget, int cindex )
{
	int sock = Contacts[ cindex ].sok;
	DWORD seq = Contacts[ cindex ].chat_seq;

#ifdef TRACE_FUNCTION
	g_print( "icq_refuse_chat\n" );
#endif

	TCPRefuseChat( sock, cindex, seq );
}

void icq_accept_file( GtkWidget *widget, int cindex )
{
	int sock = Contacts[ cindex ].sok;
	DWORD seq = Contacts[ cindex ].file_seq;

#ifdef TRACE_FUNCTION
	g_print( "icq_accept_file\n" );
#endif

	TCPAcceptFile( sock, cindex, seq );
}

void icq_refuse_file( GtkWidget *widget, int cindex )
{
	int sock = Contacts[ cindex ].sok;
	DWORD seq = Contacts[ cindex ].file_seq;

#ifdef TRACE_FUNCTION
	g_print( "icq_refuse_file\n" );
#endif

	TCPRefuseFile( sock, cindex, seq );
}

void begin_search( GtkWidget *widget, gpointer *entries )
{
#ifdef TRACE_FUNCTION
	g_print( "begin_search\n" );
#endif

	start_search( GPOINTER_TO_INT( entries[5] ),
	              gtk_entry_get_text( GTK_ENTRY( entries[4] ) ),
	              gtk_entry_get_text( GTK_ENTRY( entries[1] ) ),
	              gtk_entry_get_text( GTK_ENTRY( entries[2] ) ),
	              gtk_entry_get_text( GTK_ENTRY( entries[3] ) ),
	              atoi( gtk_entry_get_text( GTK_ENTRY( entries[0] ) ) ) );
	found_list = NULL;
}


void authorize_uin( GtkWidget *widget, struct sokandlb *data )
{
  int cx;
  GtkCList *clist = GTK_CLIST( data->lb_userwin );
  
#ifdef TRACE_FUNCTION
  g_print( "authorize_uin\n" );
#endif

  for( cx = 0; cx < Num_Contacts; cx++ )
    if( GPOINTER_TO_INT( clist->selection->data ) == Contacts[ cx ].lb_index )
      break;
  
  icq_sendauthmsg( data->sok, Contacts[ cx ].uin );
  /* g_print("authorize_uin(%ld)", Contacts[ cx ].uin ); */
}

void search_window( GtkWidget *widget, struct sokandlb *data )
{
	static GtkWidget *window = NULL;
	GtkWidget *table;
	GtkWidget *label; 
	GtkWidget *box;

	static GtkWidget *uin;
	static GtkWidget *nick;
	static GtkWidget *fname;
	static GtkWidget *lname;
	static GtkWidget *email;
	static GtkWidget *search_entries[6];

	GtkWidget *search_button;
	GtkWidget *close_button;

#ifdef TRACE_FUNCTION
	g_print( "search_window\n" );
#endif

	search_entries[ 5 ] = GINT_TO_POINTER( data->sok );

	window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	gtk_container_border_width( GTK_CONTAINER( window ), 10 );
	gtk_window_set_title( GTK_WINDOW( window ), "GnomeICU: Add Contact" );
	gtk_widget_set_usize( window, 265, 215 );
	
	table = gtk_table_new( 6, 2, FALSE );
	gtk_container_add( GTK_CONTAINER( window ), table );
	gtk_widget_show( table );

	uin = gtk_entry_new();
	search_entries[ 0 ] = uin;
	gtk_table_attach( GTK_TABLE( table ), uin, 1, 2, 0, 1, 0, 0, 5, 5 );
	gtk_widget_show( uin );
	label = gtk_label_new( "UIN:" );
	gtk_misc_set_alignment( GTK_MISC( label ), 1, 0.5 );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 0, 1, GTK_FILL, 0, 0, 5 );
	gtk_widget_show( label );

	nick = gtk_entry_new();
	search_entries[ 1 ] = nick;
	gtk_table_attach( GTK_TABLE( table ), nick, 1, 2, 1, 2, 0, 0, 5, 5 );
	gtk_widget_show( nick );
	label = gtk_label_new( "Nick Name:" );
	gtk_misc_set_alignment( GTK_MISC( label ), 1, 0.5 );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 1, 2, GTK_FILL, 0, 0, 5 );
	gtk_widget_show( label );

	fname = gtk_entry_new();
	search_entries[ 2 ] = fname;
	gtk_table_attach( GTK_TABLE( table ), fname, 1, 2, 2, 3, 0, 0, 5, 5 );
	gtk_widget_show( fname );
	label = gtk_label_new( "First Name:" );
	gtk_misc_set_alignment( GTK_MISC( label ), 1, 0.5 );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 2, 3, GTK_FILL, 0, 0, 5 );
	gtk_widget_show( label );

	lname = gtk_entry_new();
	search_entries[ 3 ] = lname;
	gtk_table_attach( GTK_TABLE( table ), lname, 1, 2, 3, 4, 0, 0, 5, 5 );
	gtk_widget_show( lname );
	label = gtk_label_new( "Last Name:" );
	gtk_misc_set_alignment( GTK_MISC( label ), 1, 0.5 );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 3, 4, GTK_FILL, 0, 0, 5 );
	gtk_widget_show( label );

	email = gtk_entry_new();
	search_entries[ 4 ] = email;
	gtk_table_attach( GTK_TABLE( table ), email, 1, 2, 4, 5, 0, 0, 5, 5 );
	gtk_widget_show( email );
	label = gtk_label_new( "eMail:" );
	gtk_misc_set_alignment( GTK_MISC( label ), 1, 0.5 );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 4, 5, GTK_FILL, 0, 0, 5 );
	gtk_widget_show( label );

	box = gtk_hbox_new( FALSE, 0 );
	search_button = gtk_button_new_with_label( "Search" );
   GTK_WIDGET_SET_FLAGS( search_button, GTK_CAN_DEFAULT );
	gtk_widget_set_usize( search_button, 35, 25 );
	gtk_signal_connect( GTK_OBJECT( search_button ), "clicked",
	                    GTK_SIGNAL_FUNC( begin_search ), search_entries );
	gtk_signal_connect_object( GTK_OBJECT( search_button ), "clicked",
	                           (GtkSignalFunc) gtk_widget_destroy,
	                           GTK_OBJECT( window ) );
	gtk_box_pack_start( GTK_BOX( box ), search_button, FALSE, FALSE, 5 );
	gtk_widget_set_usize( search_button, 80, 30 );
	gtk_widget_show( search_button );

	close_button = gtk_button_new_with_label( "Cancel" );
	gtk_widget_set_usize( close_button, 35, 25 );
	gtk_signal_connect_object( GTK_OBJECT( close_button ), "clicked",
	                           (GtkSignalFunc) gtk_widget_destroy,
	                           GTK_OBJECT( window ) );
	gtk_box_pack_start( GTK_BOX( box ), close_button, FALSE, FALSE, 5 );
	gtk_widget_set_usize( close_button, 80, 30 );
	gtk_widget_show( close_button );

	gtk_widget_show( box );
	gtk_table_attach( GTK_TABLE( table ), box, 1, 2, 5, 6, GTK_FILL, 0, 0, 0 );
	   
	gtk_widget_grab_default( search_button );
	gtk_widget_show( window );
}

void add_to_inv_list( GtkWidget *widget, struct sokandlb *data )
{
	int cx;
	GtkCList *clist = GTK_CLIST( data->lb_userwin );

#ifdef TRACE_FUNCTION
	g_print( "add_to_inv_list\n" );
#endif

	for( cx = 0; cx < Num_Contacts; cx++ )
	{
		if( GPOINTER_TO_INT( clist->selection->data ) ==
		    Contacts[ cx ].lb_index )
			break;
	}

	Contacts[ cx ].invis_list = TRUE;
	Contacts[ cx ].vis_list = FALSE;
	snd_invis_list( data->sok );
}

void remove_from_inv_list( GtkWidget *widget, struct sokandlb *data )
{
	int cx;
	GtkCList *clist = GTK_CLIST( data->lb_userwin );

#ifdef TRACE_FUNCTION
	g_print( "remove_from_inv_list\n" );
#endif

	for( cx = 0; cx < Num_Contacts; cx++ )
	{
		if( GPOINTER_TO_INT( clist->selection->data ) ==
		    Contacts[ cx ].lb_index )
			break;
	}

	Contacts[ cx ].invis_list = FALSE;
	snd_invis_list( data->sok );
}

void add_to_vis_list( GtkWidget *widget, struct sokandlb *data )
{
	int cx;
	GtkCList *clist = GTK_CLIST( data->lb_userwin );

#ifdef TRACE_FUNCTION
	g_print( "add_to_vis_list\n" );
#endif

	for( cx = 0; cx < Num_Contacts; cx++ )
	{
		if( GPOINTER_TO_INT( clist->selection->data ) ==
		    Contacts[ cx ].lb_index )
			break;
	}

	Contacts[ cx ].vis_list = TRUE;
	Contacts[ cx ].invis_list = FALSE;
	snd_vis_list( data->sok );
}

void remove_from_vis_list( GtkWidget *widget, struct sokandlb *data )
{
	int cx;
	GtkCList *clist = GTK_CLIST( data->lb_userwin );

#ifdef TRACE_FUNCTION
	g_print( "remove_from_vis_list\n" );
#endif

	for( cx = 0; cx < Num_Contacts; cx++ )
	{
		if( GPOINTER_TO_INT( clist->selection->data ) ==
		    Contacts[ cx ].lb_index )
			break;
	}

	Contacts[ cx ].vis_list = FALSE;
	snd_vis_list( data->sok );
}

void display_mess_history( GtkWidget *widget, struct sokandlb *data )
{
	int cx;
	GtkCList *clist = GTK_CLIST( data->lb_userwin );
	char buf[256];
	GtkWidget *button;
	GtkWidget *table;
	GtkWidget *mainbox;
	GtkWidget *scrollbar;
	GtkWidget *statusbar;
	GtkWidget *progress;
	GtkWidget *hbox;

	char filename[ 256 ];
	FILE *file;

#ifdef TRACE_FUNCTION
	g_print( "display_mess_history\n" );
#endif

	for( cx = 0; cx < Num_Contacts; cx++ )
	{
		if( GPOINTER_TO_INT( clist->selection->data ) ==
		    Contacts[ cx ].lb_index )
			break;
	}
	
	Contacts[ cx ].log_window = gtk_window_new( GTK_WINDOW_DIALOG );
	Contacts[ cx ].log_list = gtk_text_new( NULL, NULL );
/*	gtk_container_border_width( GTK_CONTAINER( Contacts[ cx ].log_window ), 10 );*/
	gtk_widget_set_usize( Contacts[ cx ].log_window, 450, 400 );
	sprintf( buf, "GnomeICU: Message History: %s", Contacts[ cx ].nick );
	gtk_window_set_title( GTK_WINDOW( Contacts[ cx ].log_window ), buf );
	gtk_signal_connect( GTK_OBJECT( Contacts[ cx ].log_window ), "destroy",
	                    GTK_SIGNAL_FUNC( gtk_widget_destroy ),
	                    &Contacts[ cx ].log_window );

	mainbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( Contacts[ cx ].log_window ), mainbox );
	gtk_widget_show( mainbox );
		
	table = gtk_table_new( 3, 2, FALSE );
	gtk_container_set_border_width( GTK_CONTAINER( table ), 10 );
	gtk_box_pack_start( GTK_BOX( mainbox ), table, TRUE, TRUE, 0 );

	gtk_table_attach( GTK_TABLE( table ), Contacts[ cx ].log_list, 0, 1, 0, 1,
	                  GTK_EXPAND | GTK_SHRINK | GTK_FILL,
	                  GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 5 );
		
	scrollbar = gtk_vscrollbar_new( GTK_TEXT( Contacts[ cx ].log_list )->vadj );
	gtk_table_attach( GTK_TABLE( table ), scrollbar, 1, 2, 0, 1,
	                  GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 5 );
	gtk_widget_show( scrollbar );
	gtk_widget_show( Contacts[ cx ].log_list );
	gtk_widget_show( table );
	gtk_widget_show( Contacts[ cx ].log_window );

	button = gtk_button_new_with_label( "Close" );
	gtk_widget_set_usize( button, 45, 25 );
	gtk_table_attach( GTK_TABLE( table ), button, 0, 2, 2, 3, 0, 0, 0, 0 );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
	                           GTK_SIGNAL_FUNC( gtk_widget_destroy ),
	                           GTK_OBJECT( Contacts[ cx ].log_window ) );
	gtk_widget_show( button );

	hbox = gtk_hbox_new( TRUE, 0 );
	gtk_box_pack_end( GTK_BOX( mainbox ), hbox, FALSE, FALSE, 0 );

	statusbar = gtk_statusbar_new();
	gtk_box_pack_start( GTK_BOX( hbox ), statusbar, TRUE, TRUE, 0 );
	gtk_widget_show( statusbar );

	gtk_statusbar_push( GTK_STATUSBAR( statusbar ), 1, "Loading Message History..." );

	progress = gtk_progress_bar_new();
	gtk_box_pack_start( GTK_BOX( hbox ), progress, TRUE, TRUE, 0 );
	gtk_widget_show( progress );

	gtk_widget_show( hbox );

	gtk_text_freeze( GTK_TEXT( Contacts[ cx ].log_list ) );
	sprintf( filename, "%s/.icq/history/%u", getenv( "HOME" ),
	         Contacts[ cx ].uin );

	file = fopen( filename, "r" );

	if( file )
	{
		char *buffer;
		char *ptr;
		struct stat fs;
		int nchars;
		int cy = 0;

		stat( filename, &fs );
		buffer = (char*)g_malloc( fs.st_size + 16 );
		nchars = fread( buffer, 1, fs.st_size, file );
		fclose( file );

		ptr = buffer;

		while( cy < nchars )
		{
			if( buffer[ cy ] == '*' )
			{
				if( buffer[ cy + 1 ] == '*' && buffer[ cy + 2 ] == '*' &&
				    buffer[ cy + 3 ] == ' ' )
				{
					buffer[ cy ] = 0x00;
					gtk_text_insert( GTK_TEXT( Contacts[ cx ].log_list ), NULL, NULL, NULL,
					                 ptr, -1 );

					ptr = &buffer[ cy ];
					buffer[ cy ] = '*';
					gtk_text_set_point( GTK_TEXT( Contacts[ cx ].log_list ), 0 );
					if( cy )
						gtk_progress_bar_update( GTK_PROGRESS_BAR( progress ),
						                         (float)((float)cy/(float)nchars) );

					while( gtk_events_pending() )
						gtk_main_iteration();
					         
				}
			}

			cy ++;
		}

		if( strlen( ptr ) )
		{
			buffer[ cy++ ] = '\n';
			buffer[ cy ] = 0x00;
			gtk_text_insert( GTK_TEXT( Contacts[ cx ].log_list ), NULL, NULL, NULL,
			                 ptr, -1 );
		}

		g_free( buffer );

		gtk_progress_bar_update( GTK_PROGRESS_BAR( progress ), 1.0F );
		gtk_statusbar_pop( GTK_STATUSBAR( statusbar ), 1 );
		gtk_statusbar_push( GTK_STATUSBAR( statusbar ), 1, "Finished" );

	}

	gtk_text_thaw( GTK_TEXT( Contacts[ cx ].log_list ) );
}

void send_url_window_default( GtkWidget *widget, struct sokandlb *data )
{
	send_url_window( widget, data, "" );
}

void send_url_window( GtkWidget *widget, struct sokandlb *data, char *defaulturl )
{
	int cx;
	GtkCList *clist = GTK_CLIST( data->lb_userwin );

	char title[64];

	GtkWidget *window;
	GtkWidget *table;
	GtkWidget *label;
	GtkWidget *button;
	GtkWidget *mainbox;
	GtkWidget *box;

	struct URLInfo *urlinfo = (struct URLInfo *)g_malloc( sizeof( struct URLInfo ) );

#ifdef TRACE_FUNCTION
	g_print( "send_url_window\n" );
#endif
	
	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( GPOINTER_TO_INT( clist->selection->data ) ==
		    Contacts[ cx ].lb_index )
			break;
	}

	urlinfo->cindex = cx;

	sprintf( title, "Send URL to: %s", Contacts[ cx ].nick );

	window = gtk_window_new( GTK_WINDOW_DIALOG );
	gtk_window_set_title( GTK_WINDOW( window ), "GnomeICU: Send URL" );
	gtk_container_border_width( GTK_CONTAINER( window ), 10 );
	gtk_widget_set_usize( window, 340, 160 );

	mainbox = gtk_vbox_new( 0, FALSE );
	gtk_container_add( GTK_CONTAINER( window ), mainbox );
	gtk_widget_show( mainbox );

	label = gtk_label_new( title );
	gtk_box_pack_start( GTK_BOX( mainbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );

	table = gtk_table_new( 3, 2, FALSE );
	gtk_box_pack_start( GTK_BOX( mainbox ), table, FALSE, FALSE, 0 );

	label = gtk_label_new( "URL:" );
	gtk_misc_set_alignment( GTK_MISC( label ), 1.0, 1.0 );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 0, 1,
	                  GTK_FILL, 0, 0, 10 );
	gtk_widget_show( label );
	
	label = gtk_label_new( "Description:" );
	gtk_misc_set_alignment( GTK_MISC( label ), 1.0, 1.0 );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 1, 2,
	                  GTK_FILL, 0, 0, 10 );
	gtk_widget_show( label );
	
	urlinfo->data = data;
	
	urlinfo->url = gtk_entry_new();
	gtk_table_attach( GTK_TABLE( table ), urlinfo->url, 1, 2, 0, 1, 0, 0, 0, 10 );
	gtk_entry_set_text( GTK_ENTRY( urlinfo->url ), defaulturl );
	gtk_widget_show( urlinfo->url );
	
	urlinfo->desc = gtk_entry_new();
	gtk_table_attach( GTK_TABLE( table ), urlinfo->desc, 1, 2, 1, 2, 0, 0, 0, 10 );
	gtk_widget_show( urlinfo->desc );
	
	box = gtk_hbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(box), GTK_BUTTONBOX_SPREAD);
	gtk_table_attach( GTK_TABLE( table ), box, 0, 2, 2, 3, 0, 0, 0, 10 );
	gtk_widget_show( box );
	
	button = gtk_button_new_with_label( "Send" );
	gtk_widget_set_usize( button, 100, 30 );
	gtk_container_add( GTK_CONTAINER( box ), button );

	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( icq_sendurl ), urlinfo );

	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
	                           GTK_SIGNAL_FUNC( gtk_widget_destroy ),
	                           GTK_OBJECT( window ) );

	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( "Cancel" );
	gtk_widget_set_usize( button, 100, 30 );
	gtk_container_add( GTK_CONTAINER( box ), button );

	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
	                           GTK_SIGNAL_FUNC( gtk_widget_destroy ),
	                           GTK_OBJECT( window ) );

	gtk_widget_show( button );

	gtk_widget_show( table );
	gtk_widget_show( window );
}

void send_chat_request( GtkWidget *widget, GtkWidget *entry )
{
	int cx;
	GtkCList *clist = GTK_CLIST( MainData->lb_userwin );

#ifdef TRACE_FUNCTION
	g_print( "request_chat\n" );
#endif

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( GPOINTER_TO_INT( clist->selection->data ) ==
		    Contacts[ cx ].lb_index )
			break;
	}

	TCPSendChatRequest( Contacts[ cx ].uin,
	                    gtk_entry_get_text( GTK_ENTRY( entry ) ), MainData );
}

void send_file_request(GtkWidget *widget, file_request_info *data)
{
	TCPSendFileRequest( data->uin,
	                    gtk_entry_get_text(GTK_ENTRY(data->msg)),
	                    gtk_entry_get_text(GTK_ENTRY(data->file)),
	                    data->data );

	gtk_widget_destroy(data->dlg);

	g_free(data);
}

void file_chooser_set_retval( GtkWidget *widget, file_request_info *data)
{
	GtkFileSelection *filesel=GTK_FILE_SELECTION(widget->parent->parent->parent);
	gtk_entry_set_text(GTK_ENTRY(data->file),
	                   gtk_file_selection_get_filename(filesel));
	gtk_widget_destroy(GTK_WIDGET(filesel));
}

void file_choose( GtkWidget *widget, file_request_info *data )
{
	GtkWidget *filesel;
#ifdef TRACE_FUNCTION
	g_print( "file_choose\n" );
#endif

	filesel = gtk_file_selection_new("GnomeICU: File Transfer");

	gtk_file_selection_set_filename(GTK_FILE_SELECTION(filesel),
	                                gtk_entry_get_text(GTK_ENTRY(data->file)));
	gtk_signal_connect(GTK_OBJECT(filesel), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filesel)->ok_button),
	                   "clicked", GTK_SIGNAL_FUNC(file_chooser_set_retval), data );
	                   gtk_signal_connect_object(GTK_OBJECT (GTK_FILE_SELECTION
	                   (filesel)->cancel_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy),
	                   GTK_OBJECT( filesel ) );

	gtk_widget_show(filesel);
}

void request_file( GtkWidget *widget, struct sokandlb *data, char *defaultfile )
{
	int cx;
	GtkCList *clist = GTK_CLIST( data->lb_userwin );
	GtkWidget *button,*table,*box;
	file_request_info *request;

#ifdef TRACE_FUNCTION
	g_print( "request_file\n" );
#endif

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( GPOINTER_TO_INT( clist->selection->data ) ==
		    Contacts[ cx ].lb_index )
			break;
	}

	request=g_new(file_request_info,1);

	request->uin = Contacts[ cx ].uin;

	request->dlg=gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(request->dlg),"GnomeICU: Send File");

	table=gtk_table_new(1,1,FALSE);

	request->file=gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(request->file), defaultfile);

	request->msg=gtk_entry_new();

	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new("Message:"), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), request->msg, 1, 2, 0, 1);

	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new("File:"), 0, 1, 1, 2);

	box=gtk_hbox_new(FALSE, 2);
	button=gtk_button_new_with_label("Choose...");
	gtk_signal_connect(GTK_OBJECT(button), "clicked", file_choose, request);

	gtk_container_add(GTK_CONTAINER(box), request->file);
	gtk_container_add(GTK_CONTAINER(box), button);

	gtk_table_attach_defaults(GTK_TABLE(table), box, 1, 2, 1, 2);

	gtk_table_set_col_spacings(GTK_TABLE(table), 4);
	gtk_table_set_row_spacings(GTK_TABLE(table), 4);

	gtk_container_set_border_width(GTK_CONTAINER(table), 4);

	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(request->dlg)->vbox), table);

	button=gtk_button_new_with_label("Send");
	gtk_signal_connect(GTK_OBJECT(button), "clicked", send_file_request, request);

	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(request->dlg)->action_area), button);

	button=gtk_button_new_with_label("Cancel");
	gtk_signal_connect_object(GTK_OBJECT(button),
	                          "clicked",
	                          GTK_SIGNAL_FUNC(gtk_widget_destroy),
	                          GTK_OBJECT(request->dlg));

	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(request->dlg)->action_area), button);

	gtk_widget_show_all(request->dlg);
	gtk_widget_show(request->dlg);
}

void request_chat( GtkWidget *widget, struct sokandlb *data )
{
	int cx;
	GtkCList *clist = GTK_CLIST( data->lb_userwin );
	GtkWidget *button,*table;
	GtkWidget *window, *entry;

#ifdef TRACE_FUNCTION
	g_print( "request_chat\n" );
#endif

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( GPOINTER_TO_INT( clist->selection->data ) ==
		    Contacts[ cx ].lb_index )
			break;
	}

	window = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW( window ),"GnomeICU: Send Chat Request");

	table=gtk_table_new(1,1,FALSE);

	entry = gtk_entry_new();

	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new("Reason:"), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), entry, 1, 2, 0, 1);

	gtk_signal_connect( GTK_OBJECT( entry ), "activate", send_chat_request,
	                    entry );
	gtk_signal_connect_object( GTK_OBJECT( entry ), "activate",
	                    GTK_SIGNAL_FUNC( gtk_widget_destroy ),
	                    GTK_OBJECT( window ) );

	gtk_table_set_col_spacings(GTK_TABLE(table), 4);
	gtk_table_set_row_spacings(GTK_TABLE(table), 4);

	gtk_container_set_border_width(GTK_CONTAINER(table), 4);

	gtk_container_add(GTK_CONTAINER(GTK_DIALOG( window )->vbox), table);

	button=gtk_button_new_with_label("Send");
	gtk_signal_connect(GTK_OBJECT(button), "clicked", send_chat_request, entry );
	gtk_signal_connect_object(GTK_OBJECT(button),
	                          "clicked",
	                          GTK_SIGNAL_FUNC(gtk_widget_destroy),
	                          GTK_OBJECT( window ) );

	gtk_container_add(GTK_CONTAINER(GTK_DIALOG( window )->action_area), button);

	button=gtk_button_new_with_label("Cancel");
	gtk_signal_connect_object(GTK_OBJECT(button),
	                          "clicked",
	                          GTK_SIGNAL_FUNC(gtk_widget_destroy),
	                          GTK_OBJECT( window ) );

	gtk_container_add(GTK_CONTAINER(GTK_DIALOG( window )->action_area), button);

	gtk_widget_show_all( window );
	gtk_widget_show( window );
}

void request_file_default( GtkWidget *widget, struct sokandlb *data )
{
	request_file( widget, data, "" );
}

void remove_user( GtkWidget *widget, struct sokandlb *data )
{
	int cindex, cx;
	int lb_index;
	GtkCList *clist = GTK_CLIST( data->lb_userwin );
	GtkWidget *dialog;

#ifdef TRACE_FUNCTION
	g_print( "remove_user\n" );
#endif

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( GPOINTER_TO_INT( clist->selection->data ) ==
		    Contacts[ cx ].lb_index )
		{
			break;
		}
	}

	if( Contacts[ cx ].status == STATUS_OFFLINE )
		data->offline --;
	else
		data->online --;

	cindex = cx;
	lb_index = Contacts[ cx ].lb_index;

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( Contacts[ cx ].lb_index > lb_index )
			Contacts[ cx ].lb_index --;
	}

	memset( &Contacts[ cindex ], 0x00, sizeof( Contact_Member ) );

	for( cx = cindex + 1; cx < Num_Contacts; cx ++ )
		memcpy( &Contacts[ cx - 1 ], &Contacts[ cx ], sizeof( Contact_Member ) );

	Num_Contacts --;
	gtk_clist_remove( GTK_CLIST( data->lb_userwin ), lb_index );

	dialog = gnome_message_box_new( _("User list has changed.  Do you\nwish to save these changes?"),
	                                GNOME_MESSAGE_BOX_QUESTION,
	                                GNOME_STOCK_BUTTON_YES, GNOME_STOCK_BUTTON_NO, NULL );
	gnome_dialog_button_connect( GNOME_DIALOG( dialog ), 0,
	                             GTK_SIGNAL_FUNC( Save_RC ), NULL );
	gtk_widget_show( dialog );
}

void retrieve_away_message( GtkWidget *widget, struct sokandlb *data )
{
	int cx;
	GtkCList *clist = GTK_CLIST( data->lb_userwin );

#ifdef TRACE_FUNCTION
	g_print( "retreive_away_message\n" );
#endif

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( GPOINTER_TO_INT( clist->selection->data ) ==
		    Contacts[ cx ].lb_index )
		{
			break;
		}
	}

	Contacts[ cx ].show_again = TRUE;

	TCPRetrieveAwayMessage( cx, data );
}

void show_personal_info( GtkWidget *widget, struct sokandlb *data )
{
	int cx;
	GtkCList *clist = GTK_CLIST( data->lb_userwin );

#ifdef TRACE_FUNCTION
	g_print( "show_personal_info\n" );
#endif

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( GPOINTER_TO_INT( clist->selection->data ) ==
		    Contacts[ cx ].lb_index )
		{
			break;
		}
	}
	send_info_req( data->sok, Contacts[ cx ].uin );
	send_ext_info_req( data->sok, Contacts[ cx ].uin );

	dump_personal_info( Contacts[ cx ].uin );
}

void dump_personal_info( DWORD uin )
{
	int cx;
	char *string;
	GtkWidget *table;
	GtkWidget *label;
	GtkWidget *button;
	GtkWidget *vbutton;
	GtkWidget *notebook;
	GtkWidget *mainbox;
	GtkWidget *hbox;
	GtkWidget *scrollbar;

#ifdef TRACE_FUNCTION
	g_print( "dump_personal_info\n" );
#endif

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( uin == Contacts[ cx ].uin )
			break;
	}

	Contacts[ cx ].info->ip = (char*)g_malloc( 17 );
	Contacts[ cx ].info->port = (char*)g_malloc( 6 );
	if( Contacts[ cx ].current_ip != -1 )
	{
		sprintf( Contacts[ cx ].info->ip, "%u.%u.%u.%u",
		         (BYTE) (Contacts[ cx ].current_ip >> 24),
		         (BYTE) (Contacts[ cx ].current_ip >> 16),
		         (BYTE) (Contacts[ cx ].current_ip >> 8),
		         (BYTE) (Contacts[ cx ].current_ip) );
		sprintf( Contacts[ cx ].info->port, "%u", Contacts[ cx ].port );
	}
	else
	{
		strcpy( Contacts[ cx ].info->ip, "N/A" );
		strcpy( Contacts[ cx ].info->port, "N/A" );
	}

	if( Contacts[ cx ].info->window == NULL )
	{
		Contacts[ cx ].info->window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
		gtk_container_border_width( GTK_CONTAINER( Contacts[ cx ].info->window ), 10 );
		gtk_window_set_title( GTK_WINDOW( Contacts[ cx ].info->window ), "GnomeICU: User Information" );

		gtk_signal_connect( GTK_OBJECT( Contacts[ cx ].info->window ), "destroy",
		                    (GtkSignalFunc)clear_i_window,
		                    GINT_TO_POINTER( Contacts[ cx ].uin ) );

		mainbox = gtk_vbox_new( FALSE, 0 );
		gtk_container_add( GTK_CONTAINER( Contacts[ cx ].info->window ), mainbox );

		notebook = gtk_notebook_new();
		gtk_notebook_set_tab_pos( GTK_NOTEBOOK( notebook ), GTK_POS_TOP );
		gtk_box_pack_start( GTK_BOX( mainbox ), notebook, FALSE, FALSE, 10 );

/** General Tab **/

		table = gtk_table_new( 4, 7, FALSE );
		gtk_container_set_border_width( GTK_CONTAINER( table ), 7 );
		gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), table,
		                          gtk_label_new( "General" ) );

		label = gtk_label_new( "UIN:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 0, 1, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( "Nick:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 3, 4, 0, 1, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );
		
		label = gtk_label_new( "F. Name:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 2, 3, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( "L. Name:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 3, 4, 2, 3, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );
		
		label = gtk_label_new( "Sex:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 3, 4, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( "Age:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 3, 4, 3, 4, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( "Alias:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 3, 4, 1, 2, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( "Auth:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 1, 2, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		Contacts[ cx ].info->w_uin = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), Contacts[ cx ].info->w_uin,
		                  1, 2, 0, 1, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( Contacts[ cx ].info->w_uin ), FALSE );
		gtk_widget_show( Contacts[ cx ].info->w_uin );

		Contacts[ cx ].info->w_nick = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), Contacts[ cx ].info->w_nick,
		                  4, 7, 0, 1, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( Contacts[ cx ].info->w_nick ), FALSE );
		gtk_widget_show( Contacts[ cx ].info->w_nick );

		Contacts[ cx ].info->w_first = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), Contacts[ cx ].info->w_first,
		                  1, 3, 2, 3, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( Contacts[ cx ].info->w_first ), FALSE );
		gtk_widget_show( Contacts[ cx ].info->w_first );

		Contacts[ cx ].info->w_last = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), Contacts[ cx ].info->w_last,
		                  4, 7, 2, 3, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( Contacts[ cx ].info->w_last ), FALSE );
		gtk_widget_show( Contacts[ cx ].info->w_last );

		Contacts[ cx ].info->w_sex = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), Contacts[ cx ].info->w_sex,
		                  1, 2, 3, 4, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( Contacts[ cx ].info->w_sex ), FALSE );
		gtk_widget_show( Contacts[ cx ].info->w_sex );

		Contacts[ cx ].info->w_age = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), Contacts[ cx ].info->w_age,
		                  4, 7, 3, 4, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( Contacts[ cx ].info->w_age ), FALSE );
		gtk_widget_show( Contacts[ cx ].info->w_age );

		Contacts[ cx ].info->w_alias = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), Contacts[ cx ].info->w_alias,
		                  4, 6, 1, 2, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( Contacts[ cx ].info->w_alias ), FALSE );
		gtk_widget_show( Contacts[ cx ].info->w_alias );

		button = gtk_button_new_with_label( "Set" );
		gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		                    (GtkSignalFunc)change_nick_window,
		                    GINT_TO_POINTER( Contacts[ cx ].uin ) );
		gtk_table_attach( GTK_TABLE( table ), button,
		                  6, 7, 1, 2, GTK_FILL | GTK_EXPAND, GTK_FILL, 0, 5 );
		gtk_widget_show( button );

		Contacts[ cx ].info->w_auth = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), Contacts[ cx ].info->w_auth,
		                  1, 2, 1, 2, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( Contacts[ cx ].info->w_auth ), FALSE );
		gtk_widget_show( Contacts[ cx ].info->w_auth );

		gtk_widget_show( table );

/** Internet Tab **/
		table = gtk_table_new( 3, 2, FALSE );
		gtk_container_set_border_width( GTK_CONTAINER( table ), 7 );
		gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), table,
		                          gtk_label_new( "Internet" ) );

		label = gtk_label_new( "IP:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 0, 1, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( "Port:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 1, 2, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( "Email:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 2, 3, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		Contacts[ cx ].info->w_ip = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), Contacts[ cx ].info->w_ip,
		                  1, 2, 0, 1, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( Contacts[ cx ].info->w_ip ), FALSE );
		gtk_widget_show( Contacts[ cx ].info->w_ip );

		Contacts[ cx ].info->w_port = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), Contacts[ cx ].info->w_port,
		                  1, 2, 1, 2, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( Contacts[ cx ].info->w_port ), FALSE );
		gtk_widget_show( Contacts[ cx ].info->w_port );

		Contacts[ cx ].info->w_email = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), Contacts[ cx ].info->w_email,
		                  1, 2, 2, 3, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_widget_set_usize( Contacts[ cx ].info->w_email, 200, 0 );
		gtk_entry_set_editable( GTK_ENTRY( Contacts[ cx ].info->w_email ), FALSE );
		gtk_widget_show( Contacts[ cx ].info->w_email );

		gtk_widget_show( table );

/** Location Tab **/
		table = gtk_table_new( 3, 2, FALSE );
		gtk_container_set_border_width( GTK_CONTAINER( table ), 7 );
		gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), table,
		                          gtk_label_new( "Location" ) );

		label = gtk_label_new( "Phone:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 0, 1, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( "City:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 1, 2, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( "State:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 2, 3, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		Contacts[ cx ].info->w_phone = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), Contacts[ cx ].info->w_phone,
		                  1, 2, 0, 1, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( Contacts[ cx ].info->w_phone ), FALSE );
		gtk_widget_show( Contacts[ cx ].info->w_phone );

		Contacts[ cx ].info->w_city = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), Contacts[ cx ].info->w_city,
		                  1, 2, 1, 2, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( Contacts[ cx ].info->w_city ), FALSE );
		gtk_widget_show( Contacts[ cx ].info->w_city );

		Contacts[ cx ].info->w_state = gtk_entry_new();
		if( Contacts[ cx ].info->state != NULL )
			gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].info->w_state ), Contacts[ cx ].info->state );

		gtk_table_attach( GTK_TABLE( table ), Contacts[ cx ].info->w_state,
		                  1, 2, 2, 3, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( Contacts[ cx ].info->w_state ), FALSE );
		gtk_widget_show( Contacts[ cx ].info->w_state );

		gtk_widget_show( table );

/** About Tab **/
		table = gtk_table_new( 3, 3, FALSE );
		gtk_container_set_border_width( GTK_CONTAINER( table ), 7 );
		gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), table,
		                          gtk_label_new( "About" ) );

		label = gtk_label_new( "Home Page:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 0, 1, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( "About:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 0, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 1, 2, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		Contacts[ cx ].info->w_homepage = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), Contacts[ cx ].info->w_homepage,
		                  1, 2, 0, 1, GTK_FILL | GTK_EXPAND, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( Contacts[ cx ].info->w_homepage ), FALSE );
		gtk_widget_show( Contacts[ cx ].info->w_homepage );

		vbutton = gtk_button_new_with_label( "View" );
		gtk_table_attach( GTK_TABLE( table ), vbutton,
		                  2, 3, 0, 1, GTK_FILL, 0, 0, 0 );

		gtk_signal_connect( GTK_OBJECT( vbutton ), "clicked",
		                    GTK_SIGNAL_FUNC( display_url_from_entry ),
		                    Contacts[ cx ].info->w_homepage );

		gtk_widget_show( vbutton );

		hbox = gtk_hbox_new( FALSE, 0 );
		Contacts[ cx ].info->w_about = gtk_text_new( NULL, NULL );
		gtk_text_set_word_wrap( GTK_TEXT( Contacts[ cx ].info->w_about ), TRUE );

		gtk_box_pack_start( GTK_BOX( hbox ), Contacts[ cx ].info->w_about, TRUE, TRUE, 0 );
		gtk_widget_show( Contacts[ cx ].info->w_about );

		scrollbar = gtk_vscrollbar_new( GTK_TEXT( Contacts[ cx ].info->w_about )->vadj );
		gtk_box_pack_start( GTK_BOX( hbox ), scrollbar, FALSE, FALSE, 0 );
		gtk_widget_show( scrollbar );


		gtk_table_attach( GTK_TABLE( table ), hbox,
		                  0, 3, 2, 3, GTK_FILL | GTK_EXPAND,
		                  GTK_FILL | GTK_EXPAND, 5, 5 );

		gtk_widget_show( hbox );
		gtk_widget_show( table );

		hbox = gtk_hbutton_box_new();
		gtk_button_box_set_layout( GTK_BUTTON_BOX( hbox ),
		                           GTK_BUTTONBOX_SPREAD );

		button = gtk_button_new_with_label( "Close" );
		gtk_widget_set_usize( button, 55, 30 );
		gtk_box_pack_end( GTK_BOX( mainbox ), hbox, FALSE, FALSE, 0 );
		gtk_box_pack_end( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
		gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		                    (GtkSignalFunc) gtk_widget_destroy,
		                    GTK_OBJECT( Contacts[ cx ].info->window ) );
		gtk_widget_show( hbox );
		gtk_widget_show( button );

		gtk_widget_show( notebook );
		gtk_widget_show( mainbox );
		gtk_widget_show( Contacts[ cx ].info->window );
	}

	string = (char*)g_malloc( 16 );
	if( Contacts[ cx ].info->uin )
		sprintf( string, "%u", Contacts[ cx ].info->uin );
	else
		strcpy( string, "Unknown" );
	gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].info->w_uin ), string );
	g_free( string );

	if( Contacts[ cx ].info->nick != NULL )
		gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].info->w_nick ), Contacts[ cx ].info->nick );

	if( Contacts[ cx ].info->first != NULL )
		gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].info->w_first ), Contacts[ cx ].info->first );

	if( Contacts[ cx ].info->last != NULL )
		gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].info->w_last ), Contacts[ cx ].info->last );

	if( Contacts[ cx ].info->sex == MALE )
		gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].info->w_sex ), "Male" );
	else if( Contacts[ cx ].info->sex == FEMALE )
		gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].info->w_sex ), "Female" );
	else
		gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].info->w_sex ), "Unknown" );

	string = (char*)g_malloc( 8 );
	if( Contacts[ cx ].info->age )
		sprintf( string, "%d", Contacts[ cx ].info->age % 1000 );
	else
		strcpy( string, "Unknown" );
	gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].info->w_age ), string );
	g_free( string );

	if( Contacts[ cx ].nick != NULL )
		gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].info->w_alias ), Contacts[ cx ].nick );

	if( Contacts[ cx ].info->auth )
		gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].info->w_auth ), "Auth required" );
	else
		gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].info->w_auth ), "No auth required" );

	if( Contacts[ cx ].info->uin == 0 )
		gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].info->w_auth ), "Unknown" );

	if( Contacts[ cx ].info->ip != NULL )
		gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].info->w_ip ), Contacts[ cx ].info->ip );

	if( Contacts[ cx ].info->port != NULL )
		gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].info->w_port ), Contacts[ cx ].info->port );

	if( Contacts[ cx ].info->email != NULL )
		gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].info->w_email ), Contacts[ cx ].info->email );

	if( Contacts[ cx ].info->phone != NULL )
		gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].info->w_phone ), Contacts[ cx ].info->phone );

	if( Contacts[ cx ].info->city != NULL )
		gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].info->w_city ), Contacts[ cx ].info->city );

	if( Contacts[ cx ].info->state != NULL )
		gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].info->w_state ), Contacts[ cx ].info->state );

	if( Contacts[ cx ].info->homepage != NULL )
		gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].info->w_homepage ), Contacts[ cx ].info->homepage );

	if( Contacts[ cx ].info->about != NULL )
	{
		gtk_text_freeze( GTK_TEXT( Contacts[ cx ].info->w_about ) );
		gtk_text_insert( GTK_TEXT( Contacts[ cx ].info->w_about ), NULL, NULL, NULL,
		                 Contacts[ cx ].info->about, -1 );
		gtk_text_thaw( GTK_TEXT( Contacts[ cx ].info->w_about ) );
	}
}

void show_info_new( SOK_T sok, int uin )
{
	char *string;
	GtkWidget *table;
	GtkWidget *label;
	GtkWidget *button;
	GtkWidget *vbutton;
	GtkWidget *notebook;
	GtkWidget *mainbox;
	GtkWidget *hbox;
	GtkWidget *scrollbar;
	static dataandint data;
	static int first = TRUE;

#ifdef TRACE_FUNCTION
	g_print( "show_info_new\n" );
#endif

	if( first )
	{
		memset( &New_Contact, 0x00, sizeof( New_Contact ) );
		New_Contact.info = (USER_INFO_PTR)g_malloc( sizeof( USER_INFO_STRUCT ) );
		memset( New_Contact.info, 0x00, sizeof( USER_INFO_STRUCT ) );
		first = FALSE;
	}

	if( New_Contact.info->window == NULL )
	{
		New_Contact.info->window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
		gtk_container_border_width( GTK_CONTAINER( New_Contact.info->window ), 10 );
		gtk_window_set_title( GTK_WINDOW( New_Contact.info->window ), "GnomeICU: User Information" );

		gtk_signal_connect( GTK_OBJECT( New_Contact.info->window ), "destroy",
		                    (GtkSignalFunc)clear_i_window,
		                    GINT_TO_POINTER( New_Contact.uin ) );

		mainbox = gtk_vbox_new( FALSE, 0 );
		gtk_container_add( GTK_CONTAINER( New_Contact.info->window ), mainbox );

		notebook = gtk_notebook_new();
		gtk_notebook_set_tab_pos( GTK_NOTEBOOK( notebook ), GTK_POS_TOP );
		gtk_box_pack_start( GTK_BOX( mainbox ), notebook, FALSE, FALSE, 10 );

/** General Tab **/

		table = gtk_table_new( 4, 7, FALSE );
		gtk_container_set_border_width( GTK_CONTAINER( table ), 7 );
		gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), table,
		                          gtk_label_new( "General" ) );

		label = gtk_label_new( "UIN:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 0, 1, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( "Nick:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 3, 4, 0, 1, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );
		
		label = gtk_label_new( "F. Name:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 2, 3, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( "L. Name:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 3, 4, 2, 3, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );
		
		label = gtk_label_new( "Sex:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 3, 4, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( "Age:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 3, 4, 3, 4, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( "Alias:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 3, 4, 1, 2, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( "Auth:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 1, 2, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		New_Contact.info->w_uin = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), New_Contact.info->w_uin,
		                  1, 2, 0, 1, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( New_Contact.info->w_uin ), FALSE );
		gtk_widget_show( New_Contact.info->w_uin );

		New_Contact.info->w_nick = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), New_Contact.info->w_nick,
		                  4, 7, 0, 1, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( New_Contact.info->w_nick ), FALSE );
		gtk_widget_show( New_Contact.info->w_nick );

		New_Contact.info->w_first = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), New_Contact.info->w_first,
		                  1, 3, 2, 3, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( New_Contact.info->w_first ), FALSE );
		gtk_widget_show( New_Contact.info->w_first );

		New_Contact.info->w_last = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), New_Contact.info->w_last,
		                  4, 7, 2, 3, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( New_Contact.info->w_last ), FALSE );
		gtk_widget_show( New_Contact.info->w_last );

		New_Contact.info->w_sex = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), New_Contact.info->w_sex,
		                  1, 2, 3, 4, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( New_Contact.info->w_sex ), FALSE );
		gtk_widget_show( New_Contact.info->w_sex );

		New_Contact.info->w_age = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), New_Contact.info->w_age,
		                  4, 7, 3, 4, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( New_Contact.info->w_age ), FALSE );
		gtk_widget_show( New_Contact.info->w_age );

		New_Contact.info->w_alias = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), New_Contact.info->w_alias,
		                  4, 6, 1, 2, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( New_Contact.info->w_alias ), FALSE );
		gtk_widget_show( New_Contact.info->w_alias );

		button = gtk_button_new_with_label( "Set" );
		gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		                    (GtkSignalFunc)change_nick_window,
		                    GINT_TO_POINTER( New_Contact.uin ) );
		gtk_table_attach( GTK_TABLE( table ), button,
		                  6, 7, 1, 2, GTK_FILL | GTK_EXPAND, GTK_FILL, 0, 5 );
		gtk_widget_show( button );

		New_Contact.info->w_auth = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), New_Contact.info->w_auth,
		                  1, 2, 1, 2, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( New_Contact.info->w_auth ), FALSE );
		gtk_widget_show( New_Contact.info->w_auth );

		gtk_widget_show( table );

/** Internet Tab **/
		table = gtk_table_new( 3, 2, FALSE );
		gtk_container_set_border_width( GTK_CONTAINER( table ), 7 );
		gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), table,
		                          gtk_label_new( "Internet" ) );

		label = gtk_label_new( "IP:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 0, 1, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( "Port:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 1, 2, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( "Email:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 2, 3, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		New_Contact.info->w_ip = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), New_Contact.info->w_ip,
		                  1, 2, 0, 1, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( New_Contact.info->w_ip ), FALSE );
		gtk_widget_show( New_Contact.info->w_ip );

		New_Contact.info->w_port = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), New_Contact.info->w_port,
		                  1, 2, 1, 2, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( New_Contact.info->w_port ), FALSE );
		gtk_widget_show( New_Contact.info->w_port );

		New_Contact.info->w_email = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), New_Contact.info->w_email,
		                  1, 2, 2, 3, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_widget_set_usize( New_Contact.info->w_email, 200, 0 );
		gtk_entry_set_editable( GTK_ENTRY( New_Contact.info->w_email ), FALSE );
		gtk_widget_show( New_Contact.info->w_email );

		gtk_widget_show( table );

/** Location Tab **/
		table = gtk_table_new( 3, 2, FALSE );
		gtk_container_set_border_width( GTK_CONTAINER( table ), 7 );
		gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), table,
		                          gtk_label_new( "Location" ) );

		label = gtk_label_new( "Phone:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 0, 1, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( "City:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 1, 2, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( "State:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 2, 3, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		New_Contact.info->w_phone = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), New_Contact.info->w_phone,
		                  1, 2, 0, 1, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( New_Contact.info->w_phone ), FALSE );
		gtk_widget_show( New_Contact.info->w_phone );

		New_Contact.info->w_city = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), New_Contact.info->w_city,
		                  1, 2, 1, 2, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( New_Contact.info->w_city ), FALSE );
		gtk_widget_show( New_Contact.info->w_city );

		New_Contact.info->w_state = gtk_entry_new();
		if( New_Contact.info->state != NULL )
			gtk_entry_set_text( GTK_ENTRY( New_Contact.info->w_state ), New_Contact.info->state );

		gtk_table_attach( GTK_TABLE( table ), New_Contact.info->w_state,
		                  1, 2, 2, 3, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( New_Contact.info->w_state ), FALSE );
		gtk_widget_show( New_Contact.info->w_state );

		gtk_widget_show( table );

/** About Tab **/
		table = gtk_table_new( 3, 3, FALSE );
		gtk_container_set_border_width( GTK_CONTAINER( table ), 7 );
		gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), table,
		                          gtk_label_new( "About" ) );

		label = gtk_label_new( "Home Page:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 0, 1, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( "About:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 0, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 1, 2, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		New_Contact.info->w_homepage = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), New_Contact.info->w_homepage,
		                  1, 2, 0, 1, GTK_FILL | GTK_EXPAND, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( New_Contact.info->w_homepage ), FALSE );
		gtk_widget_show( New_Contact.info->w_homepage );

		vbutton = gtk_button_new_with_label( "View" );
		gtk_table_attach( GTK_TABLE( table ), vbutton,
		                  2, 3, 0, 1, GTK_FILL, 0, 0, 0 );

		gtk_signal_connect( GTK_OBJECT( vbutton ), "clicked",
		                    GTK_SIGNAL_FUNC( display_url_from_entry ),
		                    New_Contact.info->w_homepage );

		gtk_widget_show( vbutton );

		hbox = gtk_hbox_new( FALSE, 0 );
		New_Contact.info->w_about = gtk_text_new( NULL, NULL );
		gtk_text_set_word_wrap( GTK_TEXT( New_Contact.info->w_about ), TRUE );

		gtk_box_pack_start( GTK_BOX( hbox ), New_Contact.info->w_about, TRUE, TRUE, 0 );
		gtk_widget_show( New_Contact.info->w_about );

		scrollbar = gtk_vscrollbar_new( GTK_TEXT( New_Contact.info->w_about )->vadj );
		gtk_box_pack_start( GTK_BOX( hbox ), scrollbar, FALSE, FALSE, 0 );
		gtk_widget_show( scrollbar );


		gtk_table_attach( GTK_TABLE( table ), hbox,
		                  0, 3, 2, 3, GTK_FILL | GTK_EXPAND,
		                  GTK_FILL | GTK_EXPAND, 5, 5 );

		gtk_widget_show( hbox );
		gtk_widget_show( table );

		hbox = gtk_hbutton_box_new();
		gtk_button_box_set_layout( GTK_BUTTON_BOX( hbox ),
		                           GTK_BUTTONBOX_SPREAD );

		data.i = uin;
		data.data = GINT_TO_POINTER( sok );

		button = gtk_button_new_with_label( "Add User" );
		gtk_widget_set_usize( button, 55, 30 );
		gtk_box_pack_end( GTK_BOX( mainbox ), hbox, FALSE, FALSE, 0 );
		gtk_box_pack_end( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
		gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		                    GTK_SIGNAL_FUNC( add_user_from_info ), &data );
		gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		                    (GtkSignalFunc) gtk_widget_destroy,
		                    GTK_OBJECT( New_Contact.info->window ) );
		gtk_widget_show( button );

		button = gtk_button_new_with_label( "Close" );
		gtk_widget_set_usize( button, 55, 30 );
		gtk_box_pack_end( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
		gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		                    (GtkSignalFunc) gtk_widget_destroy,
		                    GTK_OBJECT( New_Contact.info->window ) );
		gtk_widget_show( hbox );
		gtk_widget_show( button );

		gtk_widget_show( notebook );
		gtk_widget_show( mainbox );
		gtk_widget_show( New_Contact.info->window );
	}

	string = (char*)g_malloc( 16 );
	if( New_Contact.info->uin )
		sprintf( string, "%u", New_Contact.info->uin );
	else
		strcpy( string, "Unknown" );
	gtk_entry_set_text( GTK_ENTRY( New_Contact.info->w_uin ), string );
	g_free( string );

	if( New_Contact.info->nick != NULL )
		gtk_entry_set_text( GTK_ENTRY( New_Contact.info->w_nick ), New_Contact.info->nick );

	if( New_Contact.info->first != NULL )
		gtk_entry_set_text( GTK_ENTRY( New_Contact.info->w_first ), New_Contact.info->first );

	if( New_Contact.info->last != NULL )
		gtk_entry_set_text( GTK_ENTRY( New_Contact.info->w_last ), New_Contact.info->last );

	if( New_Contact.info->sex == MALE )
		gtk_entry_set_text( GTK_ENTRY( New_Contact.info->w_sex ), "Male" );
	else if( New_Contact.info->sex == FEMALE )
		gtk_entry_set_text( GTK_ENTRY( New_Contact.info->w_sex ), "Female" );
	else
		gtk_entry_set_text( GTK_ENTRY( New_Contact.info->w_sex ), "Unknown" );

	string = (char*)g_malloc( 8 );
	if( New_Contact.info->age )
		sprintf( string, "%d", New_Contact.info->age % 1000 );
	else
		strcpy( string, "Unknown" );
	gtk_entry_set_text( GTK_ENTRY( New_Contact.info->w_age ), string );
	g_free( string );

	if( New_Contact.nick != NULL )
		gtk_entry_set_text( GTK_ENTRY( New_Contact.info->w_alias ), New_Contact.nick );

	if( New_Contact.info->auth )
		gtk_entry_set_text( GTK_ENTRY( New_Contact.info->w_auth ), "Auth required" );
	else
		gtk_entry_set_text( GTK_ENTRY( New_Contact.info->w_auth ), "No auth required" );

	if( New_Contact.info->uin == 0 )
		gtk_entry_set_text( GTK_ENTRY( New_Contact.info->w_auth ), "Unknown" );

	if( New_Contact.info->ip != NULL )
		gtk_entry_set_text( GTK_ENTRY( New_Contact.info->w_ip ), New_Contact.info->ip );

	if( New_Contact.info->port != NULL )
		gtk_entry_set_text( GTK_ENTRY( New_Contact.info->w_port ), New_Contact.info->port );

	if( New_Contact.info->email != NULL )
		gtk_entry_set_text( GTK_ENTRY( New_Contact.info->w_email ), New_Contact.info->email );

	if( New_Contact.info->phone != NULL )
		gtk_entry_set_text( GTK_ENTRY( New_Contact.info->w_phone ), New_Contact.info->phone );

	if( New_Contact.info->city != NULL )
		gtk_entry_set_text( GTK_ENTRY( New_Contact.info->w_city ), New_Contact.info->city );

	if( New_Contact.info->state != NULL )
		gtk_entry_set_text( GTK_ENTRY( New_Contact.info->w_state ), New_Contact.info->state );

	if( New_Contact.info->homepage != NULL )
		gtk_entry_set_text( GTK_ENTRY( New_Contact.info->w_homepage ), New_Contact.info->homepage );

	if( New_Contact.info->about != NULL )
	{
		gtk_text_freeze( GTK_TEXT( New_Contact.info->w_about ) );
		gtk_text_insert( GTK_TEXT( New_Contact.info->w_about ), NULL, NULL, NULL,
		                 New_Contact.info->about, -1 );
		gtk_text_thaw( GTK_TEXT( New_Contact.info->w_about ) );
	}

	if( start_new_info )
	{
		send_info_req( sok, uin );
		send_ext_info_req( sok, uin );
		start_new_info = FALSE;
	}
}

void icq_refresh_list( GtkWidget *widget, struct sokandlb *data )
{
#ifdef TRACE_FUNCTION
	g_print( "icq_refresh_list\n" );
#endif

	Show_Quick_Status( data );
}

void icq_quit( GtkWidget *widget, struct sokandlb *data )
{
	int cx;

#ifdef TRACE_FUNCTION
	g_print( "icq_quit\n" );
#endif

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( Contacts[ cx ].sok > 0 )
			close( Contacts[ cx ].sok );
		if( Contacts[ cx ].chat_sok > 0 )
			close( Contacts[ cx ].chat_sok );
	}

	if( data->window != NULL && GTK_WIDGET_VISIBLE( data->window ) )
		gdk_window_get_size( GTK_WIDGET( data->window )->window,
		                     &WindowWidth,
		                     &WindowHeight );

	Save_RC();
	gtk_main_quit();
}

void icq_refresh( struct sokandlb *data, int sok, GdkInputCondition cond )
{
	static struct timeval tv;
	static fd_set readfds;
	static int next, time_delay = 120;
	int status;

	tv.tv_sec = 2;
	tv.tv_usec = 500000;

#ifdef TRACE_FUNCTION
	g_print( "icq_refresh\n" );
#endif

	FD_ZERO(&readfds);
	FD_SET(data->sok, &readfds);

	FD_SET(STDIN, &readfds);

	/* Don't care about writefds and exceptfds: */
	select(data->sok+1, &readfds, NULL, NULL, &tv);

	if (FD_ISSET(data->sok, &readfds))
	{
		Handle_Server_Response( data );
	}

	if ( time( NULL ) > next )
	{
		next = time( NULL ) + time_delay;
		Keep_Alive( data->sok );
	}

	if( ( status = Show_Quick_Status( data ) ) > 0 )
	{
		if( status == 1 )
			gnomeicu_event( EV_USERON );
		if( status == 2 )
			gnomeicu_event( EV_USEROFF );
	}
}

void icq_msgbox(char *message_text, char *sender, DWORD uin, struct sokandlb *data )
{
	GtkWidget *window = NULL;
	GtkWidget *message = NULL;
	GtkWidget *button;
	GtkWidget *table;
	GtkWidget *mainbox = NULL;
	GtkWidget *box;
	GtkWidget *text;
	GtkWidget *scrollbar;

	static GtkWidget *allow_button;
	GtkWidget *respond_text;
	GtkWidget *respond_button;
/*	GtkWidget *force_respond_button;*/
	GtkWidget *respond_scrollbar;

	GtkWidget *label;
	GtkWidget *entry;

	GtkWidget *readnext_button;

	char *filesize;

	int cx;
	char *nick;
	int cindex = 0;

#ifdef TRACE_FUNCTION
	g_print( "icq_msgbox\n" );
#endif
	
	if( message_text[ 0 ] != 'n' )
		window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( uin == Contacts[ cx ].uin )
			break;
	}
	
	if( cx == Num_Contacts )
		return;

	nick = Contacts[ cx ].nick;

	if( message_text[ 0 ] == 'f' )
		sprintf( sender, "File Request from %s:", nick );

	if( message_text[ 0 ] == 'c' )
		sprintf( sender, "Chat Request from %s:", nick );

	if( message_text[ 0 ] == 'u' )
		sprintf( sender, "URL from %s:", nick );

	if( message_text[ 0 ] == 'a' )
		sprintf( sender, "Auth Request from %s:", nick );

	if( message_text[ 0 ] == 'n' )
		sprintf( sender, "%s has added you to his/her list", nick );


	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( uin == Contacts[ cx ].uin )
		{
			cindex = cx;
			Contacts[ cx ].messages --;
			applet_update( Current_Status, NULL, data );
			if( Contacts[ cx ].messages == 0 )
			{
				Contacts[ cx ].icon_p = GetIcon_p( Contacts[ cx ].status );
				Contacts[ cx ].icon_b = GetIcon_b( Contacts[ cx ].status );
				Contacts[ cx ].need_update = 1;
			}
		}
	}

	if( message_text[ 0 ] != 'n' )
		gtk_container_border_width( GTK_CONTAINER( window ), 10 );

	if( message_text[ 0 ] == 'c' )
	{
		gtk_window_set_title( GTK_WINDOW( window ), "GnomeICU: Chat Request" );
	}
	else if( message_text[ 0 ] == 'f' )
	{
		gtk_window_set_title( GTK_WINDOW( window ), "GnomeICU: File Request" );
	}
	else if( message_text[ 0 ] == 'm' )
	{
		gtk_window_set_title(GTK_WINDOW( window ), "GnomeICU: Message" );
		gtk_widget_set_usize( window, 535, 375 );
	}
	else if( message_text[ 0 ] == 'u' )
	{
		gtk_window_set_title( GTK_WINDOW( window ), "GnomeICU: URL" );
		gtk_widget_set_usize( window, 350, 145 );
	}
	else if( message_text[ 0 ] == 'a' )
	{
		gtk_window_set_title( GTK_WINDOW( window ), "GnomeICU: Authorization Request" );
		gtk_widget_set_usize( window, 350, 100 );
	}

	if( message_text[ 0 ] != 'n' )
	{
		mainbox = gtk_vbox_new( FALSE, 0 );
		gtk_container_add( GTK_CONTAINER( window ), mainbox );
		gtk_widget_show( mainbox );

		message = gtk_label_new( sender );

		gtk_box_pack_start( GTK_BOX( mainbox ), message, FALSE, FALSE, 0 );
		gtk_widget_show( message );
	}

	if( message_text[ 0 ] == 'm' )
	{
		table = gtk_table_new(3, 2, FALSE);
		gtk_box_pack_start( GTK_BOX( mainbox ), table, TRUE, TRUE, 0);
	
		text = gtk_text_new( NULL, NULL );
		gtk_text_set_word_wrap( GTK_TEXT( text ), TRUE );
		gtk_table_attach( GTK_TABLE( table ), text, 0, 1, 0, 1,
		                  GTK_EXPAND | GTK_SHRINK | GTK_FILL,
		                  GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 5 );
		gtk_text_set_editable( GTK_TEXT( text ), FALSE );

		scrollbar = gtk_vscrollbar_new( GTK_TEXT( text )->vadj );
		gtk_table_attach( GTK_TABLE( table ), scrollbar, 1, 2, 0, 1,
		                  GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 5 );
		gtk_widget_show( scrollbar );

		respond_text = gtk_text_new( NULL, NULL );
		gtk_text_set_word_wrap( GTK_TEXT( respond_text ), TRUE );
		gtk_table_attach( GTK_TABLE( table ), respond_text, 0, 1, 1, 2,
		                  GTK_EXPAND | GTK_SHRINK | GTK_FILL,
		                  GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 5 );
		gtk_text_set_editable( GTK_TEXT( respond_text ), TRUE );

		gtk_signal_connect( GTK_OBJECT( respond_text ), "key_press_event",
		                    GTK_SIGNAL_FUNC( ctrl_enter_cb ), data );

		respond_scrollbar = gtk_vscrollbar_new( GTK_TEXT( respond_text )->vadj );
		gtk_table_attach( GTK_TABLE( table ), respond_scrollbar, 1, 2, 1, 2,
		                  GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 5 );
		gtk_widget_show( respond_scrollbar );

		gtk_widget_show( text );
		gtk_widget_show( respond_text );
		gtk_widget_show( table );

		gtk_widget_grab_focus( respond_text );

		gtk_text_insert( GTK_TEXT( text ), NULL, NULL, NULL,
		                 ( 1 + message_text ), -1 );

		box = gtk_hbutton_box_new();
		gtk_button_box_set_layout(GTK_BUTTON_BOX(box), GTK_BUTTONBOX_SPREAD);
		button = gtk_button_new_with_label( "Close" );
		gtk_widget_set_usize(button, 35, 25);
		gtk_table_attach(GTK_TABLE(table), box, 0, 1, 2, 3, GTK_FILL, 0, 0, 0);
		gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		                    GTK_SIGNAL_FUNC( icq_refresh_list ), data );

		gtk_signal_connect_object(GTK_OBJECT (button), "clicked",
		                          (GtkSignalFunc) gtk_widget_destroy, 
	                             GTK_OBJECT(window));

		readnext_button = gtk_button_new_with_label( "Read Next" );
		Contacts[ cindex ].read_next = readnext_button;
		gtk_signal_connect( GTK_OBJECT( readnext_button ), "destroy",
		                    GTK_SIGNAL_FUNC( gtk_widget_destroyed ),
		                    &Contacts[ cindex ].read_next );
		if( Contacts[ cindex ].messages < 1 ||
		    ( Contacts[ cindex ].messages && Contacts[ cindex ].message[ 1 ][ 0 ] != 'm' ) )
			gtk_widget_set_sensitive( readnext_button, FALSE );
		gtk_widget_set_usize( readnext_button, 35, 25 );
		gtk_object_set_data( GTK_OBJECT( readnext_button ), "nick", Contacts[ cindex ].nick );
		gtk_object_set_data( GTK_OBJECT( readnext_button ), "text", text );
		gtk_signal_connect( GTK_OBJECT( readnext_button ), "clicked",
		                    GTK_SIGNAL_FUNC( read_next ), data );

		respond_button = gtk_button_new_with_label( "Reply" );
		gtk_widget_set_usize(respond_button, 35, 25 );

		gtk_object_set_data( GTK_OBJECT( respond_text ), "button", respond_button );

/*		force_respond_button = gtk_button_new_with_label( "Via Server" );
		gtk_widget_set_usize( force_respond_button, 35, 25 );
*/
		gtk_container_add(GTK_CONTAINER( box ), respond_button );
/*		gtk_container_add( GTK_CONTAINER( box ), force_respond_button );*/
		gtk_container_add( GTK_CONTAINER( box ), readnext_button );
		gtk_container_add(GTK_CONTAINER( box ), button);
		gtk_object_set_data( GTK_OBJECT( respond_button ), "nick", Contacts[ cindex ].nick );
		gtk_object_set_data( GTK_OBJECT( respond_button ), "text", respond_text );
		gtk_object_set_data( GTK_OBJECT( respond_button ), "force", NULL );
		gtk_signal_connect( GTK_OBJECT( respond_button ), "clicked",
		                    GTK_SIGNAL_FUNC( icq_sendmessage ), data );
		gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		                    GTK_SIGNAL_FUNC( icq_refresh_list ), data );

		gtk_signal_connect_object(GTK_OBJECT ( respond_button ), "clicked",
		                          (GtkSignalFunc) gtk_widget_destroy, 
		                          GTK_OBJECT(window));
		gtk_widget_show( respond_button );

/*		gtk_object_set_data( GTK_OBJECT( force_respond_button ), "nick", Contacts[ cindex ].nick );
		gtk_object_set_data( GTK_OBJECT( force_respond_button ), "text", respond_text );
		gtk_object_set_data( GTK_OBJECT( force_respond_button ), "force", "1" );
		gtk_signal_connect( GTK_OBJECT( force_respond_button ), "clicked",
		                    GTK_SIGNAL_FUNC( icq_sendmessage ), data );

		gtk_signal_connect_object(GTK_OBJECT ( force_respond_button ), "clicked",
		                          (GtkSignalFunc) gtk_widget_destroy, 
		                          GTK_OBJECT(window));
		gtk_widget_show( force_respond_button );*/
		gtk_widget_show( button );
		gtk_widget_show( readnext_button );

		gtk_widget_show(box);
	}
	if( message_text[ 0 ] == 'n' )
	{
		gtk_widget_show( gnome_message_box_new( _( sender ),
		                                        GNOME_MESSAGE_BOX_INFO,
		                                        GNOME_STOCK_BUTTON_OK, NULL ) );
		return;
	}
	if( message_text[ 0 ] == 'c' )
	{
		table = gtk_table_new( 1, 2, FALSE );

		label = gtk_label_new( "Reason:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
		gtk_table_attach_defaults( GTK_TABLE( table ), label, 0, 1, 0, 1 );
		gtk_widget_show( label );

		entry = gtk_entry_new();
		if( Contacts[ cindex ].chat_reason != NULL )
			gtk_entry_set_text( GTK_ENTRY( entry ), Contacts[ cindex ].chat_reason );
		gtk_widget_set_usize( entry, 75, 0 );
		gtk_table_attach_defaults( GTK_TABLE( table ), entry, 1, 2, 0, 1 );
		gtk_widget_show( entry );

		if( Contacts[ cindex ].chat_reason != NULL )
		{
			g_free( Contacts[ cindex ].chat_reason );
			Contacts[ cindex ].chat_reason = NULL;
		}

		gtk_box_pack_start( GTK_BOX( mainbox ), table, FALSE, FALSE, 20 );
		gtk_widget_show( table );

		box = gtk_hbutton_box_new();
		gtk_button_box_set_layout(GTK_BUTTON_BOX(box), GTK_BUTTONBOX_SPREAD);
		button = gtk_button_new_with_label( "Accept" );
		gtk_widget_set_usize(button, 35, 25);
		gtk_container_add(GTK_CONTAINER( box ), button);
		gtk_box_pack_start( GTK_BOX( mainbox ), box, FALSE, FALSE, 20 );
		gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		                    GTK_SIGNAL_FUNC( icq_accept_chat ),
				    GINT_TO_POINTER( cindex ) );

		gtk_signal_connect_object(GTK_OBJECT (button), "clicked",
		                          (GtkSignalFunc) gtk_widget_destroy, 
	                             GTK_OBJECT(window));
		gtk_widget_show(button);

		button = gtk_button_new_with_label( "Refuse" );
		gtk_widget_set_usize(button, 35, 25);
		gtk_container_add(GTK_CONTAINER( box ), button);
		gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		                    GTK_SIGNAL_FUNC( icq_refuse_chat ),
				    GINT_TO_POINTER( cindex ) );

		gtk_signal_connect_object(GTK_OBJECT (button), "clicked",
		                          (GtkSignalFunc) gtk_widget_destroy, 
	                             GTK_OBJECT(window));
		gtk_widget_show( button );
		gtk_widget_show( box );
	}

	if( message_text[ 0 ] == 'f' )
	{
		table = gtk_table_new( 3, 2, FALSE );

		label = gtk_label_new( "File Name:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
		gtk_table_attach_defaults( GTK_TABLE( table ), label, 0, 1, 0, 1 );
		gtk_widget_show( label );

		label = gtk_label_new( "File Size:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
		gtk_table_attach_defaults( GTK_TABLE( table ), label, 0, 1, 1, 2 );
		gtk_widget_show( label );

		label = gtk_label_new( "Reason:" );
		gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
		gtk_table_attach_defaults( GTK_TABLE( table ), label, 0, 1, 2, 3 );
		gtk_widget_show( label );

		entry = gtk_entry_new();
		gtk_entry_set_text( GTK_ENTRY( entry ), Contacts[ cindex ].file_short_name );
		gtk_widget_set_usize( entry, 75, 0 );
		gtk_table_attach_defaults( GTK_TABLE( table ), entry, 1, 2, 0, 1 );
		gtk_widget_show( entry );

		filesize = (char*)g_malloc( 10 );
		sprintf( filesize, "%d", Contacts[ cindex ].file_size );
		
		entry = gtk_entry_new();
		gtk_entry_set_text( GTK_ENTRY( entry ), filesize );
		gtk_widget_set_usize( entry, 75, 0 );
		gtk_table_attach_defaults( GTK_TABLE( table ), entry, 1, 2, 1, 2 );
		gtk_widget_show( entry );
		
		g_free( filesize );

		entry = gtk_entry_new();
		gtk_entry_set_text( GTK_ENTRY( entry ), &message_text[1] );
		gtk_widget_set_usize( entry, 75, 0 );
		gtk_table_attach_defaults( GTK_TABLE( table ), entry, 1, 2, 2, 3 );
		gtk_widget_show( entry );
		
		gtk_box_pack_start( GTK_BOX( mainbox ), table, FALSE, FALSE, 20 );
		gtk_widget_show( table );

		box = gtk_hbutton_box_new();
		gtk_button_box_set_layout(GTK_BUTTON_BOX(box), GTK_BUTTONBOX_SPREAD);
		button = gtk_button_new_with_label( "Accept" );
		gtk_widget_set_usize(button, 35, 25);
		gtk_container_add(GTK_CONTAINER( box ), button);
		gtk_box_pack_start( GTK_BOX( mainbox ), box, FALSE, FALSE, 20 );
		gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		                    GTK_SIGNAL_FUNC( icq_accept_file ),
		                    GINT_TO_POINTER( cindex ) );

		gtk_signal_connect_object(GTK_OBJECT (button), "clicked",
		                          (GtkSignalFunc) gtk_widget_destroy, 
	                             GTK_OBJECT(window));
		gtk_widget_show(button);

		button = gtk_button_new_with_label( "Refuse" );
		gtk_widget_set_usize(button, 35, 25);
		gtk_container_add(GTK_CONTAINER( box ), button);
		gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		                    GTK_SIGNAL_FUNC( icq_refuse_file ),
				    GINT_TO_POINTER( cindex ) );

		gtk_signal_connect_object(GTK_OBJECT (button), "clicked",
		                          (GtkSignalFunc) gtk_widget_destroy, 
	                             GTK_OBJECT(window));
		gtk_widget_show( button );
		gtk_widget_show( box );
	}

	if( message_text[ 0 ] == 'a' )
	{
		box = gtk_hbutton_box_new();
		gtk_button_box_set_layout(GTK_BUTTON_BOX(box), GTK_BUTTONBOX_SPREAD);
		allow_button = gtk_button_new_with_label( "Allow" );
		gtk_widget_set_usize( allow_button, 35, 25 );
		gtk_container_add( GTK_CONTAINER( box ), allow_button );
		gtk_box_pack_start( GTK_BOX( mainbox ), box, FALSE, FALSE, 20 );
		gtk_object_set_data( GTK_OBJECT( allow_button ), "uin", GUINT_TO_POINTER(Contacts[ cindex ].uin) );
		gtk_signal_connect( GTK_OBJECT( allow_button ), "clicked",
		                    GTK_SIGNAL_FUNC( icq_allow_auth ), GINT_TO_POINTER( data->sok ) );

		gtk_signal_connect_object(GTK_OBJECT( allow_button ), "clicked",
		                          (GtkSignalFunc) gtk_widget_destroy, 
	                             GTK_OBJECT( window ) );
		gtk_widget_show( allow_button );

		button = gtk_button_new_with_label( "Refuse" );
		gtk_widget_set_usize(button, 35, 25);
		gtk_container_add(GTK_CONTAINER( box ), button);

		gtk_signal_connect_object(GTK_OBJECT (button), "clicked",
		                          (GtkSignalFunc) gtk_widget_destroy, 
	                             GTK_OBJECT(window));
		gtk_widget_show( button );
		gtk_widget_show( box );
	}
	if( message_text[ 0 ] == 'u' )
	{
		int url_len = 0, desc_len = 0;
		GtkWidget *url = gtk_entry_new();
		GtkWidget *desc = gtk_entry_new();

		char *curl = (char *)g_malloc( strlen( message_text ) );
		char *cdesc = (char *)g_malloc( strlen( message_text ) );

		gtk_misc_set_alignment( GTK_MISC( message ), 0.0, 0.5 );

		gtk_widget_set_usize( url, 250, 0 );
		gtk_widget_set_usize( desc, 250, 0 );

		for( cx = 1; ; cx ++ )
		{
			if( message_text[ cx ] == '\xFE' || message_text[ cx ] == 0x00 )
			{
				if( message_text[ cx ] == 0x00 )
				{
					url_len = cx - 2 - desc_len;
					break;
				}
				else
					desc_len = cx - 1;
			}
		}

		memcpy( cdesc, message_text + 1, desc_len );
		cdesc[ desc_len ] = 0x00;
		memcpy( curl, message_text + 2 + desc_len, url_len );
		curl[ url_len ]  = 0x00;
/*		sscanf( message_text + 1, "%[^\xFE]\xFE%[^\xFE]", cdesc, curl );*/
		
		gtk_entry_set_text( GTK_ENTRY( url ), curl );
		gtk_entry_set_text( GTK_ENTRY( desc ), cdesc );

		message = gtk_label_new( "Description:" );
		gtk_misc_set_alignment( GTK_MISC( message ), 0.0, 0.5 );
		gtk_widget_show( message );

		gtk_box_pack_start( GTK_BOX( mainbox ), url, FALSE, FALSE, 5 );
		gtk_box_pack_start( GTK_BOX( mainbox ), message, FALSE, FALSE, 0 );
		gtk_box_pack_start( GTK_BOX( mainbox ), desc, FALSE, FALSE, 5 );

		box = gtk_hbutton_box_new();
		gtk_button_box_set_layout( GTK_BUTTON_BOX( box ),
		                           GTK_BUTTONBOX_SPREAD );
		gtk_box_pack_start( GTK_BOX( mainbox ), box, FALSE, FALSE, 0 );
		gtk_widget_show( box );

		button = gtk_button_new_with_label( "Display" );
		gtk_widget_set_usize( button, 100, 30 );
		gtk_container_add( GTK_CONTAINER( box ), button );

		gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		                    GTK_SIGNAL_FUNC( display_url ),
		                    curl );
		
		gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		                           GTK_SIGNAL_FUNC( gtk_widget_destroy ),
		                           GTK_OBJECT( window ) );
		gtk_widget_show( button );

		button = gtk_button_new_with_label( "Close" );
		gtk_widget_set_usize( button, 100, 30 );
		gtk_container_add( GTK_CONTAINER( box ), button );

		gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		                           GTK_SIGNAL_FUNC( gtk_widget_destroy ),
		                           GTK_OBJECT( window ) );
		gtk_widget_show( button );

		gtk_widget_show( url );
		gtk_widget_show( desc );
	}
	gtk_widget_show( window );
}

void icq_set_status_online( GtkWidget *widget, struct sokandlb *data )
{
	ProgressData *pdata = NULL;

#ifdef TRACE_FUNCTION
	g_print( "icq_set_status_online\n" );
#endif

	if( Current_Status == STATUS_OFFLINE )
	{
		Done_Login = FALSE;
		data->sok = Connect_Remote( server, remote_port, STDERR );
		if( data->sok > 0 )
		{
			udp_gdk_input = gdk_input_add( data->sok, GDK_INPUT_READ, (GdkInputFunction) icq_refresh, data );
			Connected = TRUE;
			connecting = show_wait( "Connecting to Server", pdata );
			gtk_statusbar_push( GTK_STATUSBAR( statusbar ), 1, " Connecting to Server..." );

			Current_Status = STATUS_ONLINE;
			Login( data->sok, &passwd[0], our_ip, our_port );
		}
	}
	else
	{
		icq_change_status( data->sok, STATUS_ONLINE, data );
	}
}

void icq_set_status_offline( GtkWidget *widget, struct sokandlb *data )
{
	int cx;

#ifdef TRACE_FUNCTION
	g_print( "icq_set_status_offline\n" );
#endif

	Current_Status = STATUS_OFFLINE;
	Quit_ICQ( data->sok );
	if( udp_gdk_input )
	{
		gdk_input_remove( udp_gdk_input );
		udp_gdk_input = 0;
	}
	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		Contacts[ cx ].last_status = Contacts[ cx ].status;
		Contacts[ cx ].status = STATUS_OFFLINE;
	}
	Show_Quick_Status( data );
	seq_num = 0;
	memset( serv_mess, FALSE, 1024 );
	close( data->sok );

	Connected = FALSE;

	ready_set();

	if( applet_toggle )
	{
		applet_update( Current_Status, NULL, data );
	}

	msg_queue_clear();
}

void icq_set_status_away( GtkWidget *widget, struct sokandlb *data )
{
	ProgressData *pdata = NULL;

#ifdef TRACE_FUNCTION
	g_print( "icq_set_status_away\n" );
#endif

	if( Current_Status == STATUS_OFFLINE )
	{
		Current_Status = STATUS_AWAY;
		Done_Login = FALSE;
		data->sok = Connect_Remote( server, remote_port, STDERR );
		udp_gdk_input = gdk_input_add( data->sok, GDK_INPUT_READ, (GdkInputFunction) icq_refresh, data );
		Connected = TRUE;
		connecting = show_wait( "Connecting to Server", pdata );
		gtk_statusbar_push( GTK_STATUSBAR( statusbar ), 1, " Connecting to Server..." );

		Login( data->sok, &passwd[0], our_ip, our_port );
	}
	else
	{
		icq_change_status( data->sok, STATUS_AWAY, data );
		change_away_window( NULL, NULL );
	}
}

void icq_set_status_na( GtkWidget *widget, struct sokandlb *data )
{
	ProgressData *pdata = NULL;

#ifdef TRACE_FUNCTION
	g_print( "icq_set_status_na\n" );
#endif

	if( Current_Status == STATUS_OFFLINE )
	{
		Current_Status = STATUS_NA;
		Done_Login = FALSE;
		data->sok = Connect_Remote( server, remote_port, STDERR );
		udp_gdk_input = gdk_input_add( data->sok, GDK_INPUT_READ, (GdkInputFunction) icq_refresh, data );
		Connected = TRUE;
		connecting = show_wait( "Connecting to Server", pdata );
		gtk_statusbar_push( GTK_STATUSBAR( statusbar ), 1, " Connecting to Server..." );

		Login( data->sok, &passwd[0], our_ip, our_port );
	}
	else
	{
		icq_change_status( data->sok, STATUS_NA, data );
		change_away_window( NULL, NULL );
	}
}

void icq_set_status_invisible( GtkWidget *widget, struct sokandlb *data )
{
	ProgressData *pdata = NULL;

#ifdef TRACE_FUNCTION
	g_print( "icq_set_status_invisible\n" );
#endif

	if( Current_Status == STATUS_OFFLINE )
	{
		Current_Status = STATUS_INVISIBLE;
		Done_Login = FALSE;
		data->sok = Connect_Remote( server, remote_port, STDERR );
		udp_gdk_input = gdk_input_add( data->sok, GDK_INPUT_READ, (GdkInputFunction) icq_refresh, data );
		Connected = TRUE;
		connecting = show_wait( "Connecting to Server", pdata );
		gtk_statusbar_push( GTK_STATUSBAR( statusbar ), 1, " Connecting to Server..." );

		Login( data->sok, &passwd[0], our_ip, our_port );
	}
	else
	{
		icq_change_status( data->sok, STATUS_INVISIBLE, data );
	}
}

void icq_set_status_ffc( GtkWidget *widget, struct sokandlb *data )
{
	ProgressData *pdata = NULL;

#ifdef TRACE_FUNCTION
	g_print( "icq_set_status_ffc\n" );
#endif

	if( Current_Status == STATUS_OFFLINE )
	{
		Current_Status = STATUS_FREE_CHAT;
		Done_Login = FALSE;
		data->sok = Connect_Remote( server, remote_port, STDERR );
		udp_gdk_input = gdk_input_add( data->sok, GDK_INPUT_READ, (GdkInputFunction) icq_refresh, data );
		Connected = TRUE;
		connecting = show_wait( "Connecting to Server", pdata );
		gtk_statusbar_push( GTK_STATUSBAR( statusbar ), 1, " Connecting to Server..." );

		Login( data->sok, &passwd[0], our_ip, our_port );
	}
	else
	{
		icq_change_status( data->sok, STATUS_FREE_CHAT, data );
	}
}

void icq_set_status_occ( GtkWidget *widget, struct sokandlb *data )
{
	ProgressData *pdata = NULL;

#ifdef TRACE_FUNCTION
	g_print( "icq_set_status_occ\n" );
#endif

	if( Current_Status == STATUS_OCCUPIED )
		return;

	if( Current_Status == STATUS_OFFLINE )
	{
		Current_Status = STATUS_OCCUPIED;
		Done_Login = FALSE;
		data->sok = Connect_Remote( server, remote_port, STDERR );
		udp_gdk_input = gdk_input_add( data->sok, GDK_INPUT_READ, (GdkInputFunction) icq_refresh, data );
		Connected = TRUE;
		connecting = show_wait( "Connecting to Server", pdata );
		gtk_statusbar_push( GTK_STATUSBAR( statusbar ), 1, " Connecting to Server..." );

		Login( data->sok, &passwd[0], our_ip, our_port );
	}
	else
	{
		icq_change_status( data->sok, STATUS_OCCUPIED, data );
		change_away_window( NULL, NULL );
	}
}

void icq_set_status_dnd( GtkWidget *widget, struct sokandlb *data )
{
	ProgressData *pdata = NULL;

#ifdef TRACE_FUNCTION
	g_print( "icq_set_status_dnd\n" );
#endif

	if( Current_Status == STATUS_DND )
		return;

	if( Current_Status == STATUS_OFFLINE )
	{
		Current_Status = STATUS_DND;
		Done_Login = FALSE;
		data->sok = Connect_Remote( server, remote_port, STDERR );
		udp_gdk_input = gdk_input_add( data->sok, GDK_INPUT_READ, (GdkInputFunction) icq_refresh, data );
		Connected = TRUE;
		connecting = show_wait( "Connecting to Server", pdata );
		gtk_statusbar_push( GTK_STATUSBAR( statusbar ), 1, " Connecting to Server..." );

		Login( data->sok, &passwd[0], our_ip, our_port );
	}
	else
	{
		icq_change_status( data->sok, STATUS_DND, data );
		change_away_window( NULL, NULL );
	}
}


GtkWidget *create_menu ( struct sokandlb *data )
{ 
	GtkWidget *item;
	GtkWidget *menu;

#ifdef TRACE_FUNCTION
	g_print( "create_menu\n" );
#endif

	menu = gtk_menu_new();

	item = gtk_menu_item_new_with_label ( "Online" );

	gtk_menu_append( GTK_MENU ( menu ), item );
	gtk_widget_show( item );

	gtk_signal_connect(GTK_OBJECT( item ), "activate",
	                   GTK_SIGNAL_FUNC(icq_set_status_online), data );

	item = gtk_menu_item_new_with_label ( "Offline" );

	gtk_menu_append( GTK_MENU ( menu ), item );
	gtk_widget_show( item );

	gtk_signal_connect(GTK_OBJECT( item ), "activate",
	                   GTK_SIGNAL_FUNC(icq_set_status_offline), data );

	item = gtk_menu_item_new_with_label ( "Away" );

	gtk_menu_append( GTK_MENU ( menu ), item );
	gtk_widget_show( item );

	gtk_signal_connect(GTK_OBJECT( item ), "activate",
	                   GTK_SIGNAL_FUNC(icq_set_status_away), data );

	item = gtk_menu_item_new_with_label ( "Not Available" );

	gtk_menu_append( GTK_MENU ( menu ), item );
	gtk_widget_show( item );

	gtk_signal_connect(GTK_OBJECT( item ), "activate",
	                   GTK_SIGNAL_FUNC(icq_set_status_na), data );

	item = gtk_menu_item_new_with_label ( "Free for Chat" );

	gtk_menu_append( GTK_MENU ( menu ), item );
	gtk_widget_show( item );

	gtk_signal_connect(GTK_OBJECT( item ), "activate",
	                   GTK_SIGNAL_FUNC(icq_set_status_ffc), data );

	item = gtk_menu_item_new_with_label ( "Occupied" );

	gtk_menu_append( GTK_MENU ( menu ), item );
	gtk_widget_show( item );

	gtk_signal_connect(GTK_OBJECT( item ), "activate",
	                   GTK_SIGNAL_FUNC(icq_set_status_occ), data );

	item = gtk_menu_item_new_with_label ( "Do Not Disturb" );

	gtk_menu_append( GTK_MENU ( menu ), item );
	gtk_widget_show( item );

	gtk_signal_connect(GTK_OBJECT( item ), "activate",
	                   GTK_SIGNAL_FUNC(icq_set_status_dnd), data );

	item = gtk_menu_item_new_with_label ( "Invisible" );

	gtk_menu_append( GTK_MENU ( menu ), item );
	gtk_widget_show( item );

	gtk_signal_connect(GTK_OBJECT( item ), "activate",
	                   GTK_SIGNAL_FUNC(icq_set_status_invisible), data );

	return menu;
}

void icq_sendmessage( GtkWidget *button, struct sokandlb *data )
{
	char *buf;
	gchar *nick;
	GtkWidget *entry;
	gpointer forced;

#ifdef TRACE_FUNCTION
	g_print( "icq_sendmessage\n" );
#endif

	nick = gtk_object_get_data( GTK_OBJECT( button ), "nick" );
	entry = gtk_object_get_data( GTK_OBJECT( button ), "text" );
	forced = gtk_object_get_data( GTK_OBJECT( button ), "force" );

	buf = (char*)g_malloc( strlen( gtk_editable_get_chars( GTK_EDITABLE( entry ), 0, -1 ) ) + 1 );

	strcpy( buf, gtk_editable_get_chars( GTK_EDITABLE( entry ), 0, -1 ) );
	icq_sendmsg( data->sok, nick2uin( nick ), buf, data,
	             ( forced == NULL ? 0 : 1 ) );
	g_free( buf );
}

void show_contact_message( int cx, struct sokandlb *data )
{
	char *buf;

	if( Contacts[ cx ].messages )
	{
		char *nick = Contacts[ cx ].nick;
		int cy;

		buf = g_malloc( strlen( nick ) + 64 );

		sprintf( buf, "Message from %s:", nick );

		icq_msgbox( Contacts[ cx ].message[ 0 ], buf, Contacts[ cx ].uin, data );

		g_free( Contacts[ cx ].message[ 0 ] );
		for( cy = 0; cy < Contacts[ cx ].messages; cy ++ )
			Contacts[ cx ].message[ cy ] = Contacts[ cx ].message[ cy + 1 ];
		Contacts[ cx ].message[ Contacts[ cx ].messages ] = NULL;

		if( Contacts[ cx ].messages == 0 )
		{
			Contacts[ cx ].icon_p = GetIcon_p( Contacts[ cx ].status );
			Contacts[ cx ].icon_b = GetIcon_b( Contacts[ cx ].status );
			Contacts[ cx ].need_update = 1;
		}

		Show_Quick_Status( data );

		g_free( buf );
	}
}
	
gint icq_sendmessage_window( GtkWidget *clist, GdkEventButton *event, struct sokandlb *data )
{
	int row, column;
	GtkWidget *window;
	GtkWidget *message;
	GtkWidget *mainbox;
	GtkWidget *button;
	GtkWidget *text;
	GtkWidget *table;
	GtkWidget *box;
	GtkWidget *scrollbar;
	GtkWidget *cancel;
/*	GtkWidget *force_button;*/

	int cx, t;
	int cindex;

	char label_str[64];
	gchar *nick = NULL;
	int uin;

	int key_select = FALSE;

#ifdef TRACE_FUNCTION
	g_print( "icq_sendmessage_window\n" );
#endif

	if( event == NULL )
		return FALSE;

	if( event->type == GDK_KEY_PRESS )
	{
 		if( ((GdkEventKey*)event)->keyval != GDK_Return && ((GdkEventKey*)event)->keyval != ' ' )
			return FALSE;
		key_select = TRUE;
	}

	gtk_clist_get_selection_info( GTK_CLIST( clist ), event->x, event->y,
	                              &row, &column );

	if( event->type == GDK_KEY_PRESS )
		row = GTK_CLIST(clist)->focus_row;

	if( !GTK_IS_SCROLLBAR( clist ) && key_select == FALSE &&
	    event->button == 3 )
		gtk_clist_select_row( GTK_CLIST( clist ), row, column );

	if( key_select == FALSE )
	{
		if(  event->type != GDK_2BUTTON_PRESS && event->button == 1 )
			return FALSE;

		if( event->type != GDK_BUTTON_PRESS && event->button == 3 )
			return FALSE;

		if( event->button == 2 )
			return FALSE;
	}

	uin = GPOINTER_TO_INT( gtk_clist_get_row_data( GTK_CLIST( clist ), row ) );

	if( uin == 0 )
		return FALSE;

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( Contacts[ cx ].uin == uin )
			break;
	}

	cindex = cx;

	nick = Contacts[ cx ].nick;

	if( event->button == 3 ||
	    ( event->type == GDK_KEY_PRESS && ((GdkEventKey*)event)->keyval == ' ' ) )
	{
	
		if( cx == Num_Contacts )
			return FALSE;
		else
		{
			GtkWidget *personal_menu;
			GdkEventButton *bevent = (GdkEventButton *) event;

			GtkWidget *pm, *item_box, *item_label;
			GtkWidget *item;
			personal_menu = gtk_menu_new();

			item_box = gtk_hbox_new( FALSE, 0 );
			pm = gtk_pixmap_new( icon_message_pixmap, icon_message_bitmap );
			gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
			gtk_widget_show( pm );
			item = gtk_menu_item_new();
			item_label = gtk_label_new( "  Send Message..." );
			gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
			gtk_widget_show( item_label );
			gtk_container_add( GTK_CONTAINER( item ), item_box );
			gtk_widget_show( item_box );
			gtk_menu_append( GTK_MENU( personal_menu ), item );
			gtk_signal_connect( GTK_OBJECT( item ), "activate",
			                    GTK_SIGNAL_FUNC( icq_sendmessage_window_from_menu ),
			                    data );
			gtk_widget_show( item );

			item_box = gtk_hbox_new( FALSE, 0 );
			pm = gtk_pixmap_new( icon_url_pixmap, icon_url_bitmap );
			gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
			gtk_widget_show( pm );
			item = gtk_menu_item_new();
			item_label = gtk_label_new( "  Send URL..." );
			gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
			gtk_widget_show( item_label );
			gtk_container_add( GTK_CONTAINER( item ), item_box );
			gtk_widget_show( item_box );
			gtk_menu_append( GTK_MENU( personal_menu ), item );
			gtk_signal_connect( GTK_OBJECT( item ), "activate",
			                    GTK_SIGNAL_FUNC( send_url_window_default ),
			                    data );
			gtk_widget_show( item );

			item_box = gtk_hbox_new( FALSE, 0 );
			pm = gtk_pixmap_new( icon_chat_pixmap, icon_chat_bitmap );
			gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
			gtk_widget_show( pm );
			item = gtk_menu_item_new();
			item_label = gtk_label_new( "  Send Chat Request..." );
			gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
			gtk_widget_show( item_label );
			gtk_container_add( GTK_CONTAINER( item ), item_box );
			gtk_widget_show( item_box );
			gtk_menu_append( GTK_MENU( personal_menu ), item );
			gtk_signal_connect( GTK_OBJECT( item ), "activate",
			                    GTK_SIGNAL_FUNC( request_chat ),
			                    data );
			gtk_widget_show( item );

			item_box = gtk_hbox_new( FALSE, 0 );
			pm = gtk_pixmap_new( icon_file_pixmap, icon_file_bitmap );
			gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
			gtk_widget_show( pm );
			item = gtk_menu_item_new();
			item_label = gtk_label_new( "  Send File Request..." );
			gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
			gtk_widget_show( item_label );
			gtk_container_add( GTK_CONTAINER( item ), item_box );
			gtk_widget_show( item_box );
			gtk_menu_append( GTK_MENU( personal_menu ), item );
			gtk_signal_connect( GTK_OBJECT( item ), "activate",
			                    GTK_SIGNAL_FUNC( request_file_default ),
			                    data );
			gtk_widget_show( item );

			item = gtk_menu_item_new();
			gtk_menu_append( GTK_MENU( personal_menu ), item );
			gtk_widget_show( item );

			item_box = gtk_hbox_new( FALSE, 0 );
			pm = gtk_pixmap_new( icon_info_pixmap, icon_info_bitmap );
			gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
			gtk_widget_show( pm );
			item = gtk_menu_item_new();
			item_label = gtk_label_new( "   User Info..." );
			gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
			gtk_widget_show( item_label );
			gtk_container_add( GTK_CONTAINER( item ), item_box );
			gtk_widget_show( item_box );
			gtk_menu_append( GTK_MENU( personal_menu ), item );
			gtk_signal_connect( GTK_OBJECT( item ), "activate",
			                    GTK_SIGNAL_FUNC( show_personal_info ), data );
			gtk_widget_show( item );

			item = gtk_menu_item_new_with_label( "Read Away Message" );
			gtk_menu_append( GTK_MENU( personal_menu ), item );
			gtk_signal_connect( GTK_OBJECT( item ), "activate",
			                    GTK_SIGNAL_FUNC( retrieve_away_message ), data );
			gtk_widget_show( item );

			item = gtk_menu_item_new_with_label( "Message History" );
			gtk_menu_append( GTK_MENU( personal_menu ), item );
			gtk_signal_connect( GTK_OBJECT( item ), "activate",
			                    GTK_SIGNAL_FUNC( display_mess_history ), data );
			gtk_widget_show( item );

			item = gtk_menu_item_new();
			gtk_menu_append( GTK_MENU( personal_menu ), item );
			gtk_widget_show( item );

			item = gtk_menu_item_new_with_label( "Add to Invisible List" );
			gtk_menu_append( GTK_MENU( personal_menu ), item );
			gtk_signal_connect( GTK_OBJECT( item ), "activate",
			                    GTK_SIGNAL_FUNC( add_to_inv_list ), data );
			if( Contacts[ cx ].invis_list )
				gtk_widget_set_sensitive( item, FALSE );
			gtk_widget_show( item );

			item = gtk_menu_item_new_with_label( "Remove from Invisible List" );
			gtk_menu_append( GTK_MENU( personal_menu ), item );
			gtk_signal_connect( GTK_OBJECT( item ), "activate",
			                    GTK_SIGNAL_FUNC( remove_from_inv_list ), data );
			if( !Contacts[ cx ].invis_list )
				gtk_widget_set_sensitive( item, FALSE );
			gtk_widget_show( item );

			item = gtk_menu_item_new();
			gtk_menu_append( GTK_MENU( personal_menu ), item );
			gtk_widget_show( item );

			item = gtk_menu_item_new_with_label( "Add to Visible List" );
			gtk_menu_append( GTK_MENU( personal_menu ), item );
			gtk_signal_connect( GTK_OBJECT( item ), "activate",
			                    GTK_SIGNAL_FUNC( add_to_vis_list ), data );
			if( Contacts[ cx ].vis_list )
				gtk_widget_set_sensitive( item, FALSE );
			gtk_widget_show( item );

			item = gtk_menu_item_new_with_label( "Remove from Visible List" );
			gtk_menu_append( GTK_MENU( personal_menu ), item );
			gtk_signal_connect( GTK_OBJECT( item ), "activate",
			                    GTK_SIGNAL_FUNC( remove_from_vis_list ), data );
			if( !Contacts[ cx ].vis_list )
				gtk_widget_set_sensitive( item, FALSE );
			gtk_widget_show( item );

			item = gtk_menu_item_new();
			gtk_menu_append( GTK_MENU( personal_menu ), item );
			gtk_widget_show( item );

			item = gtk_menu_item_new_with_label( "Authorize User" );
			gtk_menu_append( GTK_MENU( personal_menu ), item );
			gtk_signal_connect( GTK_OBJECT( item ), "activate",
			                    GTK_SIGNAL_FUNC( authorize_uin ), data );
			gtk_widget_show( item );

			item = gtk_menu_item_new_with_label( "Rename User" );
			gtk_menu_append( GTK_MENU( personal_menu ), item );
			gtk_signal_connect( GTK_OBJECT( item ), "activate",
			                    GTK_SIGNAL_FUNC( change_nick_window ), data );
			gtk_widget_show( item );

			item = gtk_menu_item_new_with_label( "Remove User" );
			gtk_menu_append( GTK_MENU( personal_menu ), item );
			gtk_signal_connect( GTK_OBJECT( item ), "activate",
			                    GTK_SIGNAL_FUNC( remove_user ),
			                    data );
			gtk_widget_show( item );

			item = gtk_menu_item_new();
			gtk_menu_append( GTK_MENU( personal_menu ), item );
			gtk_widget_show( item );

			t = Contacts[ cx ].current_ip;
			if( t != 0xffffffff )
				sprintf( label_str, "IP: %u.%u.%u.%u",(BYTE) (t>>24),(BYTE) (t>>16),(BYTE) (t>>8),(BYTE) (t) );
			else
				sprintf( label_str, "IP: N/A" );
			item = gtk_menu_item_new_with_label( label_str );
			gtk_menu_append( GTK_MENU( personal_menu ), item );
			gtk_widget_set_sensitive( item, FALSE );
			gtk_widget_show( item );

			sprintf( label_str, "Port: %u", Contacts[ cx ].port );
			item = gtk_menu_item_new_with_label( label_str );
			gtk_menu_append( GTK_MENU( personal_menu ), item );
			gtk_widget_set_sensitive( item, FALSE );
			gtk_widget_show( item );

			sprintf( label_str, "Status: 0x%04X", (unsigned int)Contacts[ cx ].status );
			item = gtk_menu_item_new_with_label( label_str );
			gtk_menu_append( GTK_MENU( personal_menu ), item );
			gtk_widget_set_sensitive( item, FALSE );
			gtk_widget_show( item );

			sprintf( label_str, "True Status: 0x%04X", (unsigned int)Contacts[ cx ].true_status );
			item = gtk_menu_item_new_with_label( label_str );
			gtk_menu_append( GTK_MENU( personal_menu ), item );
			gtk_widget_set_sensitive( item, FALSE );
			gtk_widget_show( item );

			gtk_menu_popup( GTK_MENU( personal_menu ), NULL, NULL, NULL, NULL,
			                bevent->button, bevent->time );
		}
		return FALSE;
	}


	if( Contacts[ cx ].messages )
	{
		show_contact_message( cx, data );
		return FALSE;
	}

	sprintf(label_str, "Send Message to: %s", nick );

	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

	gtk_container_border_width( GTK_CONTAINER(window), 10 );
	gtk_window_set_title(GTK_WINDOW(window), "GnomeICU: Send Message");
	gtk_widget_set_usize( window, 450, 230 );

	mainbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( window ), mainbox );
	gtk_widget_show( mainbox );

	message = gtk_label_new( label_str );

	gtk_box_pack_start( GTK_BOX( mainbox ), message, TRUE, TRUE, 0 );
	gtk_widget_show( message );

	table = gtk_table_new(3, 2, FALSE);
	gtk_box_pack_start( GTK_BOX( mainbox ), table, TRUE, TRUE, 0);
	
	text = gtk_text_new( NULL, NULL );
	gtk_text_set_word_wrap( GTK_TEXT( text ), TRUE );
	gtk_table_attach( GTK_TABLE( table ), text, 0, 1, 0, 1,
	                  GTK_EXPAND | GTK_SHRINK | GTK_FILL,
	                  GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 5 );

	gtk_text_set_editable( GTK_TEXT( text ), TRUE );

	gtk_signal_connect( GTK_OBJECT( text ), "key_press_event",
	                    GTK_SIGNAL_FUNC( ctrl_enter_cb ), data );

	gtk_object_set_data( GTK_OBJECT( text ), "nick", Contacts[ cindex ].nick );
	gtk_object_set_data( GTK_OBJECT( text ), "force", NULL );

	scrollbar = gtk_vscrollbar_new( GTK_TEXT( text )->vadj );
	gtk_table_attach( GTK_TABLE( table ), scrollbar, 1, 2, 0, 1,
	                  GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 5 );
	gtk_widget_show( scrollbar );

	gtk_widget_show( text );
	gtk_widget_show( table );
	gtk_widget_show( window );

	gtk_widget_grab_focus( text );

	box = gtk_hbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX( box ),
	                          GTK_BUTTONBOX_SPREAD);
	button = gtk_button_new_with_label( "Send" );
	gtk_widget_set_usize(button, 35, 25);
	gtk_container_add(GTK_CONTAINER( box ), button);

	gtk_object_set_data( GTK_OBJECT( text ), "button", button );

/*	force_button = gtk_button_new_with_label( "Via Server" );
	gtk_widget_set_usize( force_button, 75, 25 );
	gtk_container_add( GTK_CONTAINER( box ), force_button );*/
	cancel = gtk_button_new_with_label( "Cancel" );
	gtk_widget_set_usize( cancel, 35, 25 );
	gtk_container_add( GTK_CONTAINER( box ), cancel );
	gtk_signal_connect_object( GTK_OBJECT( cancel ), "clicked",
	                    (GtkSignalFunc) gtk_widget_destroy,
	                    GTK_OBJECT( window ) );
	gtk_widget_show( cancel );
	gtk_table_attach(GTK_TABLE(table), box,
	                 0, 1, 1, 2, GTK_FILL, 0, 0, 0);
	gtk_object_set_data( GTK_OBJECT( button ), "nick", Contacts[ cindex ].nick );
	gtk_object_set_data( GTK_OBJECT( button ), "text", text );
	gtk_object_set_data( GTK_OBJECT( button ), "force", NULL );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( icq_sendmessage ), data );
	gtk_signal_connect_object(GTK_OBJECT (button), "clicked",
	                          (GtkSignalFunc) gtk_widget_destroy, 
                             GTK_OBJECT(window));
	gtk_widget_show(button);
/*	gtk_object_set_data( GTK_OBJECT( force_button ), "nick", Contacts[ cindex ].nick );
	gtk_object_set_data( GTK_OBJECT( force_button ), "text", text );
	gtk_object_set_data( GTK_OBJECT( force_button ), "force", "1" );
	gtk_signal_connect( GTK_OBJECT( force_button ), "clicked",
	                    GTK_SIGNAL_FUNC( icq_sendmessage ), data );
	gtk_signal_connect_object(GTK_OBJECT ( force_button ), "clicked",
	                          (GtkSignalFunc) gtk_widget_destroy, 
                             GTK_OBJECT(window));
	gtk_widget_show( force_button );*/
	gtk_widget_show( box );

	return FALSE;
}

void icq_sendmessage_window_from_menu( GtkWidget *widget, struct sokandlb *data )
{
	GtkWidget *window;
	GtkWidget *message;
	GtkWidget *mainbox;
	GtkWidget *button;
/*	GtkWidget *force_button;*/
	static GtkWidget *text;
	GtkWidget *table;
	GtkWidget *box;
	GtkWidget *scrollbar;
	GtkWidget *cancel;
	GtkCList *clist = GTK_CLIST( data->lb_userwin );

	int cx;

	char label_str[64];

#ifdef TRACE_FUNCTION
	g_print( "icq_sendmessage_window_from_menu\n" );
#endif

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( GPOINTER_TO_INT( clist->selection->data ) ==
		    Contacts[ cx ].lb_index )
			break;
	}

	sprintf(label_str, "Send Message to: %s", Contacts[ cx ].nick );

	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

	gtk_container_border_width( GTK_CONTAINER(window), 10 );
	gtk_window_set_title(GTK_WINDOW(window), "GnomeICU: Send Message");
	gtk_widget_set_usize( window, 450, 230 );

	mainbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( window ), mainbox );
	gtk_widget_show( mainbox );

	message = gtk_label_new( label_str );

	gtk_box_pack_start( GTK_BOX( mainbox ), message, TRUE, TRUE, 0 );
	gtk_widget_show( message );

	table = gtk_table_new(3, 2, FALSE);
	gtk_box_pack_start( GTK_BOX( mainbox ), table, TRUE, TRUE, 0);
	
	text = gtk_text_new( NULL, NULL );
	gtk_text_set_word_wrap( GTK_TEXT( text ), TRUE );
	gtk_table_attach( GTK_TABLE( table ), text, 0, 1, 0, 1,
	                  GTK_EXPAND | GTK_SHRINK | GTK_FILL,
	                  GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 5 );

	gtk_text_set_editable( GTK_TEXT( text ), TRUE );

	scrollbar = gtk_vscrollbar_new( GTK_TEXT( text )->vadj );
	gtk_table_attach( GTK_TABLE( table ), scrollbar, 1, 2, 0, 1,
	                  GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 5 );
	gtk_widget_show( scrollbar );

	gtk_widget_show( text );
	gtk_widget_show( table );
	gtk_widget_show( window );

	box = gtk_hbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX( box ),
	                          GTK_BUTTONBOX_SPREAD);
	button = gtk_button_new_with_label( "Send" );
	gtk_widget_set_usize(button, 35, 25);
	gtk_container_add(GTK_CONTAINER( box ), button);
/*	force_button = gtk_button_new_with_label( "Via Server" );
	gtk_widget_set_usize( force_button, 75, 25 );
	gtk_container_add( GTK_CONTAINER( box ), force_button );*/
	cancel = gtk_button_new_with_label( "Cancel" );
	gtk_widget_set_usize( cancel, 35, 25 );
	gtk_container_add( GTK_CONTAINER( box ), cancel );
	gtk_signal_connect_object( GTK_OBJECT( cancel ), "clicked",
	                    (GtkSignalFunc) gtk_widget_destroy,
	                    GTK_OBJECT( window ) );
	gtk_widget_show( cancel );
	gtk_table_attach(GTK_TABLE(table), box,
	                 0, 1, 1, 2, GTK_FILL, 0, 0, 0);
	gtk_object_set_data( GTK_OBJECT( button ), "nick", Contacts[ cx ].nick );
	gtk_object_set_data( GTK_OBJECT( button ), "text", text );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( icq_sendmessage ), data );
	gtk_signal_connect_object(GTK_OBJECT (button), "clicked",
	                          (GtkSignalFunc) gtk_widget_destroy, 
                             GTK_OBJECT(window));
	gtk_widget_show(button);
/*	gtk_object_set_data( GTK_OBJECT( force_button ), "nick", Contacts[ cx ].nick );
	gtk_object_set_data( GTK_OBJECT( force_button ), "text", text );
	gtk_object_set_data( GTK_OBJECT( force_button ), "force", "1" );
	gtk_signal_connect( GTK_OBJECT( force_button ), "clicked",
	                    GTK_SIGNAL_FUNC( icq_sendmessage ), data );
	gtk_signal_connect_object(GTK_OBJECT ( force_button ), "clicked",
	                          (GtkSignalFunc) gtk_widget_destroy, 
                             GTK_OBJECT(window));
	gtk_widget_show( force_button );*/
	gtk_widget_show( box );

	return;
}

int stay_connected( struct sokandlb *data )
{
#ifdef TRACE_FUNCTION
	g_print( "stay_connected\n" );
#endif

	Keep_Alive( data->sok );
	return TRUE;
}

void read_next( GtkWidget *widget, struct sokandlb *data )
{
	GtkWidget *text;
	char buf[100];

	int i, cy;

	gchar *nick;

#ifdef TRACE_FUNCTION
	g_print( "read_next\n" );
#endif

	nick = gtk_object_get_data( GTK_OBJECT( widget ), "nick" );
	text = gtk_object_get_data( GTK_OBJECT( widget ), "text" );

	if( nick == NULL )
		return;

	for( i = 0; i < Num_Contacts; i ++ )
	{
		if( !strcmp( Contacts[ i ].nick, nick ) )
			break;
	}

	if( Contacts[ i ].messages > 0 )
	{
		sprintf( buf, "Message from %s:", nick );
		gtk_text_set_point( GTK_TEXT( text ), 0 );
		gtk_text_forward_delete( GTK_TEXT( text ),
		                         gtk_text_get_length( GTK_TEXT( text ) ) );

		gtk_text_insert( GTK_TEXT( text ), NULL, NULL, NULL,
		                 ( 1 + Contacts[ i ].message[ 0 ] ), -1 );

		if( Contacts[ i ].messages <= 1 ||
		    ( Contacts[ i ].messages && Contacts[ i ].message[ 1 ][ 0 ] != 'm' ) )
			gtk_widget_set_sensitive( Contacts[ i ].read_next, FALSE );

		g_free( Contacts[ i ].message[ 0 ] );
		for( cy = 0; cy < Contacts[ i ].messages; cy ++ )
			Contacts[ i ].message[ cy ] = Contacts[ i ].message[ cy + 1 ];
		Contacts[ i ].message[ Contacts[ i ].messages ] = NULL;
		Contacts[ i ].messages --;
		applet_update( Current_Status, NULL, data );
		if( Contacts[ i ].messages == 0 )
		{
			Contacts[ i ].icon_p = GetIcon_p( Contacts[ i ].status );
			Contacts[ i ].icon_b = GetIcon_b( Contacts[ i ].status );
			Contacts[ i ].need_update = 1;
		}
		Show_Quick_Status( data );
	}

	return;
}

int ctrl_enter_cb( GtkWidget *widget, GdkEventKey *ev, int sock )
{
	switch( ev->keyval )
	{
		case GDK_Return:
			if( ev->state & GDK_CONTROL_MASK )
				gtk_signal_emit_by_name( GTK_OBJECT( gtk_object_get_data( GTK_OBJECT( widget ), "button" ) ), "clicked", MainData );
/*				icq_sendmessage( gtk_object_get_data( GTK_OBJECT( widget ), "button" ), MainData );*/
			break;
	}

	return FALSE;
}

void clear_i_window( GtkWidget *wigdet, gpointer data )
{
	int uin;
	int cx;
	
	uin = GPOINTER_TO_INT( data );
	
	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( Contacts[ cx ].uin == uin )
			break;
	}
	
	if( cx == Num_Contacts )
	{
		New_Contact.info->window = NULL;
		return;
	}

	Contacts[ cx ].info->window = NULL;
}
