/*
 * This is the main source file for GnomeICU.
 * Written by:
 *  Jeremy Wise <jwise@pathwaynet.com>
 *
 * Original content provided by:
 *  Matt Smith
 */

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif

#include "gnomeicu.h"
#include "dragdrop.h"
#include "datatype.h"
#include <stdio.h>
#include <stdlib.h>

#include <unistd.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/time.h>

#include <fcntl.h>
#include <time.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <assert.h>
#include <sys/wait.h>
#include <signal.h>

#ifdef HAVE_SOCKS5
#define SOCKS
#include <socks.h>
#endif

#include <gtk/gtk.h>
#include "gtkfunc.h"

#include "xpms/gnomeicu-away.xpm"
#include "xpms/gnomeicu-na.xpm"
#include "xpms/gnomeicu-occ.xpm"
#include "xpms/gnomeicu-dnd.xpm"
#include "xpms/gnomeicu-ffc.xpm"
#include "xpms/gnomeicu-inv.xpm"
#include "xpms/gnomeicu-online.xpm"
#include "xpms/gnomeicu-offline.xpm"

#include "tcp.h"

#include <gnome.h>
#include "applet.h"

#include "loadpixmap.h"

#include "sendmsg.h"
#include "msg_queue.h"

BOOL Int_End;
BOOL Russian = FALSE;
BOOL Logging = TRUE;
BOOL Quit = FALSE;
BOOL serv_mess[ 1024 ];
WORD seq_num = 1;  /* current sequence number */
DWORD our_ip = 0x0100007f; /* localhost for some reason */
DWORD our_port = 0; /* the port to make tcp connections on */
DWORD our_sok; /* The TCP socket */
/************ We don't make tcp connections yet though :( */
char nickname[30];
BOOL Contact_List = FALSE;
Contact_Member Contacts[ 200 ]; /* no more than 100 contacts max */
Contact_Member New_Contact;
int Num_Contacts=0;
DWORD Current_Status=STATUS_OFFLINE;
DWORD last_recv_uin=0;
char passwd[100];
char server[100];
DWORD set_status;
DWORD remote_port;
BOOL Done_Login=FALSE;
char Away_Message[256] = "User is currently away.";
BOOL search_in_progress = FALSE;

int sound_disable = FALSE;

BYTE chat_fg_red = 0, chat_fg_green = 0, chat_fg_blue = 0;
BYTE chat_bg_red = 255, chat_bg_green = 255, chat_bg_blue = 255;

GtkWidget *log_list;
GtkWidget *log_window;

GdkPixmap *icon_blank_pixmap;
GdkPixmap *icon_message_pixmap;
GdkPixmap *icon_url_pixmap;
GdkPixmap *icon_auth_pixmap;
GdkPixmap *icon_away_pixmap;
GdkPixmap *icon_na_pixmap;
GdkPixmap *icon_occ_pixmap;
GdkPixmap *icon_dnd_pixmap;
GdkPixmap *icon_ffc_pixmap;
GdkPixmap *icon_inv_pixmap;
GdkPixmap *icon_online_pixmap;
GdkPixmap *icon_offline_pixmap;
GdkPixmap *icon_chat_pixmap;
GdkPixmap *icon_chat2_pixmap;
GdkPixmap *icon_file_pixmap;
GdkPixmap *icon_info_pixmap;
GdkPixmap *nomess_pixmap;

GdkBitmap *icon_blank_bitmap;
GdkBitmap *icon_message_bitmap;
GdkBitmap *icon_url_bitmap;
GdkBitmap *icon_auth_bitmap;
GdkBitmap *icon_away_bitmap;
GdkBitmap *icon_na_bitmap;
GdkBitmap *icon_occ_bitmap;
GdkBitmap *icon_dnd_bitmap;
GdkBitmap *icon_ffc_bitmap;
GdkBitmap *icon_inv_bitmap;
GdkBitmap *icon_online_bitmap;
GdkBitmap *icon_offline_bitmap;
GdkBitmap *icon_chat_bitmap;
GdkBitmap *icon_chat2_bitmap;
GdkBitmap *icon_file_bitmap;
GdkBitmap *icon_info_bitmap;
GdkBitmap *nomess_bitmap;

char configfilename[256] = "/GnomeICU/";

int sound_toggle = FALSE;
int beep_toggle = FALSE;
int force_toggle = FALSE;
int webpresence_toggle = TRUE;

int Connected = FALSE;

USER_INFO_PTR our_info;

int packet_toggle = FALSE;

int is_new_user = FALSE;

int udp_gdk_input = 0;
int tcp_gdk_input = 0;

GtkWidget *statusbar;
GtkTooltips *status_tooltip;

int connecting;

int applet_toggle = TRUE;

USER_INFO_STRUCT our_user_info;

char WindowTitle[256];
int WindowWidth = 175, WindowHeight = 310;

unsigned int next_resend;

struct sokandlb *MainData;

GdkFont *ChatFont;
char ChatFontString[256];

	GtkWidget *app;

void Server_Response( struct sokandlb *data, srv_net_icq_pak pak, DWORD len, WORD cmd, WORD ver, WORD seq, WORD uin );
void add_from_search( GtkWidget *widget, struct sokandlb *data );
gint app_save_state_cb( GnomeClient *client, gint phase, GnomeRestartStyle save_style, gint shutdown, GnomeInteractStyle interact_style, gint fast, gpointer client_data );
void about( GtkWidget *widget, struct sokandlb *data );
void handle_signal( int signum );
int hide_ch_window( GtkWidget *widget, GdkEvent *event, GtkWidget *window );
void Check_Endian( void );
gint hide_dont_kill( GtkWidget *widget );

gint hide_dont_kill( GtkWidget *widget )
{
	gtk_widget_hide(widget);
	return TRUE;
}

void ready_set( void )
{
	char *sts = NULL;

#ifdef TRACE_FUNCTION
	g_print( "ready_set\n" );
#endif

	if ( Current_Status == STATUS_OFFLINE )
	{
		sts = " Ready (Offline)";
	}
	else
	{
		switch ( Current_Status & 0xffff )
		{
			case STATUS_ONLINE:
				sts = " Ready (Online)";
				break;
			case STATUS_DND:
				sts = " Ready (Do Not Disturb)";
				break;
			case STATUS_AWAY:
				sts = " Ready (Away)";
				break;
			case STATUS_OCCUPIED:
				sts = " Ready (Occupied)";
				break;
			case STATUS_NA:
				sts = " Ready (Not Available)";
				break;
			case STATUS_INVISIBLE:
				sts = " Ready (Invisible)";
				break;
			case STATUS_FREE_CHAT:
				sts = " Ready (Free for Chat)";
				break;
			default:
				sts = " Ready";
				break;
		}
	}

	gtk_statusbar_pop( GTK_STATUSBAR( statusbar ), 1 );

	gtk_statusbar_push( GTK_STATUSBAR( statusbar ), 1, sts );

}

void add_from_search( GtkWidget *widget, struct sokandlb *data )
{
	int new_uin;
	int row;
	char name[16];

#ifdef TRACE_FUNCTION
	g_print( "add_from_search\n" );
#endif

	row = GPOINTER_TO_INT( GTK_CLIST( found_list )->selection->data );
	new_uin = GPOINTER_TO_INT(
		gtk_clist_get_row_data( GTK_CLIST( found_list ), row ) );
	sprintf( name, "%d", new_uin );
	Add_User( data->sok, new_uin, name );
}

gint app_save_state_cb( GnomeClient *client, gint phase, GnomeRestartStyle save_style, gint shutdown, GnomeInteractStyle interact_style, gint fast, gpointer client_data )
{
	gchar *prefix= gnome_client_get_config_prefix (client);
	gchar *argv[]= { "rm", "-r", NULL, NULL };
	gchar *config_param = NULL;
	int i = 1;

#ifdef TRACE_FUNCTION
	g_print ("app_save_state_cb\n");
#endif

	/* Here is the real SM code. We set the argv to the parameters needed
	   to restart/discard the session that we've just saved and call
	   the gnome_session_set_*_command to tell the session manager it. */

	argv[2] = gnome_config_get_real_path (prefix);
	gnome_client_set_discard_command (client, 3, argv);

	/* Set commands to clone and restart this application.  Note that we
	   use the same values for both -- the session management code will
	   automatically add whatever magic option is required to set the
	   session id on startup.  */

	argv[0]= (gchar*) client_data;
	if ( applet_toggle == FALSE )
		argv[i++] = "-a";
	if ( strlen( configfilename ) )
	{
		config_param = g_strdup_printf ("--config=%s", configfilename);
		argv[i++] = config_param;
	}

	gnome_client_set_restart_command (client, i, argv);
	gnome_client_set_clone_command (client, 0, NULL);

	if ( config_param )
		g_free(config_param);

	return TRUE;
}

void about( GtkWidget *widget, struct sokandlb *data )
{
	GtkWidget *about;
	const char *authors[] =
	{
		"Jeremy Wise <jwise@pathwaynet.com>",
		NULL
	};

#ifdef TRACE_FUNCTION
	g_print( "about\n" );
#endif

	about = gnome_about_new( N_("GnomeICU"), VERSION,
	                         "(C) 1999 Jeremy Wise",
	                         authors,
	                         N_( "GnomeICU is a small, fast and functional "
	                         "clone of Mirabilis' ICQ program, specifically "
	                         "designed for Linux and X."),
	                         NULL );

	gtk_widget_show( about );

	return;
}

unsigned int sound_pid;

void handle_signal( int signum )
{
	int status;
	
	if( signum == SIGCHLD )
	{
		waitpid( sound_pid, &status, WNOHANG );
		if( WIFEXITED( status ) || WIFSIGNALED( status ) )
			sound_pid = 0;
	}
	if( signum == SIGUSR1 )
		g_print( "Received SIGUSR1.  Not responding.\n" );
}

int hide_ch_window( GtkWidget *widget, GdkEvent *event, GtkWidget *window )
{
#ifdef TRACE_FUNCTION
	g_print( "hide_ch_window\n" );
#endif
	gtk_widget_hide( window );
	return TRUE;
}

void toggle_log_window( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "toggle_log_window\n" );
#endif

	if( !GTK_WIDGET_VISIBLE( log_window ) )
		gtk_widget_show( log_window );
}

/*
 * Connect to 'hostname' on port 'port'
 * 'hostname' can be DNS or n.n.n.n
 */
 
int Connect_Remote( char *hostname, int port, FD_T aux )
{
	int conct, length;
	int sok;

	/* Used for inet address */
	struct sockaddr_in sin;

	/* Used for DNS lookup */
	struct hostent *host_struct;
   
	/* Check for n.n.n.n notation */
	sin.sin_addr.s_addr = inet_addr( hostname );

#ifdef TRACE_FUNCTION
	g_print( "Connect_Remote\n" );
#endif

	/* If name isn't n.n.n.n, it must be DNS */
/*	if ( sin.sin_addr.s_addr  == -1 )
	{*/
		host_struct = gethostbyname( hostname );

		if ( host_struct == NULL )
		{
			return 0;
		}
/*	}
	else
		host_struct = gethostbyaddr( hostname, strlen( hostname ), AF_INET );
*/
	sin.sin_addr = *( ( struct in_addr * )host_struct->h_addr );

	/* Use inet, not AppleTalk */
	sin.sin_family = AF_INET;
	
	/* Port */
	sin.sin_port = g_htons( port );

	/* Create unconnected socket */
	sok = socket( AF_INET, SOCK_DGRAM, 0 );

	if ( sok == -1 )
	  g_print( "Could not create socket\n" );

	conct = connect( sok, ( struct sockaddr * ) &sin, sizeof( sin ) );

	/* Connection Failure */
	if ( conct == -1 )
	{
		g_print( "Could not connect to socket\n" );
		return 0;
	}
	
	length = sizeof( sin ) ;
	getsockname( sok, ( struct sockaddr * ) &sin, &length );
	our_ip   = sin.sin_addr.s_addr;
	if( !our_port )
		our_port = g_ntohs( sin.sin_port + 2 );

	/* Connected */
	return sok;
}

/* Handle packets from Server */
static void Multi_Packet( struct sokandlb *data, BYTE *pdata )
{
	int num_pack, i;
	int len;
	BYTE *j;
	srv_net_icq_pak pak;
	num_pack = (unsigned char) pdata[ 0 ];
	j = pdata;
	j++;

#ifdef TRACE_FUNCTION
	g_print( "Multi_Packet\n" );
#endif

	sound_disable = TRUE;
	
	for( i = 0; i < num_pack; i ++ )
	{
		len = Chars_2_Word( j );
		memcpy( &pak, j, sizeof( pak ) );
		j += 2;
		Server_Response( data, pak, (len+2) - sizeof( pak.head ), Chars_2_Word( pak.head.cmd ),
		                 Chars_2_Word( pak.head.ver ), Chars_2_Word( pak.head.seq ),
		                 Chars_2_Word( pak.head.UIN ) );
		j += len;
	}

	sound_disable = FALSE;
}

void Server_Response( struct sokandlb *data, srv_net_icq_pak pak, DWORD len, WORD cmd, WORD ver, WORD seq, WORD uin )
{
	ProgressData *pdata = NULL;
	GtkWidget *window;
	GtkWidget *scrollwindow;
	GtkWidget *box;
	GtkWidget *button;
	GtkWidget *buttonbox;

	static int update_reported = 0;

	SIMPLE_MESSAGE_PTR s_mesg;
	int i, cx;
	int old_status;

#ifdef TRACE_FUNCTION
	g_print( "Server_Response\n" );
#endif
   
	switch ( cmd )
	{
		case SRV_MULTI_PACKET:
			Multi_Packet( data, pak.data );
			break;
		case SRV_WEBPRESENCE_ACK:
			icq_finishwebpresence( data->sok );
			break;
		case SRV_ACK:
			/* Server Acknowledged Command */
			Check_Queue( seq );
			break;
		case SRV_NEW_UIN:
			our_info->uin = Chars_2_DW( pak.head.UIN );
			seq_num = 0;
			memset( serv_mess, FALSE, 1024 );
			close( data->sok );
			data->sok = Connect_Remote( server, remote_port, STDERR );
			Login( data->sok, passwd, our_ip, our_port );
			break;
		case SRV_LOGIN_REPLY:
			our_ip = Chars_2_DW( &pak.data[0] );
			log_window_add( "Connected to ICQ Server", 1, our_info->uin );
			gtk_timeout_remove( connecting );
/*			icq_change_status( data->sok, Current_Status, data );*/
			ready_set();
			Time_Stamp();

			ack_srv( data->sok, Chars_2_Word( pak.head.seq ) );
			snd_login_1( data->sok );
			snd_contact_list( data->sok );
			snd_invis_list( data->sok );
			snd_vis_list( data->sok );
			if( webpresence_toggle )
				icq_sendwebpresence( data->sok );
			break;
		case SRV_RECV_MESSAGE:
			Recv_Message( data->sok, pak, data );
			break;
		case SRV_X1:
			/* Unknown message sent after login */
			ack_srv( data->sok, Chars_2_Word( pak.head.seq ) );
			applet_update( Current_Status, NULL, data );
			break;
		case SRV_X2:
			/* Unknown message sent after login */
			Show_Quick_Status( data );
			Done_Login = TRUE;
			ack_srv( data->sok, Chars_2_Word( pak.head.seq ) );
			snd_got_messages( data->sok );
			is_new_user = FALSE;
			break;
		case SRV_INFO_REPLY:
			Display_Info_Reply( data->sok, pak, data );
			break;
		case SRV_EXT_INFO_REPLY:
			Display_Ext_Info_Reply( data->sok, pak );
			break;
		case SRV_USER_OFFLINE:
			User_Offline( data->sok, pak );
			break;
		case SRV_USER_ONLINE:
			User_Online( data->sok, pak );
			break;
		case SRV_STATUS_UPDATE:
			Status_Update( data->sok, pak );
			ack_srv( data->sok, Chars_2_Word( pak.head.seq ) );
			break;
		case SRV_TRY_AGAIN:
			/* Server busy, retrying */
			Login( data->sok, passwd, our_ip, our_port );
			for( i = 0; i< 1024; i++ )
			{
				serv_mess[ i ]=FALSE;
			}
			break;
		case SRV_FORCE_DISCONNECT:
		case SRV_GO_AWAY:
			log_window_add( "Server forced disconnect", 1, our_info->uin );
			Time_Stamp();
			Quit = TRUE;
			old_status = Current_Status;
			Current_Status = STATUS_OFFLINE;
			if( Connected )
			{
				Quit_ICQ( data->sok );
				if( udp_gdk_input )
				{
					gdk_input_remove( udp_gdk_input );
					udp_gdk_input = 0;
				}
				for( cx = 0; cx < Num_Contacts; cx ++ )
				{
					Contacts[ cx ].last_status = Contacts[ cx ].status;
					Contacts[ cx ].status = STATUS_OFFLINE;
				}
				Show_Quick_Status( data );
				seq_num = 0;
				memset( serv_mess, FALSE, 1024 );
				close( data->sok );

				Connected = FALSE;

				ready_set();
   
				if( applet_toggle )
				{
					applet_update( Current_Status, NULL, data );
				}

				msg_queue_clear();

				Current_Status = old_status;
				Done_Login = FALSE;
				data->sok = Connect_Remote( server, remote_port, STDERR );
				if( data->sok > 0 )
				{
					udp_gdk_input = gdk_input_add( data->sok, GDK_INPUT_READ, (GdkInputFunction) icq_refresh, data );
					Connected = TRUE;
					connecting = show_wait( "Connecting to Server", pdata );
					gtk_statusbar_push( GTK_STATUSBAR( statusbar ), 1, " Connecting to Server..." );

					Login( data->sok, passwd, our_ip, our_port );
				}
			}

			break;
		case SRV_END_OF_SEARCH:
			if( found_list )
			{
				gtk_timeout_remove( search_wait );
				gtk_statusbar_pop( GTK_STATUSBAR( statusbar ), 2 + search_wait );
				window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
				gtk_widget_set_usize( window, 700, 360 );
				gtk_container_border_width( GTK_CONTAINER( window ), 0 );
				gtk_window_set_title( GTK_WINDOW( window ), "Search Results" );
	
				box = gtk_vbox_new( FALSE, 0 );
				gtk_container_add( GTK_CONTAINER( window ), box );
				gtk_widget_show( box );
			
				scrollwindow = gtk_scrolled_window_new( NULL, NULL );
				gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW( scrollwindow ),
				                                GTK_POLICY_AUTOMATIC,
				                                GTK_POLICY_AUTOMATIC );
				gtk_box_pack_start( GTK_BOX( box ), scrollwindow, FALSE, FALSE, 0 );
				gtk_widget_set_usize( scrollwindow, 600, 300 );
				gtk_widget_show( scrollwindow );
			
				gtk_clist_set_selection_mode( GTK_CLIST( found_list ),
				                              GTK_SELECTION_BROWSE );
				gtk_container_add( GTK_CONTAINER( scrollwindow ), found_list );
				gtk_clist_set_column_width( GTK_CLIST( found_list ), 0, 75 );
				gtk_clist_set_column_width( GTK_CLIST( found_list ), 1, 75 );
				gtk_clist_set_column_width( GTK_CLIST( found_list ), 2, 75 );
				gtk_clist_set_column_width( GTK_CLIST( found_list ), 3, 75 );
				gtk_clist_set_column_width( GTK_CLIST( found_list ), 4, 150 );
				gtk_clist_set_column_width( GTK_CLIST( found_list ), 5, 150 );
				gtk_widget_show( found_list );

				buttonbox = gtk_hbox_new( FALSE, 0 );
				gtk_container_set_border_width( GTK_CONTAINER( buttonbox ), 10 );
				gtk_box_pack_end( GTK_BOX( box ), buttonbox, FALSE, FALSE, 0 );
				button = gtk_button_new_with_label( "Add to List" );
				gtk_widget_set_usize( button, 100, 30 );
				gtk_box_pack_start( GTK_BOX( buttonbox ), button, FALSE, FALSE, 5 );

				gtk_signal_connect( GTK_OBJECT( button ), "clicked",
				                    GTK_SIGNAL_FUNC( add_from_search ),
				                    data );
				gtk_widget_show( button );
				
				button = gtk_button_new_with_label( "Close" );
				gtk_widget_set_usize( button, 100, 30 );
				gtk_box_pack_start( GTK_BOX( buttonbox ), button, FALSE, FALSE, 5 );

				gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
				                           GTK_SIGNAL_FUNC( gtk_widget_destroy ),
				                           GTK_OBJECT( window ) );
				gtk_widget_show( button );
				gtk_widget_show( buttonbox );			
				gtk_widget_show( window );
			}
			ack_srv( data->sok, Chars_2_Word( pak.head.seq ) );
			break;
		case SRV_USER_FOUND:
			Display_Search_Reply( data->sok, pak );
			break;
		case SRV_SYS_DELIVERED_MESS:
			s_mesg = ( SIMPLE_MESSAGE_PTR ) pak.data;
			last_recv_uin = Chars_2_DW( s_mesg->uin );
			Time_Stamp();
			Do_Msg( Chars_2_Word( s_mesg->type ), ( s_mesg->len + 2 ),
			        last_recv_uin, data, 'm' ); 
			ack_srv( data->sok, Chars_2_Word( pak.head.seq ) );

			if ( 0xfe != *( ((unsigned char *) s_mesg ) + sizeof( s_mesg ) ) )
			{
			}
			break;
		case SRV_BAD_PASSWORD:
			OK_Box( "Error: Bad password", "The password you've provided is incorrect" );
			gtk_timeout_remove( connecting );
			Current_Status = STATUS_OFFLINE;
			gtk_statusbar_push( GTK_STATUSBAR( statusbar ), 1, " Server Disconnected" );
			break;
		case SRV_UPDATE:
		case SRV_UPDATE_EXT:
		case SRV_AUTH_UPDATE:
			if( !update_reported )
				gtk_widget_show( gnome_message_box_new( _("User info successfully updated"),
				                                        GNOME_MESSAGE_BOX_INFO,
				                                        GNOME_STOCK_BUTTON_OK, NULL ) );
			update_reported++;
			if( ++update_reported == 4 )
				update_reported = 0;
			ack_srv( data->sok, Chars_2_Word( pak.head.seq ) );
			break;
		default:
			/* Unhandled Commands */
			if( Chars_2_Word( pak.head.cmd ) == 0x001e )
				break;
			g_print( "\nThe response was %04X\t", Chars_2_Word( pak.head.cmd ) );
			g_print( "The version was %X\t", Chars_2_Word( pak.head.ver ) );
			Time_Stamp();
			g_print( "\nThe SEQ was %04X\t", Chars_2_Word( pak.head.seq ) );

			g_print( "The sizea was %u\n", len );
			/* Fake */
			ack_srv( data->sok, Chars_2_Word( pak.head.seq ) );
	}
}

void Handle_Server_Response( struct sokandlb *data )
{
   srv_net_icq_pak pak;
	static DWORD last_seq = -1;
   int s;

#ifdef TRACE_FUNCTION
	g_print( "Handle_Server_Response\n" );
#endif

   s = SOCKREAD( data->sok, &pak.head.ver, sizeof( pak ) - 2  );
   if ( s < 0 )
      return;
/*	if ( ( serv_mess[ Chars_2_Word( pak.head.seq ) ] ) &&
      ( Chars_2_Word( pak.head.cmd ) != SRV_NEW_UIN ) ) */
	if( ( last_seq == Chars_2_Word( pak.head.seq ) ) &&
	    ( Chars_2_Word( pak.head.cmd ) != SRV_NEW_UIN ) )
   {
      if ( Chars_2_Word( pak.head.cmd ) != SRV_ACK ) /* ACKs don't matter */
      {
         ack_srv( data->sok, Chars_2_Word( pak.head.seq ) ); /* LAGGGGG!! */
         return;
      }
   }
   if ( Chars_2_Word( pak.head.cmd ) != SRV_ACK )
   {
      serv_mess[ Chars_2_Word( pak.head.seq2 ) ] = TRUE;
		last_seq = Chars_2_Word( pak.head.seq );
      ack_srv( data->sok, Chars_2_Word( pak.head.seq ) );
   }

	packet_print( pak.head.ver, s,
	              PACKET_TYPE_UDP | PACKET_DIRECTION_RECEIVE );

   Server_Response( data, pak, s - ( sizeof( pak.head ) - 2 ),
      Chars_2_Word( pak.head.cmd ), Chars_2_Word( pak.head.ver ),
      Chars_2_Word( pak.head.seq ), Chars_2_DW( pak.head.UIN ) );
}

/* Verify that we are in the correct endian */
void Check_Endian( void )
{
	int i;
	char pass[10] = { '1', '0', '0', '0', '0', '0', '0', '0', '0' };

#ifdef TRACE_FUNCTION
	g_print( "Check_Endian\n" );
#endif

	i = *( DWORD * ) pass;
	if ( i == 1 )
	{
		Int_End = TRUE;
	}
	else
	Int_End = FALSE;
}

static char *cfnp;

int main( int argc, char *argv[] )
{
	struct sokandlb sal;
	int i;
	int next;

	int l = 1;
	int temp_sok;
	struct sockaddr_in addr;

	ProgressData *pdata = NULL;

	GnomeClient *client;

	static struct poptOption arguments[] =
	{
		{"uin", 'u', POPT_ARG_STRING, &cfnp, 0, N_("Use the defined UIN"), N_("UIN")},
		{NULL, 'a', POPT_ARG_NONE, 0, 0, N_("startup without applet support"), NULL},
		{NULL, 0, 0, NULL, 0, NULL, NULL}
	};

	GnomeUIInfo statusmenu[] =
	{
		{
			GNOME_APP_UI_ITEM,
			N_("Online"), N_(""),
			icq_set_status_online, &sal, NULL,
			GNOME_APP_PIXMAP_DATA, icon_online_xpm,
			0, 0, NULL
		},
		{
			GNOME_APP_UI_ITEM,
			N_("Away"), N_(""),
			icq_set_status_away, &sal, NULL,
			GNOME_APP_PIXMAP_DATA, icon_away_xpm,
			0, 0, NULL
		},
		{
			GNOME_APP_UI_ITEM,
			N_("Not Available"), N_(""),
			icq_set_status_na, &sal, NULL,
			GNOME_APP_PIXMAP_DATA, icon_na_xpm,
			0, 0, NULL
		},
		{
			GNOME_APP_UI_ITEM,
			N_("Free for Chat"), N_(""),
			icq_set_status_ffc, &sal, NULL,
			GNOME_APP_PIXMAP_DATA, icon_ffc_xpm,
			0, 0, NULL
		},
		{
			GNOME_APP_UI_ITEM,
			N_("Occupied"), N_(""),
			icq_set_status_occ, &sal, NULL,
			GNOME_APP_PIXMAP_DATA, icon_occ_xpm,
			0, 0, NULL
		},
		{
			GNOME_APP_UI_ITEM,
			N_("Do Not Disturb"), N_(""),
			icq_set_status_dnd, &sal, NULL,
			GNOME_APP_PIXMAP_DATA, icon_dnd_xpm,
			0, 0, NULL
		},
		{
			GNOME_APP_UI_ITEM,
			N_("Invisible"), N_(""),
			icq_set_status_invisible, &sal, NULL,
			GNOME_APP_PIXMAP_DATA, icon_inv_xpm,
			0, 0, NULL
		},

		GNOMEUIINFO_SEPARATOR,

		{
			GNOME_APP_UI_ITEM,
			N_("Offline"), N_(""),
			icq_set_status_offline, &sal, NULL,
			GNOME_APP_PIXMAP_DATA, icon_offline_xpm,
			0, 0, NULL
		},

		GNOMEUIINFO_END
	};

	GnomeUIInfo icqmenu[] =
	{
		{
			GNOME_APP_UI_ITEM,
			N_("_Add Contact..."), N_("Add a contact to your list"),
			search_window, &sal, NULL,
			GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW,
			'N', GDK_CONTROL_MASK, NULL
		},

		{
			GNOME_APP_UI_ITEM,
			N_("_Connection History"), N_("Display Connection History Window"),
			toggle_log_window, NULL, NULL,
			GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BOOK_OPEN,
			'C', GDK_CONTROL_MASK, NULL
		},		

		{
			GNOME_APP_UI_ITEM,
			N_("_Options"), N_("Configure GnomeICU"),
			configure_window, &sal, NULL,
			GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PROP,
			'O', GDK_CONTROL_MASK, NULL
		},

		{
			GNOME_APP_UI_ITEM,
			N_( "Change Your _Info" ), N_( "Change your personal information" ),
			change_info_window, NULL, NULL,
			GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PROP,
			'I', GDK_CONTROL_MASK, NULL
		},

		GNOMEUIINFO_SEPARATOR,

		{
			GNOME_APP_UI_ITEM,
			N_("H_ide Main Window"), N_("Hide Main Window" ),
			applet_hide_main, NULL, NULL,
			GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_HOME,
			'H', GDK_CONTROL_MASK, NULL
		},

		GNOMEUIINFO_SEPARATOR,
		
		{ 
			GNOME_APP_UI_ITEM,
			N_("E_xit"), N_("Exit GnomeICU"),
			icq_quit, &sal, NULL,
			GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_QUIT,
			'Q', GDK_CONTROL_MASK, NULL
		},

		GNOMEUIINFO_END
	};

	GnomeUIInfo helpmenu[] =
	{
		{
			GNOME_APP_UI_ITEM,
			N_("About..."), N_("About GnomeICU"),
			about, &sal, NULL,
			GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT,
			0, 0, NULL
		},
		
		GNOMEUIINFO_END
	};

	GnomeUIInfo mainmenu[] =
	{
		GNOMEUIINFO_SUBTREE(N_("_ICQ"), icqmenu ),
		GNOMEUIINFO_SUBTREE(N_("_Status"), statusmenu ),
		GNOMEUIINFO_SUBTREE(N_("_Help"), helpmenu ),
		GNOMEUIINFO_END
	};

	GtkStyle  *style;
	GtkWidget *box, *box2, *box3;
	GtkWidget *scrollwindow;
	GtkWidget *button;
	GtkWidget *log_table, *bbox;
	GtkWidget *statusbox;
	GtkWidget *scroll_win;

	char *lltitles[] = { "Time", "Date", "User", "Action" };

#if 0
	char *sys[2] = { "", "System" };
#endif

#ifdef HAVE_SOCKS5
	SOCKSinit(argv[0]);
#endif

	our_info = (USER_INFO_PTR)g_malloc( sizeof( USER_INFO_STRUCT ) );
	our_info->uin = 0;
   our_info->nick = NULL;
   our_info->first = NULL;
   our_info->last = NULL;
	our_info->sex = NOT_SPECIFIED;
	our_info->age = 0;
   our_info->auth = FALSE;
	our_info->birth_year = 0;
	our_info->birth_month = 0;
	our_info->birth_day = 0;
	our_info->ip = NULL;
	our_info->port = NULL;
	our_info->email = NULL;
	our_info->email2 = NULL;
	our_info->email3 = NULL;
	our_info->phone = NULL;
	our_info->fax = NULL;
	our_info->cellular = NULL;
	our_info->street = NULL;
	our_info->city = NULL;
	our_info->state = NULL;
	our_info->zip = 0;
	our_info->country = 1;
	our_info->c_status = 0;
	our_info->homepage = NULL;
	our_info->about = NULL;

	our_info->window = NULL;

	our_info->w_uin = NULL;
	our_info->w_nick = NULL;
	our_info->w_first = NULL;
	our_info->w_last = NULL;
	our_info->w_sex = NULL;
	our_info->w_age = NULL;
	our_info->w_auth = NULL;
	our_info->w_birth_year = NULL;
	our_info->w_birth_month = NULL;
	our_info->w_birth_day = NULL;

	our_info->w_ip = NULL;
	our_info->w_port = NULL;
	our_info->w_email = NULL;
	our_info->w_email2 = NULL;
	our_info->w_email3 = NULL;
	our_info->w_hide_email = NULL;

	our_info->w_phone = NULL;
	our_info->w_fax = NULL;
	our_info->w_cellular = NULL;
	our_info->w_city = NULL;
	our_info->w_state = NULL;
	our_info->w_zip = NULL;
	our_info->w_country = NULL;
	our_info->w_c_status = NULL;

	our_info->w_homepage = NULL;
	our_info->w_about = NULL;

	MainData = &sal;

	sal.online = 0;
	sal.offline = 0;

#ifdef TRACE_FUNCTION
	g_print( "main\n" );
#endif

	sprintf( WindowTitle, "GnomeICU" );

	signal( SIGCHLD, &handle_signal );
	signal( SIGUSR1, &handle_signal );

	make_applet( argc, argv, &sal );
	gnome_config_push_prefix( configfilename );

	if( applet_toggle == FALSE )
	{
		cfnp = 0;
		gnome_init_with_popt_table( "gnomeicu", VERSION, argc, argv,
		                            arguments, 0, NULL );
		if( cfnp )
			sprintf( configfilename, "/GnomeICU_%s/", cfnp );
	}

	gtk_rc_parse ( ".gtkrc" );

	strcpy( ChatFontString, "" );

	Get_Unix_Config_Info();

	if( !strcmp( ChatFontString, "" ) )
		strcpy( ChatFontString, "-adobe-courier-medium-r-normal-*-*-140-*-*-m-*-iso8859-1" );

	if ( applet_toggle == FALSE )
	{
		client = gnome_master_client();
		/* EKP 3.10.99 - changed connect_object to connect and
		   icq_quit_object to icq_quit */
		gtk_signal_connect( GTK_OBJECT( client ), "destroy",
		                    GTK_SIGNAL_FUNC( icq_quit ),
		                    (gpointer)&sal );

		gtk_signal_connect( GTK_OBJECT ( client ), "save_yourself",
		                    GTK_SIGNAL_FUNC(app_save_state_cb),
		                    (gpointer)argv[0]);
	}

	app = gnome_app_new( WindowTitle, WindowTitle );
	sal.window =  app;

	gtk_window_set_policy( GTK_WINDOW( app ), TRUE, TRUE, FALSE );

	gtk_widget_realize( app );
	gnome_app_create_menus( GNOME_APP( app ), mainmenu );

	if( applet_toggle == FALSE )
	{
		/* Changed from "delete_event" to "destroy" because it is right :) [PEL]
		 * Now it doesn't segfault when closed by the WM */

	/* EKP 3.10.99 - changed icq_quit_object to icq_quit */
		gtk_signal_connect( GTK_OBJECT( app ), "destroy",
	   	                 GTK_SIGNAL_FUNC( icq_quit ), (gpointer)&sal );
	}
	else
	{
		gtk_signal_connect( GTK_OBJECT( app ), "delete_event",
		                     GTK_SIGNAL_FUNC( hide_dont_kill ), 0 );
	}

	gtk_widget_set_usize( app, WindowWidth, WindowHeight );

	box = gtk_vbox_new( FALSE, 0);
	box2 = gtk_vbox_new( FALSE, 0 );
	box3 = gtk_table_new( 1, 2, FALSE );

	gnome_app_set_contents( GNOME_APP( app ), box2 );

	gtk_container_border_width( GTK_CONTAINER( box ), 5 );

	gtk_container_add( GTK_CONTAINER( box2 ), box );

	sal.lb_userwin = gtk_clist_new( 2 );
	gtk_widget_show( sal.lb_userwin );

	scroll_win = gtk_scrolled_window_new( NULL, NULL );
	gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW (scroll_win),
	                                GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC );
	
	gtk_container_add( GTK_CONTAINER( scroll_win ), sal.lb_userwin );

/*	gtk_widget_set_usize( sal.lb_userwin,
	                      ( WindowWidth - 68 ) < 0 ? 0 : WindowWidth - 68, -1 );
*/
	gtk_clist_set_row_height( GTK_CLIST( sal.lb_userwin ), 20 );
	gtk_clist_set_column_width( GTK_CLIST( sal.lb_userwin ), 0, 16 );
	gtk_clist_set_column_width( GTK_CLIST( sal.lb_userwin ), 1, 10 );
	gtk_clist_set_selection_mode( GTK_CLIST( sal.lb_userwin ),
	                              GTK_SELECTION_BROWSE);

	gtk_signal_connect( GTK_OBJECT( sal.lb_userwin ), "button_press_event",
		                    GTK_SIGNAL_FUNC( icq_sendmessage_window ), &sal );

	gtk_signal_connect( GTK_OBJECT( sal.lb_userwin ), "key_press_event",
	                    GTK_SIGNAL_FUNC( icq_sendmessage_window ), &sal );

	init_contact_list_drag_drop( sal.lb_userwin, &sal );

	gtk_box_pack_start( GTK_BOX( box ), scroll_win, TRUE, TRUE, 0 );
	gtk_widget_show( scroll_win );

	statusbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_end( GTK_BOX( box2 ), statusbox, FALSE, FALSE, 0 );
	gtk_widget_show( statusbox );

	statusbar = gtk_statusbar_new();
	gtk_widget_set_usize( statusbar, 0, 20 );
	gtk_box_pack_start( GTK_BOX( statusbox ), statusbar, TRUE, TRUE, 0 );
	gtk_widget_show( statusbar );

	progress_bar_make();
	gtk_box_pack_end( GTK_BOX( box2 ), progress_indicator, FALSE, FALSE, 0 );
	gtk_widget_show( progress_indicator );

	status_tooltip = gtk_tooltips_new();
	gtk_tooltips_set_tip( status_tooltip,
	                      statusbar, "foo\nbar", NULL );
	gtk_tooltips_enable( status_tooltip );

	init_colors( &sal );

	if( applet_toggle == FALSE )
	{
		style = gtk_widget_get_style( sal.lb_userwin );
		init_pixmaps( style, app );
	}

	log_window = gtk_window_new( GTK_WINDOW_DIALOG );

	gtk_widget_set_usize( log_window, 625, 250 );

	gtk_container_border_width( GTK_CONTAINER ( log_window ), 5 );

	gtk_window_set_title(GTK_WINDOW ( log_window ), "GnomeICU: Connection History");

	scrollwindow = gtk_scrolled_window_new( NULL, NULL );
	gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW( scrollwindow ),
	                                GTK_POLICY_AUTOMATIC,
	                                GTK_POLICY_AUTOMATIC );

	log_list = gtk_clist_new_with_titles( 4, lltitles );
	gtk_widget_show( log_list );

	gtk_container_add( GTK_CONTAINER( scrollwindow ), log_list );
	gtk_widget_show( scrollwindow );

	gtk_clist_column_titles_passive( GTK_CLIST( log_list ) );
	gtk_clist_set_row_height( GTK_CLIST( log_list ), 20 );
	gtk_clist_set_selection_mode (GTK_CLIST( log_list ),
	                              GTK_SELECTION_EXTENDED );

	log_table = gtk_table_new( 3, 1, FALSE );
	gtk_container_add( GTK_CONTAINER( log_window ), log_table );
	bbox = gtk_hbox_new( FALSE, 0 );

	gtk_table_attach( GTK_TABLE( log_table ), scrollwindow, 0, 1, 0, 1,
	GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 0, 5 );

	gtk_clist_set_column_width( GTK_CLIST( log_list ), 0, 80 );
	gtk_clist_set_column_width( GTK_CLIST( log_list ), 1, 60 );
	gtk_clist_set_column_width( GTK_CLIST( log_list ), 2, 100 );

	button = gtk_button_new_with_label( "Close" );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
	                           GTK_SIGNAL_FUNC( gtk_widget_hide_on_delete ),
	                           GTK_OBJECT( log_window ) );

	gtk_widget_set_usize( button, 100, 30 );
	gtk_container_add( GTK_CONTAINER( bbox ), button );
	gtk_table_attach( GTK_TABLE( log_table ), bbox, 0, 1, 1, 2, 0, 0, 0, 0 );
	gtk_widget_show( button );
	gtk_widget_show( log_table );
	gtk_widget_show( bbox );
	gtk_widget_show( box );
	gtk_widget_show( box2 );

	for( i = 0; i < Num_Contacts; i ++ )
	{
		Contacts[ i ].icon_p = icon_offline_pixmap;
		Contacts[ i ].icon_b = icon_offline_bitmap;
	}

	Show_Quick_Status( &sal );

	memset( serv_mess, FALSE, 1024 );

	msg_queue_init();

	if (argc > 1 )
	{
		for ( i = 1; i < argc; i++ )
		{
			if ( argv[i][0] != '-' )
			{
			}
		}
	}

	Check_Endian();

	if( applet_toggle == FALSE )
		gtk_widget_show( GTK_WIDGET( app ) );

	while( gtk_events_pending() )
		gtk_main_iteration();

	sal.sok = Connect_Remote( server, remote_port, STDERR );

	if ( sal.sok > 0 )
	{
		gtk_timeout_add( 120000, (GtkFunction) stay_connected, &sal );
		gtk_timeout_add( 500, (GtkFunction) flash_messages, &sal );
#ifdef USE_AUTOAWAY
		gtk_timeout_add( 1000, (GtkFunction) auto_away, &sal );
#endif
		udp_gdk_input = gdk_input_add( sal.sok, GDK_INPUT_READ, (GdkInputFunction) icq_refresh, &sal );

		addr.sin_addr.s_addr = g_htonl( INADDR_ANY );
		addr.sin_family = AF_INET;
		addr.sin_port = g_htons( our_port );
	
		temp_sok = socket( AF_INET, SOCK_STREAM, 0 );
		setsockopt( temp_sok, SOL_SOCKET, SO_REUSEADDR, &l, 4 );

		our_sok = bind( temp_sok, (struct sockaddr *)&addr, sizeof( addr ) );
		if( -1 == our_sok )
		  g_error( "Could not bind to socket, port %u\n", our_port );


		our_sok = temp_sok;
	
		if( -1 == listen( our_sok, 10 ) )
		  g_error( "Cannot listen to socket, port %u\n", our_port );

		l = sizeof( addr );

		tcp_gdk_input = gdk_input_add( our_sok, GDK_INPUT_READ, (GdkInputFunction) TCPAcceptIncoming, &sal );

		Connected = TRUE;

		connecting = show_wait( "Connecting to Server", pdata );
		gtk_statusbar_push( GTK_STATUSBAR( statusbar ), 1, " Connecting to Server..." );

		if( is_new_user )
		{
			Init_New_User();
			Save_RC();
		}

		Login( sal.sok, passwd, our_ip, our_port );

		our_info->ip = (char*)g_malloc( 16 );
		sprintf( our_info->ip, "%u.%u.%u.%u",
		         (BYTE) (our_ip),
		         (BYTE) (our_ip >> 8),
		         (BYTE) (our_ip >> 16),
		         (BYTE) (our_ip >> 24) );
		our_info->port = (char*)g_malloc( 8 );
		sprintf( our_info->port, "%u", our_port );

		next = time( NULL );
		next += 60;
	}
	else
		icq_set_status_offline( NULL, MainData );


	if( applet_toggle )
	{
		applet_update( STATUS_OFFLINE, NULL, &sal );
		applet_widget_gtk_main();
	}
	else
		gtk_main();

	Quit_ICQ( sal.sok );
	return 0;
}
