/* dragdrop.c
 *
 *  GnomeICU DnD support
 *
 *  Much help from gnome-core/panel/panel.c on this one.
 */

#include "dragdrop.h"
#include <ctype.h>
#include <libgnome/libgnome.h>
#include <string.h>

enum
{
  TARGET_URL,
  TARGET_NETSCAPE_URL
};

static GtkTargetEntry contact_list_drop_types[]=
{
  { "_NETSCAPE_URL", 0, TARGET_NETSCAPE_URL },
  { "text/uri-list", 0, TARGET_URL },
  { "x-url/http", 0, TARGET_NETSCAPE_URL },
  { "x-url/ftp", 0, TARGET_NETSCAPE_URL },
  { "text/plain",0,TARGET_NETSCAPE_URL, }
  /* ??  For some reason Netscape wants to send me stuff as text/plain */
};

static gint n_contact_list_drop_types=
  sizeof(contact_list_drop_types)/sizeof(contact_list_drop_types[0]);

static void contact_list_dnd_drop(GtkWidget *widget,
				  GdkDragContext *context,
				  gint x,
				  gint y,
				  GtkSelectionData *selection_data,
				  guint info,
				  guint time,
				  struct sokandlb *data)
{
  GtkCList *list;
  int row;
  int column;

/*  g_print("Got drop: %s\n",(char*)selection_data->data);*/

  g_return_if_fail(widget);
  g_return_if_fail(GTK_IS_CLIST(widget));

  list=GTK_CLIST(widget);

  gtk_clist_get_selection_info(list, x, y, &row, &column);

  gtk_clist_select_row(list, row, column);

  switch(info)
    {
    case TARGET_URL:
      /* We got a bunch of file names */
      {
	GList *files=gnome_uri_list_extract_filenames(selection_data->data),*tmp;

	for(tmp=files; tmp; tmp=g_list_next(tmp))
	  {
	    g_print("Got URL: %s\n",(char*)tmp->data);
	    request_file(widget, data, (char *)tmp->data);
	  }

	gnome_uri_list_free_strings(files);
      }
      break;
    case TARGET_NETSCAPE_URL:
      {
	GString *type=g_string_new("");
	char *url=(char*) selection_data->data;
	char *tmp=url;
	
	g_print("Got Netscape URL: %s\n",url);

	while(isalpha(*tmp))
	  type=g_string_append_c(type,*tmp++);

	g_print("Type is %s\n",type->str);

	if(!strcmp(type->str,""))
	  /* Assume it's a straight filename */
	   {
	     request_file(widget, data, tmp);
	     g_string_free(type,1);
	     return;
	   }

	if(!strcmp(type->str,"file"))
	  {
	    if(*tmp++!=':')
	      {
		g_warning("Badly formed URL: %s\n",url);
		g_string_free(type,1);
		return;
	      }
	    if(tmp[0]=='/'&&tmp[1]=='/')
	      /* file://host/loationc handling.
	       * If it's of the form file://localhost/stuff, do a file transfer
	       * on stuff, otherwise continue.
	       */
	      {
		tmp+=2;
		if(strstr(tmp,"localhost")==tmp)
		  {
		    tmp+=strlen("localhost");
		    g_print("Sending file request for %s\n",tmp);
		    request_file(widget, data, tmp);
		    g_string_free(type,1);
		    return;
		  }
	      }
	    else /* Of the form file:... */
	      {
		request_file(widget, data, tmp);
		g_string_free(type,1);
		return;
	      }
	  }

	g_print("Sending URL request for %s\n",url);
	send_url_window( widget, data, url );
	g_string_free(type,1);
	break;
      }
    }
}

void init_contact_list_drag_drop(GtkWidget *list, struct sokandlb *data)
{
/*  g_print("Initializing drag&drop with %i types\n",n_contact_list_drop_types);*/
  gtk_signal_connect(GTK_OBJECT(list),
		     "drag_data_received",
		     GTK_SIGNAL_FUNC(contact_list_dnd_drop),
		     data);
  gtk_drag_dest_set(GTK_WIDGET(list),
		    GTK_DEST_DEFAULT_MOTION |
		    GTK_DEST_DEFAULT_HIGHLIGHT |
		    GTK_DEST_DEFAULT_DROP,
		    contact_list_drop_types,
		    n_contact_list_drop_types,
		    GDK_ACTION_COPY);
}
