
#include "E.h"

void               *
FindItem(char *name, int id, int find_by, int type)
{
  List               *ptr;

  EDBUG(6, "FindItem");
  ptr = lists[type].next;
  if (find_by == LIST_FINDBY_NAME)
    {
      while (ptr)
	{
	  if ((!strcmp(name, ptr->name)))
	    EDBUG_RETURN(ptr->item);
	  ptr = ptr->next;
	}
    }
  else if (find_by == LIST_FINDBY_ID)
    {
      while (ptr)
	{
	  if ((ptr->id == id))
	    EDBUG_RETURN(ptr->item);
	  ptr = ptr->next;
	}
    }
  else if (find_by == LIST_FINDBY_BOTH)
    {
      while (ptr)
	{
	  if ((!strcmp(name, ptr->name)) && (ptr->id == id))
	    EDBUG_RETURN(ptr->item);
	  ptr = ptr->next;
	}
    }
  else if (find_by == LIST_FINDBY_POINTER)
    {
      while (ptr)
	{
	  if (ptr->item == (void *)name)
	    EDBUG_RETURN(ptr->item);
	  ptr = ptr->next;
	}
    }
  else if (find_by == LIST_FINDBY_NONE)
    {
      while (ptr)
	{
	  EDBUG_RETURN(ptr->item);
	}
    }
  EDBUG_RETURN(NULL);
}

void
AddItem(void *item, char *name, int id, int type)
{
  List               *ptr;

  EDBUG(6, "AddItem");
  ptr = Emalloc(sizeof(List));
  if (!ptr)
    EDBUG_RETURN_;
  ptr->item = item;
  ptr->name = duplicate(name);
  ptr->id = id;
  ptr->next = lists[type].next;
  lists[type].next = ptr;
  EDBUG_RETURN_;
}

void
MoveItemToListTop(void *item, int type)
{
  List               *ptr, *pptr;

  EDBUG(6, "MoveItemToListTop");

  pptr = NULL;
  ptr = lists[type].next;
  while (ptr)
    {
      if (ptr->item == item)
	{
	  if (pptr)
	    {
	      pptr->next = ptr->next;
	      ptr->next = lists[type].next;
	      lists[type].next = ptr;
	    }
	  else
	    {
	      EDBUG_RETURN_;
	    }
	}
      else
	{
	  pptr = ptr;
	  ptr = ptr->next;
	}
    }
  EDBUG_RETURN_;
}

void               *
RemoveItem(char *name, int id, int find_by, int type)
{
  List               *ptr, *pptr;
  void               *p;

  EDBUG(6, "RemoveItem");
  pptr = NULL;
  ptr = lists[type].next;
  if (find_by == LIST_FINDBY_NAME)
    {
      while (ptr)
	{
	  if ((!strcmp(name, ptr->name)))
	    {
	      if (pptr)
		pptr->next = ptr->next;
	      else
		lists[type].next = ptr->next;
	      p = ptr->item;
	      if (ptr->name)
		Efree(ptr->name);
	      Efree(ptr);
	      EDBUG_RETURN(p);
	    }
	  pptr = ptr;
	  ptr = ptr->next;
	}
    }
  else if (find_by == LIST_FINDBY_ID)
    {
      while (ptr)
	{
	  if ((ptr->id == id))
	    {
	      if (pptr)
		pptr->next = ptr->next;
	      else
		lists[type].next = ptr->next;
	      p = ptr->item;
	      if (ptr->name)
		Efree(ptr->name);
	      Efree(ptr);
	      EDBUG_RETURN(p);
	    }
	  pptr = ptr;
	  ptr = ptr->next;
	}
    }
  else if (find_by == LIST_FINDBY_BOTH)
    {
      while (ptr)
	{
	  if ((!strcmp(name, ptr->name)) && (ptr->id == id))
	    {
	      if (pptr)
		pptr->next = ptr->next;
	      else
		lists[type].next = ptr->next;
	      p = ptr->item;
	      if (ptr->name)
		Efree(ptr->name);
	      Efree(ptr);
	      EDBUG_RETURN(p);
	    }
	  pptr = ptr;
	  ptr = ptr->next;
	}
    }
  else if (find_by == LIST_FINDBY_POINTER)
    {
      while (ptr)
	{
	  if (ptr->item == (void *)name)
	    {
	      if (pptr)
		pptr->next = ptr->next;
	      else
		lists[type].next = ptr->next;
	      p = ptr->item;
	      if (ptr->name)
		Efree(ptr->name);
	      Efree(ptr);
	      EDBUG_RETURN(p);
	    }
	  pptr = ptr;
	  ptr = ptr->next;
	}
    }
  else if (find_by == LIST_FINDBY_NONE)
    {
      while (ptr)
	{
	  if (pptr)
	    pptr->next = ptr->next;
	  else
	    lists[type].next = ptr->next;
	  p = ptr->item;
	  if (ptr->name)
	    Efree(ptr->name);
	  Efree(ptr);
	  EDBUG_RETURN(p);
	  pptr = ptr;
	  ptr = ptr->next;
	}
    }
  EDBUG_RETURN(NULL);
}

void              **
ListItemType(int *num, int type)
{
  List               *ptr;
  int                 i, len;
  void              **lst;

  EDBUG(6, "ListItemType");
  *num = 0;
  len = 0;
  if (type == LIST_TYPE_ANY)
    EDBUG_RETURN(NULL);
  ptr = lists[type].next;
  while (ptr)
    {
      len++;
      ptr = ptr->next;
    }
  if (!len)
    EDBUG_RETURN(NULL);
  lst = Emalloc(len * sizeof(void *));

  i = 0;
  ptr = lists[type].next;
  while (ptr)
    {
      lst[i++] = ptr->item;
      ptr = ptr->next;
    }
  *num = i;
  EDBUG_RETURN(lst);
}

char              **
ListItems(int *num, int type)
{
  List               *ptr;
  int                 i, len;
  char              **list;

  EDBUG(7, "ListItems");
  i = 0;
  len = 0;
  list = NULL;
  ptr = lists[type].next;
  if (type != LIST_TYPE_ANY)
    {
      while (ptr)
	{
	  len++;
	  ptr = ptr->next;
	}
    }
  else
    {
      while (ptr)
	{
	  len++;
	  ptr = ptr->next;
	}
    }
  list = Emalloc(len * sizeof(char *));

  if (!list)
    {
      *num = 0;
      EDBUG_RETURN(NULL);
    }
  ptr = lists[type].next;
  if (type != LIST_TYPE_ANY)
    {
      while (ptr)
	{
	  list[i] = duplicate(ptr->name);
	  i++;
	  ptr = ptr->next;
	}
    }
  else
    {
      while (ptr)
	{
	  list[i] = duplicate(ptr->name);
	  i++;
	  ptr = ptr->next;
	}
    }
  *num = len;
  EDBUG_RETURN(list);
}

void              **
ListItemTypeID(int *num, int type, int id)
{
  List               *ptr;
  int                 i, len;
  void              **lst;

  EDBUG(6, "ListItemType");
  *num = 0;
  if (type == LIST_TYPE_ANY)
    EDBUG_RETURN(NULL);
  len = 64;
  lst = Emalloc(len * sizeof(void *));

  i = 0;
  ptr = lists[type].next;
  while (ptr)
    {
      if ((ptr->id == id))
	lst[i++] = ptr->item;
      if (i >= len)
	{
	  len += 64;
	  lst = Erealloc(lst, len * sizeof(void *));
	}
      ptr = ptr->next;
    }
  *num = i;
  if (i <= 0)
    {
      Efree(lst);
      EDBUG_RETURN(NULL);
    }
  EDBUG_RETURN(lst);
}

void              **
ListItemTypeName(int *num, int type, char *name)
{
  List               *ptr;
  int                 i, len;
  void              **lst;

  EDBUG(6, "ListItemTypeName");
  *num = 0;
  if (type == LIST_TYPE_ANY)
    EDBUG_RETURN(NULL);
  len = 64;
  lst = Emalloc(len * sizeof(void *));

  i = 0;
  ptr = lists[type].next;
  while (ptr)
    {
      if ((!strcmp(name, ptr->name)))
	lst[i++] = ptr->item;
      if (i >= len)
	{
	  len += 64;
	  lst = Erealloc(lst, len * sizeof(void *));
	}
      ptr = ptr->next;
    }
  *num = i;
  if (i <= 0)
    {
      Efree(lst);
      EDBUG_RETURN(NULL);
    }
  EDBUG_RETURN(lst);
}
