#include "E.h"

extern char         waitonly;

int
main(int argc, char **argv)
{
  XEvent              ev;
  Client             *me, *e;
  char                buf[10240];
  int                 i, j, k;
  fd_set              fd;
  char                ret;

  waitonly = 0;
  lists.next = NULL;
  SetupX();
  CommsSetup();
  CommsFindCommsWindow();
  XSelectInput(disp, comms_win, StructureNotifyMask);
  XSelectInput(disp, root.win, PropertyChangeMask);
  e = MakeClient(comms_win);
  AddItem(e, "E", e->win, LIST_TYPE_CLIENT);
  me = MakeClient(my_win);
  AddItem(me, "ME", me->win, LIST_TYPE_CLIENT);
  CommsSend(e, "set clientname eesh");
  CommsSend(e, "set version 0.1");
  CommsSend(e, "set author The Rasterman");
  CommsSend(e, "set email raster@rasterman.com");
  CommsSend(e, "set web http://www.enlightenment.org");
/*  CommsSend(e, "set address NONE"); */
  CommsSend(e, "set info Enlightenment IPC Shell - talk to E direct");
/*  CommsSend(e, "set pixmap 0"); */

  for (i = 0; i < argc; i++)
    {
      if (!strcmp(argv[i], "-e"))
	{
	  if (i != (argc - 1))
	    {
	      CommsSend(e, argv[++i]);
	      XSync(disp, False);
	      exit(0);
	    }
	}
      else if (!strcmp(argv[i], "-ewait"))
	{
	  waitonly = 1;
	  if (i != (argc - 1))
	    CommsSend(e, argv[++i]);
	}
      else if ((!strcmp(argv[i], "-h")) ||
	       (!strcmp(argv[i], "--h")) ||
	       (!strcmp(argv[i], "-help")) ||
	       (!strcmp(argv[i], "--help")))
	{
	  printf("%s [ -e \"Command to Send to Enlightenment then exit\"]"
		 "   [ -ewait \"Command to Send to E then wait for a reply then exit\"]\n",
		 argv[0]);
	  exit(0);
	}
    }

  XSync(disp, False);
  j = 0;
  fcntl(0, F_SETFL, O_NONBLOCK);
  for (;;)
    {
      if (waitonly)
	{
	  XNextEvent(disp, &ev);
	  if (ev.type == ClientMessage)
	    HandleComms(&ev);
	  else if (ev.type == DestroyNotify)
	    exit(0);
	  XSync(disp, False);
	}
      else
	{
	  FD_ZERO(&fd);
	  FD_SET(0, &fd);
	  FD_SET(ConnectionNumber(disp), &fd);
	  if (select(ConnectionNumber(disp) + 1, &fd, NULL, NULL, NULL) < 0)
	    exit(0);
	  XSync(disp, False);

	  if (FD_ISSET(0, &fd))
	    {
	      k = 0;
	      while ((ret = read(0, &(buf[j]), 1) > 0))
		{
		  k = 1;
		  if (buf[j] == '\n')
		    {
		      buf[j] = 0;
		      if (strlen(buf) > 0)
			{
			  CommsSend(e, buf);
			  XSync(disp, False);
			}
		      j = -1;
		    }
		  j++;
		}
	      if ((ret < 0) || ((k == 0) && (ret == 0)))
		exit(0);
	    }
	  else if (FD_ISSET(ConnectionNumber(disp), &fd))
	    {
	      while (XPending(disp))
		{
		  XNextEvent(disp, &ev);
		  if (ev.type == ClientMessage)
		    HandleComms(&ev);
		  else if (ev.type == DestroyNotify)
		    exit(0);
		}
	      XSync(disp, False);
	    }
	}
    }
  return 0;
}
